<?php
    use Illuminate\Support\Facades\Route;
    $routeName = Route::currentRouteName();
?>



<header>
    <div class="container-fluid">
        <nav class="navbar_custom jewellery ">
            <a class="navbar-brand" href="<?php echo e(route('admin.dashboard.index')); ?>">
                <img src="<?php echo e(asset('public/img/logo.png')); ?>"/> 
            </a>
            <div class="dashboard">
                <div class="form-group">
                    <select class="form-select" id="dashboardDropdown" value="">
                        <option class="switchDashboard <?php echo e((request()->routeIs('admin.*')) ? 'active' : ''); ?>" 
                            <?php echo e((request()->routeIs('admin.*')) ? 'selected' : ''); ?> value="admin" id="adminDashboard">Admin Dashboard</option>
                        <option class="switchDashboard <?php echo e((!request()->routeIs('admin.*')) ? 'active' : ''); ?>" <?php echo e((!request()->routeIs('admin.*')) ? 'selected' : ''); ?> value="web" id="frontDashboard">Front Dashboard</option>
                    </select>
                </div>
            </div>
            <div class="ms-auto items d-flex">
                <div class="d-flex align-items-center">
                    <div class="add-jewellery">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('jewellery-read')): ?>
                        <a href="<?php echo e(route('admin.jewelleries.create')); ?>">Add Jewellery<img src="<?php echo e(asset('public/img/plus.png')); ?>"/></a>
                        <?php endif; ?>
                    </div>
                    <!-- <div class="add-noti">
                        <a href="javascript:void(0);">Notification<img src="<?php echo e(asset('public/img/bell.png')); ?>"/></a>
                    </div> -->
                    <div class="add-noti dropdown add-noti-content">
                        <a href="javascript:void(0);" id="notification_box" role="button">
                            <span class="d_non_1">Notification</span>
                            <img src="<?php echo e(asset('public/img/bell.png')); ?>">
                        </a>
                        
                        <div class="drop_1 dropdown-menu">
                            <div class="box_n1">
                                <a href="javascript:void(0);">Show All Notifications</a>
                            </div>
                            
                            <?php $__empty_1 = true; $__currentLoopData = Auth::user()->unreadNotifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <!--<div style="background-color:cyan;"></div>-->
                            <?php 
                                // dd(is_array($notification->data) ? 'array' : 'not array' );
                                $notificationData = $notification->data['data']; 
                                // dd($notificationData);
                            ?>
                            <div class="box_n1 box_text" id="notification-<?php echo e($notification->id); ?>">
                                <h6><span><?php echo e($notificationData['item_code'] ?? 'item_code'); ?></span> <?php echo e($notificationData['message'] ?? 'message'); ?></h6>
                                <div class="text-danger">
                                    <small><?php echo e($notificationData['date_time'] ?? 'date_time'); ?></small>
                                </div>
                                <a href="javascript:void(0);" class="markAsRead" id="hide_noti-<?php echo e($notification->id); ?>" data-record_id="<?php echo e($notification->id); ?>">
                                    <i class="icofont-close-line"></i>
                                </a>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="box_n1 box_text">
                                <!-- <h6><span>J123450</span> due tomorrow</h6> -->
                                <div class="text-danger">
                                    <small>No record found!</small>
                                </div>
                                <a href="javascript:void(0);" id="hide_noti">
                                    <i class="icofont-close-line"></i>
                                </a>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="name-of-user">
                        <div class="btn-group">
                            <button type="button" class="dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                <label><?php echo e(auth()->user()->fullname); ?><span><?php echo e(!empty(auth()->user()->role) ? auth()->user()->role->name : \App\Models\Admin::SUBADMIN); ?></span></label>
                                <?php $fullname = auth()->user()->fullname ?>
                                <i><?php echo e(ucfirst($fullname[0])); ?></i>
                            </button>
                            <div class="dropdown-menu dropdown-menu-end">
                                <a class="dropdown-item <?php echo e(in_array($routeName,['admin.showPasswordForm']) ? 'active_l':''); ?>"
                                   href="<?php echo e(route('admin.showPasswordForm')); ?>">
                                    Change Password
                                </a>
                                <a class="dropdown-item <?php echo e(in_array($routeName,['admin.showProfileForm']) ? 'active_l':''); ?>"
                                   href="<?php echo e(route('admin.showProfileForm')); ?>">
                                    My Profile
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="nav_right_content d-flex align-items-center">
                    <div class="d-flex align-items-center ps-2">
                        
                    </div>
                    <div class="d-flex align-items-center log">
                        <a href="<?php echo e(route('admin.logout')); ?>"
                            onclick="event.preventDefault(); document.getElementById('logout-form').submit();"><p>Log Out<img class="ms-2" src="<?php echo e(asset('public/img/logout.png')); ?>"/></p></a>
                        <form id="logout-form" action="<?php echo e(route('admin.logout')); ?>" method="POST" style="display: none;">
                            <?php echo csrf_field(); ?>
                        </form>
                    </div>
                </div>
            </div>
        </nav>
    </div>
</header>

<script>
    $(document).ready(function () {
        //---------------------- Notification JS Starts --------------------
        $('#notification_box').click(function () {
            $('.drop_1').slideToggle();
        });
        
        // $("#hide_noti").click(function () {
        //     $('.box_text').hide();
        // });

        $('#hide_noti').on('click', function(){
            $('.drop_1.dropdown-menu').hide();
        });

		$('.markAsRead').on('click', function(e){
			e.preventDefault();
			var record_id = $(this).data("record_id");
            console.log('record_id :', record_id);

	        $.ajax({
	            url: "<?php echo e(route('admin.markNotificationAsRead')); ?>",
	            type: "POST",
	            cache: false,
	            data: {"_token":"<?php echo e(csrf_token()); ?>", id:record_id},
	            dataType: 'json',
	            success:function(res){
		            console.log(res);
		            if (res.status == 0) {
		                error(res.message, res.title); 
		            }else if (res.status == 1) {
		                $('#notification-'+record_id).remove();
		                success(res.message, res.title);
		            }
	            },
	            error: function(response) {
	            	$('#message-error').text(response.responseJSON.errors.message);
	            }
	        });
		});
        //------------------------ Notification JS Ends --------------------

        //---------------------- Switch Dashboard JS Starts ----------------
        $('#dashboardDropdown').change(function(){
            _this = $(this);
            var selectedVal = _this.val();
            // _this.children().removeClass('active');
            // $('#'+selectedVal+'Dashboard').addClass('active');

            var requestedUrl = '<?php echo e(route("switchDashboard", ":requestFor")); ?>';
            requestedUrl = requestedUrl.replace(':requestFor', selectedVal);
            console.log('requestedUrl', requestedUrl);

            $.ajax({
                type:'GET',
                url: requestedUrl,
                success: function(res){
                    console.log('res :'+res);

                    if(res.status==0){
                        error(res.message, res.title);
                    }else if(res.status==1){
                        window.open(res.data, '_blank');
                        success(res.message, res.title);  
                        location.reload(true); 
                    }
                },
            });
        });
        //---------------------- Switch Dashboard JS Ends ------------------
    });
</script><?php /**PATH /home/sancysup/public_html/sancy_erp/resources/views/admin/elements/layouts/nav.blade.php ENDPATH**/ ?>