<div class="modal fade" id="invoice" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog invoice_1 modal-xl">
        <div class="modal-content">
            <div class="modal-header border-0">
                <h5 class="modal-title" id="exampleModalLabel">Invoice</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="invoice_item">
                    <p>Pay Amount in:</p>
                    <ul>
                        <input type="hidden" id="invoice_id" name="invoice_id">
                        <li class="nav-link print_active full_payment">
                            <a href="javascript:void(0)">Full</a>
                            <input type="hidden" id="full_paid_amount" name="full_paid_amount" value="">   
                           
                        </li>
                        <li class="nav-link print_active layaway_click no_vip"><a href="javascript:void(0)">Layaway</a></li>
                        <li class="nav-link border-0 layaway_amount layway_deposite_amount" style="display: none;">
                            <input type="text" class="form-control" id="paid_amount" placeholder="First deposit amount ($)">
                            <label class="field_error" id="deposit_amount"> </label>
                        </li>
                    </ul>
                    <div class="text-center mt-4">
                        <a href="javascript:void(0)" type="button" class="btn btn-secondary no_print btn_print btnprn mx-auto">Print Invoice</a>
                    </div>
                </div>
            </div>
            <div class="modal-footer border-top-0">
            </div>
        </div>
    </div>
</div>

<script>

    $("body").delegate(".print_active", "click", function () {
        let $_this = $(this);
        $('.print_active').removeClass('active');
        $('.print_active').addClass('no_print');
        $_this.addClass('active'); 
    });

    $('.full_payment').click(function(){
        var invoice_id = $('#invoice_id').val();
        var paid_amount = $('#full_paid_amount').val();
        $('#loader').show();
        updatePayment(invoice_id,paid_amount);
    });

    $('.layaway_click').click(function(){
        $('.layaway_amount').show();
        $('.layaway_amount').addClass('active')
        $('.btn_print').addClass('printActive')
    });

    $('.layaway_amount').on('focusout',function(){
        var invoice_id = $('#invoice_id').val();
        var paid_amount = $('#paid_amount').val();
        $('#loader').show();
        updatePayment(invoice_id,paid_amount);
        // $('#paid_amount').val('');
    });
    
    function updatePayment(invoice_id,paid_amount){
        $.ajax({
            url: "<?php echo e(route('invoices.updatePayment')); ?>",
            type: "json",
            data: {'invoice_id':invoice_id,'paid_amount':paid_amount},
            method: 'POST',
            cache: false,
            beforeSend: function () {
                $('.field_error').html('');
            },
            success: function (response) { 
                $('#loader').hide();

                if(!response.errors){    
                    if(response.status == 1){
                        alertMessageRight(response.message, 'success');
                        $('.btn_print').addClass('printActive');
                        $('.btn_print').removeClass('no_print');
                        $('#paid_amount').addClass('no_print')
                    }else{
                        alertMessageRight(response.message,'error');
                    }
                } else{
                    $.each(response.errors,function(key,value){
                        $('#deposit_amount').html(value)
                      alertMessageRight(value,'error');
                    });
                }
            }
        });
    }


    $('body').on('hidden.bs.modal','#invoice',function(){
      
      location.href = "<?php echo e(route('invoices.todaysSales')); ?>"
      
    });

</script><?php /**PATH /home/sancysup/public_html/sancy_erp/resources/views/frontend/invoices/pay_amount_with_print_invoice_popup.blade.php ENDPATH**/ ?>