<?php 
    use App\Models\Quotation;
    $shopSettings = \App\Models\Setting::shop_settings(); 
?>



<?php $__env->startSection('title',"Print Quotation"); ?>

<?php $__env->startSection('header', "Print Quotation"); ?>

<?php $__env->startSection('content'); ?>

<table style="max-width:500px; width:100%; margin:0 auto; padding:40px;">
    <tbody>
        <tr style="">
            <td>
              <img style="margin-bottom:60px;" src="<?php echo e(asset('public/img/print_order_voucher.png')); ?>" alt="logo">
            </td>
            <td style="vertical-align:baseline; text-align:right;">
                <h5 style="margin:0px; font-size:12px; font-weight:600; color:#BE1E2D; opacity:0.6;">Quotation No. <?php echo e(empty($quotation->quotation_no) ?  getItemCode(Quotation::ZEROES, $quotation->id, Quotation::QUOTATION) : $quotation->quotation_no); ?></h5>
                <p style="margin:0px;font-weight: 300;font-size:12px;color:#000;">
                    Date <?php echo e(date('d/m/Y', strtotime($quotation->reference_date))); ?>

                </p>
                <p style="margin:0px; font-weight:300; font-size:12px; color:#000;">
                    Order Voucher No. <?php echo e(empty($quotation->quotation_no) ?  getItemCode(Quotation::ZEROES, $quotation->id, Quotation::VOUCHER) : $quotation->quotation_no); ?>

                </p>
            </td>
        </tr>
        <tr style="margin-top:20px;">
            <td style="font-size:12px;">
                <p style="color:#64748B; margin:0px;">Sales Person: 
                    <span style="color:#BE1E2D; opacity:0.6; font-weight:600;padding-left:15px; margin:0px;">
                        <?php echo e(ucwords($quotation->staff_name) ?? $quotation->staff ? ucwords($quotation->staff->fullname) : ''); ?>

                    </span>
                </p>
                <p></p>
            </td>
            <td style="font-size:12px; text-align:right;">
                <p style="color:#64748B ;margin:0px;">Received From: 
                    <span style="color:#BE1E2D; opacity:0.6; font-weight:600;padding-left:15px;">
                        <?php echo e(ucwords($quotation->customer_name) ?? ucwords($quotation->customer->fullname) ?? ''); ?>

                    </span>
                </p>
                <p></p>
            </td>
        </tr>
        <tr style="">
            <td>
                <p style="font-size:10px;font-weight:300;color:#000;margin:0px;"><?php echo e($shopSettings['email']); ?></p>
            </td>
            <td style="text-align:right;">
                <p style="font-size:10px;font-weight:300;color:#000;margin:0px;"><?php echo e($quotation->customer_email ?? $quotation->customer->email ?? ''); ?></p>
            </td>
        </tr>
        <tr style="">
            <td>
                <p style="font-size:10px; font-weight:300; color:#000;">
                    <?php echo e($shopSettings['address_line1']); ?>

                    <span style="display:block;">
                        <?php echo e($shopSettings['address_line2']); ?>

                    </span>
                    <span style="display:block;">
                        <?php echo e($shopSettings['phone']); ?>

                    </span>
                </p>
            </td>
            <td  style="text-align:right;">
                <p style="font-size:10px; margin-top:0; font-weight:300; color:#000;">    
                    <?php echo e($quotation->customer_phone ?? ($quotation->customer->phone ?? '')); ?>

                </p>
            </td>
        </tr>
        <tr style="">
            <td style="" colspan="2">
                <table cellpadding="0" cellspacing="0" style="width:100%;">
                    <thead>
                        <tr>
                            <th style="font-weight:600; font-size:10px; line-height:10px; color:#fff; background:#88020F; text-align: left; padding:10px 10px 10px 20px; width:10%;text-transform:uppercase;">Item <br/>Code
                            </th>
                            <th style="font-weight:600; font-size:10px; line-height:10px; color:#fff; background:#88020F; text-align: left; padding:10px 10px 10px 20px; width:10%;text-transform:uppercase;">
                                Item
                            </th>
                            <th style="font-weight:600; font-size:10px; line-height:10px; color:#fff; background:#88020F; text-align: left; padding:10px 10px 10px 20px; width:10%;text-transform:uppercase;">
                                Price
                            </th>
                            <th style="font-weight:600; font-size:10px; line-height:10px; color:#fff; background:#88020F; text-align: left; padding:10px 10px 10px 20px; width:10%;text-transform:uppercase;">
                                Gold Colour
                            </th>
                        </tr>
                    </thead>
                    <?php $counter = 1; ?>
                    <?php $__empty_1 = true; $__currentLoopData = $quotation->quotation_item; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $quotationItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr style="">
                            <td style="margin-top:10px; vertical-align:top;border-top:1px solid rgb(0 0 0 / 10%); border-bottom:1px solid rgb(0 0 0 / 10%); padding: 5px 21px;">
                                <h4 style="margin:0px; text-align:left; font-size:12px; font-weight:400; color:#000000; line-height:12px;"><?php echo e($quotationItem->item_code ?? '-'); ?></h4>
                            </td>
                            <td style="margin-top:10px; vertical-align:top;border-bottom:1px solid rgb(0 0 0 / 10%); border-top:1px solid rgb(0 0 0 / 10%); padding:5px 21px;">
                                <div style="width:216px;">
                                    <p style="margin:0px; text-align:left; font-size:10px; font-weight:400; color:#000000; line-height:12px;">
                                        <?php echo e($quotationItem->description ?? '-'); ?>

                                    </p>
                                    <?php if(quotationItemImage($quotationItem) !== null): ?>
                                        <img style="width:100%; margin-top:5px; <?php echo e((quotationItemImage($quotationItem) == getDefaultImage()) ? 'height:100px;' : ''); ?>" src="<?php echo e(quotationItemImage($quotationItem)); ?>">
                                    <?php endif; ?>
                                </div>
                            </td>
                            <td style="margin-top:10px; vertical-align:top;border-bottom:1px solid rgb(0 0 0 / 10%); border-top:1px solid rgb(0 0 0 / 10%); padding:5px 21px;">
                                <p style="margin:0px; text-align:left; font-size:10px; font-weight:400; color:#000000; line-height:12px;">$<span class="item_price" id="price-<?php echo e($counter); ?>" data-id="<?php echo e($quotationItem->id); ?>"><?php echo e($quotationItem->sub_total ?? '0'); ?></span></p>
                            </td>
                            <td style="margin-top:10px; vertical-align:top;border-bottom:1px solid rgb(0 0 0 / 10%); border-top:1px solid rgb(0 0 0 / 10%); padding:5px 21px;">
                                <p style="margin:0px; text-align:left; font-size:10px; font-weight:400; color:#000000; line-height:12px;"><?php echo e($quotationItem->gold_color->name ?? '-'); ?></p>
                            </td>
                        </tr>
                        <?php $counter++; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr style="">
                            <td colspan="4">No record found!</td>
                        </tr>
                    <?php endif; ?>
                </table>
                <table cellpadding="0" cellspacing="0" style="width: 100%;">
                    <tr style="">
                        <td style="margin-top:10px; vertical-align:top;">
                            <div style="max-width:240px; text-align:right;margin-left:auto; width:100%; margin-top:83px;">
                                <div style="padding-bottom:0px;">
                                    <h4 style="margin:0px; text-align:left; font-size:12px; font-weight:400; line-height:14px; display:inline-block; color:#777;">Subtotal:</h4>
                                    <img src="<?php echo e(asset('public/img/Line_1.png')); ?>" style="height:1px; display:inline-block;">
                                    <p style="margin:0px; font-size:12px;font-weight:600; line-height:14px; display: inline-block; color:#777;">$<span id="
                                        subtotal"><?php echo e($quotation->quotation_item_sum_sub_total); ?>

                                        </span>
                                    </p>
                                </div>
                                <div style="padding-bottom: 20px;">
                                    <h4 style="margin:0px; text-align:left;font-size:12px; font-weight:400; line-height: 14px; display:inline-block; color:#777;">GST:</h4>
                                    <img src="<?php echo e(asset('public/img/Line_2.png')); ?>" style="height:1px; display:inline-block;">
                                    <p style="margin:0px; font-size:12px;font-weight:600; line-height:14px; display: inline-block;color:#777;">$<span id="gst"><?php echo e($quotation->gst_total); ?></span></p>
                                </div>
                                <div style="padding-bottom:10px;">
                                    <h4 style="margin:0px; text-align:left; font-size:12px; font-weight:600; line-height:16px; display:inline-block;">Total:</h4> 
                                    <img src="<?php echo e(asset('public/img/Line_3.png')); ?>" style="height:1px; display:inline-block;">
                                    <p style="margin:0px; font-size:12px;font-weight:600; line-height:16px; display: inline-block;">$<span id="total"><?php echo e($quotation->grand_total); ?></span></p>
                                </div>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td style="margin-top:10px; vertical-align:top;">
                            <p style="font-weight:300; font-size:6px; line-height:9px;">EVERY CARE WILL BE TAKEN WITH JEWELLERY ARTICLES WITH US FOR SETTING OR MAKING. HOWEVER IN CASE OF DAMAGE OR LOSS, MAXIMUM CONPENSATION 
                            SHALLBE BASED ON THE AMOUNT STATED ABOVE. CUSTOMERS ARE REQUESTED TO PAY FOR THE SETTING FEE IN ACCORDANCE WITH THE PERVAILING GOLD RETAIL 
                            PRICE. THIS ORDER IS VALID FOR 6 MONTHS ONLY.</p>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </tbody>
</table>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.new_print', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/sancysup/public_html/sancy_erp/resources/views/frontend/quotations/print/print_quotation.blade.php ENDPATH**/ ?>