<?php
$inventory = \App\Models\QuotationItem::INVENTORY;
$bespoke = \App\Models\QuotationItem::BESPOKE;
$repair = \App\Models\QuotationItem::REPAIR;
$buttonIndex = $buttonIndex+1;
?>

<div class="content-<?php echo e($buttonIndex); ?>">
    <div class="card-body create_quotation custom-create-quote">
        <div class="add_item add_item_custom">
            <div class="items">
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="exampleFormControlInput1" class="form-label head"><?php echo __('content.add_item_from_with_br'); ?></label>
                        </div>
                    </div>
                    <div class="col-md-9">
                        <ul class="nav nav-tabs ms-auto">
                            <li class="nav-item" role="presentation">
                                <button id="inventory-<?php echo e($buttonIndex); ?>"  type="button"  class="nav-link  inventory qutation_type" data-id="<?php echo e($inventory); ?>"><?php echo __('content.inventory_with_br'); ?></button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button id="bespoke-<?php echo e($buttonIndex); ?>"  type="button"  class="nav-link bespoke qutation_type" data-id="<?php echo e($bespoke); ?>"><?php echo __('content.bespoke_with_br'); ?></button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button id="repair-<?php echo e($buttonIndex); ?>"  type="button"  class="nav-link repair qutation_type" data-id="<?php echo e($repair); ?>"><?php echo __('content.repair_with_br'); ?></button>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="card-body create_quotation" id="inventory_fields-<?php echo e($buttonIndex); ?>" style="display: none;">
        <div class="add_item">
            <div class="items">
                <div class="tab-content add_items_content content-<?php echo e($buttonIndex); ?>">
                    <div class="position-relative add_items_item mt-0">
                        <div class="search">
                            <img src="<?php echo e(asset('public/img/search.png')); ?>">
                            <input type="text" name="qut[<?php echo e($buttonIndex); ?>][<?php echo e($inventory); ?>][item_code]" class="form-control cus_form_control jewelley_item_code" id="jewelley_item_code-<?php echo e($buttonIndex); ?>" placeholder="Enter or Search Item Code">
                            <span class="field_error" id="item_code_error-<?php echo e($buttonIndex); ?>" style="color:red"> </span>
                        </div>

                        <div class="checkout text-end">
                            <button class="btn btn_confirm inventory_confirm" type="button" data-type="<?php echo e($inventory); ?>" data-key="<?php echo e($buttonIndex); ?>"><?php echo __('content.confirm_with_br'); ?></button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="card-body create_quotation" id="bespoke_fields-<?php echo e($buttonIndex); ?>" style="display: none;">
        <div class="add_item add_item_custom">
            <div class="items">
                <div class="tab-content add_items_content content-<?php echo e($buttonIndex); ?>">
                    <div class="add_items_bespoke mt-0">
                        <div class="position-relative add_items_item">
                            <div class="form-group">
                                <label for="exampleFormControlInput1" class="form-label">Category</label>
                            </div>
                            <ul class="bespoke_category_ul-<?php echo e($buttonIndex); ?>">
                                <?php
                                    $categories = \App\Models\Category::getCategories();
                                    $gold_colors = \App\Models\GoldColor::getGoldColorsList();
                                ?>
                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="nav-link ">
                                        <a data-key="<?php echo e($buttonIndex); ?>" data-type="<?php echo e($bespoke); ?>" class="category_id d-block"  value= "<?php echo e($value->id); ?>" ><?php echo e(__('content.'.strtolower($value->name))); ?></a>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <input type="hidden" id="bespoke_category_id-<?php echo e($buttonIndex); ?>" name="qut[<?php echo e($buttonIndex); ?>][<?php echo e($bespoke); ?>][category_id]"  value="">
                                <span class="field_error" id="bespoke_category_id_error-<?php echo e($buttonIndex); ?>"> </span>
                            </ul>
                        </div>
                        <div class="position-relative add_items_item">
                            <div class="form-group">
                                <label for="exampleFormControlInput1" class="form-label"><?php echo e(__('content.description')); ?></label>
                                <input type="text" id="bespoke_description-<?php echo e($buttonIndex); ?>" name="qut[<?php echo e($buttonIndex); ?>][<?php echo e($bespoke); ?>][description]" class="form-control" placeholder="Enter description...">
                                <span class="field_error" id="bespoke_description_error-<?php echo e($buttonIndex); ?>"> </span>
                            </div>
                            <div class="checkout text-start">
                                <button class="btn btn_confirm btn_illustration bespokeIllustrationModal-<?php echo e($buttonIndex); ?>" data-key="<?php echo e($buttonIndex); ?>" type="button" data-bs-toggle="modal"
                                        data-bs-target="#bespokeIllustrationModal-<?php echo e($buttonIndex); ?>">
                                    Add Illustration
                                </button>
                            </div>
                        </div>
                        <div class="position-relative add_items_item">
                            <div class="form-group">
                                <label for="exampleFormControlInput1" class="form-label"><?php echo e(__('content.gold_colour')); ?></label>
                            </div>
                            <ul class="gold_color bespoke_gold_color_ul-<?php echo e($buttonIndex); ?>">
                                <?php $__currentLoopData = $gold_colors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                      $val = strtok($value," ");
                                    ?>
                                    <li class="nav-link">
                                        <a data-key="<?php echo e($buttonIndex); ?>" data-type="<?php echo e($bespoke); ?>" class="gold_color_id d-block"  value="<?php echo e($key); ?>" ><?php echo e(__('content.'.strtolower($val))); ?></a>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <input type="hidden" id="bespoke_gold_color_id-<?php echo e($buttonIndex); ?>" name="qut[<?php echo e($buttonIndex); ?>][<?php echo e($bespoke); ?>][gold_color_id]"  value="">
                                <span class="field_error" id="bespoke_gold_color_id_error-<?php echo e($buttonIndex); ?>"> </span>
                            </ul>
                        </div>
                        <div class="position-relative add_items_item">
                            <div class="row">
                                <div class="col-lg-6 col-md-6">
                                    <div class="form-group pt-0">
                                        <label for="exampleFormControlInput1" class="form-label"><?php echo e(__('content.additional_material')); ?></label>
                                        <input type="text" class="form-control" id="bespoke_material-<?php echo e($buttonIndex); ?>" name="qut[<?php echo e($buttonIndex); ?>][<?php echo e($bespoke); ?>][material]"  placeholder="Enter material">
                                        <span class="field_error" id="bespoke_material_error-<?php echo e($buttonIndex); ?>"> </span>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-6">
                                    <div class="form-group pt-0">
                                        <label for="exampleFormControlInput1" class="form-label"><?php echo e(__('content.quantity')); ?> </label>
                                        <input type="text" class="form-control" id="bespoke_quantity-<?php echo e($buttonIndex); ?>" name="qut[<?php echo e($buttonIndex); ?>][<?php echo e($bespoke); ?>][quantity]"  placeholder="">
                                        <span class="field_error" id="bespoke_quantity_error-<?php echo e($buttonIndex); ?>"> </span>  </div>
                                </div>
                                <div class="col-lg-12 col-md-12 col-12 mt-4">
                                    <div class="form-check">
                                        <input class="form-check-input" value="1" name="qut[<?php echo e($buttonIndex); ?>][<?php echo e($bespoke); ?>][customer_received]"  type="checkbox" id="bespoke_customer_received-<?php echo e($buttonIndex); ?>">
                                        <label class="form-check-label" for="gridCheck">
                                            <?php echo e(__('content.jewellry_received')); ?>

                                        </label>
                                    </div>
                                </div>
                                <div class="checkout text-end">
                                    <button class="btn btn_confirm bespoke_repair_confirm" type="button" data-type="<?php echo e($bespoke); ?>" data-key="<?php echo e($buttonIndex); ?>" ><?php echo __('content.confirm_with_br'); ?></button>
                                    
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="card-body create_quotation" id="repair_fields-<?php echo e($buttonIndex); ?>" style="display: none;">
        <div class="add_item add_item_custom">
            <div class="items">
                <div class="tab-content add_items_content">
                    <div class="add_items_bespoke mt-0">

                        <div class="position-relative add_items_item">
                            <div class="form-group">
                                <label for="exampleFormControlInput1" class="form-label">Category</label>
                            </div>
                            <ul class="repair_category_ul-<?php echo e($buttonIndex); ?>">

                                <?php
                                    $categories = \App\Models\Category::getCategories();
                                    $gold_colors = \App\Models\GoldColor::getGoldColorsList();

                                ?>
                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="nav-link ">
                                        <a  data-key="<?php echo e($buttonIndex); ?>" data-type="<?php echo e($repair); ?>" class="category_id d-block"  value= "<?php echo e($value->id); ?>" ><?php echo e(__('content.'.strtolower($value->name))); ?></a>
                                    </li>

                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                <input type="hidden" id="repair_category_id-<?php echo e($buttonIndex); ?>" name="qut[<?php echo e($buttonIndex); ?>][<?php echo e($repair); ?>][category_id]" value="">
                            </ul>
                            <div><span class="field_error" id="repair_category_id_error-<?php echo e($buttonIndex); ?>"> </span></div>
                        </div>
                        <div class="position-relative add_items_item">
                            <div class="form-group">
                                <label for="exampleFormControlInput1" class="form-label"><?php echo e(__('content.description')); ?></label>
                                <input type="text" id="repair_description-<?php echo e($buttonIndex); ?>" name="qut[<?php echo e($buttonIndex); ?>][<?php echo e($repair); ?>][description]" class="form-control"  placeholder="Enter description...">
                                <span class="field_error" id="repair_description_error-<?php echo e($buttonIndex); ?>" style="color:red"> </span>
                            </div>
                            <div class="checkout text-start">
                                <button class="btn btn_confirm btn_illustration repairIllustrationModal-<?php echo e($buttonIndex); ?>" data-key="<?php echo e($buttonIndex); ?>" type="button" data-bs-toggle="modal"
                                        data-bs-target="#repairIllustrationModal-<?php echo e($buttonIndex); ?>">
                                    Add Illustration
                                </button>
                            </div>
                        </div>
                        <div class="position-relative add_items_item">
                            <div class="form-group">
                                <label for="exampleFormControlInput1" class="form-label"><?php echo e(__('content.gold_colour')); ?></label>
                            </div>
                            <ul class="gold_color repair_gold_color_ul-<?php echo e($buttonIndex); ?>">

                                <?php $__currentLoopData = $gold_colors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $val = strtok($value," ");
                                    ?>
                                    <li class="nav-link">
                                        <a data-key="<?php echo e($buttonIndex); ?>" data-type="<?php echo e($repair); ?>" class="gold_color_id d-block"  value="<?php echo e($key); ?>" ><?php echo e(__('content.'.strtolower($val))); ?></a>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                <input type="hidden" id="repair_gold_color_id-<?php echo e($buttonIndex); ?>" name="qut[<?php echo e($buttonIndex); ?>][<?php echo e($repair); ?>][gold_color_id]" value="">
                                <span class="field_error" id="repair_gold_color_id_error-<?php echo e($buttonIndex); ?>" style="color:red"> </span>
                            </ul>
                        </div>
                        <div class="position-relative add_items_item">
                            <div class="row">
                                <div class="col-lg-6 col-md-6">
                                    <div class="form-group pt-0">
                                        <label for="exampleFormControlInput1" class="form-label"><?php echo e(__('content.additional_material')); ?></label>
                                        <input type="text" class="form-control" name="qut[<?php echo e($buttonIndex); ?>][<?php echo e($repair); ?>][material]" id="repair_material-<?php echo e($buttonIndex); ?>" placeholder="Enter Material">
                                        <span class="field_error" id="repair_material_error-<?php echo e($buttonIndex); ?>" style="color:red"> </span>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-6">
                                    <div class="form-group pt-0">
                                        <label for="exampleFormControlInput1" class="form-label"><?php echo e(__('content.quantity')); ?> </label>
                                        <input type="text" class="form-control" name="qut[<?php echo e($buttonIndex); ?>][<?php echo e($repair); ?>][quantity]" id="repair_quantity-<?php echo e($buttonIndex); ?>" placeholder="">
                                        <span class="field_error" id="repair_quantity_error-<?php echo e($buttonIndex); ?>" style="color:red"> </span>
                                    </div>
                                </div>
                                <div class="col-lg-12 col-md-12 col-12 mt-4">
                                    <div class="form-check">
                                        <input class="form-check-input"  name="qut[<?php echo e($buttonIndex); ?>][<?php echo e($repair); ?>][customer_received]"  type="checkbox" id="repair_customer_received-<?php echo e($buttonIndex); ?>" value="1">
                                        <label class="form-check-label" for="gridCheck">
                                            <?php echo e(__('content.jewellry_received')); ?>

                                        </label>
                                    </div>
                                </div>

                                <div class="checkout text-end">
                                    <button class="btn btn_confirm bespoke_repair_confirm" type="button"  data-type="<?php echo e($repair); ?>" data-key="<?php echo e($buttonIndex); ?>" ><?php echo __('content.confirm_with_br'); ?></button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="bespokeIllustrationModal-<?php echo e($buttonIndex); ?>" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog illustration_dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"><?php echo e(__('content.add_illustation')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6 d-flex align-items-center">
                            <div class="required_photo">
                                <div class="dropzone dropZoneimageUpload" id="bespokeDropZoneimageUpload-<?php echo e($buttonIndex); ?>">
                                    <span class="drop-zone__prompt dz-default dz-message">
                                    <div>
                                    <p>Click here to add photo</p>
                                    <span>Photo Requiement:</span>
                                    <ul>
                                    <li>File type PNG or JPG</li>
                                    <li>Maximum Size: 2 MB</li>
                                    </ul>
                                    </div>
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="form-group modal_drawing pt-0">
                                <div class="start-drawing" id="blackboardPlaceholder">
                                    <p>Start Drawing</p>
                                    <canvas data-key="<?php echo e($buttonIndex); ?>" class="drawingCanvas bespoke_drawingCanvas" width="500" height="230"></canvas>
                                    <div class="pen-eraser">
                                    <span class="pen" onclick="togglePenPointer(this);"><img
                                                src="<?php echo e(asset('public/img/pen.png')); ?>"/></span>
                                        <span class="erase" onclick="eraserHandler(this);"><img
                                                    src="<?php echo e(asset('public/img/eraser.png')); ?>"/></span>
                                    </div>
                                </div>
                                <input type="hidden" id="drawing_textarea_base64-0"
                                name="qut[<?php echo e($buttonIndex); ?>][<?php echo e($bespoke); ?>][drawing_textarea_base64]">
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <div id="bespoke-template-preview-<?php echo e($buttonIndex); ?>" class="preview-droped-images" >
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" data-key="<?php echo e($buttonIndex); ?>" data-type="<?php echo e($bespoke); ?>"  class="btn btn-primary btn-save illustration_save"><?php echo e(__('content.save')); ?> </button>
                    <input type="hidden" class="illustrartion" name="qut[<?php echo e($buttonIndex); ?>][<?php echo e($bespoke); ?>][illustration]" value="">
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="repairIllustrationModal-<?php echo e($buttonIndex); ?>" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog illustration_dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"><?php echo e(__('content.add_illustation')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6 d-flex align-items-center">
                            <div class="required_photo">
                                <div class="dropzone dropZoneimageUpload" id="repairDropZoneimageUpload-<?php echo e($buttonIndex); ?>">
                                    <span class="drop-zone__prompt dz-default dz-message">
                                    <div>
                                    <p>Click here to add photo</p>
                                    <span>Photo Requiement:</span>
                                    <ul>
                                    <li>File type PNG or JPG</li>
                                    <li>Maximum Size: 2 KB</li>
                                    </ul>
                                    </div>
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="form-group modal_drawing pt-0">
                                <div class="start-drawing" id="blackboardPlaceholder">
                                    <p>Start Drawing</p>
                                    <canvas data-key="<?php echo e($buttonIndex); ?>" class="drawingCanvas repair_drawingCanvas" width="500" height="230"></canvas>
                                    <div class="pen-eraser">
                                    <span class="pen" onclick="togglePenPointer(this);"><img
                                                src="<?php echo e(asset('public/img/pen.png')); ?>"/></span>
                                        <span class="erase" onclick="eraserHandler(this);"><img
                                                    src="<?php echo e(asset('public/img/eraser.png')); ?>"/></span>
                                    </div>
                                </div>
                                <input type="hidden"  name="qut[<?php echo e($buttonIndex); ?>][<?php echo e($repair); ?>][drawing_textarea_base64]">
                            </div>
                        </div>

                        <div class="col-lg-12">
                            <div id="repair-template-preview-<?php echo e($buttonIndex); ?>" class="preview-droped-images" >
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" data-key="<?php echo e($buttonIndex); ?>" data-type="<?php echo e($repair); ?>" class="btn btn-primary btn-save illustration_save"><?php echo e(__('content.save')); ?> </button>
                    <input type="hidden" class="illustrartion" name="qut[<?php echo e($buttonIndex); ?>][<?php echo e($repair); ?>][illustration]" value="">
                </div>
            </div>
        </div>
    </div>

</div>
<?php /**PATH /home/sancysup/public_html/sancy_erp/resources/views/frontend/quotations/button_render.blade.php ENDPATH**/ ?>