<?php $__env->startSection('title',"Quotations"); ?>

<?php $__env->startSection('header', "Quotations"); ?>

<?php $__env->startSection('content'); ?>

    

    <div class="card mb-4">
        <div class="card-header">
            <h4 class="mb-0">All Quotations</h4>
            <p>This section displays all quotations.</p>
        </div>
        <div class="card-body">
            <?php $placeholder = "Search Quotation Number, Phone Number..."; ?>

            <?php echo $__env->make('admin.elements.search.common', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="earring-table table-responsive">
                <table class="table stock-detail">
                    <thead>
                    <tr>
                        <th><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('quotation.reference_date', __('content.date')));?></th>
                        <th><?php echo e(__('content.quotation_id')); ?></th> 
                        
                        <th><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('total', __('content.amount')));?></th>
                        <th><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('quotation.customer_name', __('content.customer')));?></th>
                        <th><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('quotation.customer_phone', __('content.phone_number')));?></th>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['quotation-convertToInvoice','quotation-convertToInvoice','quotation-printOrderVoucher','quotation-print','quotation-update','quotation-delete'])): ?> 
                        <th><?php echo e(__('content.action')); ?></th>
                        <?php endif; ?> 
                    </tr>
                    </thead>
                    <tbody>
                    <?php if(!empty($records) && $records->count()): ?>
                        <?php $slNo = $records->firstItem() ?>
                        <?php $__currentLoopData = $records; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $record): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e(isset($record->reference_date) ? date('d/m/Y' , strtotime($record->reference_date)) : '-'); ?></td>
                                <td><?php echo e($record->quotation_no ?? '-'); ?></td> 
                                
                                <td><?php echo e(isset($record->total) ? '$'. $record->total : '-'); ?></td>
                                <td class="text-nowrap"><?php echo e(isset($record->customer_name) ? ucwords($record->customer_name) : (isset($record->customer_id) ? ucwords($record->customer->fullname) : '-')); ?></td>
                                <td class="text-nowrap"><?php echo e($record->phone_with_code); ?></td>

                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['quotation-convertToInvoice', 'quotation-convertToInvoice', 'quotation-printOrderVoucher', 'quotation-print', 'quotation-update', 'quotation-delete'])): ?>
                                <td>
                                    <div class="dropdown">
                                        <button class="btn btn-secondary down" type="button" id="dropdownMenuButton1"
                                        data-bs-toggle="dropdown" aria-expanded="false">
                                            Action
                                        </button>
                                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                                            <?php  $exist_invoice = App\Models\Invoice::checkInvoiceByQuotation($record->id); ?>
                                            <?php if(empty($exist_invoice)): ?>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quotation-convertToInvoice')): ?> 
                                                    <li><a class="dropdown-item duplicate convert_to_invoice convertToInvoice" data-attr="<?php echo e(route('admin.quotations.convertToInvoice')); ?>" data-id="<?php echo e($record->id); ?>" href="javascript:void(0)"><img src="<?php echo e(asset('public/img/convert_invoice.png')); ?>">Convert to Invoice</a></li>
                                                <?php endif; ?>
                                            <?php endif; ?>
											
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quotation-printOrderVoucher')): ?> 
												<li><a class="dropdown-item btnprn" href="<?php echo e(route('admin.quotations.printOrderVoucher', $record->id)); ?>"><img src="<?php echo e(asset('public/img/print.png')); ?>">Print Order Voucher</a></li>
                                            <?php endif; ?>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quotation-print')): ?>
												<li><a class="dropdown-item" href="<?php echo e(route('admin.quotations.printQuotation', $record->id)); ?>"><img src="<?php echo e(asset('public/img/print.png')); ?>">Print Quotation</a></li>
                                            <?php endif; ?>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quotation-sendEmailPDF')): ?>
												<li><a class="dropdown-item sendEmailPDF" href="javascript:void(0);" id="sendEmailPDF-<?php echo e($record->id); ?>" data-record_id="<?php echo e($record->id); ?>" data-for="quotations"><img src="<?php echo e(asset('public/img/envelope.png')); ?>">Send email</a></li>
                                            <?php endif; ?>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quotation-update')): ?>
                                                <li><a class="dropdown-item" href="<?php echo e(route('admin.quotations.edit', $record->id)); ?>"><img src="<?php echo e(asset('public/img/edit.png')); ?>">Edit</a></li>
                                            <?php endif; ?>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quotation-delete')): ?>
												<li><a class="dropdown-item confirmDelete" href="javascript:void(0);" data-action="<?php echo e(route('admin.quotations.destroy', $record->id)); ?>"><img src=" <?php echo e(asset('public/img/delete.png')); ?> ">Delete</a></li>
                                            <?php endif; ?>

                                        </ul>
                                    </div>
                                </td>
                                <?php endif; ?>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <tr>
                            <td class="text-center" colspan="<?php echo e((auth()->user()->canany(['quotation-convertToInvoice', 'quotation-convertToInvoice', 'quotation-printOrderVoucher', 'quotation-print', 'quotation-update', 'quotation-delete'])) ? '6' : '5'); ?>">No Record Found!</td>
                        </tr>
                    <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <?php echo $__env->make('admin.elements.pagination.common', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>

<?php echo $__env->make('admin.invoices.pay_amount_with_print_invoice_popup', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('admin.quotations.scripts.convert_to_invoice_js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 

<?php echo $__env->make('admin.elements.scripts.pdf_email_js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/sancysup/public_html/sancy_erp/resources/views/admin/quotations/index.blade.php ENDPATH**/ ?>