<?php
     $inventory = \App\Models\QuotationItem::INVENTORY;
     $bespoke = \App\Models\QuotationItem::BESPOKE;
     $repair = \App\Models\QuotationItem::REPAIR;
?>

<div class="items items_new mt-5" >
    <div class="align-items-center">
        <label class="add_itemm">Add Item From*:</label>
        <ul class="nav nav-tabs tabbing-<?php echo e($buttonIndex); ?>" id="myTab" role="tablist">
            <li class="nav-item m-0 me-3" role="presentation">
                <button class="nav-link inventory" data-key="<?php echo e($buttonIndex); ?>"  data-bs-toggle="tab" data-bs-target="#inventory-<?php echo e($buttonIndex); ?>" type="button" role="tab" aria-controls="home" aria-selected="true"><?php echo __('content.inventory_with_br'); ?></button>
            </li>
            <li class="nav-item m-0 me-3" role="presentation">
                <button class="nav-link bespoke" data-key="<?php echo e($buttonIndex); ?>" data-bs-toggle="tab" data-bs-target="#bespoke-<?php echo e($buttonIndex); ?>" type="button" role="tab" aria-controls="profile" aria-selected="false"><?php echo __('content.bespoke_with_br'); ?></button>
            </li>
            <li class="nav-item m-0 me-3" role="presentation">
                <button class="nav-link repair" data-key="<?php echo e($buttonIndex); ?>" data-bs-toggle="tab" data-bs-target="#repair-<?php echo e($buttonIndex); ?>" type="button" role="tab" aria-controls="contact" aria-selected="false"><?php echo __('content.repair_with_br'); ?></button>
            </li>
        </ul>
        <div class="tab-content" id="myTabContent-<?php echo e($buttonIndex); ?>">

            <div class="tab-pane fade show" id="inventory-<?php echo e($buttonIndex); ?>" role="tabpanel" aria-labelledby="home-tab">
                <div class="position-relative add_item_search">
                    <div class="search">
                <span><img src="<?php echo e(asset('public/img/search.png')); ?>" class="display">
                <img src="<?php echo e(asset('public/img/search_foucs.png')); ?>" class="focus_search">
                </span>
                    <div class="d-flex align-items-center position-relative">
                        <div class="input_div w-100">
                        <input type="text" id="jewelley_item_code-<?php echo e($buttonIndex); ?>" class="form-control cus_form_control jewelley_item_code" name="qut[<?php echo e($buttonIndex); ?>][<?php echo e($inventory); ?>][item_code]" placeholder="Search an item code or an scan item...">
                        <label class="field_error" id="item_code_error-<?php echo e($buttonIndex); ?>" style="color:red"> </label>
                        </div>
                        <img src="<?php echo e(asset('public/img/cross.png')); ?>" class="cross">
                    </div>
                    <div class="col-lg-12">
                        <div class="d-flex mt-5">
                            <input type="hidden" id="inventory_subtotal-<?php echo e($buttonIndex); ?>" name="qut[<?php echo e($buttonIndex); ?>][<?php echo e($inventory); ?>][subtotal]" value="">
                            <button data-key="<?php echo e($buttonIndex); ?>" class="btn btn-primary btn-create btn-confirm inventory_confirm me-4" type="button">Confirm Add Item</button>
                            <button class="btn btn-outline-primary btn-reset-form-custom reset_form" data-type="inventory" data-key="<?php echo e($buttonIndex); ?>"  type="button">Reset Form</button>
                        </div>
                    </div>
                    </div>
                </div>
            </div>

            <div class="tab-pane fade" id="bespoke-<?php echo e($buttonIndex); ?>" role="tabpanel" aria-labelledby="profile-tab">
                <div class="position-relative add_item_search add_item_search_custom">
                    <div class="sample card-body mt-0 p-0 pt-4">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="category jobs_edit">
                                    <div class="form-group">
                                        <label for="exampleFormControlInput1" class="form-label">Category</label>
                                    </div>
                                    <ul class="category_ul-<?php echo e($buttonIndex); ?>">
                                        <?php $categories = \App\Models\Category::getCategories(); ?>
                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li class=""><a class="category_id"  data-key="<?php echo e($buttonIndex); ?>" value= "<?php echo e($value->id); ?>" ><img src="<?php echo e($value->image); ?>" height="60" width="60"/><?php echo e($value->name); ?></a></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                    <input  id="bespoke_category_id-<?php echo e($buttonIndex); ?>" type="hidden" name="qut[<?php echo e($buttonIndex); ?>][<?php echo e($bespoke); ?>][category_id]" value=""/>
                                    <label class="field_error" id="bespoke_category_id_error-<?php echo e($buttonIndex); ?>"> </label>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label"><?php echo e(__('content.gold_colour')); ?></label>
                                    <select class="form-select" name="qut[<?php echo e($buttonIndex); ?>][<?php echo e($bespoke); ?>][gold_color_id]"  aria-label="Default select example" onchange="onChangeElem(event)" >
                                        <option value="">Select One Option</option>
                                        <?php $gold_colors = \App\Models\GoldColor::getGoldColorsList(); ?>
                                        <?php $__currentLoopData = $gold_colors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <label class="field_error" id="bespoke_gold_color_id_error-<?php echo e($buttonIndex); ?>"> </label>
                                </div>
                            </div>

                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label"><?php echo e(__('content.size')); ?> </label>
                                    <input type="text"  name="qut[<?php echo e($buttonIndex); ?>][<?php echo e($bespoke); ?>][size]"  class="form-control size" value="" onchange="onChangeElem(event)" >
                                    <label class="field_error" id="bespoke_size_error-<?php echo e($buttonIndex); ?>" style="color:red"> </label>
                                </div>
                            </div>

                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="exampleFormControlInput1"
                                           class="form-label"><?php echo e(__('content.description')); ?> </label>
                                    <textarea class="form-control"  name="qut[<?php echo e($buttonIndex); ?>][<?php echo e($bespoke); ?>][description]"  placeholder="Description" value="" rows="2" onchange="onChangeElem(event)"></textarea>
                                    <label class="field_error" id="bespoke_description_error-<?php echo e($buttonIndex); ?>" style="color:red"> </label>
                                </div>
                            </div>

                            <div class="col-lg-12 mt-3">
                                <label for="exampleFormControlInput1" class="form-label"> <?php echo e(__('content.draw_upload')); ?>

                                    <img src="<?php echo e(asset('public/img/folder.png')); ?>" class="folder">
                                </label>
                                <div class="row">
                                    <div class="col-lg-4">
                                        <div class="form-group pt-0">
                                            <div class="drop-zone">
                                                <div class="dropzone dropZoneimageUpload" id="bespokeDropZoneimageUpload-<?php echo e($buttonIndex); ?>">
                                                <span class="drop-zone__prompt dz-default dz-message">Drop Photo here <br><?php echo e(__('content.drop_photo')); ?>

                                                    <p>Photo Requiement:</p>
                                                    <ul>
                                                    <li>File type PNG or JPG</li>
                                                    <li>Maximum Size: 2 MB</li>
                                                    </ul>
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-lg-8">
                                        <div class="form-group pt-0">
                                            <div class="start-drawing"
                                                 id="blackboardPlaceholder">
                                                <p><?php echo e(__('content.start_drawing')); ?></p>
                                                <canvas  data-key="<?php echo e($buttonIndex); ?>" id="drawingCanvas" class="drawingCanvas bespoke_drawingCanvas" width="500"
                                                        height="230"></canvas>
                                                <div class="pen-eraser">
                                                    <span class="pen" onclick="togglePenPointer(this);"><img src="<?php echo e(asset('public/img/pen.png')); ?>"/></span>
                                                    <span class="erase" onclick="eraserHandler(this);"><img src="<?php echo e(asset('public/img/eraser.png')); ?>"/></span>
                                                </div>
                                            </div>
                                            <input type="hidden" name="qut[<?php echo e($buttonIndex); ?>][<?php echo e($bespoke); ?>][drawing_textarea_base64]" >
                                        </div>
                                    </div>
                                    <div class="col-lg-12">
                                        <div id="bespoke-template-preview-<?php echo e($buttonIndex); ?>" class="preview-droped-images" >
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="sample">
                                    <div class="col-lg-12">
                                        <div class="form-group d-flex align-items-center pt-0">
                                            <label for="exampleFormControlInput1" class="form-label mb-0 pe-5"><?php echo e(__('content.sample_provided')); ?></label>
                                            <div class="form-check">
                                                <input class="form-check-input cus-form-check-input" type="radio"  name="qut[<?php echo e($buttonIndex); ?>][<?php echo e($bespoke); ?>][is_sample_provided]" id="flexRadioDefault1" value="1"  onchange="onChangeElem(event)">
                                                <label class="form-check-label cus_form_check_label" for="flexRadioDefault1"><?php echo e(__('content.yes')); ?></label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input cus-form-check-input" type="radio" name="qut[<?php echo e($buttonIndex); ?>][<?php echo e($bespoke); ?>][is_sample_provided]" value="0" checked="checked"  onchange="onChangeElem(event)" >
                                                <label class="form-check-label cus_form_check_label"
                                                       for="flexRadioDefault1">
                                                    <?php echo e(__('content.no')); ?>

                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label for="exampleFormControlInput1" class="form-label"><?php echo e(__('content.sample_description')); ?></label>
                                            <textarea class="form-control" id="exampleFormControlTextarea1" name="qut[<?php echo e($buttonIndex); ?>][<?php echo e($bespoke); ?>][sample_description]" placeholder="<?php echo e(__('content.description')); ?>" rows="2" onchange="onChangeElem(event)"></textarea>
                                            <label class="field_error" id="bespoke_sample_description_error-<?php echo e($buttonIndex); ?>"> </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="sample">
                                <div class="row">
                                    <div class="col-lg-4">
                                        <div class="form-group pt-0">
                                            <label for="exampleFormControlInput1" class="form-label"><?php echo e(__('content.gold_weight')); ?></label>
                                            <input type="text" class="form-control" name="qut[<?php echo e($buttonIndex); ?>][<?php echo e($bespoke); ?>][gold_weight]" value="" onchange="onChangeElem(event)">
                                            <label class="field_error" id="bespoke_gold_weight_error-<?php echo e($buttonIndex); ?>"> </label>
                                        </div>
                                    </div>
                                    <div class="col-lg-4">
                                        <div class="form-group pt-0">
                                            <label for="exampleFormControlInput1" class="form-label"><?php echo e(__('content.gold_cost')); ?></label>
                                            <input type="text" class="form-control"  name="qut[<?php echo e($buttonIndex); ?>][<?php echo e($bespoke); ?>][gold_cost]"  value="" onchange="onChangeElem(event)">
                                            <label class="field_error" id="bespoke_gold_cost_error-<?php echo e($buttonIndex); ?>" > </label>
                                        </div>
                                    </div>
                                    <div class="col-lg-4">
                                        <div class="form-group pt-0">
                                            <label for="exampleFormControlInput1" class="form-label"><?php echo e(__('content.workmanship_cost')); ?></label>
                                            <input type="text" class="form-control"   name="qut[<?php echo e($buttonIndex); ?>][<?php echo e($bespoke); ?>][craftsmanship_cost]"  value="" onchange="onChangeElem(event)">
                                            <label class="field_error" id="bespoke_craftsmanship_cost_error-<?php echo e($buttonIndex); ?>"> </label>
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label for="exampleFormControlInput1" class="form-label"><?php echo e(__('content.polishing_cost')); ?></label>
                                            <input type="text" class="form-control"  name="qut[<?php echo e($buttonIndex); ?>][<?php echo e($bespoke); ?>][polishing]"  value="" onchange="onChangeElem(event)">
                                            <label class="field_error" id="bespoke_polishing_error-<?php echo e($buttonIndex); ?>"> </label>
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label for="exampleFormControlInput1" class="form-label"><?php echo e(__('content.setting_cost')); ?></label>
                                            <input type="text" class="form-control" name="qut[<?php echo e($buttonIndex); ?>][<?php echo e($bespoke); ?>][setting_cost]"  value="" onchange="onChangeElem(event)">
                                            <label class="field_error" id="bespoke_setting_cost_error-<?php echo e($buttonIndex); ?>"> </label>
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label for="exampleFormControlInput1" class="form-label"><?php echo e(__('content.earing_pin')); ?></label>
                                            <input type="text" class="form-control"  name="qut[<?php echo e($buttonIndex); ?>][<?php echo e($bespoke); ?>][earing_pin]" value="" onchange="onChangeElem(event)">
                                            <label class="field_error" id="bespoke_earing_pin_error-<?php echo e($buttonIndex); ?>"> </label>
                                        </div>
                                    </div>
                                    <div class="col-lg-6 backing_div" style="display: none">
                                        <div class="form-group">
                                            <label for="exampleFormControlInput1" class="form-label"><?php echo e(__('content.backing_type')); ?></label>
                                            <select class="form-select" aria-label="Default select example" name="qut[<?php echo e($buttonIndex); ?>][<?php echo e($bespoke); ?>][backing_type]" onchange="onChangeElem(event)" >
                                                <option value=" ">Select One Option</option>
                                                <?php $backing_types = \App\Models\Jewellery::backingTypeArray(); ?>
                                                <?php $__currentLoopData = $backing_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                            <label class="field_error" id="bespoke_backing_type_error-<?php echo e($buttonIndex); ?>"> </label>
                                        </div>
                                    </div>
                                    <div class="col-lg-6 backing_div" style="display: none">
                                        <div class="form-group">
                                            <label for="exampleFormControlInput1" class="form-label"><?php echo e(__('content.backing_cost')); ?></label>
                                            <input type="text" class="form-control"  name="qut[<?php echo e($buttonIndex); ?>][<?php echo e($bespoke); ?>][backing_cost]"  value="" onchange="onChangeElem(event)">
                                            <label class="field_error" id="bespoke_backing_cost_error-<?php echo e($buttonIndex); ?>"> </label>
                                        </div>
                                    </div>

                                    <div class="col-lg-3 backing_div" style="display: none">
                                        <div class="form-group">
                                            <label for="exampleFormControlInput1" class="form-label"><?php echo e(__('content.backing_size')); ?></label>
                                            <input type="text" class="form-control" name="qut[<?php echo e($buttonIndex); ?>][<?php echo e($bespoke); ?>][backing_size]"  value="" onchange="onChangeElem(event)">
                                            <label class="field_error" id="bespoke_backing_size_error-<?php echo e($buttonIndex); ?>"> </label>
                                        </div>
                                    </div>
                                    <div class="col-lg-3 backing_div" style="display: none">
                                        <div class="form-group">
                                            <label for="exampleFormControlInput1" class="form-label"><?php echo e(__('content.backing_quantity')); ?></label>
                                            <input type="text" class="form-control"  name="qut[<?php echo e($buttonIndex); ?>][<?php echo e($bespoke); ?>][backing_quantity]"  value="" onchange="onChangeElem(event)">
                                            <label class="field_error" id="bespoke_backing_quantity_error-<?php echo e($buttonIndex); ?>"> </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="sample">
                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="form-group pt-0">
                                            <label for="exampleFormControlInput1" class="form-label"><?php echo e(__('content.claw')); ?> </label>
                                            <select class="form-select" aria-label="Default select example" name="qut[<?php echo e($buttonIndex); ?>][<?php echo e($bespoke); ?>][claw]" onchange="onChangeElem(event)" >
                                                <option value=" ">Select One Option</option>
                                                <?php $claw = \App\Models\Jewellery::clawArray(); ?>
                                                <?php $__currentLoopData = $claw; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($key); ?>" ><?php echo e($value); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                            <label class="field_error" id="bespoke_claw_error-<?php echo e($buttonIndex); ?>"> </label>
                                        </div>
                                    </div>

                                    <div class="col-lg-6">
                                        <div class="form-group pt-0">
                                            <label for="exampleFormControlInput1" class="form-label">Worksmith</label>
                                            <?php $worksmiths = \App\Models\Worksmith::getWorksmithsList();?>
                                            <select class="form-select" aria-label="Default select example" name="qut[<?php echo e($buttonIndex); ?>][<?php echo e($bespoke); ?>][worksmith_id]" onchange="onChangeElem(event)" >
                                                <option value=" ">Select One Option</option>
                                                <?php $__currentLoopData = $worksmiths; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                            <label class="field_error" id="bespoke_worksmith_id_error-<?php echo e($buttonIndex); ?>"> </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="sample">
                                <div class="row">
                                        <div class="col-lg-3">
                                            <div class="form-group pt-0">
                                                <label for="exampleFormControlInput1" class="form-label"><?php echo e(__('content.item_code')); ?></label>
                                                <input type="text" class="form-control jewellery_item_code bespoke_multiple_stocks-<?php echo e($buttonIndex); ?>" data-type="<?php echo e($bespoke); ?>" id="jewelleries-<?php echo e($buttonIndex); ?>-<?php echo e($bespoke); ?>-stock_no-0" data-id="<?php echo e($buttonIndex); ?>" data-index="0" name="qut[<?php echo e($buttonIndex); ?>][<?php echo e($bespoke); ?>][jewelleries][0][stock_no]" value="">
                                            </div>
                                            <span class="error-message">
                                            <strong class="field_error" id="qut-<?php echo e($buttonIndex); ?>-<?php echo e($bespoke); ?>-jewelleries-0-stock_no_error"></strong>
                                            </span>
                                        </div>
                                        <div class="col-lg-3">
                                            <div class="form-group pt-0">
                                                <label for="exampleFormControlInput1" class="form-label"><?php echo e(__('content.weight')); ?></label>
                                                <input type="text" class="form-control bespoke_multiple_weights-<?php echo e($buttonIndex); ?>" data-index="0" data-type="<?php echo e($bespoke); ?>" id="jewelleries-<?php echo e($buttonIndex); ?>-<?php echo e($bespoke); ?>-weight-0" data-id="<?php echo e($buttonIndex); ?>" name="qut[<?php echo e($buttonIndex); ?>][<?php echo e($bespoke); ?>][jewelleries][0][weight]" value="" oninput="onInputweight()">
                                            </div>
                                            <span class="error-message">
                                            <strong class="field_error" id="qut-<?php echo e($buttonIndex); ?>-<?php echo e($bespoke); ?>-jewelleries-0-weight_error"></strong>
                                            </span>
                                        </div>
                                        <div class="col-lg-3">
                                            <div class="form-group pt-0">
                                                <label for="exampleFormControlInput1" class="form-label"><?php echo e(__('content.unit_price')); ?></label>
                                                <input type="text" class="form-control bespoke_multiple_unit_prices-<?php echo e($buttonIndex); ?>"  data-index="0" data-type="<?php echo e($bespoke); ?>" id="jewelleries-<?php echo e($buttonIndex); ?>-<?php echo e($bespoke); ?>-unit_price-0" data-id="<?php echo e($buttonIndex); ?>" name="qut[<?php echo e($buttonIndex); ?>][<?php echo e($bespoke); ?>][jewelleries][0][unit_price]" value="" oninput="onInputUnitPrice()">
                                            </div>
                                            <span class="error-message">
                                            <strong class="field_error" id="qut-<?php echo e($buttonIndex); ?>-<?php echo e($bespoke); ?>-jewelleries-0-unit_price_error"></strong>
                                            </span>
                                        </div>
                                        <div class="col-lg-2">
                                            <div class="form-group pt-0">
                                                <label for="exampleFormControlInput1" class="form-label"><?php echo e(__('content.price')); ?></label>
                                                <input type="text" class="form-control dynamic_price bespoke_multiple_prices-<?php echo e($buttonIndex); ?>" data-type="<?php echo e($bespoke); ?>" id="jewelleries-<?php echo e($buttonIndex); ?>-<?php echo e($bespoke); ?>-price-0" data-id="<?php echo e($buttonIndex); ?>" name="qut[<?php echo e($buttonIndex); ?>][<?php echo e($bespoke); ?>][jewelleries][0][price]" value=" ">
                                            </div>
                                            <span class="error-message">
                                            <strong class="field_error" id="qut-<?php echo e($buttonIndex); ?>-<?php echo e($bespoke); ?>-jewelleries-0-price_error"></strong>
                                            </span>
                                        </div>
                                      <div id="append_fields_bespoke-<?php echo e($buttonIndex); ?>">
                                    </div>
                                    <div class="col-lg-12">
                                        <div class="form-group plus pt-0">
                                            <a class="addPlusBespoke"  data-key="<?php echo e($buttonIndex); ?>"><i class="icofont-plus"></i></a>
                                        </div>
                                    </div>
                                    <div class="col-lg-12">
                                        <div class="d-flex mt-5">
                                            <input type="hidden" id="bespoke_subtotal-<?php echo e($buttonIndex); ?>" name="qut[<?php echo e($buttonIndex); ?>][<?php echo e($bespoke); ?>][subtotal]" value="">
                                            <button data-key="<?php echo e($buttonIndex); ?>" data-type="<?php echo e($bespoke); ?>" class="btn btn-primary btn-create btn-confirm bespoke_repair_confirm me-4" type="button">Confirm Add Item</button>
                                            <button class="btn btn-outline-primary btn-reset-form-custom reset_form" data-type="bespoke" data-key="<?php echo e($buttonIndex); ?>"  type="button">Reset Form</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

           <div class="tab-pane fade" id="repair-<?php echo e($buttonIndex); ?>" role="tabpanel" aria-labelledby="contact-tab">
                <div class="position-relative add_item_search add_item_search_custom">
                    <div class="sample card-body mt-0 p-0 pt-4">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="category jobs_edit">
                                    <div class="form-group">
                                        <label for="exampleFormControlInput1" class="form-label">Category</label>
                                    </div>
                                    <ul class="category_ul-<?php echo e($buttonIndex); ?>">
                                        <?php $categories = \App\Models\Category::getCategories(); ?>
                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li class=""><a class="category_id"  data-key="<?php echo e($buttonIndex); ?>" value= "<?php echo e($value->id); ?>" ><img src="<?php echo e($value->image); ?>" height="60" width="60"/><?php echo e($value->name); ?></a></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                    <input  id="repair_category_id-<?php echo e($buttonIndex); ?>" type="hidden" name="qut[<?php echo e($buttonIndex); ?>][<?php echo e($repair); ?>][category_id]" value=""/>
                                    <label class="field_error" id="repair_category_id_error-<?php echo e($buttonIndex); ?>"> </label>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="exampleFormControlInput1"
                                           class="form-label"><?php echo e(__('content.description')); ?> </label>
                                    <textarea class="form-control"  name="qut[<?php echo e($buttonIndex); ?>][<?php echo e($repair); ?>][description]"  placeholder="Description" value="" rows="2" onchange="onChangeElem(event)"></textarea>
                                    <label class="field_error" id="repair_description_error-<?php echo e($buttonIndex); ?>"> </label>
                                </div>
                            </div>

                            <div class="col-lg-12 mt-3">
                                <label for="exampleFormControlInput1" class="form-label"> <?php echo e(__('content.draw_upload')); ?>

                                    <img src="<?php echo e(asset('public/img/folder.png')); ?>" class="folder">
                                </label>
                                <div class="row">
                                    <div class="col-lg-4">
                                        <div class="form-group pt-0">
                                            <div class="drop-zone">
                                                <div class="dropzone dropZoneimageUpload" id="repairDropZoneimageUpload-<?php echo e($buttonIndex); ?>">
                                                <span class="drop-zone__prompt dz-default dz-message">Drop Photo here <br><?php echo e(__('content.drop_photo')); ?>

                                                    <p>Photo Requiement:</p>
                                                    <ul>
                                                    <li>File type PNG or JPG</li>
                                                    <li>Maximum Size: 2 MB</li>
                                                    </ul>
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-lg-8">
                                        <div class="form-group pt-0">
                                            <div class="start-drawing"
                                                 id="blackboardPlaceholder">
                                                <p><?php echo e(__('content.start_drawing')); ?></p>
                                                <canvas  data-key="<?php echo e($buttonIndex); ?>" id="drawingCanvas" class="drawingCanvas repair_drawingCanvas" width="500"
                                                         height="230"></canvas>
                                                <div class="pen-eraser">
                                                    <span class="pen" onclick="togglePenPointer(this);"><img src="<?php echo e(asset('public/img/pen.png')); ?>"/></span>
                                                    <span class="erase" onclick="eraserHandler(this);"><img src="<?php echo e(asset('public/img/eraser.png')); ?>"/></span>
                                                </div>
                                            </div>
                                            <input type="hidden" name="qut[<?php echo e($buttonIndex); ?>][<?php echo e($repair); ?>][drawing_textarea_base64]" >
                                        </div>
                                    </div>
                                    <div class="col-lg-12">
                                        <div id="repair-template-preview-<?php echo e($buttonIndex); ?>" class="preview-droped-images" >
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="sample">
                                <div class="row">
                                    <div class="col-lg-3">
                                        <div class="form-group pt-0">
                                            <label for="exampleFormControlInput1" class="form-label"><?php echo e(__('content.item_code')); ?></label>
                                            <input type="text" class="form-control jewellery_item_code repair_multiple_stock_no-<?php echo e($buttonIndex); ?>" name="qut[<?php echo e($buttonIndex); ?>][<?php echo e($repair); ?>][jewelleries][0][stock_no]"  data-type="<?php echo e($repair); ?>" id="jewelleries-<?php echo e($buttonIndex); ?>-<?php echo e($repair); ?>-stock_no-0" data-id="<?php echo e($buttonIndex); ?>" data-index="0" value="">
                                        </div>
                                        <span class="error-message">
                                        <strong class="field_error" id="qut-<?php echo e($buttonIndex); ?>-<?php echo e($repair); ?>-jewelleries-0-stock_no_error"></strong>
                                        </span>
                                    </div>
                                    <div class="col-lg-3">
                                        <div class="form-group pt-0">
                                            <label for="exampleFormControlInput1" class="form-label"><?php echo e(__('content.weight')); ?></label>
                                            <input type="text" class="form-control repair_multiple_weights-<?php echo e($buttonIndex); ?>" data-index="0" data-type="<?php echo e($repair); ?>"  name="qut[<?php echo e($buttonIndex); ?>][<?php echo e($repair); ?>][jewelleries][0][weight]" id="jewelleries-<?php echo e($buttonIndex); ?>-<?php echo e($repair); ?>-weight-0" data-id="<?php echo e($buttonIndex); ?>"  value="" oninput="onInputweight()">
                                        </div>
                                        <span class="error-message">
                                         <strong class="field_error" id="qut-<?php echo e($buttonIndex); ?>-<?php echo e($repair); ?>-jewelleries-0-weight_error"></strong>
                                        </span>
                                    </div>
                                    <div class="col-lg-3">
                                        <div class="form-group pt-0">
                                            <label for="exampleFormControlInput1" class="form-label"><?php echo e(__('content.unit_price')); ?></label>
                                            <input type="text" class="form-control repair_multiple_unit_prices-<?php echo e($buttonIndex); ?>" data-index="0" data-type="<?php echo e($repair); ?>" name="qut[<?php echo e($buttonIndex); ?>][<?php echo e($repair); ?>][jewelleries][0][unit_price]" id="jewelleries-<?php echo e($buttonIndex); ?>-<?php echo e($repair); ?>-unit_price-0" data-id="<?php echo e($buttonIndex); ?>" value="" oninput="onInputUnitPrice()">
                                        </div>
                                        <span class="error-message">
                                            <strong class="field_error" id="qut-<?php echo e($buttonIndex); ?>-<?php echo e($repair); ?>-jewelleries-0-unit_price_error"></strong>
                                            </span>
                                    </div>
                                    <div class="col-lg-2">
                                        <div class="form-group pt-0">
                                            <label for="exampleFormControlInput1" class="form-label"><?php echo e(__('content.price')); ?></label>
                                            <input type="text" class="form-control dynamic_price repair_multiple_prices-<?php echo e($buttonIndex); ?>" data-type="<?php echo e($repair); ?>"  name="qut[<?php echo e($buttonIndex); ?>][<?php echo e($repair); ?>][jewelleries][0][price]" id="jewelleries-<?php echo e($buttonIndex); ?>-<?php echo e($repair); ?>-price-0" data-id="<?php echo e($buttonIndex); ?>" value="">
                                        </div>
                                        <span class="error-message">
                                         <strong class="field_error" id="qut-<?php echo e($buttonIndex); ?>-<?php echo e($repair); ?>-jewelleries-0-price_error"></strong>
                                        </span>
                                    </div>
                                    <div id="append_fields_repair-<?php echo e($buttonIndex); ?>">
                                    </div>
                                    <div class="col-lg-12">
                                        <div class="form-group plus pt-0">
                                            <a class="addPlusRepair"  data-key="<?php echo e($buttonIndex); ?>"><i class="icofont-plus"></i></a>
                                        </div>
                                    </div>
                                    <div class="col-lg-12">
                                        <div class="d-flex mt-5">
                                            <input type="hidden" id="repair_subtotal-<?php echo e($buttonIndex); ?>" name="qut[<?php echo e($buttonIndex); ?>][<?php echo e($repair); ?>][subtotal]" value="">
                                            <button data-key="<?php echo e($buttonIndex); ?>" data-type="<?php echo e($repair); ?>"  class="btn btn-primary btn-create btn-confirm bespoke_repair_confirm me-4" type="button">Confirm Add Item</button>
                                            <button class="btn btn-outline-primary btn-reset-form-custom reset_form" data-type="repair" data-key="<?php echo e($buttonIndex); ?>" type="button">Reset Form</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>
<?php /**PATH /home/sancysup/public_html/sancy_erp/resources/views/admin/quotations/button_render.blade.php ENDPATH**/ ?>