<?php
use App\Models\QuotationItem;
?>


<?php $__env->startSection('title', "Quotations"); ?>
<?php $__env->startSection('header', "Quotations"); ?>

<?php $__env->startSection('content'); ?>
    
<div class="today_sale_main pb-5">
    <div class="dasboard-menu-item ps-0">
        <div class="today_sale_heading">
            <div class="create_quote_link today_sale py-4">
                <span class="d-flex align-items-center create_span">
                    <img src="<?php echo e(asset('public/img/create_quotation.png')); ?>" />
                    <a href="javascript:void(0);"><?php echo e(__('content.todays_quotaions')); ?></a>
                </span>

                <?php echo $__env->make('frontend.elements.layouts.time_date_user_details', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            </div>

            <div class="total_invoice_main d-flex align-items-center justify-content-between">
                <div class="total_invoice_wise d-flex align-items-center">
                    <div class="total_invoice">
                        <p><?php echo __('content.bespoke_with_br'); ?>

                        </p>
                        <h3><?php echo e($todayBespokeCount); ?></h3>
                    </div>
                    <div class="total_invoice">
                        <p><?php echo __('content.repair_with_br'); ?></p>
                        <h3><?php echo e($todayRepairCount); ?></h3>
                    </div>
                    <div class="total_invoice">
                        <p><?php echo __('content.inventory_with_br'); ?></p>
                        <h3><?php echo e($todayInventoryCount); ?></h3>
                    </div>
                </div>
                <div class="total_amount_todal_sale">
                    <p>Amount Transacted  (based on Invoice)</p>
                    <h3>$ <?php echo e($inventoryOrders->sum('sub_total') + $bespokeAndRepairOrders->sum('sub_total')); ?></h3>
                </div>
            </div>
        </div>
    </div>
</div>



<div class="inventory_detail">
    <?php
        $activeTab = !empty(request()->tab) ? request()->tab : null ;
        $tabInventory = QuotationItem::TAB_INVENTORY;
        $tabBespokeAndRepair = QuotationItem::TAB_BESPOKE_AND_REPAIR;
    ?>
    <ul class="nav nav-tabs nav-pills nav-justified quotation_inventory_" id="myTab" role="tablist">
        <li class="nav-item" role="presentation">
         <!--  <button class="nav-link " id="inventory-tab" data-bs-toggle="tab" data-bs-target="#inventory-tab-pane" type="button" role="tab" aria-controls="inventory-tab-pane" aria-selected="true">Inventory</button> -->

          <a href="<?php echo e(route('quotations.todaysOrders', [ 'tab' =>
            QuotationItem::TAB_INVENTORY ])); ?>" class="nav-link <?php echo e(($tab == QuotationItem::TAB_INVENTORY) ? 'active' : ''); ?>" id="table-tab">Inventory</a>
        </li>
        <li class="nav-item" role="presentation">
          <!-- <button class="nav-link " id="bespoke_and_repair-tab" data-bs-toggle="tab" data-bs-target="#bespoke_and_repair-tab-pane" type="button" role="tab" aria-controls="bespoke_and_repair-tab-pane" aria-selected="false">Bespoke and Repair</button> -->

          <a href="<?php echo e(route('quotations.todaysOrders', [ 'tab' => QuotationItem::TAB_BESPOKE_AND_REPAIR ])); ?>" class="nav-link <?php echo e(($tab == QuotationItem::TAB_BESPOKE_AND_REPAIR) ? 'active' : ''); ?>" id="table-tab">Bespoke and Repair</a>
        </li>
    </ul>
    <div class="inventory_detail_main">
        <div class="tab-content" id="myTabContent">
            <?php if($tab == $tabInventory): ?>
                <!-- <div class="tab-pane fade " id="inventory-tab-pane" role="tabpanel" aria-labelledby="inventory-tab" tabindex="0"> -->
                <div class="">
                    <div class="today_sale_detail">
                        <div class="card-body">
                            <div class="earring-table sale_detail_main table-responsive">
                                <table class="table stock-detail sale-detail">
                                    <thead>
                                        <tr>
                                            <th><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('reference_date', __('content.date')));?></th>
                                            <th><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('id', __('content.quotation_id')));?></th>
                                            <th><?php echo e(__('content.type')); ?></th>
                                            <th><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('total', __('content.amount')));?></th>
                                            <th><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('customer_name', __('content.customer')));?></th>

                                            
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['frontQuotation-printOrderVoucher','frontQuotation-print','frontQuotation-sendEmailPDF'])): ?>
                                            <th><?php echo e(__('content.action')); ?></th>
                                            <?php endif; ?>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__empty_1 = true; $__currentLoopData = $inventoryOrders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $record): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <?php $newQutNo = $record->quotation_no."-1"; ?>
                                        <tr>
                                            <td><?php echo e(isset($record->reference_date) ? date('d/m/Y', strtotime($record->reference_date)) : '-'); ?></td>
                                            <td>
                                                <a href="<?php echo e(route('quotations.showItemsList', ['quotation_id'=>$record->id, 'type'=>$tab])); ?>" class="view_link">
                                                    <?php if(!empty($record->quotation_no)): ?> 
                                                        <?php if($record->bespokeAndRepairCount > 0): ?> 
                                                            <?php echo e($newQutNo); ?> 
                                                        <?php else: ?>
                                                            <?php echo e($record->quotation_no); ?>

                                                        <?php endif; ?>
                                                    <?php else: ?> 
                                                        -
                                                    <?php endif; ?>
                                                </a>
                                            </td>
                                            <td>Inventory</td>
                                            <td><?php echo e(!empty($record->total) ? '$'.number_format($record->total) : '-'); ?></td>
                                            <td><?php echo e(isset($record->customer_name) ? ucwords($record->customer_name) : (isset($record->customer_id) ? ucwords($record->customer->fullname) : '-')); ?></td>
                                            <td>
                                                <div class="dropdown">
                                                    
                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['frontQuotation-printOrderVoucher','frontQuotation-print','frontQuotation-sendEmailPDF'])): ?>  
                                                    <button class="btn btn-secondary down" type="button" id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false">
                                                            Action
                                                        </button>
                                                    <?php endif; ?>

                                                    <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="dropdownMenuButton1">

                                                        

                                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('frontQuotation-printOrderVoucher')): ?> 
                                                            <li>
                                                                <a class="dropdown-item btnprn" href="<?php echo e(route('quotations.printOrderVoucher', $record->id)); ?>"><img src="<?php echo e(asset('public/img/print.png')); ?>">Print Order Voucher</a>
                                                            </li>
                                                        <?php endif; ?>

                                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('frontQuotation-print')): ?> 
                                                        <li>
                                                            <a class="dropdown-item" href="<?php echo e(route('quotations.printQuotation', $record->id)); ?>"><img src="<?php echo e(asset('public/img/print.png')); ?>">Print Quotation</a>
                                                        </li>
                                                        <?php endif; ?>

                                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('frontQuotation-sendEmailPDF')): ?>
                                                        <li>
                                                            <a class="dropdown-item sendEmailPDF" href="javascript:void(0);" id="sendEmailPDF-<?php echo e($record->id); ?>" data-record_id="<?php echo e($record->id); ?>" data-for="quotations"><img src="<?php echo e(asset('public/img/envelope.png')); ?>">Send email </a>
                                                        </li>
                                                        <?php endif; ?>

                                                    </ul>
                                                </div>
                                            </td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td class="text-center" colspan="6">No Record Found!</td>
                                        </tr>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>

                            <div class="row mt-4">
                                <div class="col-sm-12 col-md-5 pl-4 d-flex justify-content-start">
                                    <div class="dataTables_info" id="bs4-table_info" role="status" aria-live="polite">
                                        Page <?php echo e($inventoryOrders->currentPage()); ?> of <?php echo e($inventoryOrders->lastPage()); ?>, showing <?php echo e($inventoryOrders->count()); ?> record(s) out of <?php echo e($inventoryOrders->total()); ?> total
                                    </div>
                                </div>

                                <div class="col-sm-12 col-md-7 d-flex justify-content-end">
                                    <div class="dataTables_paginate paging_simple_numbers float-right" id="bs4-table_paginate">
                                        <?php echo $inventoryOrders->appends(Request::except('page'))->links(); ?>

                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            <?php elseif($tab == $tabBespokeAndRepair): ?>
                <!-- <div class="tab-pane fade " id="bespoke_and_repair-tab-pane" role="tabpanel" aria-labelledby="bespoke_and_repair-tab" tabindex="0"> -->
                <div class="">
                    <div class="today_sale_detail">
                        <div class="card-body">
                            <div class="earring-table sale_detail_main table-responsive">
                                <table class="table stock-detail sale-detail">
                                    <thead>
                                        <tr>
                                            <th><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('reference_date', __('content.date')));?></th>
                                            <th><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('id', __('content.quotation_id')));?></th>
                                            <th><?php echo e(__('content.type')); ?></th>
                                            <th><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('total', __('content.amount')));?></th>
                                            <th><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('customer_name', __('content.customer')));?></th>
                                            
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['frontQuotation-printOrderVoucher','frontQuotation-print','frontQuotation-sendEmailPDF'])): ?>  
                                            <th><?php echo e(__('content.action')); ?></th>
                                            <?php endif; ?>

                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__empty_1 = true; $__currentLoopData = $bespokeAndRepairOrders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $record): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <?php $newBespokeQutNo = $record->quotation_no."-2"; 
                                        ?>
                                        <tr>
                                            <td><?php echo e(isset($record->reference_date) ? date('d/m/Y', strtotime($record->reference_date)) : '-'); ?></td>
                                            <td><a href="<?php echo e(route('quotations.showItemsList',['quotation_id'=>$record->id, 'type'=>$tab])); ?>" class="view_link"><?php echo e($record->quotation_no ? (($record->inventoryCount > 0) ? $newBespokeQutNo : $record->quotation_no) : '-'); ?></a></td>
                                            <td>Bespoke Or Repair</td>
                                            <td><?php echo e(!empty($record->total) ? '$'.number_format($record->total) : '-'); ?></td>
                                            <td><?php echo e(isset($record->customer_name) ? ucwords($record->customer_name) : (isset($record->customer_id) ? ucwords($record->customer->fullname) : '-')); ?></td>
                                            <td>
                                                <div class="dropdown">
                                                    
                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['frontQuotation-printOrderVoucher','frontQuotation-print','frontQuotation-sendEmailPDF'])): ?>  
                                                    <button class="btn btn-secondary down" type="button"nid="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false">
                                                        Action
                                                    </button>
                                                    <?php endif; ?>

                                                    <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="dropdownMenuButton1">

                                                        <!-- <li><a class="dropdown-item duplicate" href="javascript:void(0);"><img src="<?php echo e(asset('public/img/hammer.png')); ?>">Send to Job Order</a></li> -->
                                                        
                                                        
                                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('frontQuotation-printOrderVoucher')): ?>
                                                            <li>
                                                                <a class="dropdown-item" href="<?php echo e(route('quotations.printOrderVoucher', $record->id)); ?>"><img src="<?php echo e(asset('public/img/print.png')); ?>">Print Order Voucher</a>
                                                            </li>
                                                        <?php endif; ?> 

                                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('frontQuotation-print')): ?>
                                                            <li>
                                                                <a class="dropdown-item btnprn" href="<?php echo e(route('quotations.printQuotation', $record->id)); ?>"><img src="<?php echo e(asset('public/img/print.png')); ?>">Print Quotation</a>
                                                            </li>
                                                        <?php endif; ?>

                                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('frontQuotation-print')): ?>
                                                            <li>
                                                                <a class="dropdown-item sendEmailPDF" href="javascript:void(0);" id="sendEmailPDF-<?php echo e($record->id); ?>" data-record_id="<?php echo e($record->id); ?>" data-for="quotations"><img src="<?php echo e(asset('public/img/envelope.png')); ?>">Send email</a>
                                                            </li>
                                                        <?php endif; ?>

                                                    </ul>
                                                </div>
                                            </td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td class="text-center" colspan="7">No Record Found!</td>
                                        </tr>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>

                            <div class="row mt-4">
                                <div class="col-sm-12 col-md-5 pl-4 d-flex justify-content-start">
                                    <div class="dataTables_info" id="bs4-table_info" role="status" aria-live="polite">
                                        Page <?php echo e($bespokeAndRepairOrders->currentPage()); ?> of <?php echo e($bespokeAndRepairOrders->lastPage()); ?>, showing <?php echo e($bespokeAndRepairOrders->count()); ?> record(s) out of <?php echo e($bespokeAndRepairOrders->total()); ?> total
                                    </div>
                                </div>

                                <div class="col-sm-12 col-md-7 d-flex justify-content-end">
                                    <div class="dataTables_paginate paging_simple_numbers float-right" id="bs4-table_paginate">
                                        <?php echo $bespokeAndRepairOrders->appends(Request::except('page'))->links(); ?>

                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php echo $__env->make('frontend.invoices.pay_amount_with_print_invoice_popup', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 


<?php echo $__env->make('frontend.elements.scripts.pdf_email_js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>  







<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/sancysup/public_html/sancy_erp/resources/views/frontend/quotations/index.blade.php ENDPATH**/ ?>