<?php 
use App\Models\Job;
?>

<div class="" id="table">
    <table class="table stock-detail">
        <thead>
        <tr>
            <th><?php echo e(__('content.select')); ?></th>
            <th class="cus-w-1"><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('item_code', __('content.jo')));?> </th>
            <th><?php echo e(__('content.image')); ?></th>
            <th style="width:310px;"><?php echo e(__('content.description')); ?></th>
            <th> <?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('estimate_completion', __('content.completion_date')));?></th>
            <th> <?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('job_type.name', __('content.type')));?></th>
            <th> <?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('job_status', __('content.status')));?></th>
            <th><?php echo e(__('content.worksmith')); ?></th>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['job-duplicate','job-quotation','job-print','job-update','job-delete'])): ?>
            <th><?php echo e(__('content.action')); ?></th>
            <?php endif; ?>
        </tr>
        </thead>
        <tbody>
        <?php if(!empty($records) && $records->count()): ?>
            <?php $__currentLoopData = $records; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $record): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault">
                        </div>
                    </td>
                    <td><strong><?php echo e($record->item_code); ?></strong></td>
                    <td><a data-fancybox="gallery" href="<?php echo e($record->first_image ? $record->first_image->image_url : Job::defaultImage()); ?>"><img width="70" src="<?php echo e($record->first_image ? $record->first_image->image_url : Job::defaultImage()); ?>"></a>
                    </td>
                    <td class="description">
                        <div><?php echo e(($record->description) ? \Illuminate\Support\Str::limit($record->description, 112, $end='...') : "-"); ?></div>
                    </td>
                    <td><?php echo e(($record->estimate_completion) ? date('d/m/y', strtotime($record->estimate_completion)) : "-"); ?></td>
                    <td><?php echo e(!empty($record->job_type->name) ? $record->job_type->name: '-'); ?></td>
                    <td>
                        <?php
                            $job_status =  Job::job_status();
                            $dynamicColor =  Job::dynamicColor($record->job_status);
                        ?>
                        <div class="dropdown job_status <?php echo e($dynamicColor); ?> <?php echo e(($dynamicColor ==  Job::MINT) ? 'not_allowed' : ''); ?> worksmith_new" id="job_status_div-<?php echo e($record->id); ?>">
                            <button class="btn btn-secondary dropdown-toggle" type="button" id="dropdownMenuJobStatus-<?php echo e($record->id); ?>" data-bs-toggle="dropdown" aria-expanded="false">
                                <?php echo e(old('job_status',$record->job_status )); ?>

                            </button>

                            <ul class="dropdown-menu status_dropdown-<?php echo e($record->id); ?>" aria-labelledby="dropdownMenuButton1">
                                <!-- <li><a class="dropdown-item status_change " value=" " data-id="">Select Option</a></li> -->
                                <?php $__currentLoopData = $job_status; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li>
                                        <a class="dropdown-item status_change <?php echo e(($record->job_status == $key) ? 'active' : ''); ?>" id="<?php echo e(str_replace(' ', '_', $key).'-'.$record->id); ?>" data-id="<?php echo e($record->id); ?>" value="<?php echo e($key); ?>"><?php echo e($value); ?></a>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <input id="job_status" type="hidden" name="job_status" value="">
                            </ul>
                        </div>
                    </td>
                    <td>
                        <div class="dropdown worksmith worksmith_new <?php echo e((  $record->job_status == Job::RECEIVED) ? 'not_allowed' : ''); ?>">
                            <button class="btn btn-secondary dropdown-toggle" type="button" id="worksmith" data-bs-toggle="dropdown" aria-expanded="false">
                                <?php echo e((!empty( $record->worksmith->fullname) ?  $record->worksmith->fullname: "Select Option"  )); ?>

                            </button>

                            <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                                <li><a class="dropdown-item worksmith_change <?php echo e((($record->worksmith_id == ' ') || empty($record->worksmith_id)) ? 'active' : ''); ?>" value=" " data-id="<?php echo e($record->id); ?>" data-name="Select Option">Select Option</a></li>
                                <?php  
                                $worksmiths  = \App\Models\Worksmith::getWorksmithsList();
                                ?>
                                <?php $__currentLoopData = $worksmiths; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><a class="dropdown-item worksmith_change <?php echo e(($record->worksmith_id == $key) ? 'active' : ''); ?>" value="<?php echo e($key); ?>" data-id="<?php echo e($record->id); ?>" data-name="<?php echo e($value); ?>"><?php echo e(strtoupper($value)); ?></a></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <input type="hidden" name="worksmith_id" value="<?php echo e($record->worksmith_id ?? ''); ?>" id="worksmith_id">
                            </ul>
                        </div>
                    </td>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['job-duplicate','job-quotation','job-print','job-update','job-delete'])): ?>
                    <td>
                        <div class="dropdown">
                            <button class="btn btn-secondary down" type="button"
                            id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false">Action</button>
                            <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                                <?php if(empty($record->deleted_at)): ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('job-duplicate')): ?>
                                        <li>
                                            <a class="dropdown-item duplicate" href="<?php echo e(route('admin.jobs.duplicate',$record->id)); ?>"><img src="<?php echo e(asset('public/img/duplicate.png')); ?>">Duplicate</a>
                                        </li>
                                    <?php endif; ?>
                                <?php endif; ?>

                                <?php if(empty($record->deleted_at)): ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('job-update')): ?> 
                                        <li>
                                            <a class="dropdown-item" href="<?php echo e(route('admin.jobs.edit',$record->id)); ?>"><img src="<?php echo e(asset('public/img/edit.png')); ?>">Edit</a>
                                        </li>
                                    <?php endif; ?>
                                <?php endif; ?>

                                <?php if(empty($record->deleted_at)): ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('job-print')): ?>
                                        <li>
                                            <a class="dropdown-item btn btn_prn btnprn" href="<?php echo e(route('admin.jobs.print',$record->id)); ?>"><img src="<?php echo e(asset('public/img/print.png')); ?>">Print</a>
                                        </li> 
                                    <?php endif; ?>
                                <?php endif; ?>

                                <?php if(empty($record->deleted_at)): ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('job-delete')): ?>
                                        <li>
                                            <a class="dropdown-item confirmDelete" href="javascript:void(0);" data-action="<?php echo e(route('admin.jobs.destroy',$record->id)); ?>"><img src="<?php echo e(asset('public/img/archive.png')); ?> ">Archive</a>
                                        </li>
                                    <?php endif; ?>
                                <?php else: ?>    
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('job-restore')): ?>
                                        <li>
                                            <a class="dropdown-item confirmRestore" href="javascript:void(0);" data-action="<?php echo e(route('admin.jobs.restore',$record->id)); ?>"><img src="<?php echo e(asset('public/img/restore.png')); ?> ">Restore</a>
                                        </li>
                                     <?php endif; ?>
                                <?php endif; ?>
                            </ul>
                        </div>
                    </td>
                    <?php endif; ?>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php else: ?>
            <tr>
                <td class="text-center" colspan="9">No Record Found!</td>
            </tr>
        <?php endif; ?>
        </tbody>
    </table>
</div>
    <?php /**PATH /home/sancysup/public_html/sancy_erp/resources/views/admin/jobs/index_table.blade.php ENDPATH**/ ?>