<!-- Modal-invoice -->
<div class="modal fade" id="Layway_popup" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
	<div class="modal-dialog Layway_popup modal-xl">
		<div class="modal-content">
			<div class="modal-header border-0">
				<h5 class="modal-title" id="exampleModalLabel">Layaway Payment</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<div class="modal-body">

				<div class="loader-bg" id="loader" style="display:none; z-index:9999;">
                    <div class="loader"></div>
                </div>

				<div class="layway_content">
					<div>
						<div class="row">
							<div class="col-md-6">
								<div class="table-responsive">
									<table class="table table-borderless table_max mb-0">
										<tr>
											<td>Total Amount:</td>
											<td class="text-end"><strong id="invoice_total"></strong></td>
										</tr>
										<tr>
											<td>Paid Amount:</td>
											<td class="text-end" id="invoice_balance"></td>
										</tr>
										<tr>
											<!-- <td class="text-end pe-4">Balance:</td>
										<td class="text-start ps-4">$600.00</td> -->

											<td colspan="2">
												<div
													class="balence_calc d-flex align-items-center justify-content-center">
													<div class="me-5">Balance:</div>
													<div id="invoice_due"></div>
												</div>
											</td>
										</tr>
									</table>
								</div>
							</div>
							<div class="col-md-6">
								<form class="paidAmountForm" id="invoicePaidAmountForm"method="POST">
                                    <!--  action=""  -->
                				<?php echo csrf_field(); ?>
	                    			<input type="hidden" name="id" id="hidden_record_id"/>
									<div class="text-end rigt_cont">
                                        <div class="form-group">
    										<h6 class="font-weight-normal mb-2">Amount to Deposit:</h6>
    										<input type="text" class="form-control form_control_amt ms-auto" name="paid_amount" id="paid_amount" placeholder="$ 0.00">
    										<span class="error-message">
    		                                    <strong id="paid_amountError" class="error_msg"></strong>
    		                                </span>
                                        </div>
										<button class="btn btn-primary btn-update mt-2" id="bt_update" type="button">Update</button>
									</div>
								</form>
							</div>
						</div>
					</div>
					<div class="bottom_t_cont mt-5 pt-5" id="bt_table">
						<div class="row">
							<div class="col-md-12">
								<h6>Layway Payment History</h6>
								<div class="earring-table sale_detail_main table-responsive">
									<table class="table stock-detail sale-detail">
										<thead>
											<tr>
												<th><?php echo e(__('content.date')); ?></th>
												<th><?php echo e(__('content.deposit')); ?></th>
												<th><?php echo e(__('content.staff')); ?></th>
											</tr>
										</thead>
										<tbody id="invoiceTransactionList">
											<!-- <tr>
												<td>11/02/2022</td>
												<td>20938022</td>
												<td>Inventory</td>
											</tr> -->
										</tbody>
									</table>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<script> 
    $(document).ready(function(){
        // alert('ready');
        $('.return_edit').click(function(){
            var record_id = $(this).data('record_id');
            console.log('record_id :',record_id);
            $('#hidden_record_id').val(record_id);

            var actionUrl = "<?php echo e(route('admin.invoices.details', ':invoice_id')); ?>";
            actionUrl = actionUrl.replace(':invoice_id', record_id);

            //--------- Display invoice details on PopUp ----------
            // $('#Layway_popup').modal('show');
            $.ajax({
                type:'GET',
                url: actionUrl,
                contentType: false,
                processData: false,
                dataType: 'json',
                success: function(res){
                    $('#loader').hide();
                    console.log('res :'+res);

                    if(res.errors) {
                        $.each(res.errors, function(key, value) {
                            key2=key.replace(".", "_");
                            $('#'+key2+'Error').html(value[0]);  
                        });
                    }

                    if(res.status==0){
                        error(res.message, res.title);
                    }else if(res.status==1){
                        $('#Layway_popup').modal('show');
                        // $("#Layway_popup").show();

                        $('#invoice_total').html('$'+res.data.total);
                        $('#invoice_balance').html('$'+res.data.balance);
                        $('#invoice_due').html('$'+res.data.due);

                        $('#invoiceTransactionList').html('');
                        var transactions = res.data.transaction;
                        if(transactions.length){
                            $.each(transactions, function(key, value) {
                                var newDate = moment(value.date).format("DD/MM/YYYY");
                                $('#invoiceTransactionList').append(`<tr>
                                    <td>${newDate}</td>
                                    <td>${(value.is_refund == 1) ? '- $'+value.refunded_amount : '$'+value.paid_amount}</td>
                                    <td class="capitalize">${res.data.staff.fullname}</td>
                                </tr>`); 
                            });
                        }else{
                            $('#invoiceTransactionList').html('<tr colspan="3" id="no_record">No record found!</tr>');
                        }
                        // success(res.message, res.title);  
                    }
                },
            });

            //--------- Update Paid Amount Js Starts Here ----------
            // $('.paidAmountForm').submit(function(e){
                $('#bt_update').click(function(e){
                // $('#bt_update').prop('disabled', false);
                e.preventDefault();
                var _this = $(this);

                // disable the button
                $('#bt_update').prop('disabled', true);


                // var action = $(this).attr('action');
                var action = "<?php echo e(route('admin.invoices.updatePaidAmount')); ?>";
                // console.log('action : ',action);

                var inputPaidAmount = $("#paid_amount").val();
                $('#paid_amount').val('');


                var formData = new FormData();
                formData.append("id", $("#hidden_record_id").val());
                formData.append("paid_amount", inputPaidAmount);
                formData.append("_token", "<?php echo e(csrf_token()); ?>");

                $('#loader').show();
                $.ajax({
                    type:'POST',
                    url: action,
                    data: formData,
                    cache: false,
                    contentType: false,
                    processData: false,
                    dataType: 'json',
                    success: function(res){
                        $('#loader').hide();

                        // enable the button
                        $('#bt_update').prop('disabled', false);
                        inputPaidAmount = '';

                        console.log('res :'+res);

                        (_this).find(':input[type=submit]').prop('disabled', false);

                        if(res.errors) {
                            if(res.errors.paid_amount){
                                $('#paid_amount').addClass('mb-2');
                            }
                            $.each(res.errors, function(key, value) {
                                key2 = key.replace(".", "_");
                                $('#'+key2+'Error').html(value[0]);  
                            });
                        }

                        if(res.status==0){
                            error(res.message, res.title);
                        }else if(res.status==1){
                            $('#Layway_popup form')[0].reset();
                            // $('#Layway_popup').modal('hide');
                            $('#no_record').hide();

                            // alert('error : '+$('.error_msg').html(' '))
                            $('.error_msg').html(' ');

                            $('#invoice_balance').html('$'+res.data.balance.toFixed(2));
                            $('#invoice_due').html('$'+res.data.due.toFixed(2));

                            var latestTransaction = res.data.transaction;
                            console.log('latestTransaction length : ', latestTransaction.length);
                            console.log('latestTransaction 0 : ', latestTransaction[0].paid_amount);
                            if(latestTransaction.length){
                                $.each(latestTransaction, function(key, value) {
                                    var newTransDate = moment(latestTransaction[0].date).format("DD/MM/YYYY");
                                    if(latestTransaction[0].paid_amount!=null){
                                        $('#invoiceTransactionList').append(`<tr>
                                            <td>${newTransDate}</td>
                                            <td>${'$'+latestTransaction[0].paid_amount}</td>
                                            <td class="capitalize">${ (res.data.staff_name) ? (res.data.staff_name) : (res.data.staff.fullname) ? (res.data.staff.fullname) : '-'}</td>
                                            </tr>`);
                                    } 
                                });
                            }
                            
                            $('#paid_amount-'+record_id).html('$'+res.data.balance);
                            success(res.message, res.title);
                        }
                    },
                });
               e.preventDefault(); 
            });
            //---------- Update Paid Amount Js Ends Here -----------

        });
    });
</script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.4/moment.min.js" />
<?php /**PATH /home/sancysup/public_html/sancy_erp/resources/views/admin/invoices/layway_popup.blade.php ENDPATH**/ ?>