<?php $__env->startSection('title',"Jobs"); ?>

<?php $__env->startSection('header', "Jobs"); ?>

<?php $__env->startSection('content'); ?>
    <div class="card mb-4">
        
        <div class="card-header d-flex justify-content-between align-items-center">
            <div>
                <h4 class="mb-0"><?php echo e(__('content.job_orders')); ?></h4>
                <p>This section displays the job orders in Sancy’s ERP</p>
            </div>

            <?php if($tab == \App\Models\Job::TABLE): ?>
            <div class="custom_filter">
                <ul class="nav">
                    <li class="nav-item">
                        <a href="<?php echo e(route('admin.jobs.index', [ 'tab'=> $tab,'job_status' => \App\Models\Job::ACTIVE ])); ?>" class="nav-link <?php echo e(( request()->job_status  == \App\Models\Job::ACTIVE ) ? 'active' : ''); ?>"  >Active</a>
                    </li>
                    <li class="nav-item">
                        <a href="<?php echo e(route('admin.jobs.index', [ 'tab'=> $tab,'job_status' => \App\Models\Job::ARCHIVED ])); ?>" class="nav-link <?php echo e(( request()->job_status  == \App\Models\Job::ARCHIVED) ? 'active' : ''); ?>" >Archived</a>
                    </li>
                </ul>
            </div>
            <?php endif; ?>

        </div>
        <div class="card-body">
            <?php
                $placeholder = "Search Jewellry Based on Code or Description";
                $jobFilter = true;
            ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('job-create')): ?>
                <?php
                $create = [
                    'route' => route('admin.jobs.create'),
                    'name' => "Create Job"
                ];
                ?>
             <?php endif; ?>
                <?php echo $__env->make('admin.elements.search.common', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <?php if($tab == \App\Models\Job::TABLE): ?>
                <div class=" earring-table table-responsive" id="myTabContent">
                    <?php echo $__env->make('admin.jobs.index_table', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <?php echo $__env->make('admin.elements.pagination.common', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php elseif($tab == \App\Models\Job::CALENDAR): ?>
                <?php echo $__env->make('admin.jobs.index_calendar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endif; ?>
        </div>
    </div>
    <!-- Modal -->
    <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered dialog-filter-option">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="staticBackdropLabel">Filter</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body filter-options">
                    <form method="get" class="ajaxForm" action="<?php echo e(url()->current()); ?>" id="AjaxFilter"
                          autocomplete="off">
                        <input type="hidden" class="form-control" name="search" value="<?php echo e(request('search')); ?>">
                        <div class="row">
                            <div class="col-lg-12 col-md-12">
                                <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label cus_label">Date</label>
                                </div>
                            </div>

                            <div class="col-lg-6 col-md-6">
                                <div class="form-group cus_form_group me-2">
                                    <input type="text" name="start_date" class=" datePicker cus_form_control" value="" readonly>
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6 position-relative">
                                <div class="form-group cus_form_group left-form-control ms-2">
                                    <input type="text" name="end_date" class=" datePicker cus_form_control" value="" readonly>
                                </div>
                            </div>
                            <div class="col-lg-12 col-md-12 pt-2">
                                <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label cus_label">Price</label>
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6">
                                <div class="form-group cus_form_group me-2">
                                    <input type="text" class="cus_form_control" id="exampleFormControlInput1" placeholder="$" name="price_min" value="">
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6 position-relative">
                                <div class="form-group cus_form_group left-form-control ms-2">
                                    <input type="text" class="cus_form_control" id="exampleFormControlInput1" placeholder="$" name="price_max" value="">
                                </div>
                            </div>

                            <div class="col-lg-12 col-md-12 pt-2">
                                <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label cus_label"><?php echo e(__('content.worksmith')); ?></label>
                                    <?php $worksmiths  = \App\Models\Worksmith::getWorksmithsList(); ?>
                                    <select class="form-select" aria-label="Default select example" name="worksmith_id">
                                        <option value="" selected>Select One Option</option>
                                        <?php $__currentLoopData = $worksmiths; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>

                            <div class="col-lg-12 col-md-12 pt-2">
                                <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label cus_label">Type</label>
                                    <select class="form-select" aria-label="Default select example" name="job_type_id">
                                        <option value="" selected>Select One Option</option>
                                        <?php $types = \App\Models\JobType::getJobTypesList(); ?>
                                        <?php $__currentLoopData = $types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>

                            <div class="col-lg-12 col-md-12 pt-2">
                                <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label cus_label">Status</label>
                                    <select class="form-select" aria-label="Default select example" name="job_status">
                                        <option value="" selected>Select One Option</option>
                                        <?php  $job_status =  App\Models\Job::job_status(); ?>
                                        <?php $__currentLoopData = $job_status; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>


                            <div class="col-lg-12 col-md-12 mt-3">
                                <div class="filter-modal-btn m-0">
                                    <button type="submit" id="AjaxFilterButton" class="btn btn-filter" data-bs-dismiss="modal"><i class="icofont-filter"></i>Filter
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>

                </div>

            </div>
        </div>
    </div>
    </div>

    <?php echo $__env->make('admin.jobs.script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/sancysup/public_html/sancy_erp/resources/views/admin/jobs/index.blade.php ENDPATH**/ ?>