<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo $__env->yieldContent("title","Sancy ERP Admin"); ?></title>
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('public/css/admin/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('public/css/admin/icofont.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('public/css/admin/custom.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('public/css/admin/developer.css')); ?>">

    <!-- ======================= TOASTR =================-->
    <!-- <link rel="stylesheet" href=""> -->
    <link rel="stylesheet" href="<?php echo e(asset('public/css/toastr.min.css')); ?>">

    <script src="<?php echo e(asset('public/js/admin/jquery-3.3.1.min.js')); ?>"></script>
    <!-- ======================= TOASTR =================-->
    <!-- <script src="<?php echo e(asset('public/vendor/toastr/build/toastr.min.js')); ?>"></script> -->
    <script src="<?php echo e(asset('public/js/toastr.min.js')); ?>"></script>
</head>
<body>

<?php echo $__env->make('admin.elements.flash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>



<header>
    <div class="container-fluid">
        <nav class="navbar navbar-expand-lg navbar-light navbar_custom">
            <a class="navbar-brand" href="<?php echo e(route('admin.login')); ?>"><img src="<?php echo e(asset('public/img/logo.png')); ?>"/> </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse"
                    data-bs-target="#navbarSupportedContent"
                    aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse justify-content-end" id="navbarSupportedContent">
                <div class="nav_right_content d-flex align-items-center">
                    
                </div>
            </div>
        </nav>
    </div>
</header>
<?php echo $__env->yieldContent('content'); ?>



<!-- Optional JavaScript -->

<script src="<?php echo e(asset('public/js/admin/bootstrap.bundle.min.js')); ?> "></script>
<script src="<?php echo e(asset('public/js/admin/custom.js')); ?> "></script>


<?php echo $__env->make('admin.elements.scripts.date_picker_js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

</body>
</html>
<?php /**PATH /home/sancysup/public_html/sancy_erp/resources/views/layouts/admin/app.blade.php ENDPATH**/ ?>