<?php
use App\Models\Invoice;
?>



<?php $__env->startSection('title',"Dashboard"); ?>

<?php $__env->startSection('header',"Dashboard"); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <?php echo \Illuminate\View\Factory::parentPlaceholder('breadcrumb'); ?>
    <li class="breadcrumb-item active" aria-current="page"> Dashboard</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="card mb-4 border_rd_12">
    <div class="card-header Job-dash ">
        <h4 class="mb-0">Dashboard</h4>
        <p>This section shows an overview of Sancy ERP System</p>
    </div>
</div>

<div class="card mb-4 report">
    <div class="row">
        <div class="col-lg-3 col-md-3 mb-4">
            <div class="form-group custom-form-group">
                <div class="d-flex align-items-center justify-content-between detailing">
                    <label for="exampleFormControlInput1" class="form-label cus_label">Total Jobs</label>
                    <a href="javascript:void(0);" class="<?php echo e((calculateJobReportVariationYearly('total') < 0) ? 'text-red' : ''); ?>"><img src="<?php echo e((calculateJobReportVariationYearly('total') >= 0) ? asset('public/img/up-down.png') : asset('public/img/red-arrow.png')); ?>" /><?php echo e((calculateJobReportVariationYearly('total') >= 0) ? '+'.calculateJobReportVariationYearly('total') : calculateJobReportVariationYearly('total')); ?>%</a>
                </div>
                <h4><?php echo e(getTotalJobsCount()); ?></h4>
                <button class="btn cus_btn view-report" data-bs-toggle="modal" data-bs-target="#reportModal" data-action="<?php echo e(route('admin.dashboard.exportTotalJobs')); ?>" data-heading="All Jobs">Report</button>
            </div>
        </div>
        <div class="col-lg-3 col-md-3 mb-4">
            <div class="form-group custom-form-group">
                <div class="d-flex align-items-center justify-content-between detailing">
                    <label for="exampleFormControlInput1" class="form-label cus_label">Completed Jobs</label>
                    <a href="javascript:void(0);" class="<?php echo e((calculateJobReportVariationYearly('completed') < 0) ? 'text-red' : ''); ?>"><img src="<?php echo e((calculateJobReportVariationYearly('completed') >= 0) ? asset('public/img/up-down.png') : asset('public/img/red-arrow.png')); ?>" /><?php echo e((calculateJobReportVariationYearly('completed') >= 0) ? '+'.calculateJobReportVariationYearly('completed') : calculateJobReportVariationYearly('completed')); ?>%</a>
                </div>
                <h4><?php echo e(getCompletedJobsCount()); ?></h4>
                <button class="btn cus_btn view-report" data-bs-toggle="modal" data-bs-target="#reportModal" data-action="<?php echo e(route('admin.dashboard.exportCompletedJobs')); ?>" data-heading="Completed Jobs">Report</button>
            </div>
        </div>
        <div class="col-lg-3 col-md-3 mb-4">
            <div class="form-group custom-form-group">
                <div class="d-flex align-items-center justify-content-between detailing">
                    <label for="exampleFormControlInput1" class="form-label cus_label">Total Quotation</label>
                    <a href="javascript:void(0);" class="<?php echo e((calculateQuotationReportVariationYearly('total') < 0) ? 'text-red' : ''); ?>"><img src="<?php echo e((calculateQuotationReportVariationYearly('total') >= 0) ? asset('public/img/up-down.png') : asset('public/img/red-arrow.png')); ?>" /><?php echo e((calculateQuotationReportVariationYearly('total') >= 0) ? '+'.calculateQuotationReportVariationYearly('total') : calculateQuotationReportVariationYearly('total')); ?>%</a>
                </div>
                <h4><?php echo e(getTotalQuotationsCount()); ?></h4>
                <button class="btn cus_btn view-report" data-bs-toggle="modal" data-bs-target="#reportModal" data-action="<?php echo e(route('admin.dashboard.exportTotalQuotations')); ?>" data-heading="Total Quotations">Report</button>
            </div>
        </div>
        <div class="col-lg-3 col-md-3 mb-4">
            <div class="form-group custom-form-group">
                <div class="d-flex align-items-center justify-content-between detailing">
                    <label for="exampleFormControlInput1" class="form-label cus_label">Total Invoice</label>
                    <a href="javascript:void(0);" class="<?php echo e((calculateInvoiceReportVariationYearly('total') < 0) ? 'text-red' : ''); ?>"><img src="<?php echo e((calculateInvoiceReportVariationYearly('total') >= 0) ? asset('public/img/up-down.png') : asset('public/img/red-arrow.png')); ?>" /><?php echo e((calculateInvoiceReportVariationYearly('total') >= 0) ? '+'.calculateInvoiceReportVariationYearly('total') : calculateInvoiceReportVariationYearly('total')); ?>%</a>
                </div>
                <h4><?php echo e(getTotalInvoicesCount()); ?></h4>
                <button class="btn cus_btn view-report" data-bs-toggle="modal" data-bs-target="#reportModal" data-action="<?php echo e(route('admin.dashboard.exportTotalInvoices')); ?>" data-heading="Total Invoices">Report</button>
            </div>
        </div>
    </div>
</div>

<div class="card details mb-4 report job_conversion">
    <div class="row">
        <div class="col-lg-6 ">
            <div class="card-header Job-dash border_rd_12">
                <h4 class="mb-0">Quotation Conversion</h4>
                <div class="row justify-content-between">
                    <div class="col-lg-7 pt-4 align-self-center" id="quotationDonutChartLegend">
                    </div>
                    <div class="col-lg-5">
                        <div id="quotationDonutChart" class="job_conversion_chart"></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-6">
            <div class="card-header Job-dash border_rd_12">
                <h4 class="mb-0">Job Completion</h4>
                <div class="row justify-content-between">
                    <div class="col-lg-7 pt-4 align-self-center" id="jobDonutChartLegend">
                    </div>
                    <div class="col-lg-5">
                        <div id="jobDonutChart" class="job_conversion_chart">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card details mb-4 report graph_chart border_rd_12">
    <div class="card-header">
        <div class="graph_chart_detail d-flex align-items-center justify-content-between">
            <h4 class="mb-0">Sales By Category</h4>
            <div class="dropdown quotation_dropdown viewDropdown" id="viewDropdownSale">
                <button class="btn dropdown-toggle month_daily p-0 d-flex align-items-center" type="button" data-bs-toggle="dropdown" aria-expanded="false" id="saleBtn" >
                Monthly View
                </button>
                <ul class="dropdown-menu">
                    <li><a class="dropdown-item" href="javascript:void(0);" id="monthlySales" data-interval="monthly" data-name="sale">Monthly view</a></li>
                    <li><a class="dropdown-item" href="javascript:void(0);" id="dailySales" data-interval="daily" data-name="sale">Daily View</a></li>
                </ul>
            </div>
            <div class="d-flex align-items-center quotation_date">
                <div class="d-flex align-items-center pe-3 chartDateFilter" data-for="Sale" data-interval="Monthly">
                    <label for="viewDropdownSale_date_start" class="form-label pe-2 mb-0">From</label>
                    <input type="text" name="start_date"  class="cus_form_control datePickerFilter  start_date" id="viewDropdownSale_date_start" value="" placeholder="mm/yyyy">
                </div>
                <div class="d-flex align-items-center chartDateFilter">
                    <label for="viewDropdownSale_date_end" class="form-label pe-2 mb-0">To</label>
                    <input type="text" name="end_date" class="cus_form_control datePickerFilter  end_date" id="viewDropdownSale_date_end" value="" placeholder="mm/yyyy" >
                </div>
            </div>
        </div>
        <div class="graph_chart_detail" id="saleColumnChart"> 
        </div>
    </div>  
</div>

<div class="card details mb-4 report graph_chart border_rd_12">
    <div class="card-header">
        <div class="graph_chart_detail d-flex align-items-center justify-content-between">
            <h4 class="mb-0">Quotation</h4>
            <div class="dropdown quotation_dropdown viewDropdown" id="viewDropdownQuatition">
                <button class="btn dropdown-toggle month_daily p-0 d-flex align-items-center" type="button" data-bs-toggle="dropdown" aria-expanded="false" id="quotationBtn">
                Monthly View
                </button>
                <ul class="dropdown-menu">
                    <li><a class="dropdown-item" href="javascript:void(0);" id="monthlyQuotations" data-interval="monthly" data-name="quotation">Monthly view</a></li>
                    <li><a class="dropdown-item" href="javascript:void(0);" id="dailyQuotations"  data-interval="daily" data-name="quotation">Daily View</a></li>
                </ul>
            </div>
            <div class="d-flex align-items-center quotation_date">
                <div class="d-flex align-items-center pe-3">
                    <label for="viewDropdownQuatition_date_start" class="form-label pe-2 mb-0">From</label>
                    <input type="text" name="start_date" class="cus_form_control datePickerFilter start_date" id="viewDropdownQuatition_date_start" value="" placeholder="mm/yyyy">
                </div>
                <div class="d-flex align-items-center">
                    <label for="viewDropdownQuatition_date_end" class="form-label pe-2 mb-0">To</label>
                    <input type="text" name="end_date" class="cus_form_control datePickerFilter end_date" id="viewDropdownQuatition_date_end" value="" placeholder="mm/yyyy">
                </div>
            </div>
        </div>
        <div class="graph_chart_detail" id="quotationColumnChart">
        </div>
    </div>  
</div>

<div class="card details mb-4 report graph_chart border_rd_12">
    <div class="card-header">
        <div class="graph_chart_detail d-flex align-items-center justify-content-between">
            <h4 class="mb-0">Invoice</h4>
            <div class="dropdown quotation_dropdown viewDropdown" id="viewDropdownInvoice">
                <button class="btn dropdown-toggle month_daily p-0 d-flex align-items-center" type="button" data-bs-toggle="dropdown" aria-expanded="false" id="invoiceBtn" >
                Monthly View
                </button>
                <ul class="dropdown-menu">
                    <li><a class="dropdown-item" href="javascript:void(0);" id="monthlyInvoices" data-interval="monthly" data-name="invoice">Monthly view</a></li>
                    <li><a class="dropdown-item" href="javascript:void(0);" id="dailyInvoices" data-interval="daily" data-name="invoice">Daily View</a></li>
                </ul>
            </div>
            <div class="d-flex align-items-center quotation_date">
                <div class="d-flex align-items-center pe-3">
                    <label for="viewDropdownInvoice_date_start" class="form-label pe-2 mb-0">From</label>
                    <input type="text" name="start_date" class="cus_form_control datePickerFilter  start_date" id="viewDropdownInvoice_date_start" value="" placeholder="mm/yyyy">
                </div>
                <div class="d-flex align-items-center">
                    <label for="viewDropdownInvoice_date_end" class="form-label pe-2 mb-0">To</label>
                    <input type="text" name="end_date" class="cus_form_control datePickerFilter end_date" id="viewDropdownInvoice_date_end" value="" placeholder="mm/yyyy">
                </div>
            </div>
        </div>
        <div class="graph_chart_detail" id="invoiceColumnChart">
        </div>
    </div>  
</div>

<div class="card details mb-4 report graph_chart border_rd_12">
    <div class="card-header">
        <div class="graph_chart_detail d-flex align-items-center justify-content-between">
            <h4 class="mb-0">Recent Invoice</h4>
            
            <form method="get" class="ajaxForm" action="<?php echo e(route('admin.dashboard.invoiceRender')); ?>" id="AjaxFilterNew" autocomplete="off">
                <div class="d-flex align-items-center quotation_date">
                    <div class="d-flex align-items-center pe-3">
                        <label for="invoice_start_date" class="form-label pe-2 mb-0">From</label>
                        <input type="text" name="invoice_start_date" class="cus_form_control dateFilter" id="invoice_start_date" placeholder="mm/yyyy">
                    </div>
                    <div class="d-flex align-items-center">
                        <label for="invoice_end_date" class="form-label pe-2 mb-0">To</label>
                        <input type="text" name="invoice_end_date" class="cus_form_control dateFilter" id="invoice_end_date" placeholder="mm/yyyy">
                    </div>
                </div>
            </form>
        </div>
        <div class="recent_invoice">
            <div class="today_sale_detail">
                <div class="card-body" id="table_content">
                    <div class="earring-table sale_detail_main table-responsive">
                        <table class="table stock-detail sale-detail">
                            <thead>
                                <tr>
                                    <th><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('reference_date', __('content.date')));?></th>
                                    <th><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('id', __('content.invoice_id')));?></th>
                                    <th><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('total', __('content.amount')));?></th>
                                    <th><?php echo e(__('content.paid_amount')); ?></th>
                                    <th><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('customer_name', __('content.customer')));?></th>
                                    <th><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('customer_phone', __('content.phone_number')));?></th>     
                                    <th><?php echo e(__('content.action')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $records; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $record): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e(isset($record->reference_date) ? date('d/m/Y', strtotime($record->reference_date)) : '-'); ?></td>
                                    <td><?php echo e($record->invoice_no ?? '-'); ?></td>
                                    <td><?php echo e(isset($record->total) ? '$'.$record->total : '-'); ?></td>
                                    <td>
                                        <div class="d-flex align-items-center">

                                            <span id="paid_amount-<?php echo e($record->id); ?>">$<?php echo e((($record->is_refund == Invoice::ONE)  && ($record->balance == Invoice::ZERO)) ? $record->balance :  ($record->paid_amount ?? 0)); ?></span>

                                            <?php if($record->due > 0): ?>
                                            <a  href="javascript:void(0)" id="invoicePaidAmount-<?php echo e($record->id); ?>" class="return_edit" data-record_id="<?php echo e($record->id); ?>"> 
                                                <img class="return_first" src="<?php echo e(asset('public/img/icon-edit.png')); ?>">
                                            </a> <!-- data-bs-toggle="modal" data-bs-target="#Layway_popup" -->
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                    <td class="text-nowrap">
                                        <?php echo e(isset($record->customer_name) ? ucwords($record->customer_name) : (isset($record->customer_id) ? ucwords($record->
                                            customer->fullname) : '-')); ?>

                                    </td>
                                    <td class="text-nowrap"><?php echo e($record->phone_with_code ?? '-'); ?></td>
                                    <td>
                                        <div class="dropdown">
                                            <button class="btn btn-secondary down" type="button" id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false">
                                                Action
                                            </button>
                                            <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                                                <?php if($record->balance > 0): ?>
                                                    <li><a class="dropdown-item" href="<?php echo e(route('admin.invoices.refund', $record->id)); ?>"><img src="<?php echo e(asset('public/img/vector.png')); ?>">Refund</a></li>
                                                <?php endif; ?>

                                                
                                                    <li><a class="dropdown-item btnprn" href="<?php echo e(route('admin.invoices.printInvoice', $record->id)); ?>"><img src="<?php echo e(asset('public/img/print.png')); ?>">Print Invoice</a></li>
                                                

                                                <li><a class="dropdown-item sendEmailPDF" href="javascript:void(0); " id="sendEmailPDF-<?php echo e($record->id); ?>" data-record_id="<?php echo e($record->id); ?>" data-for="invoices"><img src="<?php echo e(asset('public/img/envelope.png')); ?>">Send email</a></li>
                                            </ul>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td class="text-center" colspan="7">No Record Found!</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                
            </div>
        </div>
    </div>  
</div>

<?php echo $__env->make('admin.elements.exports.common_report_modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('admin.elements.exports.common_reports_script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- amchart -->
<script src="https://cdn.amcharts.com/lib/4/core.js"></script>
<script src="https://cdn.amcharts.com/lib/4/charts.js"></script>
<script src="https://cdn.amcharts.com/lib/4/themes/animated.js"></script>
<script src="https://www.amcharts.com/lib/4/themes/amcharts.js"></script>

<?php echo $__env->make('admin.dashboard.scripts.donut_chart_js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('admin.dashboard.scripts.column_chart_js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php echo $__env->make('admin.elements.scripts.pdf_email_js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php echo $__env->make('admin.dashboard.scripts.invoice_table_js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('admin.invoices.layway_popup', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/sancysup/public_html/sancy_erp/resources/views/admin/dashboard/index.blade.php ENDPATH**/ ?>