<?php $__env->startSection('title',"Add Job"); ?>

<?php $__env->startSection('header', "Add Job"); ?>
<style>
    #drawingCanvas {
        position: absolute;
        left: 0;
        right: 0;
        border: none;
        color: #FFF;
        overflow: hidden;
        background-color: transparent;
        display: none;
    }

    #tempCanvas {
        position: absolute;
        left: 0;
        right: 0;
        overflow: hidden;
        border: none;
        display: none;
    }

    .kbw-signature {
        width: 100%;
        height: 82px;
    }

    #signatureCustomer canvas {
        width: 100% !important;
        height: 100%;
        /*height: auto;*/
    }
</style>

<?php $__env->startSection('content'); ?>
    <form action="<?php echo e(route('admin.jobs.store')); ?>" method="post" autocomplete="off">
        <?php echo csrf_field(); ?>
        <?php
            $is_error = $errors->any() ? 1 : 0;
            $x = $is_error ? old('jewelleries') ? count(old('jewelleries')) : '1' : 1;
        ?>
        <div class="card mb-4">
            <div class="card-header">
                <h4 class="mb-0">Add Job <span>( Quantity: 1)</span></h4>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-lg-6 mb-4">
                        <div class="form-group cus_form_group">
                            <label  class="form-label cus_label"><?php echo e(__('content.date_created')); ?></label>
                            <input type="text" name="date" class="cus_form_control datePicker" value="<?php echo e(old('date',$record->date)); ?>" readonly>
                        </div>
                        <?php if($errors->has('date')): ?>
                            <span class="error-message">
                                <strong><?php echo e($errors->first('date')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>
                    <div class="col-lg-6 mb-4">
                        <div class="form-group cus_form_group">
                            <label class="form-label cus_label"><?php echo e(__('content.estimate_completion')); ?></label>
                            <input type="text" name="estimate_completion" class="cus_form_control datePicker" value="<?php echo e(old('estimate_completion',$record->estimate_completion)); ?>" readonly>
                        </div>
                        <?php if($errors->has('estimate_completion')): ?>
                            <span class="error-message">
                                <strong><?php echo e($errors->first('estimate_completion')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>
                    <div class="col-lg-12">
                        <div class="form-group cus_form_group">
                            <label class="form-label cus_label pe-5">Item Type</label>
                            <div class="form-group d-flex">
                                <?php $types = \App\Models\JobType::getJobTypesList(); ?>
                                <?php $__currentLoopData = $types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="form-check">
                                        <input class="form-check-input job_type cus-form-check-input" type="radio" name="type_id" value="<?php echo e($key); ?>" <?php echo e(($key) == "1" ? "checked": " "); ?> <?php echo e(old('type_id',$record->job_type_id) == $key ? "checked": " "); ?> id="type_id-<?php echo e($key); ?>">
                                        <label class="form-check-label cus_form_check_label" for="type_id-<?php echo e($key); ?>">
                                            <?php echo e(__('content.'.trim(lcfirst($value)))); ?>

                                        </label>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <div class="card details mb-4">
            <div class="card-header">
                <h4 class="mb-0">Details</h4>
            </div>
            <div class="card-body">
                <div class="row">

                    <div class="col-lg-12">
                        <div class="category jobs_edit">
                            <div class="form-group">
                                <label  class="form-label">Category</label>
                            </div>
                            <ul class="">
                                <?php $categories = \App\Models\Category::getCategories(); ?>
                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="<?php echo e(old('category_id',$record->category_id) == $value->id   ?  "active_category" : ""); ?>">
                                        <a class="category_id" data-id="<?php echo e($value->id); ?>"><img src="<?php echo e($value->image); ?>" height="60" width="60"/> <?php echo e(__('sidebar.'.strtolower($value->name))); ?>

                                        </a>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                            <input id="category_id" type="hidden" name="category_id"
                                   value="<?php echo e(old('category_id', $record->category_id)); ?>"/>
                            <?php if($errors->has('category_id')): ?>
                                <span class="error-message">
                                   <strong><?php echo e($errors->first('category_id')); ?></strong>
                                </span>
                            <?php endif; ?>
                        </div>

                    </div>

                       <div class="col-lg-6 repair_hide">
                           <div class="form-group">
                               <label  class="form-label"><?php echo e(__('content.gold_colour')); ?></label>
                               <select class="form-select" name="gold_color_id" aria-label="Default select example">
                                   <option value=" ">Select One Option</option>
                                   <?php $gold_colors = \App\Models\GoldColor::getGoldColorsList(); ?>
                                   <?php $__currentLoopData = $gold_colors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                       <option value="<?php echo e($key); ?>" <?php echo e(old('gold_color_id',$record->gold_color_id) ==  $key ? 'selected' : ''); ?>><?php echo e($value); ?></option>
                                   <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                               </select>
                           </div>
                           <?php if($errors->has('gold_color_id')): ?>
                               <span class="error-message">
                                <strong><?php echo e($errors->first('gold_color_id')); ?></strong>
                            </span>
                           <?php endif; ?>
                       </div>
                       <div class="col-lg-6 repair_hide">
                           <div class="form-group">
                               <label  class="form-label"><?php echo e(__('content.size')); ?></label>
                               <input type="text" name="size" class="form-control" value="<?php echo e(old('size',$record->size)); ?>" >
                           </div>
                           <?php if($errors->has('size')): ?>
                               <span class="error-message">
                                <strong><?php echo e($errors->first('size')); ?></strong>
                            </span>
                           <?php endif; ?>
                       </div>


                    <div class="col-lg-12">
                        <div class="form-group">
                            <label  class="form-label"><?php echo e(__('content.description')); ?></label>
                            <textarea class="form-control" name="description" id="exampleFormControlTextarea1" placeholder="Description" rows="2" value=""><?php echo e(old('description',$record->description)); ?></textarea>
                            <?php if($errors->has('description')): ?>
                                <span class="error-message">
                                    <strong><?php echo e($errors->first('description')); ?></strong>
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>

                    <div class="col-lg-12 mt-3">
                        <label  class="form-label"><?php echo e(__('content.draw_upload')); ?>

                            <img src="<?php echo e(asset('public/img/folder.png')); ?>" class="folder"></label>
                        <div class="row">
                            <div class="col-lg-4">
                                <div class="form-group pt-0">
                                    <div class="drop-zone">

                                        <div class="dropzone" id="dropZoneimageUpload">
                                            <span class="drop-zone__prompt dz-default dz-message text-start">Drop Photo here <br><?php echo e(__('content.drop_photo_only')); ?>

                                            <p style="text-align: left;margin-top: 10px;">Photo Requiement:</p>
                                            <ul>
                                                <li>File type PNG or JPG</li>
                                                <li>Maximum Size: 2 MB</li>
                                            </ul>
                                                
                                                
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-8">
                                <div class="form-group pt-0">
                                    <div class="start-drawing" id="blackboardPlaceholder">
                                        <p id="drawing-place-holder"><?php echo e(__('content.start_drawing')); ?></p>
                                        <canvas id="drawingCanvas" width="500" height="230"></canvas>
                                        <div class="pen-eraser">
                                            <span class="pen" onclick="togglePenPointer();"><img
                                                        src="<?php echo e(asset('public/img/pen.png')); ?>"/></span>
                                            <span class="erase" onclick="eraserHandler();"><img
                                                        src="<?php echo e(asset('public/img/eraser.png')); ?>"/></span>
                                        </div>
                                    </div>
                                    <input type="hidden" id="drawing_textarea_base64" name="drawing_textarea_base64">
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="preview-droped-images">
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="repair_hide">

                        <div class="col-lg-12">
                            <div class="sample">
                                <div class="col-lg-12">
                                    <div class="form-group d-flex align-items-center pt-0">
                                        <label  class="form-label mb-0 pe-5"><?php echo e(__('content.sample_provided')); ?></label>
                                        <div class="form-check">
                                            <input class="form-check-input cus-form-check-input" type="radio" name="is_sample_provided" id="flexRadioDefault1" value="1" <?php echo e(old("is_sample_provided",$record->is_sample_provided) == "1" ? 'checked' : ''); ?> >
                                            <label class="form-check-label cus_form_check_label" for="flexRadioDefault1"><?php echo e(__('content.yes')); ?></label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input cus-form-check-input" type="radio" name="is_sample_provided" value="0" <?php echo e(old("is_sample_provided",$record->is_sample_provided) == "0" ? 'checked' : ''); ?> checked="checked">
                                            <label class="form-check-label cus_form_check_label" for="flexRadioDefault1"><?php echo e(__('content.no_')); ?></label>
                                        </div>
                                    </div>
                                    <?php if($errors->has('is_sample_provided')): ?>
                                        <span class="error-message">
                                    <strong><?php echo e($errors->first('is_sample_provided')); ?></strong>
                                </span>
                                    <?php endif; ?>
                                </div>
                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label  class="form-label"><?php echo e(__('content.sample_description')); ?></label>
                                        <textarea class="form-control" name="sample_description" placeholder="<?php echo e(__('content.description')); ?>" rows="2"><?php echo e(old('sample_description',$record->sample_description)); ?></textarea>
                                    </div>
                                    <?php if($errors->has('sample_description')): ?>
                                    <span class="error-message">
                                        <strong><?php echo e($errors->first('sample_description')); ?></strong>
                                    </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <div class="sample">
                            <div class="row">
                                <div class="col-lg-4">
                                    <div class="form-group pt-0">
                                        <label  class="form-label"><?php echo e(__('content.gold_weight')); ?></label>
                                        <input type="text" class="form-control" name="gold_weight" value="<?php echo e(old('gold_weight',$record->gold_weight)); ?>">
                                    </div>
                                    <?php if($errors->has('gold_weight')): ?>
                                        <span class="error-message">
                                    <strong><?php echo e($errors->first('gold_weight')); ?></strong>
                                </span>
                                    <?php endif; ?>
                                </div>
                                <div class="col-lg-4">
                                    <div class="form-group pt-0">
                                        <label  class="form-label"><?php echo e(__('content.gold_cost')); ?></label>
                                        <input type="text" class="form-control" name="gold_cost" value="<?php echo e(old('gold_cost',$record->gold_cost)); ?>">
                                    </div>
                                    <?php if($errors->has('gold_cost')): ?>
                                        <span class="error-message">
                                    <strong><?php echo e($errors->first('gold_cost')); ?></strong>
                                </span>
                                    <?php endif; ?>
                                </div>
                                <div class="col-lg-4">
                                    <div class="form-group pt-0">
                                        <label  class="form-label"><?php echo e(__('content.workmanship_cost')); ?></label>
                                        <input type="text" class="form-control" name="workmanship_cost" value="<?php echo e(old('workmanship_cost',$record->craftsmanship_cost)); ?>">
                                    </div>
                                    <?php if($errors->has('workmanship_cost')): ?>
                                        <span class="error-message">
                                    <strong><?php echo e($errors->first('workmanship_cost')); ?></strong>
                                </span>
                                    <?php endif; ?>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label  class="form-label"><?php echo e(__('content.polishing_cost')); ?></label>
                                        <input type="text" class="form-control" name="pollising_cost" value="<?php echo e(old('pollising_cost',$record->polishing)); ?>">
                                    </div>
                                    <?php if($errors->has('pollising_cost')): ?>
                                        <span class="error-message">
                                    <strong><?php echo e($errors->first('pollising_cost')); ?></strong>
                                </span>
                                    <?php endif; ?>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label  class="form-label"><?php echo e(__('content.setting_cost')); ?></label>
                                        <input type="text" class="form-control" name="setting_cost" value="<?php echo e(old('setting_cost',$record->setting_cost)); ?>">
                                    </div>
                                    <?php if($errors->has('setting_cost')): ?>
                                        <span class="error-message">
                                    <strong><?php echo e($errors->first('setting_cost')); ?></strong>
                                </span>
                                    <?php endif; ?>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label  class="form-label"><?php echo e(__('content.earing_pin')); ?></label>
                                        <input type="text" class="form-control" name="earing_pin"  value="<?php echo e(old('earing_pin',$record->earing_pin)); ?>">
                                    </div>
                                    <?php if($errors->has('earing_pin')): ?>
                                        <span class="error-message">
                                    <strong><?php echo e($errors->first('earing_pin')); ?></strong>
                                </span>
                                    <?php endif; ?>
                                </div>
                                <div class="col-lg-6 backing_div">
                                    <div class="form-group">
                                        <label  class="form-label"><?php echo e(__('content.backing_type')); ?></label>
                                        <select class="form-select" aria-label="Default select example"
                                                name="backing_type">
                                            <option value=" ">Select One Option</option>
                                            <?php $backing_types = \App\Models\Jewellery::backingTypeArray(); ?>
                                            <?php $__currentLoopData = $backing_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($key); ?>" <?php echo e(old('backing_type',$record->backing_type) == $key ? 'selected' : ''); ?>><?php echo e($value); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <?php if($errors->has('backing_type')): ?>
                                        <span class="error-message">
                                    <strong><?php echo e($errors->first('backing_type')); ?></strong>
                                </span>
                                    <?php endif; ?>
                                </div>

                                <div class="col-lg-6 backing_div">
                                    <div class="form-group">
                                        <label  class="form-label"><?php echo e(__('content.backing_cost')); ?></label>
                                        <input type="text" class="form-control" name="backing_cost" value="<?php echo e(old('backing_cost',$record->backing_cost)); ?>">
                                    </div>
                                    <?php if($errors->has('backing_cost')): ?>
                                        <span class="error-message">
                                    <strong><?php echo e($errors->first('backing_cost')); ?></strong>
                                </span>
                                    <?php endif; ?>
                                </div>

                                <div class="col-lg-3 backing_div">
                                    <div class="form-group">
                                        <label  class="form-label"><?php echo e(__('content.backing_size')); ?></label>
                                        <input type="text" class="form-control" name="backing_size" value="<?php echo e(old('backing_size',$record->backing_size)); ?>">
                                    </div>
                                    <?php if($errors->has('backing_size')): ?>
                                        <span class="error-message">
                                    <strong><?php echo e($errors->first('backing_size')); ?></strong>
                                </span>
                                    <?php endif; ?>
                                </div>
                                <div class="col-lg-3 backing_div">
                                    <div class="form-group">
                                        <label  class="form-label"><?php echo e(__('content.backing_quantity')); ?></label>
                                        <input type="text" class="form-control"
                                               name="backing_quantity"
                                               value="<?php echo e(old('backing_quantity',$record->backing_quantity)); ?>">
                                    </div>
                                    <?php if($errors->has('backing_quantity')): ?>
                                        <span class="error-message">
                                    <strong><?php echo e($errors->first('backing_quantity')); ?></strong>
                                </span>
                                    <?php endif; ?>
                                </div>

                            </div>
                        </div>
                        <div class="sample">
                            <div class="row">
                                <div class="col-lg-6">
                                    <div class="form-group pt-0">
                                        <label  class="form-label"><?php echo e(__('content.claw')); ?></label>
                                        <select class="form-select" aria-label="Default select example" name="claw">
                                            <option value=" ">Select One Option</option>
                                            <?php $claw = \App\Models\Jewellery::clawArray(); ?>
                                            <?php $__currentLoopData = $claw; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($key); ?>" <?php echo e(old('claw',$record->claw) == $key ? 'selected' : ''); ?>><?php echo e($value); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <?php if($errors->has('claw')): ?>
                                        <span class="error-message"><strong><?php echo e($errors->first('claw')); ?></strong></span>
                                    <?php endif; ?>
                                </div>

                                <div class="col-lg-6">
                                    <div class="form-group pt-0">
                                        <label  class="form-label"><?php echo e(__('content.worksmith')); ?></label>
                                        <?php $worksmiths = \App\Models\Worksmith::getWorksmithsList();?>
                                        <select class="form-select" aria-label="Default select example" name="worksmith_id">
                                            <option value=" ">Select One Option</option>
                                            <?php $__currentLoopData = $worksmiths; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($key); ?>" <?php echo e((old('worksmith_id', $record->worksmith_id) == $key) ? 'selected' : ''); ?>><?php echo e($value); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <?php if($errors->has('worksmith_id')): ?>
                                        <span class="error-message"><strong><?php echo e($errors->first('worksmith_id')); ?></strong></span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                    </div>

                    <div class="sample">
                        <div class="row">

                            <?php if(old('jewelleries')!=""): ?>
                                <?php
                                    $oldJewelleries = old('jewelleries',@$record->loose_pieces->toArray());
                                    $oldCount = count($oldJewelleries);
                                ?>
                                <?php $__currentLoopData = old('jewelleries',@$record->loose_pieces->toArray()); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php $x=$key+1; ?>
                                    <div class="row indexes" id="row<?php echo e($key); ?>">
                                        <div class="col-lg-3">
                                            <div class="form-group pt-0">
                                                <label  class="form-label"><?php echo e(__('content.item_code')); ?></label>
                                                <input type="text" class="form-control jewellery_item_code" id="jewelleries-<?php echo e($key); ?>-stock_no" data-id="<?php echo e($key); ?>" name="jewelleries[<?php echo e($key); ?>][stock_no]"  value="<?php echo e(old('jewelleries.'.$key.'.stock_no',@$value['stock_no'])); ?>">
                                            </div>
                                            <?php if($errors->has('jewelleries.'.$key.'.stock_no')): ?>
                                                <span class="error-message">
                                                    <strong><?php echo e($errors->first('jewelleries.'.$key.'.stock_no')); ?></strong>
                                                </span>
                                            <?php endif; ?>
                                        </div>
                                        <div class="col-lg-3">
                                            <div class="form-group pt-0">
                                                <label  class="form-label"><?php echo e(__('content.weight')); ?></label>
                                                <input type="text" class="form-control" data-id="<?php echo e($key); ?>" name="jewelleries[<?php echo e($key); ?>][weight]" id="jewelleries-<?php echo e($key); ?>-weight"  value="<?php echo e(old('jewelleries.'.$key.'.weight',@$value['weight'])); ?>" oninput="onInputweight()">
                                            </div>
                                            <?php if($errors->has('jewelleries.'.$key.'.weight')): ?>
                                                <span class="error-message">
                                                    <strong><?php echo e($errors->first('jewelleries.'.$key.'.weight')); ?></strong>
                                                </span>
                                            <?php endif; ?>
                                        </div>
                                        <div class="col-lg-3">
                                            <div class="form-group pt-0">
                                                <label  class="form-label"><?php echo e(__('content.unit_price')); ?></label>
                                                <input type="text" class="form-control" data-id="<?php echo e($key); ?>" name="jewelleries[<?php echo e($key); ?>][unit_price]" id="jewelleries-<?php echo e($key); ?>-unit_price" value="<?php echo e(old('jewelleries.'.$key.'.unit_price',@$value['unit_price'])); ?>" oninput="onInputUnitPrice()">
                                            </div>
                                            <?php if($errors->has('jewelleries.'.$key.'.unit_price')): ?>
                                                <span class="error-message">
                                                    <strong><?php echo e($errors->first('jewelleries.'.$key.'.unit_price')); ?></strong>
                                                </span>
                                            <?php endif; ?>
                                        </div>
                                        <div class="col-lg-2">
                                            <div class="form-group pt-0">
                                             <label  class="form-label"><?php echo e(__('content.price')); ?></label>
                                                <input type="text" class="form-control price-<?php echo e($key); ?>" name="jewelleries[<?php echo e($key); ?>][price]" id="jewelleries-<?php echo e($key); ?>-price" value="<?php echo e(old('jewelleries.'.$key.'.price',@$value['price'])); ?>">
                                            </div>
                                            <?php if($errors->has('jewelleries.'.$key.'.price')): ?>
                                                <span class="error-message">
                                                    <strong><?php echo e($errors->first('jewelleries.'.$key.'.price')); ?></strong>
                                                </span>
                                            <?php endif; ?>
                                        </div>

                                        <?php if($key>0): ?>
                                            <div class="col-lg-1">
                                                <button type="button" name="remove" id="<?php echo e($key); ?>"
                                                        class="btn btn-danger plus_btn_remove">X
                                                </button>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                                <div class="col-lg-3">
                                    <div class="form-group pt-0">
                                        <label  class="form-label"><?php echo e(__('content.item_code')); ?></label>
                                        <input type="text" class="form-control jewellery_item_code"  name="jewelleries[0][stock_no]"  id="jewelleries-0-stock_no" data-id="0" value="<?php echo e(old('jewelleries.0.stock_no')); ?>">
                                    </div>
                                    <?php if($errors->has('jewelleries.0.stock_no')): ?>
                                        <span class="error-message">
                                    <strong><?php echo e($errors->first('jewelleries.0.stock_no')); ?></strong>
                                </span>
                                    <?php endif; ?>
                                </div>
                                <div class="col-lg-3">
                                    <div class="form-group pt-0">
                                        <label  class="form-label"><?php echo e(__('content.weight')); ?></label>
                                        <input type="text" class="form-control" data-id="0" name="jewelleries[0][weight]"  id="jewelleries-0-weight" value="<?php echo e(old('jewelleries.0.weight')); ?>" oninput="onInputweight()">
                                    </div>
                                    <?php if($errors->has('jewelleries.0.weight')): ?>
                                        <span class="error-message">
                                    <strong><?php echo e($errors->first('jewelleries.0.weight')); ?></strong>
                                </span>
                                    <?php endif; ?>
                                </div>
                                <div class="col-lg-3">
                                    <div class="form-group pt-0">
                                        <label class="form-label"><?php echo e(__('content.unit_price')); ?></label>
                                        <input type="text" class="form-control" data-id="0" name="jewelleries[0][unit_price]" id="jewelleries-0-unit_price" value="<?php echo e(old('jewelleries.0.unit_price')); ?>" oninput="onInputUnitPrice()">
                                    </div>
                                    <?php if($errors->has('jewelleries.0.unit_price')): ?>
                                        <span class="error-message">
                                    <strong><?php echo e($errors->first('jewelleries.0.unit_price')); ?></strong>
                                </span>
                                    <?php endif; ?>
                                </div>
                                <div class="col-lg-2">
                                    <div class="form-group pt-0">
                                        <label  class="form-label"><?php echo e(__('content.price')); ?></label>
                                        <input type="text" class="form-control price-0" name="jewelleries[0][price]" id="jewelleries-0-price" value="<?php echo e(old('jewelleries.0.price')); ?>">
                                    </div>
                                    <?php if($errors->has('jewelleries.0.price')): ?>
                                        <span class="error-message">
                                    <strong><?php echo e($errors->first('jewelleries.0.price')); ?></strong>
                                </span>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                            <div id="append_fields">

                            </div>
                            <div class="col-lg-12">
                                <div class="form-group plus pt-0">
                                    <a id="addPlus"><i class="icofont-plus"></i></a>
                                </div>
                            </div>

                        </div>
                    </div>

                    <div class="sample">
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="form-group pt-0">
                                    <label  class="form-label"><?php echo e(__('content.handle_by')); ?></label>
                                    <?php $handledBy = \App\Models\Admin::handleBYArray();?>
                                    <select class="form-select" aria-label="Default select example" name="staff_id">
                                        <option value="">Select One Option</option>
                                        <?php $__currentLoopData = $handledBy; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($value->id); ?>" <?php echo e(old('staff_id',$record->staff_id) == $value->id ? 'selected' : ''); ?>><?php echo e(ucwords($value->fullname)); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <?php if($errors->has('staff_id')): ?>
                                    <span class="error-message">
                                    <strong><?php echo e($errors->first('staff_id')); ?></strong>
                                </span>
                                <?php endif; ?>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group pt-0 position-relative">
                                    <label  class="form-label"><?php echo e(__('content.customer_phone_no')); ?></label>
                                    <div class="search">
                                        <img src="<?php echo e(asset('public/img/search.png')); ?>"/>
                                        <input type="text" class="form-control" id="customer_phone" placeholder="Enter or Search Phone Number" name="customer_phone" value="<?php echo e(old('customer_phone', @$record->customer->country_code." ".@$record->customer->phone)); ?>">
                                    </div>
                                    <?php if($errors->has('customer_phone')): ?>
                                        <span class="error-message">
                                    <strong><?php echo e($errors->first('customer_phone')); ?></strong>
                                </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label  class="form-label"><?php echo e(__('content.customer_name')); ?></label>
                                    <input type="text" class="form-control" id="customer_name" name="customer_name" value="<?php echo e(old('customer_name',@$record->customer->name)); ?>">
                                </div>
                                <?php if($errors->has('customer_name')): ?>
                                    <span class="error-message">
                                    <strong><?php echo e($errors->first('customer_name')); ?></strong>
                                </span>
                                <?php endif; ?>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label  class="form-label"><?php echo e(__('content.customer_email')); ?></label>
                                    <input type="text" class="form-control" id="customer_email" name="customer_email" value="<?php echo e(old('customer_email',@$record->customer->email)); ?>">
                                </div>
                                <?php if($errors->has('customer_email')): ?>
                                    <span class="error-message">
                                    <strong><?php echo e($errors->first('customer_email')); ?></strong>
                                </span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                    <div class="sample repair_show">
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="form-group pt-0">
                                    <label class="form-label">Customer Signature</label>
                                    <div id="signatureCustomer"></div>
                                    <textarea id="signature164" class="form-control signature" name="customer_signature"
                                              style="display: none" rows="2"></textarea>
                                    <div class="buttons buttons_1 sale-sig mt-2">
                                        <span id="customer_signature_clear" class="btn btn-primary btn-create"  type="submit">CLEAR</span>
                                    </div>
                                </div>
                                <?php if($errors->has('customer_signature')): ?>
                                    <span class="error-message"><strong><?php echo e($errors->first('customer_signature')); ?></strong> </span>
                                <?php endif; ?>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group pt-0">
                                    <label class="form-label">Sales Representative
                                        Signature</label>
                                    <div id="signatureSaleRepresentive"></div>
                                    <textarea id="sale_representive_signature_64" class="form-control signature" name="sales_representative_signature" style="display: none" rows="2"></textarea>
                                    <div class="buttons buttons_1 sale-sig mt-2"> <span id="sale_signature_clear" class="btn btn-primary btn-create" type="submit">CLEAR</span>
                                    </div>
                                </div>
                                <?php if($errors->has('sales_representative_signature')): ?>
                                    <span class="error-message">
                                       <strong><?php echo e($errors->first('sales_representative_signature')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <div class="card details mb-4">
            <div class="card-body">
                <div class="buttons">
                    <button class="btn btn-primary btn-create" type="submit"><?php echo e(__('content.input_cost')); ?></button>
                    <a href="" class="btn btn-primary btn-reset-form w-auto ps-3 pe-3"
                       type="button"><?php echo e(__('content.reset_form')); ?></a>
                </div>
                <div class="col-lg-5 note pt-2">
                    
                    
                    
                </div>
            </div>
        </div>
    </form>
    <?php echo $__env->make('admin.elements.scripts.jewellery_itemcode_autocomplete_js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('admin.jewelleries.script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/sancysup/public_html/sancy_erp/resources/views/admin/jobs/create.blade.php ENDPATH**/ ?>