<?php 
use App\Models\Quotation;
?>


<?php $__env->startSection('title', "Quotations"); ?>
<?php $__env->startSection('header', "Quotations"); ?>

<?php $__env->startSection('content'); ?>
	<form id="quotattionItemsForm" method="POST">
		<?php echo csrf_field(); ?>

		<input type="hidden" name="quotation_id" value="<?php echo e($quotation_id); ?>" />

		<div class="today_sale_main pb-5">
			<div class="dasboard-menu-item ps-0">
				<div class="today_sale_heading">
					<div class="create_quote_link today_sale">
						<?php echo $__env->make('frontend.elements.layouts.time_date_user_details', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
					</div>

					<div class="today_sale_detail">
						<div class="card-body">
							<div class="earring-table sale_detail_main table-responsive">
								<table class="table stock-detail sale-detail">
									<thead>
										<tr>
											<th>
												<input class="form-check-input form-check-minus" style="border: 2px solid #555;" type="checkbox">
											</th>
											<th><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('item_code', __('content.item_code')));?></th>
											<th><?php echo e(__('content.type')); ?></th>
											<th><?php echo e(__('content.image')); ?></th>
											<th><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('gold_color_id', __('content.gold_colour')));?></th>
											<th><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('sub_total', __('content.amount')));?></th>
											<th><?php echo __('content.customer_name_with_br'); ?></th>
											<th><?php echo __('content.customer_email_with_br'); ?></th>
											<th><?php echo __('content.customer_phone_no_with_br'); ?></th>

											<?php if($type == Quotation::TYPE_BESPOKE_AND_REPAIR): ?>
												<th><?php echo e(__('content.action')); ?></th>
											<?php endif; ?>
										</tr>
									</thead>
									<tbody>
										
										<?php $__empty_1 = true; $__currentLoopData = $record->quotation_item; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $quotationItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
											<tr>
												<?php $exist_invoice = App\Models\InvoiceItem::checkInvoiceByQuotationItem($quotationItem->id) ;?>
												<td>
													<input class="form-check-input" style="border: 2px solid #555;" type="checkbox" name="qut_item_ids[]" value="<?php echo e($quotationItem->id); ?>" <?php echo e(($exist_invoice) ? "disabled": " "); ?> >
												</td>
												<td><?php echo e($quotationItem->item_code ?? '-'); ?></td>
												<td><?php echo e($quotationItem->type_name ?? '-'); ?></td>
												<td>
													<a href="javascript:void(0);" class="view_image" data-record_id="<?php echo e($quotationItem->id); ?>">View</a>
													<!-- data-bs-toggle="modal" data-bs-target="#img-Modal" -->
												</td>
												<td><?php echo e(isset($quotationItem->gold_color_id) ? $quotationItem->gold_color->name : '-'); ?></td>
												<td><?php echo e(!empty($quotationItem->sub_total) ? '$'.number_format($quotationItem->sub_total) : '-'); ?></td>

												<td><?php echo e(isset($quotationItem->quotation->customer_name) ? ucwords($quotationItem->quotation->customer_name) : (isset($quotationItem->quotation->customer_id) ? ucwords($quotationItem->quotation->customer->fullname) : '-')); ?></td>
												<td><?php echo e(isset($quotationItem->quotation->customer_email) ? $quotationItem->quotation->customer_email : (isset($quotationItem->quotation->customer_id) ? $quotationItem->quotation->customer->email : '-')); ?></td>
												<td><?php echo e(isset($quotationItem->quotation->customer_phone) ? $quotationItem->quotation->customer_phone : (isset($quotationItem->quotation->customer_id) ? $quotationItem->quotation->customer->phone : '-')); ?></td>

												<?php if($type == Quotation::TYPE_BESPOKE_AND_REPAIR): ?>
													<td>
														<a href="javascript:void(0);" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-custom-class="custom-tooltip" data-bs-title="Print Job Order" class="red-tooltip">
						                                    <img src="<?php echo e(asset('public/img/print.png')); ?>">
						                                </a>
													</td>
												<?php endif; ?>
											</tr>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
		                                    <tr>
		                                        <td class="text-center" colspan="<?php echo e(($type == Quotation::TYPE_BESPOKE_AND_REPAIR) ? '7' : '6'); ?>">No Record Found!</td>
		                                    </tr>
	                                    <?php endif; ?>
									</tbody>
								</table>
							</div>
						</div>
					</div>

					<div class="buttons buttons_1">
	                    <?php if($type == Quotation::TYPE_INVENTORY): ?>
	                    	<a class="btn btn-primary btn-create btn-full submitForm" type="button" data-action="<?php echo e(route('quotations.createInvoice')); ?>">Create Invoice</a>
	                    <?php elseif($type == Quotation::TYPE_BESPOKE_AND_REPAIR): ?>
	                    	<button class="btn btn-primary btn-create btn-full sendToJobOrder" type="button" data-action="<?php echo e(route('quotations.sendToJobOrder')); ?>">Send to Job Order</button>
	                    <?php endif; ?>
	                </div>
				</div>
			</div>
		</div>
	</form>

	<?php echo $__env->make('frontend.invoices.pay_amount_with_print_invoice_popup', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
	<?php echo $__env->make('frontend.quotations.scripts.send_to_job_order', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
	<?php echo $__env->make('frontend.quotations.image_popup', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

	<script>
		$(function(){
			$('.submitForm').on('click', function(e){
				e.preventDefault();

				var formData = $('#quotattionItemsForm').serialize();
				var formAction = $(this).data('action');

		        $.ajax({
		            url: formAction,
		            type: "POST",
		            cache: false,
		            data: formData,
		            dataType: 'json',
		            success:function(res){
			            if(res.errors){
			                error(res.errors, res.title); 
			            }

			            if (res.status == 0) {
			                error(res.errors, res.title); 
			            }else if (res.status == 1) {
			                $("#quotattionItemsForm")[0].reset(); 

			                let invoiceId = res.data.id;
					        let printRoute = "<?php echo e(route('invoices.printInvoice')); ?>";
					        let printHref = printRoute + '/' + invoiceId;
					        $('.btn_print').attr('href', printHref);
					        $('#invoice_id').val(invoiceId);
					        $('#full_paid_amount').val(res.data.total);
					        $("#invoice").modal('show');
					        if(res.data.customer.is_vip == 1){
					            $('.layaway_click').removeClass('no_vip');
					        } 
			                success(res.message, res.title);
			            }
		            },
		            error: function(response) {
		            	$('#message-error').text(response.responseJSON.errors.message);
		            }
		        });
			});
		});
        
	</script>

<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/sancysup/public_html/sancy_erp/resources/views/frontend/quotations/quotation_items.blade.php ENDPATH**/ ?>