<script>
    /**
 * ---------------------------------------
 * This demo was created using amCharts 4.
 *
 * For more information visit:
 * https://www.amcharts.com/
 *
 * Documentation is available at:
 * https://www.amcharts.com/docs/v4/
 * ---------------------------------------
 */

// Set theme
am4core.useTheme(am4themes_animated);

let donartChartColors = { 'dummy':'#dadada', 'donutChartSeries1':'#0F172A', 'donutChartSeries2':'#CBD5E1' };
console.log('donartChartColors : '+JSON.stringify(donartChartColors))
console.log('donartChartColors donutChartSeries1 : '+donartChartColors.donutChartSeries1);

// Add data
donutChartData1 = [
    {
      "name": "Dummy",
      "all_quotation": 100,
      "invoice": 100,
      "disabled": true,
      "color": am4core.color("#fff"), // #dadada -> lightgrey background
      "opacity": 0.3,
      // "strokeDasharray": "4,4",
      "tooltip": ""
    },
    {
      "name": "Quotation Conversion",
      "all_quotation": '<?php echo e(getTotalQuotationsCount()); ?>',
      "invoice": '<?php echo e(getConvertedInvoicesCount()); ?>',
    }
];


donutChartData2 = [
    {
      "name": "Dummy",
      "all_jobs": 100,
      "completed": 100,
      "disabled": true,
      "color": am4core.color("#fff"), // #dadada -> lightgrey background
      "opacity": 0.3,
      // "strokeDasharray": "4,4",
      "tooltip": ""
    },
    {
      "name": "Job Completion",
      "all_jobs": '<?php echo e(getTotalJobsCount()); ?>',
      "completed": '<?php echo e(getCompletedJobsCount()); ?>',
    }
    // , {
    //   "country": "Czechia","litres": 301.9,"bottles": 990
    // }
];
// console.log('donutChartData1', donutChartData1);
// console.log('donutChartData2', donutChartData2);

// Create chart instance
var donutChart1 = am4core.create("quotationDonutChart", am4charts.PieChart);
var donutChart2 = am4core.create("jobDonutChart", am4charts.PieChart); 

drawNestedDonutChart(donutChart1, donutChartData1, 'quotation');
drawNestedDonutChart(donutChart2, donutChartData2, 'job');

function drawNestedDonutChart(chart, data, chart_for){
    // Let's cut a hole in our Pie chart the size of 40% the radius
    chart.innerRadius = am4core.percent(40);

    chart.data = data;

    // var hs = pieSeries.slices.template.states.getKey("hover");
    // hs.properties.scale = 1;
    // hs.properties.fillOpacity = 0.5;

    // Add and configure Series
    var donutChartSeries1 = chart.series.push(new am4charts.PieSeries());
    donutChartSeries1.dataFields.value = getValue1Name(chart_for);
    donutChartSeries1.dataFields.category = getCategoryName(chart_for, 'donutChartSeries1');
    // console.log('donutChartSeries1',donutChartSeries1.dataFields.value);
    donutChartSeries1.slices.template.stroke = am4core.color("#0F172A");
    donutChartSeries1.slices.template.strokeWidth = 2;
    // donutChartSeries1.slices.template.strokeOpacity = 1;

    donutChartSeries1.labels.template.disabled = true;
    donutChartSeries1.slices.template.fill = am4core.color('#0F172A');

    // Disabling labels and ticks on inner circle
    donutChartSeries1.labels.template.disabled = true; // true
    donutChartSeries1.ticks.template.disabled = false; // true

    // // Disable sliding out of slices
    // donutChartSeries1.slices.template.states.getKey("hover").properties.shiftRadius = 0;
    // donutChartSeries1.slices.template.states.getKey("hover").properties.scale = 0.9;

    // donutChartSeries1.adapter.remove("clickable");
    // donutChartSeries1.adapter.remove("draggable");

    // Add second series
    var donutChartSeries2 = chart.series.push(new am4charts.PieSeries());
    donutChartSeries2.dataFields.value = getValue2Name(chart_for);
    donutChartSeries2.dataFields.category = getCategoryName(chart_for, 'donutChartSeries2');
    donutChartSeries2.slices.template.stroke = am4core.color("#CBD5E1"); // 0F172A
    donutChartSeries2.slices.template.strokeWidth = 2;
    // donutChartSeries2.slices.template.strokeOpacity = 1;

    // // Disable sliding out of slices
    // donutChartSeries2.slices.template.states.getKey("hover").properties.shiftRadius = 0;
    // donutChartSeries2.slices.template.states.getKey("hover").properties.scale = 1.1;

    donutChartSeries2.labels.template.disabled = true;
    donutChartSeries2.slices.template.fill = am4core.color('#CBD5E1');

    // Disabling labels and ticks on inner circle
    donutChartSeries2.labels.template.disabled = true; // true
    donutChartSeries2.ticks.template.disabled = false; // true

    // Disable toggling
    // chart.legend.itemContainers.template.clickable = false;
    // chart.legend.itemContainers.template.focusable = false;
    // chart.legend.itemContainers.template.cursorOverStyle = am4core.MouseCursorStyle.default;

    //--------------------- Placeholder Starts Here --------------------
    /* Set up slice1 appearance */
    var slice1 = donutChartSeries1.slices.template;
    slice1.propertyFields.fill = "color"; // am4core.color("#dadada");
    slice1.propertyFields.fillOpacity = "opacity"; // 0.3;
    slice1.propertyFields.stroke = "color";
    slice1.propertyFields.strokeDasharray = "strokeDasharray"; // "4,4";

    var category1Name = (getValue1Name(chart_for)).replace('_', ' ');
    console.log('category1Name', category1Name);
    slice1.propertyFields.tooltipText = `${category1Name}`;

    // slice1.propertyFields.tooltipText = `{category}[/]
    //                                     ----
    //                                     ${getValue1Name(chart_for)}: {percent}%`;

    // getValue1Name(chart_for)+": {percent}%"; // "tooltip";

    // donutSeries.labels.template.propertyFields.disabled = "disabled";
    // donutSeries.ticks.template.propertyFields.disabled = "disabled";

    slice1.isHover = false;

    // Disable hover & active behavior
    slice1.states.getKey("hover").properties.scale = 1;
    slice1.states.getKey("active").properties.shiftRadius = 0;

    // Hiding dummy slice from legend
    // donutChartSeries1.dataFields.hiddenInLegend = "disabled";

    /* Set up slice2 appearance */
    var slice2 = donutChartSeries2.slices.template;
    slice2.propertyFields.fill = "color"; // am4core.color("#dadada");
    slice2.propertyFields.fillOpacity = "opacity"; // 0.3;
    slice2.propertyFields.stroke = "color";
    slice2.propertyFields.strokeDasharray = "strokeDasharray"; // "4,4";

    var category2Name = (getValue2Name(chart_for)).replace('_', ' ');
    console.log('category2Name', category2Name);
    slice2.propertyFields.tooltipText = `${category2Name}`;

    slice2.isHover = false;

    // Hiding dummy slice from legend
    // donutChartSeries2.dataFields.hiddenInLegend = "disabled";

    // Disable hover & active behavior
    slice2.states.getKey("hover").properties.scale = 1;
    slice2.states.getKey("active").properties.shiftRadius = 0;
    
    //-------------------------------------------------------
    // chart.legend.dispose();
    /* Create legend */
    chart.radius = am4core.percent(100); // 95

    // Create custom legend
    chart.events.on("ready", function(event) {
        // populate our custom legend when chart renders
        var legendName = chart_for+'DonutChartLegend';
        chart.customLegend = document.getElementById(legendName);

        displaySeriesWiseLegend(donutChartSeries2, 'donutChartSeries2');
        displaySeriesWiseLegend(donutChartSeries1, 'donutChartSeries1');
        function displaySeriesWiseLegend(seriesVar, seriesName){
            seriesVar.dataItems.each(function(row, i) {
                var percent = Math.round(row.values.value.percent * 100) / 100;
                var value = row.value;
                var categoryName = (seriesVar.dataFields.value).replace('_', ' ');
                
                if(i == 1){
                    chart.customLegend.innerHTML += `<div class="conversion d-flex align-items-center justify-content-between">
                        <div class="conversion_quot" style="background-color:${getColorBySeriesName(seriesName)};"></div>
                        <h6 class="m-0">${categoryName}</h6>
                        <p class="conversion_value">${value}</p>
                        <p class="conversion_per">${percent}%</p>
                    </div>`;
                }
            });
        }
    });

    //-----------------------------------------------------------------
    function getCategoryName(chart_for, seriesName){
        if(chart_for == 'quotation'){
            if(seriesName == 'donutChartSeries1'){
                getValue1Name(chart_for);
            }else{
                getValue2Name(chart_for);
            }
        }else if(chart_for == 'job'){
            if(seriesName == 'donutChartSeries2'){
                getValue1Name(chart_for);
            }else{
                getValue2Name(chart_for);
            }
        } 
    } 

    function getValue1Name(chart_for){
        if(chart_for == 'quotation'){
            return 'invoice'; 
        }else if(chart_for == 'job'){
            return 'completed'; 
        } 
    }

    function getValue2Name(chart_for){
        if(chart_for == 'quotation'){
            return 'all_quotation'; 
        }else if(chart_for == 'job'){
            return 'all_jobs'; 
        } 
    }

    function getColorBySeriesName(seriesName){
        if(seriesName == 'donutChartSeries1'){
            return '#0F172A'; 
        }else if(seriesName == 'donutChartSeries2'){
            return '#CBD5E1'; 
        } 
    }
}
</script><?php /**PATH /home/sancysup/public_html/sancy_erp/resources/views/admin/dashboard/scripts/donut_chart_js.blade.php ENDPATH**/ ?>