<?php
    use Illuminate\Support\Facades\Route;
    $routeName = Route::currentRouteName();
    $category = \App\Models\Category::getCategoriesList();
?>

<div class="dasboard-menu">
    <div class="d-flex align-items-start _inner-menu">
        <ul class="nav flex-column nav-pills" id="v-pills-tab" role="tablist" aria-orientation="vertical">
            <ul class="all-acc">
                <li class="nav-item <?php echo e(in_array($routeName,['admin.dashboard.index']) ? 'active_l':''); ?>">
                    <a href="<?php echo e(route('admin.dashboard.index')); ?>" class="nav-link" id="v-pills-home-tab" type="button">
                        <img src="<?php echo e(asset('public/images/menu-icon/icon-1.png')); ?>"/><?php echo e(__('sidebar.dashboard')); ?>

                    </a>
                </li>
            </ul>

            <ul class="all-acc">

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['jewellery-create', 'jewellery-read'])): ?>
                    <h4><?php echo e(__('sidebar.inventory')); ?></h4>
                <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('jewellery-create')): ?>
                    <li class="nav-item <?php echo e(in_array($routeName,['admin.jewelleries.create']) ? 'active_l':''); ?>">
                        <a class="nav-link" href="<?php echo e(route('admin.jewelleries.create')); ?>"><img src="<?php echo e(asset('public/images/menu-icon/icon-2.png')); ?>"/> <?php echo e(__('sidebar.add_jewellery')); ?></a>
                    </li>
                <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('jewellery-read')): ?>
                    <?php $__currentLoopData = $category; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="nav-item <?php echo e((request()->category_id == $value->id) ? in_array($routeName,['admin.jewelleries.edit','admin.jewelleries.indexByCategory','admin.jewelleries.duplicate','admin.jewelleries.purchagedCostSummery']) ? 'active_l':'': ''); ?>">
                            <a class="nav-link" href="<?php echo e(route('admin.jewelleries.indexByCategory',$value->id)); ?>"><img src="<?php echo e($value->icon_image); ?>"/><?php echo e(__('sidebar.'.strtolower($value->name))); ?></a>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>

            </ul>

            <ul class="all-acc">
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['job-create', 'job-read', 'job-dashboard'])): ?>
                    <h4><?php echo e(__('sidebar.job_order')); ?> </h4>
                <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('job-dashboard')): ?>
                <li class="nav-item <?php echo e(in_array($routeName,['admin.jobs.dashboard']) ? 'active_l':''); ?>">
                    <a class="nav-link" href="<?php echo e(route('admin.jobs.dashboard')); ?>"><img src="<?php echo e(asset('public/images/menu-icon/icon-1.png')); ?>"/> <?php echo e(__('sidebar.dashboard')); ?></a>
                </li>
                <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('job-create')): ?>
                    <li class="nav-item <?php echo e(in_array($routeName,['admin.jobs.create']) ? 'active_l':''); ?>">
                        <a class="nav-link" href="<?php echo e(route('admin.jobs.create')); ?>"><img src="<?php echo e(asset('public/images/menu-icon/icon-2.png')); ?>"/><?php echo e(__('sidebar.create_job')); ?></a>
                    </li>
                <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('job-read')): ?>
                    <li class="nav-item <?php echo e(in_array($routeName,['admin.jobs.index','admin.jobs.edit','admin.jobs.duplicate','admin.jobs.bespokeCostSummery']) ? 'active_l':''); ?>">
                        <a class="nav-link" href="<?php echo e(route('admin.jobs.index')); ?> "><img src="<?php echo e(asset('public/images/menu-icon/icon-10.png')); ?>"/><?php echo e(__('sidebar.all_job_order')); ?></a>
                    </li>
                <?php endif; ?>
            </ul>

            <ul class="all-acc">
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['quotation-create','quotation-read'])): ?>
                <h4><?php echo e(__('sidebar.sales')); ?></h4>
                <!-- <li class="nav-item ">
                    <a class="nav-link" href="javascript:void(0);"><img src="<?php echo e(asset('public/images/menu-icon/icon-1.png')); ?>"/>
                    </a>
                </li> -->
                <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['quotation-create','quotation-read', 'invoice-create','invoice-read'])): ?>
                <li class="nav-item side-dropdown">
                    <a class="nav-link" data-bs-toggle="collapse" data-bs-target="#flush-collapseOne" aria-expanded="false" aria-controls="flush-collapseOne" href="javascript:void(0);"><img src=" <?php echo e(asset('public/img/Library.png')); ?>"/><?php echo e(__('sidebar.quotations')); ?></a>
                    <span>
                        <?php if(in_array($routeName,['admin.quotations.create','admin.quotations.index'])): ?>
                            <img src="<?php echo e(asset('public/img/arrow_down.png')); ?>" class="img_arrow_change" data-text="-"/>
                        <?php else: ?>
                            <img src="<?php echo e(asset('public/img/right_arrow.png')); ?>" class="img_arrow_change" data-text="+" />
                        <?php endif; ?>
                    </span>
                    <ul style="display: <?php echo e(in_array($routeName,['admin.quotations.create','admin.quotations.index','admin.quotations.edit' ]) ? 'block':''); ?>;">

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quotation-create')): ?>
                        <li class="nav-item <?php echo e(in_array($routeName,['admin.quotations.create']) ? 'active_l':''); ?>">
                            <a class="nav-link" href="<?php echo e(route('admin.quotations.create')); ?>"><img src="<?php echo e(asset('public/img/Library.png')); ?>"/><?php echo e(__('sidebar.create_quotations')); ?></a>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quotation-read')): ?>
                        <li class="nav-item <?php echo e(in_array($routeName,['admin.quotations.index','admin.quotations.edit'] ) ? 'active_l':''); ?>">
                            <a class="nav-link" href="<?php echo e(route('admin.quotations.index')); ?>"><img src="<?php echo e(asset('public/img/Library.png')); ?>"/><?php echo e(__('sidebar.quotations_list')); ?></a>
                        </li>
                        <?php endif; ?>

                    </ul>
                </li>
                <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['invoice-create','invoice-read'])): ?>

                <li class="nav-item side-dropdown">
                    <a class="nav-link" data-bs-toggle="collapse" data-bs-target="#flush-collapseOne" aria-expanded="false" aria-controls="flush-collapseOne" href="javascript:void(0);"><img src="<?php echo e(asset('public/img/Library.png')); ?>"/><?php echo e(__('sidebar.invoice')); ?></a><span>
                        <?php if(in_array($routeName,['admin.invoices.create','admin.invoices.index'])): ?>
                            <img src="<?php echo e(asset('public/img/arrow_down.png')); ?>"class="img_arrow_change" data-text="-" />
                        <?php else: ?>
                            <img src="<?php echo e(asset('public/img/right_arrow.png')); ?>" class="img_arrow_change" data-text="+" />
                        <?php endif; ?>
                     </span>
                    <ul style="display: <?php echo e(in_array($routeName,['admin.invoices.create','admin.invoices.index']) ? 'block':'none'); ?>">

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('invoice-create')): ?>
                        <li class="nav-item <?php echo e(in_array($routeName,['admin.invoices.create']) ? 'active_l':''); ?>">
                            <a class="nav-link" href="<?php echo e(route('admin.invoices.create')); ?>"><img src=" <?php echo e(asset('public/img/Library.png')); ?> "/><?php echo e(__('sidebar.create_invoice')); ?></a>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('invoice-read')): ?>
                        <li class="nav-item <?php echo e(in_array($routeName,['admin.invoices.index']) ? 'active_l':''); ?>">
                            <a class="nav-link" href="<?php echo e(route('admin.invoices.index')); ?>"><img src="<?php echo e(asset('public/img/Library.png')); ?>"/><?php echo e(__('sidebar.invoice_list')); ?></a>
                        </li>
                        <?php endif; ?>
                    </ul>
                </li>
                <?php endif; ?>

            </ul>

            <ul class="all-acc">

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['customer-create','customer-read','customer-dashboard'])): ?>
                <h4><?php echo e(__('sidebar.customers')); ?></h4>
                <?php endif; ?>

                
                    <!-- <li class="nav-item">
                        <a class="nav-link" href="javascript:void(0);"><img src="<?php echo e(asset('public/images/menu-icon/icon-1.png')); ?>"/></a>
                    </li> -->
                

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('customer-create')): ?>
                <li class="nav-item <?php echo e(in_array($routeName,['admin.customers.create']) ? 'active_l':''); ?>">
                    <a class="nav-link" href="<?php echo e(route('admin.customers.create')); ?>"><img src="<?php echo e(asset('public/images/menu-icon/icon-2.png')); ?>"/><?php echo e(__('sidebar.create_customer')); ?></a>
                </li>
                <?php endif; ?>

               <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('customer-read')): ?>
                <li class="nav-item <?php echo e(in_array($routeName,['admin.customers.index','admin.customers.edit']) ? 'active_l':''); ?>">
                    <a class="nav-link" href="<?php echo e(route('admin.customers.index')); ?>"><img src="<?php echo e(asset('public/images/menu-icon/icon-10.png')); ?>"/><?php echo e(__('sidebar.all_customer')); ?></a>
                </li>
                <?php endif; ?>
            </ul>

            <ul class="all-acc">
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['consignment-create','consignment-read'])): ?>
                <h4><?php echo e(__('sidebar.consignment')); ?></h4>
                <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('consignment-create')): ?>
                <li class="nav-item <?php echo e(in_array($routeName,['admin.consignments.create']) ? 'active_l':''); ?>">
                    <a class="nav-link" href="<?php echo e(route('admin.consignments.create')); ?>"><img src="<?php echo e(asset('public/images/menu-icon/icon-2.png')); ?>"/><?php echo e(__('sidebar.create_new_consignment')); ?></a>
                </li>
                <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('consignment-read')): ?>
                <li class="nav-item <?php echo e(in_array($routeName,['admin.consignments.index','admin.consignments.edit']) ? 'active_l':''); ?>">
                    <a class="nav-link" href="<?php echo e(route('admin.consignments.index')); ?>"><img src="<?php echo e(asset('public/images/menu-icon/icon-10.png')); ?>"/><?php echo e(__('sidebar.view_consignment_list')); ?></a>
                </li>
                <?php endif; ?>
            </ul>
            <ul class="all-acc">
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['role-create','role-read'])): ?>
                <h4><?php echo e(__('sidebar.access_role')); ?></h4>
                <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('role-create')): ?>
                <li class="nav-item <?php echo e(in_array($routeName,['admin.roles.create']) ? 'active_l':''); ?>">
                    <a class="nav-link" href="<?php echo e(route('admin.roles.create')); ?>"><img src="<?php echo e(asset('public/images/menu-icon/icon-2.png')); ?>"/><?php echo e(__('sidebar.create_access_role')); ?></a>
                </li>
                <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('role-read')): ?>
                <li class="nav-item <?php echo e(in_array($routeName,['admin.roles.index','admin.roles.edit']) ? 'active_l':''); ?>">
                    <a class="nav-link" href="<?php echo e(route('admin.roles.index')); ?>"><img src="<?php echo e(asset('public/images/menu-icon/icon-10.png')); ?>"/><?php echo e(__('sidebar.view_access_role')); ?></a>
                </li>
                <?php endif; ?>

            </ul>

            <ul class="all-acc">
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['staff-create','staff-read'])): ?>
                    <h4><?php echo e(__('sidebar.staff_account')); ?></h4>
                <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('staff-create')): ?>
                    <li class="nav-item <?php echo e(in_array($routeName,['admin.staffs.create']) ? 'active_l':''); ?>">
                        <a class="nav-link" href="<?php echo e(route('admin.staffs.create')); ?>"><img src="<?php echo e(asset('public/images/menu-icon/icon-2.png')); ?>"/><?php echo e(__('sidebar.create_staff_account')); ?></a>
                    </li>
                <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('staff-read')): ?>
                    <li class="nav-item <?php echo e(in_array($routeName,['admin.staffs.index','admin.staffs.edit']) ? 'active_l':''); ?>">
                        <a class="nav-link" href="<?php echo e(route('admin.staffs.index')); ?>"><img src="<?php echo e(asset('public/images/menu-icon/icon-10.png')); ?>"/> <?php echo e(__('sidebar.all_staff_account')); ?></a>
                    </li>
                <?php endif; ?>

            </ul>

            <ul class="all-acc">

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['worksmith-create','worksmith-read'])): ?>
                <h4>Worksmith</h4>
                <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('worksmith-create')): ?>
                <li class="nav-item <?php echo e(in_array($routeName,['admin.worksmiths.create']) ? 'active_l':''); ?>">
                    <a class="nav-link" href="<?php echo e(route('admin.worksmiths.create')); ?>"><img src="<?php echo e(asset('public/images/menu-icon/icon-2.png')); ?>"/><?php echo e(__('sidebar.create_worksmith')); ?></a>
                </li>
                <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('worksmith-read')): ?>
                <li class="nav-item <?php echo e(in_array($routeName,['admin.worksmiths.index','admin.worksmiths.edit']) ? 'active_l':''); ?>">
                    <a class="nav-link" href="<?php echo e(route('admin.worksmiths.index')); ?>"><img src="<?php echo e(asset('public/images/menu-icon/icon-10.png')); ?>"/><?php echo e(__('sidebar.all_worksmith')); ?></a>
                </li>
                <?php endif; ?>

            </ul>

            <ul class="all-acc">

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['setting-shopSetting','setting-priceSetting'])): ?>
                <h4>Settings</h4>
                <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('setting-shopSetting')): ?>

                <li class="nav-item <?php echo e(in_array($routeName,['admin.settings.shopSettings']) ? 'active_l':''); ?>">
                    <a class="nav-link" href="<?php echo e(route('admin.settings.shopSettings')); ?>"><img src="<?php echo e(asset('public/images/menu-icon/icon-2.png')); ?>"/>Shop Settings</a>
                </li>
                <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('setting-priceSetting')): ?>
                <li class="nav-item <?php echo e(in_array($routeName,['admin.settings.priceSettings',]) ? 'active_l':''); ?>">
                    <a class="nav-link" href="<?php echo e(route('admin.settings.priceSettings')); ?>"><img src="<?php echo e(asset('public/images/menu-icon/icon-10.png')); ?>"/>Price Settings</a>
                </li>
                <?php endif; ?>

            </ul>

        </ul>
    </div>

</div>

<script type="text/javascript">
    $(document).ready(function(){
        $(".side-dropdown span").click(function(){

        var arrowText = $(this).children().attr('data-text');

        $(this).siblings("ul").slideToggle();
        if(arrowText == '+'){
            $(this).children().attr('src',"<?php echo e(asset('public/img/arrow_down.png')); ?>");
            $(this).children().attr('data-text','-');
        }else{
            $(this).children().attr('src',"<?php echo e(asset('public/img/right_arrow.png')); ?>");
            $(this).children().attr('data-text','+');
        }
    });
    });
</script>

<?php /**PATH /home/sancysup/public_html/sancy_erp/resources/views/admin/elements/layouts/sidebar.blade.php ENDPATH**/ ?>