<?php
use App\Models\Invoice;
?>


<?php $__env->startSection('title',"Invoice"); ?>
<?php $__env->startSection('header', "Invoice"); ?>

<?php $__env->startSection('content'); ?>


    <div class="card mb-4">
        <div class="card-header">
            <h4 class="mb-0">All Invoice</h4>
            <p>This section displays all invoice.</p>
        </div>
        <div class="card-body">
            <?php $placeholder = "Search Invoice Number, Phone Number..."; ?>

            <?php echo $__env->make('admin.elements.search.common', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="earring-table table-responsive">
                <table class="table stock-detail">
                    <thead>
                    <tr>
                        <th><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('reference_date', __('content.date')));?></th>
                        <th><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('id', __('content.invoice_id')));?></th>
                        <th><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('total', __('content.amount')));?></th>
                        <th><?php echo e(__('content.paid_amount')); ?></th>
                        <th><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('invoice.customer_name', __('content.customer')));?></th>
                        <th><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('invoice.customer_phone', __('content.phone_number')));?></th>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['invoice-refund','invoice-print','invoice-sendEmailPDF'])): ?>    
                          <th><?php echo e(__('content.action')); ?></th>
                        <?php endif; ?>
                    </tr>
                    </thead>
                    <tbody>
                    <?php if(!empty($records) && $records->count()): ?>
                        <?php $slNo = $records->firstItem() ?>
                        <?php $__currentLoopData = $records; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $record): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e(isset($record->reference_date) ? date('d/m/Y', strtotime($record->reference_date)) : '-'); ?></td>
                                <td><?php echo e($record->invoice_no ?? '-'); ?></td>
                                <td><?php echo e(isset($record->total) ? '$'.$record->total : '-'); ?></td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <span id="paid_amount-<?php echo e($record->id); ?>">$<?php echo e((($record->is_refund == Invoice::ONE)  && ($record->balance == Invoice::ZERO)) ? $record->balance :  ($record->paid_amount ?? 0)); ?></span>

                                        <?php if($record->due > 0): ?>
                                        <a  href="javascript:void(0);" id="invoicePaidAmount-<?php echo e($record->id); ?>" class="return_edit" data-record_id="<?php echo e($record->id); ?>"> 
                                            <img class="return_first" src="<?php echo e(asset('public/img/icon-edit.png')); ?>">
                                        </a> <!-- data-bs-toggle="modal" data-bs-target="#Layway_popup" -->
                                        <?php endif; ?>
                                    </div>
                                </td>
                                <td class="text-nowrap">
                                    <?php echo e(isset($record->customer_name) ? ucwords($record->customer_name) : (isset($record->customer_id) ? ucwords($record->customer->fullname) : '-')); ?>

                                </td>
                                <td class="text-nowrap"><?php echo e($record->phone_with_code ?? '-'); ?></td>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['invoice-refund','invoice-print','invoice-sendEmailPDF'])): ?>
                                <td>
                                    <div class="dropdown">
                                        <button class="btn btn-secondary down" type="button" id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false">
                                            Action
                                        </button>
                                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                                           
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('invoice-refund')): ?>
                                                <?php if($record->balance > 0): ?>
                                                    <li><a class="dropdown-item" href="<?php echo e(route('admin.invoices.refund', $record->id)); ?>"><img src="<?php echo e(asset('public/img/vector.png')); ?>">Refund</a></li>
                                                <?php endif; ?>
                                            <?php endif; ?>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('invoice-print')): ?>
                                                <li><a class="dropdown-item" href="<?php echo e(route('admin.invoices.printInvoice', $record->id)); ?>"><img src="<?php echo e(asset('public/img/print.png')); ?>">Print Invoice</a></li> <!-- btnprn -->
                                            <?php endif; ?>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('invoice-sendEmailPDF')): ?>
                                                <li><a class="dropdown-item sendEmailPDF" href="javascript:void(0); " id="sendEmailPDF-<?php echo e($record->id); ?>" data-record_id="<?php echo e($record->id); ?>" data-for="invoices"><img src="<?php echo e(asset('public/img/envelope.png')); ?>">Send email</a></li>
                                            <?php endif; ?>

                                        </ul>
                                    </div>
                                </td>
                                <?php endif; ?>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <tr>
                            <td class="text-center" colspan="7">No Record Found!</td>
                        </tr>
                    <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <?php echo $__env->make('admin.elements.pagination.common', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>

    <?php echo $__env->make('admin.elements.scripts.pdf_email_js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('admin.invoices.layway_popup', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/sancysup/public_html/sancy_erp/resources/views/admin/invoices/index.blade.php ENDPATH**/ ?>