<?php

use Illuminate\Support\Facades\Route;

//use App\Http\Controllers\HomeController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
// use Route as RequestRoute;
Route::get('/clear-cache', function() {
    Artisan::call('config:clear');
    Artisan::call('cache:clear');
    Artisan::call('route:clear');
    Artisan::call('view:clear');
    return view('clear_cache');
});


Route::prefix('admin')->namespace("\App\Http\Controllers\Admin")->name('admin.')->group(function (){

    // Login
    Auth::routes(['register' => false]);
    Route::get('/', [App\Http\Controllers\Admin\Auth\LoginController::class, 'showLoginForm'])->name('showLoginForm');

    Route::middleware(['auth:admin'])->group(function () {
        //Dashboard Route
        Route::get('/dashboard', [App\Http\Controllers\Admin\DashboardController::class, 'index'])->name('dashboard.index');
        Route::get('/invoice-render', [App\Http\Controllers\Admin\DashboardController::class, 'invoiceRender'])->name('dashboard.invoiceRender');
        Route::post('/dashboard/export-total-jobs', [App\Http\Controllers\Admin\DashboardController::class, 'exportTotalJobs'])->name('dashboard.exportTotalJobs');
        Route::post('/dashboard/export-completed-jobs', [App\Http\Controllers\Admin\DashboardController::class, 'exportCompletedJobs'])->name('dashboard.exportCompletedJobs');
        Route::post('/dashboard/export-total-quotations', [App\Http\Controllers\Admin\DashboardController::class, 'exportTotalQuotations'])->name('dashboard.exportTotalQuotations');
        Route::post('/dashboard/export-total-invoices', [App\Http\Controllers\Admin\DashboardController::class, 'exportTotalInvoices'])->name('dashboard.exportTotalInvoices');

        // Route::get('/notifications', [App\Http\Controllers\Admin\NotificationsController::class, 'index'])->name('notifications.index');

        // Route::get('/notifications/markAsRead/{user_id}/{notification_id}', [App\Http\Controllers\Admin\NotificationsController::class, 'markAsRead'])->name('notifications.markAsRead');

        Route::post('/notifications/mark-as-read/', [App\Http\Controllers\Admin\NotificationsController::class, 'markNotificationAsRead'])->name('markNotificationAsRead');

        //update Profile Routes
        Route::get('/editProfile', [App\Http\Controllers\Admin\AdminController::class, 'showProfileForm'])->name('showProfileForm');
        Route::put('/updateProfile', [App\Http\Controllers\Admin\AdminController::class, 'updateProfile'])->name('updateProfile');
        Route::post('/updateProfilePic', [App\Http\Controllers\Admin\AdminController::class, 'updateProfilePic'])->name('updateProfilePic');

        //Change Password Routes
        Route::get('/changePassword', [App\Http\Controllers\Admin\AdminController::class, 'showPasswordForm'])->name('showPasswordForm');
        Route::post('/changePassword', [App\Http\Controllers\Admin\AdminController::class, 'updatePassword'])->name('updatePassword');

        //Materials Routes
        Route::get('/materials', [\App\Http\Controllers\Admin\MaterialsController::class, 'index'])->name('materials.index');
        Route::get('/materials/create', [App\Http\Controllers\Admin\MaterialsController::class, 'create'])->name('materials.create');
        Route::post('/materials/store', [App\Http\Controllers\Admin\MaterialsController::class, 'store'])->name('materials.store');
        Route::get('/materials/edit/{material_id}', [App\Http\Controllers\Admin\MaterialsController::class, 'edit'])->name('materials.edit');
        Route::put('/materials/update/{material_id}', [App\Http\Controllers\Admin\MaterialsController::class, 'update'])->name('materials.update');
        Route::get('/materials/destroy/{material_id}', [App\Http\Controllers\Admin\MaterialsController::class, 'destroy'])->name('materials.destroy');
        Route::get('/materials/changeStatus', [App\Http\Controllers\Admin\MaterialsController::class, 'changeStatus'])->name('materials.changeStatus');

        //categories Routes
        Route::get('/categories', [\App\Http\Controllers\Admin\CategoriesController::class, 'index'])->name('categories.index');
        Route::get('/categories/create', [App\Http\Controllers\Admin\CategoriesController::class, 'create'])->name('categories.create');
        Route::post('/categories/store', [App\Http\Controllers\Admin\CategoriesController::class, 'store'])->name('categories.store');
        Route::get('/categories/edit/{id}', [App\Http\Controllers\Admin\CategoriesController::class, 'edit'])->name('categories.edit');
        Route::put('/categories/update/{id}', [App\Http\Controllers\Admin\CategoriesController::class, 'update'])->name('categories.update');
        Route::get('/categories/destroy/{id}', [App\Http\Controllers\Admin\CategoriesController::class, 'destroy'])->name('categories.destroy');
        Route::get('/categories/changeStatus', [App\Http\Controllers\Admin\CategoriesController::class, 'changeStatus'])->name('categories.changeStatus');

        // Sizes Routes
        Route::get('/sizes', [\App\Http\Controllers\Admin\SizesController::class, 'index'])->name('sizes.index');
        Route::get('/sizes/create', [App\Http\Controllers\Admin\SizesController::class, 'create'])->name('sizes.create');
        Route::post('/sizes/store', [App\Http\Controllers\Admin\SizesController::class, 'store'])->name('sizes.store');
        Route::get('/sizes/edit/{size_id}', [App\Http\Controllers\Admin\SizesController::class, 'edit'])->name('sizes.edit');
        Route::put('/sizes/update/{size_id}', [App\Http\Controllers\Admin\SizesController::class, 'update'])->name('sizes.update');
        Route::get('/sizes/destroy/{size_id}', [App\Http\Controllers\Admin\SizesController::class, 'destroy'])->name('sizes.destroy');
        Route::get('/sizes/changeStatus', [App\Http\Controllers\Admin\SizesController::class, 'changeStatus'])->name('sizes.changeStatus');

        // Types Route
        Route::get('/types', [\App\Http\Controllers\Admin\TypesController::class, 'index'])->name('types.index');
        Route::get('/types/create', [App\Http\Controllers\Admin\TypesController::class, 'create'])->name('types.create');
        Route::post('/types/store', [App\Http\Controllers\Admin\TypesController::class, 'store'])->name('types.store');
        Route::get('/types/edit/{type_id}', [App\Http\Controllers\Admin\TypesController::class, 'edit'])->name('types.edit');
        Route::put('/types/update/{type_id}', [App\Http\Controllers\Admin\TypesController::class, 'update'])->name('types.update');
        Route::get('/types/destroy/{type_id}', [App\Http\Controllers\Admin\TypesController::class, 'destroy'])->name('types.destroy');
        Route::get('/types/changeStatus', [App\Http\Controllers\Admin\TypesController::class, 'changeStatus'])->name('types.changeStatus');

        //Jewellery
        Route::group(['middleware' => ['permissions:jewelleries']], function () {
            //Route::get('/jewelleries/index', [App\Http\Controllers\Admin\JewelleriesController::class, 'index'])->name('jewelleries.index');
            Route::get('/jewelleries/index/{category_id}/{tab?}', [App\Http\Controllers\Admin\JewelleriesController::class, 'indexByCategory'])->name('jewelleries.indexByCategory');
            Route::get('/jewelleries/create', [App\Http\Controllers\Admin\JewelleriesController::class, 'create'])->name('jewelleries.create');
            Route::post('/jewelleries/store', [App\Http\Controllers\Admin\JewelleriesController::class, 'store'])->name('jewelleries.store');
            Route::get('/jewelleries/destroy/{id}', [App\Http\Controllers\Admin\JewelleriesController::class, 'destroy'])->name('jewelleries.destroy');
            Route::post('/jewelleries/dropzoneStore', [App\Http\Controllers\Admin\JewelleriesController::class, 'dropzoneStore'])->name('jewelleries.dropzoneStore');
            Route::get('/jewelleries/duplicate/{category_id}/{id}', [App\Http\Controllers\Admin\JewelleriesController::class, 'duplicateContent'])->name('jewelleries.duplicate');
            Route::post('/jewelleries/duplicate/add', [App\Http\Controllers\Admin\JewelleriesController::class, 'addDuplicateJewellery'])->name('jewelleries.addDuplicate');
            Route::get('/jewelleries/edit/{category_id}/{id}', [App\Http\Controllers\Admin\JewelleriesController::class, 'edit'])->name('jewelleries.edit');
            Route::put('/jewelleries/update/{id}', [App\Http\Controllers\Admin\JewelleriesController::class, 'update'])->name('jewelleries.update');
            Route::get('/jewelleries/purchaged-cost-summery/{category_id}/{id}', [App\Http\Controllers\Admin\JewelleriesController::class, 'purchagedCostSummery'])->name('jewelleries.purchagedCostSummery');
            Route::get('/jewelleries/bespoke-cost-summery/{id}', [App\Http\Controllers\Admin\JewelleriesController::class, 'bespokeCostSummery'])->name('jewelleries.bespokeCostSummery');
            Route::put('/jewelleries/update-cost', [App\Http\Controllers\Admin\JewelleriesController::class, 'updateCost'])->name('jewelleries.updateCost');
            Route::put('/jewelleries/job-update-cost', [App\Http\Controllers\Admin\JewelleriesController::class, 'jobUpdateCost'])->name('jewelleries.jobUpdateCost');
            Route::get('/jewelleries/print/{category_id}/{id}', [App\Http\Controllers\Admin\JewelleriesController::class, 'printJewellery'])->name('jewelleries.print');
            Route::get('/jewelleries/print/tag/{category_id}/{id}', [App\Http\Controllers\Admin\JewelleriesController::class, 'printJewelleryTag'])->name('jewelleries.print.tag');
        });


        //jobs
        Route::group(['middleware' => ['permissions:jobs']], function () {
            Route::get('/jobs-list/{tab?}/{job_status?}/{year?}/{month?}', [App\Http\Controllers\Admin\JobsController::class, 'index'])->name('jobs.index')->where('tab', '[a-z]+');
            Route::get('/jobs/dashboard/{year?}/{month?}', [App\Http\Controllers\Admin\JobsController::class, 'dashboard'])->name('jobs.dashboard');
            Route::get('/jobs/create', [App\Http\Controllers\Admin\JobsController::class, 'create'])->name('jobs.create');
            Route::post('/jobs/store', [App\Http\Controllers\Admin\JobsController::class, 'store'])->name('jobs.store');
            Route::get('/jobs/changeStatus', [App\Http\Controllers\Admin\JobsController::class, 'changeStatus'])->name('jobs.changeStatus');
            Route::get('/jobs/edit/{id}', [App\Http\Controllers\Admin\JobsController::class, 'edit'])->name('jobs.edit');
            Route::put('/jobs/update/{id}', [App\Http\Controllers\Admin\JobsController::class, 'update'])->name('jobs.update');
            Route::get('/jobs/destroy/{id}', [App\Http\Controllers\Admin\JobsController::class, 'destroy'])->name('jobs.destroy');
            Route::get('/jobs/restore/{id}', [App\Http\Controllers\Admin\JobsController::class, 'restore'])->name('jobs.restore');
            Route::get('/jobs/duplicate/{id}', [App\Http\Controllers\Admin\JobsController::class, 'duplicateContent'])->name('jobs.duplicate');
            Route::post('/jobs/duplicate/add', [App\Http\Controllers\Admin\JobsController::class, 'addDuplicateJob'])->name('jobs.addDuplicate');
            Route::get('/jobs/bespoke-cost-summery/{id}', [App\Http\Controllers\Admin\JobsController::class, 'bespokeCostSummery'])->name('jobs.bespokeCostSummery');
            Route::get('/jobs/repair-cost-summery/{id}', [App\Http\Controllers\Admin\JobsController::class, 'repairCostSummery'])->name('jobs.repairCostSummery');
            Route::put('/jobs/update-cost', [App\Http\Controllers\Admin\JobsController::class, 'updateCost'])->name('jobs.updateCost');
            Route::get('/jobs/print/{id}', [App\Http\Controllers\Admin\JobsController::class, 'printJob'])->name('jobs.print');
            Route::get('/jobs/assignWorksmith', [App\Http\Controllers\Admin\JobsController::class, 'assignWorksmith'])->name('jobs.assignWorksmith');

            Route::post('/jobs/export-total', [App\Http\Controllers\Admin\JobsController::class, 'exportTotal'])->name('jobs.exportTotal');
            Route::post('/jobs/export-bespoke', [App\Http\Controllers\Admin\JobsController::class, 'exportBespoke'])->name('jobs.exportBespoke');
            Route::post('/jobs/export-repair', [App\Http\Controllers\Admin\JobsController::class, 'exportRepair'])->name('jobs.exportRepair');
            Route::post('/jobs/export-delayed', [App\Http\Controllers\Admin\JobsController::class, 'exportDelayed'])->name('jobs.exportDelayed');
        });

        //Roles Routes
        Route::group(['middleware' => ['permissions:roles']], function () {
            Route::get('/roles', [\App\Http\Controllers\Admin\RolesController::class, 'index'])->name('roles.index');
            Route::get('/roles/create', [App\Http\Controllers\Admin\RolesController::class, 'create'])->name('roles.create');
            Route::post('/roles/store', [App\Http\Controllers\Admin\RolesController::class, 'store'])->name('roles.store');
            Route::get('/roles/edit/{id}', [App\Http\Controllers\Admin\RolesController::class, 'edit'])->name('roles.edit');
            Route::put('/roles/update/{id}', [App\Http\Controllers\Admin\RolesController::class, 'update'])->name('roles.update');
            Route::get('/roles/destroy/{id}', [App\Http\Controllers\Admin\RolesController::class, 'destroy'])->name('roles.destroy');
        });

        //Staffs Routes
        Route::group(['middleware' => ['permissions:staffs']], function () {
            Route::get('/staffs/index/{tab?}', [\App\Http\Controllers\Admin\StaffsController::class, 'index'])->name('staffs.index');
            Route::get('/staffs/create', [App\Http\Controllers\Admin\StaffsController::class, 'create'])->name('staffs.create');
            Route::post('/staffs/store', [App\Http\Controllers\Admin\StaffsController::class, 'store'])->name('staffs.store');
            Route::get('/staffs/edit/{id}', [App\Http\Controllers\Admin\StaffsController::class, 'edit'])->name('staffs.edit');
            Route::put('/staffs/update/{id}', [App\Http\Controllers\Admin\StaffsController::class, 'update'])->name('staffs.update');
            Route::get('/staffs/destroy/{id}', [App\Http\Controllers\Admin\StaffsController::class, 'destroy'])->name('staffs.destroy');
        });

        //Customers Routes
        Route::group(['middleware' => ['permissions:customers']], function () {
            Route::get('/customers-list/{tab?}', [\App\Http\Controllers\Admin\CustomersController::class, 'index'])->name('customers.index');
            Route::get('/customers/create', [App\Http\Controllers\Admin\CustomersController::class, 'create'])->name('customers.create');
            Route::post('/customers/store', [App\Http\Controllers\Admin\CustomersController::class, 'store'])->name('customers.store');
            Route::get('/customers/edit/{id}', [App\Http\Controllers\Admin\CustomersController::class, 'edit'])->name('customers.edit');
            Route::put('/customers/update/{id}', [App\Http\Controllers\Admin\CustomersController::class, 'update'])->name('customers.update');
            Route::get('/customers/destroy/{id}', [App\Http\Controllers\Admin\CustomersController::class, 'destroy'])->name('customers.destroy');
            // Route::get('/customers/changeStatus', [App\Http\Controllers\Admin\CustomersController::class, 'changeStatus'])->name('customers.changeStatus');
            Route::post('/customers/makeVIP', [App\Http\Controllers\Admin\CustomersController::class, 'makeVIP'])->name('customers.makeVIP');
            Route::get('/customers/transactions-list/{customer_id}', [App\Http\Controllers\Admin\CustomersController::class, 'transactionsList'])->name('customers.transactionsList');
            Route::get('/customers/invoice-items-list/{customer_id}/{invoice_id}', [App\Http\Controllers\Admin\CustomersController::class, 'invoiceItemsList'])->name('customers.invoiceItemsList');
        });

        //Worksmith Routes
        Route::group(['middleware' => ['permissions:worksmiths']], function () {
            Route::get('/worksmiths', [\App\Http\Controllers\Admin\WorksmithsController::class, 'index'])->name('worksmiths.index');
            Route::get('/worksmiths/create', [App\Http\Controllers\Admin\WorksmithsController::class, 'create'])->name('worksmiths.create');
            Route::post('/worksmiths/store', [App\Http\Controllers\Admin\WorksmithsController::class, 'store'])->name('worksmiths.store');
            Route::get('/worksmiths/edit/{id}', [App\Http\Controllers\Admin\WorksmithsController::class, 'edit'])->name('worksmiths.edit');
            Route::put('/worksmiths/update/{id}', [App\Http\Controllers\Admin\WorksmithsController::class, 'update'])->name('worksmiths.update');
            Route::get('/worksmiths/destroy/{id}', [App\Http\Controllers\Admin\WorksmithsController::class, 'destroy'])->name('worksmiths.destroy');
        });

        //Quotations Routes
        Route::group(['middleware' => ['permissions:quotations']], function () {
            Route::get('/quotations', [App\Http\Controllers\Admin\QuotationsController::class, 'index'])->name('quotations.index');
            Route::get('/quotations/create', [App\Http\Controllers\Admin\QuotationsController::class, 'create'])->name('quotations.create');
            Route::post('/quotations/store',[App\Http\Controllers\Admin\QuotationsController::class, 'store'])->name('quotations.store');
            Route::get('/quotations/edit/{id}', [App\Http\Controllers\Admin\QuotationsController::class, 'edit'])->name('quotations.edit');
            Route::put('/quotations/update', [App\Http\Controllers\Admin\QuotationsController::class, 'update'])->name('quotations.update');
            Route::get('/quotations/destroy/{id}', [App\Http\Controllers\Admin\QuotationsController::class, 'destroy'])->name('quotations.destroy');
            Route::get('/quotations/print-quotation/{quotation_id}',[App\Http\Controllers\Admin\QuotationsController::class, 'printQuotation'])->name('quotations.printQuotation');
            Route::get('quotations/send-email-pdf/{quotation_id?}', [App\Http\Controllers\Admin\QuotationsController::class, 'sendEmailPDF'])->name('quotations.sendEmailPDF');
            Route::get('/quotations/print_order-voucher/{quotation_id}',[App\Http\Controllers\Admin\QuotationsController::class, 'printOrderVoucher'])->name('quotations.printOrderVoucher');
            // Route::get('/quotations/convert-to-invoice/{quotation_item_id}',[App\Http\Controllers\Admin\QuotationsController::class, 'convertToInvoice'])->name('quotations.convertToInvoice');
            Route::post('/quotations/convert-to-invoice',[App\Http\Controllers\Admin\QuotationsController::class, 'convertToInvoice'])->name('quotations.convertToInvoice');
        });

        //Invoice Routes
        Route::group(['middleware' => ['permissions:invoices']], function () {
            Route::get('/invoices', [App\Http\Controllers\Admin\InvoicesController::class, 'index'])->name('invoices.index');
            Route::get('/invoices/create', [App\Http\Controllers\Admin\InvoicesController::class, 'create'])->name('invoices.create');
            Route::post('/invoices/store',[App\Http\Controllers\Admin\InvoicesController::class, 'store'])->name('invoices.store');
            Route::get('/invoices/print-invoice/{invoice_id?}',[App\Http\Controllers\Admin\InvoicesController::class, 'printInvoice'])->name('invoices.printInvoice');
            Route::get('invoices/send-email-pdf/{invoice_id?}', [App\Http\Controllers\Admin\InvoicesController::class, 'sendEmailPDF'])->name('invoices.sendEmailPDF');

            Route::get('/invoices/details/{invoice_id}',[App\Http\Controllers\Admin\InvoicesController::class, 'invoiceDetails'])->name('invoices.details');
            Route::post('/invoices/update-paid-amount',[App\Http\Controllers\Admin\InvoicesController::class, 'updatePaidAmount'])->name('invoices.updatePaidAmount');
            Route::post('/invoices/update-payment',[App\Http\Controllers\Admin\InvoicesController::class, 'updatePayment'])->name('invoices.updatePayment');
            Route::get('/invoices/refund/{invoice_id}',[App\Http\Controllers\Admin\InvoicesController::class, 'invoiceRefund'])->name('invoices.refund');
            Route::get('/invoices/cost/{invoice_id}',[App\Http\Controllers\Admin\InvoicesController::class, 'cost'])->name('invoices.cost');
            Route::post('/invoices/updateCost/{invoice_id}',[App\Http\Controllers\Admin\InvoicesController::class, 'updateCost'])->name('invoices.updateCost');
        });

        //Consignment Routes
        Route::group(['middleware' => ['permissions:consignments']], function () {
            Route::get('/consignments', [\App\Http\Controllers\Admin\ConsignmentsController::class, 'index'])->name('consignments.index');
            Route::get('/consignments/create', [App\Http\Controllers\Admin\ConsignmentsController::class, 'create'])->name('consignments.create');
            Route::post('/consignments/store', [App\Http\Controllers\Admin\ConsignmentsController::class, 'store'])->name('consignments.store');
            Route::get('/consignments/edit/{id}', [App\Http\Controllers\Admin\ConsignmentsController::class, 'edit'])->name('consignments.edit');
            Route::put('/consignments/update/{id}', [App\Http\Controllers\Admin\ConsignmentsController::class, 'update'])->name('consignments.update');
            Route::get('/consignments/destroy/{id}', [App\Http\Controllers\Admin\ConsignmentsController::class, 'destroy'])->name('consignments.destroy');
            Route::get('/consignments/review-cost-summary/{id}', [App\Http\Controllers\Admin\ConsignmentsController::class, 'reviewCostSummary'])->name('consignments.reviewCostSummary');
            Route::post('/consignments/updateCost/', [App\Http\Controllers\Admin\ConsignmentsController::class, 'updateCost'])->name('consignments.updateCost');
            Route::get('/consignments/print-receipt/{consignment_id}',[App\Http\Controllers\Admin\ConsignmentsController::class, 'printReceipt'])->name('consignments.printReceipt');
            Route::post('/consignments/update-amount-used',[App\Http\Controllers\Admin\ConsignmentsController::class, 'updateAmountUsed'])->name('consignments.updateAmountUsed');
        });

        // Setting Routes
        Route::group(['middleware' => ['permissions:settings']], function () {
        Route::get('/settings/shop-settings', [App\Http\Controllers\Admin\SettingsController::class, 'shopSettings'])->name('settings.shopSettings');
        Route::put('/settings/shop-settings', [App\Http\Controllers\Admin\SettingsController::class, 'updateShopSettings'])->name('settings.updateShopSettings');
        Route::get('/settings/price-settings', [App\Http\Controllers\Admin\SettingsController::class, 'priceSettings'])->name('settings.priceSettings');
        Route::put('/settings/price-settings', [App\Http\Controllers\Admin\SettingsController::class, 'updatePriceSettings'])->name('settings.updatePriceSettings');
        });

        // Ajax
        Route::post('/get_sizes_by_category_id', [App\Http\Controllers\Admin\AjaxController::class, 'getSizesByCategoryId'])->name('get_sizes_by_category_id');
        Route::get('/phone-autocomplete-search', [App\Http\Controllers\Admin\AjaxController::class, 'phoneAutocompleteSearch'])->name('phoneAutocompleteSearch');
        Route::post('/get-user-by-phone', [App\Http\Controllers\Admin\AjaxController::class, 'getUserByPhone'])->name('getUserByPhone');
        Route::post('/admins/singleDropzoneStore', [App\Http\Controllers\Admin\AjaxController::class, 'singleDropzoneStore'])->name('admins.dropzoneStore');
        Route::post('/get-user-phone-list', [App\Http\Controllers\Admin\AjaxController::class, 'getUserPhoneList'])->name('getUserPhoneList');
        Route::Post('/getJewelleryByItemCode/{module}', [App\Http\Controllers\Admin\AjaxController::class, 'getJewelleryByItemCode'])->name('getJewelleryByItemCode');
        Route::Post('/bespokeRepairData', [App\Http\Controllers\Admin\AjaxController::class, 'bespokeReairData'])->name('bespokeReairData');
        Route::Post('/getJobByItemCode/{module}', [App\Http\Controllers\Admin\AjaxController::class, 'getJobByItemCode'])->name('getJobByItemCode');
        Route::post('/get-jewellery-itemcode-list', [App\Http\Controllers\Admin\AjaxController::class, 'getJewelleryItemCodeList'])->name('getJewelleryItemCodeList');
    });
});



// Front Routes
Auth::routes(['register' => false]);
Route::get('/', [App\Http\Controllers\HomeController::class, 'index'])->name('index');

Route::middleware(['auth:web'])->group(function () {
    // POS Home Route
    Route::get('/dashboard', [App\Http\Controllers\HomeController::class, 'dashboard'])->name('dashboard');

    // Qoutations Routes
    Route::group(['middleware' => ['permissions:quotations']], function () {
        // Route::get('/pos_home', [App\Http\Controllers\QuotationsController::class, 'quotationIndex'])->name('quotations.pos_home');
        Route::get('/quotations/create',[App\Http\Controllers\QuotationsController::class, 'create'])->name('quotations.create');
        Route::post('/quotations/store',[App\Http\Controllers\QuotationsController::class, 'quotationsStore'])->name('quotations.quotationsStore');
        Route::get('/quotations/todays-orders/{tab?}', [App\Http\Controllers\QuotationsController::class, 'todaysOrders'])->name('quotations.todaysOrders');
        Route::get('/quotations/items-list/{quotation_id}/{type}', [App\Http\Controllers\QuotationsController::class, 'showItemsList'])->name('quotations.showItemsList');
        Route::get('/quotations/print-quotation/{quotation_id}',[App\Http\Controllers\QuotationsController::class, 'printQuotation'])->name('quotations.printQuotation');
        Route::get('/quotations/print_order-voucher/{quotation_id}',[App\Http\Controllers\QuotationsController::class, 'printOrderVoucher'])->name('quotations.printOrderVoucher');
        Route::get('/quotations/print-both/{quotation_id}',[App\Http\Controllers\QuotationsController::class, 'printBoth'])->name('quotations.printBoth');

        Route::get('quotations/send-email-pdf/{quotation_id?}', [App\Http\Controllers\QuotationsController::class, 'sendEmailPDF'])->name('quotations.sendEmailPDF');
        Route::post('/quotations/convert-to-invoice',[App\Http\Controllers\QuotationsController::class, 'convertToInvoice'])->name('quotations.convertToInvoice');
        Route::get('/quotation-items/detail/{quotation_item_id}',[App\Http\Controllers\QuotationsController::class, 'quotationItemDetail'])->name('quotation_items.detail');

        /////new route by shiwa make prermission
        Route::post('/quotations/create-invoice',[App\Http\Controllers\QuotationsController::class, 'createInvoice'])->name('quotations.createInvoice');
        Route::post('/quotations/send-to-job-order',[App\Http\Controllers\QuotationsController::class, 'sendToJobOrder'])->name('quotations.sendToJobOrder');

    });

    // Invoices Routes
    Route::group(['middleware' => ['permissions:invoices']], function () {
        Route::get('/invoices/create', [App\Http\Controllers\InvoicesController::class, 'create'])->name('invoices.create');
        Route::post('/invoices/store',[App\Http\Controllers\InvoicesController::class, 'store'])->name('invoices.store');
        Route::get('/invoices/todays-sales', [App\Http\Controllers\InvoicesController::class, 'todaysSales'])->name('invoices.todaysSales');
        Route::get('/invoices/print-invoice/{invoice_id?}',[App\Http\Controllers\InvoicesController::class, 'printInvoice'])->name('invoices.printInvoice');
        Route::get('invoices/send-email-pdf/{invoice_id?}', [App\Http\Controllers\InvoicesController::class, 'sendEmailPDF'])->name('invoices.sendEmailPDF');
        Route::get('/invoices/details/{invoice_id}',[App\Http\Controllers\InvoicesController::class, 'invoiceDetails'])->name('invoices.details');
        Route::post('/invoices/update-paid-amount',[App\Http\Controllers\InvoicesController::class, 'updatePaidAmount'])->name('invoices.updatePaidAmount');
        Route::get('/invoices/refund/{invoice_id}',[App\Http\Controllers\Admin\InvoicesController::class, 'invoiceRefund'])->name('invoices.refund');
        Route::post('/invoices/update-payment',[App\Http\Controllers\InvoicesController::class, 'updatePayment'])->name('invoices.updatePayment');
    });

    // Jobs Routes
    Route::group(['middleware' => ['permissions:jobs']], function () {
        Route::get('/jobs/repair-create/{job_type}',[App\Http\Controllers\JobsController::class, 'repairCreate'])->name('jobs.repairCreate');
        Route::get('/jobs/bespoke-create/{job_type}',[App\Http\Controllers\JobsController::class, 'bespokeCreate'])->name('jobs.bespokeCreate');
        Route::Post('jobs/bespokeReairData', [App\Http\Controllers\JobsController::class, 'bespokeReairData'])->name('jobs.bespokeReairData');
        Route::Post('jobs/store', [App\Http\Controllers\JobsController::class, 'store'])->name('jobs.store');
        Route::get('/jobs/print-job/{job_id?}',[App\Http\Controllers\JobsController::class, 'printJob'])->name('jobs.printJob');
    });

    // Ajax Routes
    Route::Post('getJewelleryByItemCode/{module}', [App\Http\Controllers\AjaxController::class, 'getJewelleryByItemCode'])->name('getJewelleryByItemCode');
    Route::Post('getJobByItemCode/{module}', [App\Http\Controllers\AjaxController::class, 'getJobByItemCode'])->name('getJobByItemCode');
    Route::Post('bespokeReairData/{module}', [App\Http\Controllers\AjaxController::class, 'bespokeReairData'])->name('bespokeReairData');
    Route::post('/get-user-phone-list', [App\Http\Controllers\AjaxController::class, 'getUserPhoneList'])->name('getUserPhoneList');
    Route::post('/get-jewellery-itemcode-list', [App\Http\Controllers\AjaxController::class, 'getJewelleryItemCodeList'])->name('getJewelleryItemCodeList');

    //Global Search On Front Dashboard
    Route::post('/get-item-global-search', [App\Http\Controllers\AjaxController::class, 'getItemGlobalSearch'])->name('getItemGlobalSearch');

});

// For Admin & Front both
Route::get('switchDashboard/{requestFor}', [App\Http\Controllers\SwitchDashboardsController::class, 'switchDashboard'])->name('switchDashboard');
Route::post('ajaxDropzoneStore', [App\Http\Controllers\AjaxController::class, 'ajaxDropzoneStoreTmpImage'])->name('ajaxDropzoneStore');


