<!doctype html>
<html lang="en">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>@yield('title','Sancy')</title>
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">

    <script src="{{ asset('public/js/admin/jquery-3.3.1.min.js') }}"></script>


</head>

<body style="background: #fff;font-family: 'Poppins', sans-serif;" > 

@php $priceSettings = \App\Models\Setting::price_settings(); @endphp

@yield('content')

<script>
$(document).ready(function() {
    let isJsApplicable = "{{ in_array(Route::currentRouteName(), [ 'admin.quotations.printOrderVoucher', 'admin.quotations.printQuotation', 'admin.invoices.printInvoice', 'quotations.printOrderVoucher',  'quotations.printQuotation', 'invoices.printInvoice']) }}";

    if(isJsApplicable){
	    let subTotal = calculateSubTotal();
	    $('#subtotal').html(subTotal);

	    let gst = calculateGST();
	    $('#gst').html(gst);

	    let total = calculateTotal();
	    $('#total').html(total);


	    function calculateSubTotal(){
	        let counter = "{{ $counter }}";
	        let sub_total = 0;
	        for (let i = 1; i < counter; i++) {
	            sub_total = sub_total + parseFloat($('#price-'+i).html());
	        }
	        sub_total = parseFloat(sub_total).toFixed(2);
	        return sub_total;
	    }

	    function calculateGST(){
	    	let gstPercent = "{{ $priceSettings['gst_percent'] }}";
	        let gst_amount = (parseFloat(subTotal) * parseFloat(gstPercent)) / 100;
	        gst_amount =  parseFloat(gst_amount).toFixed(2);
	        return gst_amount;
	    }

	    function calculateTotal(){
	        let total_amount = parseFloat(subTotal) + parseFloat(gst);
	        total_amount = parseFloat(total_amount).toFixed(2);
	        return total_amount;
	    }
	}
});


</script>

</body>

</html>