@extends('layouts.master')

@section('title',"Dashboard")

@section('header', "Dashboard")


@section('content')
    <div class="dashboard-main POS_main POS_main_color">

        <div class="dasboard-menu-item ps-0">
            <div class="container-fluid">
                @include('frontend.elements.layouts.time_date_user_details')
            </div>

            <div class="container POS_home_container">
                <div class="create_tab_with_search">
                    <form name="autocomplete_item_form" id="autocompleteItemForm" method="post" action="#">
                    @csrf
                        <div class="form-group ui-widget">
                            <input type="text" class="form-control" id="autocompleteCode" placeholder="Start entering item code or scanning to search for products...">
                        </div>
                    </form>
                </div>
                <div class="created_link click_full">
                    <div class="row">
                        @can('frontQuotation-create')
                        <div class="col-lg-4">
                            <div class="text-center create c_quotation">
                                <a href="{{ route('quotations.create') }}" class="text-center">{!! __('content.create_quotation_with_br') !!}</a>
                            </div>
                        </div>
                        @endcan

                        @can('frontRepairJob-create')
                        <div class="col-lg-4">
                            @php  $repair = strtoLower(App\Models\Job::REPAIR);  @endphp
                            <div class="text-center create repair_job">
                                <a href="{{ route('jobs.repairCreate',$repair) }}" class="text-center"> {!! __('content.create_order_voucher_with_br') !!}</a>
                            </div>
                        </div>
                        @endcan

                        @can('frontQuotation-read')
                        <div class="col-lg-4">
                            <div class="text-center create sales">
                                <a href="{{ route('quotations.todaysOrders') }}" class="text-center">{!! __('content.today_sales_with_br') !!}</a>
                            </div>
                        </div>
                        @endcan

                        @can('frontInvoice-create')
                            <div class="col-lg-4">
                                <div class="text-center create invoice">
                                    <a href="{{ route('invoices.create') }}" class="text-center">{!! __('content.create_invoice_with_br') !!}</a>
                                </div>
                            </div>
                        @endcan

                        @can('frontBespokeJob-create')
                        <div class="col-lg-4">
                            @php  $bespoke = strtoLower(App\Models\Job::BESPOKE);  @endphp
                            <div class="text-center create bespoke_job">
                                <a href="{{ route('jobs.bespokeCreate',$bespoke) }}" class="text-center">{!! __('content.create_worksmith_job_with_br') !!}</a>
                            </div>
                        </div>
                        @endcan

                        @can('frontInvoice-read')
                            <div class="col-lg-4">
                                <div class="text-center create order">
                                    <a href="{{ route('invoices.todaysSales') }}" class="text-center">{!! __('content.today_order_with_br') !!}</a>
                                </div>
                            </div>
                        @endcan

                    </div>
                </div>
            </div>
        </div>

    </div>

<script>
    $('#autocompleteItemForm').on('keydown', function(e) {
        var keyCode = e.keyCode || e.which;
        // var tag = e.target.tagName
        // if (keyCode === 13 && tag !=="TEXTAREA") {
        if (keyCode === 13) {
            // console.log("Enter prevented")
            e.preventDefault();
            return false;
        }
        // else{
        //     console.log("Enter is ok...")
        // }
    });

    var searchRequest = null;
    $("#autocompleteCode").autocomplete({
        minLength: 2,
        source: function (request, response) {
            searchRequest = $.ajax({
                type: "POST",
                url: "{{ route('getItemGlobalSearch') }}",
                data: {'q': request.term},
                beforeSend: function () {
                    if (searchRequest != null) {
                        searchRequest.abort();
                    }
                },
                success: response,
                dataType: 'json',
                error: function (xhr) {
                    if (xhr.status == 403) {
                        window.location.reload();
                    }
                }
            });
        },
        select: function (event, ui) {
            if(ui.item.table_prefix=='I'){
                alert(ui.item.value+'='+ui.item.table_prefix);
            }else if(ui.item.table_prefix=='Q'){
                window.location.href="{{ route('quotations.todaysOrders') }}?search="+ui.item.value
            }else if(ui.item.table_prefix=='IN'){
                window.location.href="{{ route('invoices.todaysSales') }}?search="+ui.item.value
            }else if(ui.item.table_prefix=='J'){
                alert(ui.item.value+'='+ui.item.table_prefix);
            }
            event.preventDefault();
        },
        focus: function (event, ui) {
            var key_code = e.keyCode || e.which;
            if (key_code === 13) {
                // console.log("Enter prevented")
                e.preventDefault();
                return false;
            }
            this.value = ui.item.label;
            event.preventDefault();
        },
    });
</script>
@endsection
