<script>

    ///////////////////Start to write for Paint Editor/drawing feature here ////////////////////////////
    var contextx = [];
    var existDrawImage = {!! (isset($record) && !empty($record['drawing_image'])) ?  json_encode($record['drawing_image']) :"0" !!};
    // Check for the canvas tag onload.
    if (window.addEventListener) {
        window.addEventListener('load', function () {
            function init() {

                //var canvas, canvaso, contexto;
                var drawContexts,drawContext;

                //drawContext = document.getElementById('drawingCanvas');
                drawContexts = document.getElementsByClassName('drawingCanvas');



                for(let i = 0; i<drawContexts.length; i++){
                    let elem = drawContexts[i];
                    let context_2D = drawingByUser(elem);


                    let bepokeClass = getMatchClassNameByElem(elem);
                    contextx.push({key:elem.getAttribute('data-key'),id:bepokeClass,context:context_2D})
                }
            }

            init();

        }, false);
    }

    function getMatchClassNameByElem(elem){
        let convasClassName = '';

        elem.classList.forEach(
            function(token, index) {
                if(token == 'bespoke_drawingCanvas'){
                    convasClassName = 'bespoke_drawingCanvas';
                }else if(token == 'repair_drawingCanvas'){
                    convasClassName = 'repair_drawingCanvas';
                }
            }
        );

        return convasClassName;
    }


    /* Get Context Of element */
    function drawingByUser(canvaso, key = 0) {
        var context, canvas, contexto;
        // Default tool. (chalk, line, rectangle)
        var tool;
        var tool_default = 'chalk';
        if (!canvaso) {
            console.error('Error! The canvas element was not found!');
            // alert('Error! The canvas element was not found!');
            // return;
        }
        if (!canvaso.getContext) {
            console.error('Error! No canvas.getContext!');
            //  alert('Error! No canvas.getContext!');
            // return;
        }
        // Create 2d canvas.
        contexto = canvaso.getContext('2d');
        if (!contexto) {
            console.error('Error! Failed to getContext!');
            //  alert('Error! Failed to getContext!');
            // return;
        }
        // Build the temporary canvas.
        var container = canvaso.parentNode;
        canvas = document.createElement('canvas');
        if (!canvas) {
            console.error('Error! Cannot create a new canvas element!');
            // alert('Error! Cannot create a new canvas element!');
            // return;
        }
        canvas.id = 'tempCanvas';
        //canvas.classList.add('tempCanvas');
        canvas.width = canvaso.width;
        canvas.height = canvaso.height;
        container.appendChild(canvas);
        context = canvas.getContext('2d');
        context.strokeStyle = "#000000";// Default line color.
        context.lineWidth = 1.0;// Default stroke weight.

        // Fill transparent canvas with dark grey (So we can use the color to erase).
        context.fillStyle = "#ffffff";
        context.fillRect(0, 0, 897, 532);//Top, Left, Width, Height of canvas.

        if (existDrawImage && existDrawImage != '0') {
            drawImageToCanvas(existDrawImage,canvaso);
            setTimeout(() => {
                img_update(canvaso,canvas,context,contexto);
            }, 2000)
        }


        var tools = {};
        // Chalk tool.
        tools.chalk = function () {
            var tool = this;
            this.started = false;
            // Begin drawing with the chalk tool.
            this.mousedown = function (ev) {
                context.beginPath();
                context.moveTo(ev._x, ev._y);
                tool.started = true;
            };
            this.mousemove = function (ev) {
                if (tool.started) {
                    context.lineTo(ev._x, ev._y);
                    context.stroke();
                }
            };
            this.mouseup = function (ev) {
                if (tool.started) {
                    tool.mousemove(ev);
                    tool.started = false;
                    img_update(canvaso,canvas,context,contexto);
                }
            };
        };

        if (tools[tool_default]) {
            tool = new tools[tool_default]();
        }

        // Get the mouse position.
        function ev_canvas(ev) {
            if (ev.layerX || ev.layerX == 0) { // Firefox
                ev._x = ev.layerX;
                ev._y = ev.layerY;
            } else if (ev.offsetX || ev.offsetX == 0) { // Opera
                ev._x = ev.offsetX;
                ev._y = ev.offsetY;
            }
            // Get the tool's event handler.
            var func = tool[ev.type];
            if (func) {
                func(ev);
            }

        }

        // Event Listeners.
        canvas.addEventListener('mousedown', ev_canvas, false);
        canvas.addEventListener('mousemove', ev_canvas, false);
        canvas.addEventListener('mouseup', ev_canvas, false);

        function ev_tool_change(ev) {
            if (tools[this.value]) {
                tool = new tools[this.value]();
            }
        }

        // Create the temporary canvas on top of the canvas, which is cleared each time the user draws.
        function img_update(canvaso,canvas,context,contexto) {
            contexto.drawImage(canvas, 0, 0);
            context.clearRect(0, 0, canvas.width, canvas.height);
            let convasContent = canvaso?.toDataURL("image/png")
            let parentNextSibling = canvaso.parentElement.nextElementSibling;

            //document.getElementById('drawing_textarea_base64').value = convasContent;
            parentNextSibling.value = convasContent;
        }

        return context;
    }

    /* Active/Diactive pen pointer to write the */
    function togglePenPointer(e) {
        let previousDrawElement = e.parentElement.previousElementSibling;
        let nextTempElement = e.parentElement.nextElementSibling;
        let drawCanvas = previousDrawElement.style.display;
        let bepokeClass =  getMatchClassNameByElem(previousDrawElement);

        if (drawCanvas != "block") {
            previousDrawElement.style.display = "block";
            nextTempElement.style.display = "block";
        }

        let contexxt = contextx.find((elem)=>(elem.id === bepokeClass && parseInt(elem.key) === parseInt(previousDrawElement.getAttribute('data-key'))));
        let contxt = contexxt['context'];
        contxt.strokeStyle = '#000000';
        contxt.lineWidth = '1.0';
    }


    /* Eraser handler */
    function eraserHandler(e) {
        let previousDrawElement = e.parentElement?.previousElementSibling;
        let bepokeClass =  getMatchClassNameByElem(previousDrawElement);
        let contexxt = contextx.find((elem)=>(elem.id === bepokeClass && parseInt(elem.key) === parseInt(previousDrawElement.getAttribute('data-key'))));
        let contxt = contexxt['context'];
        contxt.strokeStyle = '#FFFFFF';
        contxt.lineWidth = '22';
    }

    /* draw image into the canvas */
    function drawImageToCanvas(imagey,currentElm) {
        let bepokeClass =  getMatchClassNameByElem(currentElm);
        let contexxt = contextx.find((elem)=>(elem.id === bepokeClass && parseInt(elem.key) === parseInt(currentElm.getAttribute('data-key'))));
        let contxt = contexxt['context'];
        //let contxt = contextx[0]['context'];
        const imagex = new Image();
        imagex.src = imagey;
        imagex.onload = () => {
            contxt.drawImage(imagex, 0, 0)
        }
    }

    $("body").delegate(".pen-eraser span", "click", function () {
        // $(".pen-eraser span").click(function () {
        $(this).addClass('active').siblings().removeClass('active');
    });

    ///////////////////End here of Paint Editor/drawing  feature  ////////////////////////////

            @php
                $user_phone =  \App\Models\User::getPhoneArray();

            @endphp
    var items =  {!!  json_encode($user_phone) !!};
    $("#phone").autocomplete({
        source: items, // list of items.
    });


    ///////////////////ItemCode Autocomplete search ////////////////////////////
            @php
                $item_code =  \App\Models\Jewellery::getItemCodeArray();

            @endphp
    var item_code =  {!!  json_encode($item_code) !!};
    $(".jewelley_item_code").autocomplete({
        source: item_code, // list of items.
    });



    ///////////////////DropZone////////////////////////////
    const TABLENAME = "quotations";

    $(document).ready(function () {

        var x = 0;

        $(".dropZoneimageUpload").dropzone({

            headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
            acceptedFiles: ".jpg,.png,",
            maxFiles: 10,
            maxFilesize: 0.5,
            maxThumbnailFilesize: 1,
            autoProcessQueue: true,
            addRemoveLinks: true,
            url: "{{ route('quotations.dropzoneStore') }}",

            sending: function (file, xhr, formData) {

                formData.append('table', TABLENAME);

                $(file.previewElement).append($('<div class="upload_progress" id="upload_progress"><div class="progress"><div class="progress-bar" role="progressbar" aria-valuenow="75" aria-valuemin="0" aria-valuemax="100" style="width:70%"> </div> </div> </div>'));

                if (xhr.upload) {
                    xhr.upload.addEventListener('progress', function (event) {
                        var percent = 0;
                        var position = event.loaded || event.position;
                        var total = event.total;
                        if (event.lengthComputable) {
                            percent = Math.ceil(position / total * 100);
                        }
                        //update progressbar
                        $("#upload_progress .progress-bar").css("width", +percent + "%").html(+percent + "%");
                    }, true);
                }
                return xhr;
            },

            init: function () {
                this.on("error", function (file, response) {
                    alertMessageRight(response, 'error');
                    this.removeFile(file);
                });

            },

            success: function (file, response) {

                $(file.previewElement).append($(`<input type="hidden" name="images[]" class="dropzone_images-${x}"  value="${response.file}">`));
                $(file.previewElement.querySelector("#upload_progress")).hide();
            },

        });


        $('.remove_button').click(function () {
            $(this).parent().remove();
        });


        /////////////////////Quotation //////////////////////////


        $('#name').on('input', function () {
            let name = $('#name').val();
            if (name) {
                $('#nameData').val(name);

            } else {
                $('#nameData').val('');
            }
        });

        $('#email').on('input', function () {
            let email = $('#email').val();
            if (email) {
                $('#emailData').val(email);

            } else {
                $('#emailData').val('');
            }
        });

        $('#phone').on('input', function () {
            let phone = $('#phone').val();
            if (phone) {
                $('#phoneData').val(phone);

            } else {
                $('#phoneData').val('');
            }
        });

        $("body").delegate(".category_id", "click", function () {

            let $_this = $(this);
            let index = $_this.attr('data-key')
            let category_val = $_this.attr('value');

            $(`.category_ul-${index} li`).removeClass('active');
            $_this.parent().addClass('active');
            $(`.category_ul-${index} input`).val(category_val);
        });

        $("body").delegate(".gold_color_id", "click", function () {

            var $_this = $(this);
            let index = $_this.attr('data-key');
            let gold_color_val = $_this.attr('value');

            $(`.gold_color_ul-${index} li`).removeClass('active');
            $_this.parent().addClass('active');
            $(`.gold_color_ul-${index} input`).val(gold_color_val);
        });

        ////////////////Active and InActive button ////////////////

        $("#inventory_fields-" + x).hide();
        $("#bespoke_fields-" + x).hide();
        $("#repair_fields-" + x).hide();
        $("#total_bill").hide();
        $(".empty_file").show();
        $('#checkout_btn').show();
        $('#checkout_submit').hide();

        $(document).on("click", '.qutation_type', function (e) {

            e.preventDefault();

            $_this = $(this);

            var phone = $('#phone').val();
            var name = $('#name').val();
            var email = $('#email').val();
            var type = $_this.attr('data-id');

            $('#inventory-' + x).addClass('inctive_type_button');
            $('#bespoke-' + x).addClass('inctive_type_button');
            $('#repair-' + x).addClass('inctive_type_button');

            if (type == "inventory") {
                $("#bespoke_fields-" + x).hide();
                $("#repair_fields-" + x).hide();
                $("#inventory_fields-" + x).show();
                $('#' + type + '-' + x).removeClass('inctive_type_button');

            } else if (type == "bespoke") {
                $("#inventory_fields-" + x).hide();
                $("#repair_fields-" + x).hide();
                $("#bespoke_fields-" + x).show();
                $('#' + type + '-' + x).removeClass('inctive_type_button');
            } else {
                $("#inventory_fields-" + x).hide();
                $("#bespoke_fields-" + x).hide();
                $("#repair_fields-" + x).show();
                $('#' + type + '-' + x).removeClass('inctive_type_button');
            }

        });


        var subtotal_quot = 0;

        $(document).on("click", ".inventory_confirm", function (e) {
            e.preventDefault();

            $_this = $(this);
            let nameData = $("#nameData").val();
            let emailData = $("#emailData").val();
            let phoneData = $("#phoneData").val();

            let btn_type = $_this.attr('data-type');
            let index = $_this.attr('data-key');
            let item_code = $("#jewelley_item_code-" + index).val();

            var thisHref = "{{route('quotations.getJewelleryByItemCode')}}";

            if (!thisHref || thisHref == '#') {
                return false;
            }

            $.ajax({
                url: thisHref,
                type: "json",
                data: {'item_code': item_code, 'name': nameData, 'email': emailData, 'phone': phoneData},
                type: 'GET',
                cache: false,

                beforeSend: function () {
                    $('.field_error').html('');
                },

                success: function (response) {

                    if (!response.errors) {

                        if (response.status) {

                            $("#jewelley_item_code-" + x).attr('readonly', true);

                            let item_string = `18k ${ response.data.gold_color.name} ${response.data.category.name} (Small) Link chain`
                            let price = (response.data.review_cost) ? response.data.review_cost.total : "0";

                            $(".customer_append").append(`

                            <div class="item_select-${x} mt-5">
                            <div class="d-flex align-items-start amount_price">
                              <div class="form-group">
                              <label for="exampleFormControlInput1" class="form-label m-0" id="item_string_invent-${x}">${item_string}</label>
                              <p id="item_code_str_invent-${x}">${response.data.item_code}</p>
                              <input type="text" class="form-control" id="exampleFormControlInput1" placeholder="Additional Information...">
                            </div>
                              <div class="form-group d-flex align-items-center">
                               <input type="text" class="form-control amount" id="price-${x}"  placeholder=" " value="${price}">
                              </div>
                            </div>
                            <div class="edit-delete d-flex align-items-center mt-3">
							<a href="#" class="inventory_edit me-4" data-key="${x}"><img src="{{ asset('public/img/edit.png')}}" class="img-fluid pe-2">Edit</a>
							<a href="#" class="quotation_dlt" data-key="${x}"><img src="{{ asset('public/img/delete.png') }}" class="img-fluid pe-2">Remove</a>
						    </div>

                             <div class="hidden_fields">
                             <input type="hidden" id="item_code_invent-${x}" name="quotations[${x}][inventory][item_code]" value="${response.data.item_code}">
                             <input type="hidden" id="jewellery_id_invent-${x}" name="quotations[${x}][inventory][jewellery_id]" value="${response.data.id}">
                             <input type="hidden" id="category_id_invent-${x}" name="quotations[${x}][inventory][category_id]" value="${response.data.category_id}">
                             <input type="hidden" id="type_name-${x}" name="quotations[${x}][inventory][type_name]" value="${btn_type}">
                             </div>

                           </div>
                        `);



                            $(".empty_file").hide();
                            $("#total_bill").show();
                            $('#checkout_btn').hide();
                            $('#checkout_submit').show();

                            $(".inventory_confirm").hide();

                            calculateTotal(price);

                            $(".qutation_type").removeClass("qutation_type")

                            x++;
                            $("#append_button").append(`

                                    <div class="content-${x}">
                                    <div class="card-body create_quotation">
                                    <div class="add_item">
                                    <div class="items">
                                    <div class="d-flex align-items-center">
                                    <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label head">Add Item</label>
                                    </div>
                                    <ul class="nav nav-tabs ms-auto">
                                    <li class="nav-item" role="presentation">
                                    <button id="inventory-${x}" class="nav-link  inventory qutation_type" data-id="inventory">Inventory</button>
                                    </li>
                                    <li class="nav-item" role="presentation">
                                    <button id="bespoke-${x}"  class="nav-link bespoke qutation_type" data-id="bespoke">Bespoke</button>
                                    </li>
                                    <li class="nav-item" role="presentation">
                                    <button id="repair-${x}" class="nav-link repair qutation_type" data-id="repair">Repair</button>
                                    </li>
                                    </ul>
                                    </div>
                                    </div>
                                    </div>
                                    </div>

                                    <div class="card-body create_quotation" id="inventory_fields-${x}" style="display: none;">
                                    <div class="add_item">
                                    <div class="items">
                                    <div class="tab-content add_items_content content-${x}">
                                    <div class="position-relative add_items_item mt-0">
                                    <div class="search">
                                    <img src="{{ asset('public/img/search.png') }}">
                                    <input type="text" name="item_code[]" class="form-control cus_form_control jewelley_item_code" id="jewelley_item_code-${x}" placeholder="Enter or Search Item Code">
                                    <span class="field_error" id="item_code_error-${x}" style="color:red"> </span>
                                    </div>

                                    <div class="checkout text-end">
                                    <button class="btn btn_confirm inventory_confirm" data-type="inventory" data-key="${x}">Confirm</button>
                                    </div>
                                    </div>
                                    </div>
                                    </div>
                                    </div>
                                    </div>

                                    <div class="card-body create_quotation" id="bespoke_fields-${x}" style="display: none;">
                                    <div class="add_item">
                                    <div class="items">
                                    <div class="tab-content add_items_content content-${x}">
                                    <div class="add_items_bespoke mt-0">
                                    <div class="position-relative add_items_item">
                                    <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label">Category</label>
                                    </div>
                                    <ul class="category_ul-${x}">
                                            @php
                                            $categories = \App\Models\Category::getCategories();
                                            $gold_colors = \App\Models\GoldColor::getGoldColorsList();
                                            @endphp
                                    @foreach($categories as $key=>$value)
                                    <li class="nav-link ">
                                    <a data-key="${x}"  class="category_id d-block"  value= "{{ $value->id }}" >{{ $value->name }}</a>
                                    </li>
                                    @endforeach
                                    <input type="hidden" id="category_id-${x}" name="category_id" value="">
                                    <span class="field_error" id="category_id_error-${x}" style="color:red"> </span>
                                    </ul>
                                    </div>
                                    <div class="position-relative add_items_item">
                                    <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label">Description</label>
                                    <input type="text" id="description-${x}" name="description" class="form-control" id="exampleFormControlInput1" placeholder="Enter description...">
                                    <span class="field_error" id="description_error-${x}" style="color:red"> </span>
                                    </div>
                                    <div class="checkout text-start">
                                    <button class="btn btn_confirm btn_illustration" type="button" data-bs-toggle="modal"
                                    data-bs-target="#bespokeIllustrationModal-${x}">
                                    Add Illustration
                                    </button>
                                    </div>
                                    </div>
                                    <div class="position-relative add_items_item">
                                    <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label">Gold Colour</label>
                                    </div>
                                    <ul class="gold_color gold_color_ul-${x}">
                                    @foreach($gold_colors as $key=>$value)
                                    <li class="nav-link">
                                    <a data-key="${x}" class="gold_color_id d-block" name="gold_color_id" value="{{ $key }}" >{{ $value }}</a>
                                    </li>
                                    @endforeach
                                    <input type="hidden" id="gold_color_id-${x}" name="gold_color_id" value="">
                                    <span class="field_error" id="gold_color_id_error-${x}" style="color:red"> </span>
                                    </ul>
                                    </div>
                                    <div class="position-relative add_items_item">
                                    <div class="row">
                                    <div class="col-lg-6 col-md-6">
                                    <div class="form-group pt-0">
                                    <label for="exampleFormControlInput1" class="form-label">Additional Material</label>
                                    <input type="text" class="form-control" id="material-${x}" placeholder="Enter material">
                                    <span class="field_error" id="material_error-${x}" style="color:red"> </span>
                                    </div>
                                    </div>
                                    <div class="col-lg-6 col-md-6">
                                    <div class="form-group pt-0">
                                    <label for="exampleFormControlInput1" class="form-label">Quantity</label>
                                    <input type="text" class="form-control" id="quantity-${x}"   placeholder="">
                                    <span class="field_error" id="quantity_error-${x}" style="color:red"> </span>  </div>
                                    </div>
                                    <div class="col-lg-12 col-md-12 col-12 mt-4">
                                    <div class="form-check">
                                    <input class="form-check-input" name="customer_received" type="checkbox" id="customer_received-0">
                                    <label class="form-check-label" for="gridCheck">
                                    Customer’s jewellery is received
                                    </label>
                                    </div>
                                    </div>
                                    <div class="checkout text-end">
                                    <button class="btn btn_confirm bespoke_confirm" data-type="bespoke" data-key="${x}" >Confirm</button>
                                    {{--<button class="btn btn_confirm">Confirm</button>--}}
                                    </div>
                                    </div>
                                    </div>
                                    </div>
                                    </div>
                                    </div>
                                    </div>
                                    </div>

                                    <div class="card-body create_quotation" id="repair_fields-${x}" style="display: none;">
                                    <div class="add_item">
                                    <div class="items">
                                    <div class="tab-content add_items_content">
                                    <div class="add_items_bespoke mt-0">

                                    <div class="position-relative add_items_item">
                                    <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label">Category</label>
                                    </div>
                                    <ul class="category_ul-${x}">

                                            @php
                                            $categories = \App\Models\Category::getCategories();
                                            $gold_colors = \App\Models\GoldColor::getGoldColorsList();

                                            @endphp
                                    @foreach($categories as $key=>$value)
                                    <li class="nav-link ">
                                    <a  data-key="${x}" class="category_id d-block"  value= "{{ $value->id }}" >{{ $value->name }}</a>
                                    </li>

                                    @endforeach

                                    <input type="hidden" id="repair_category_id-${x}" name="repair_category_id[]" value="">
                                    </ul>
                                    <div><span class="field_error" id="repair_category_id_error-${x}" style="color:red"> </span></div>
                                    </div>
                                    <div class="position-relative add_items_item">
                                    <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label">Description</label>
                                    <input type="text" id="repair_description-${x}" name="repair_description[]" class="form-control"  placeholder="Enter description...">
                                    <span class="field_error" id="repair_description_error-${x}" style="color:red"> </span>
                                    </div>
                                    <div class="checkout text-start">
                                    <button class="btn btn_confirm btn_illustration" type="button" data-bs-toggle="modal"
                                    data-bs-target="#repairIllustrationModal-${x}">
                                    Add Illustration
                                    </button>
                                    </div>
                                    </div>
                                    <div class="position-relative add_items_item">
                                    <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label">Gold Colour</label>
                                    </div>
                                    <ul class="gold_color gold_color_ul-${x}">

                                    @foreach($gold_colors as $key=>$value)
                                    <li class="nav-link">
                                    <a data-key="${x}" class="gold_color_id d-block"  name="repair_gold_color_id[]" value="{{ $key }}" >{{ $value }}</a>
                                    </li>
                                    @endforeach

                                    <input type="hidden" id="repair_gold_color_id-${x}" name="repair_gold_color_id[]" value="">
                                    <span class="field_error" id="repair_gold_color_id_error-${x}" style="color:red"> </span>
                                    </ul>
                                    </div>
                                    <div class="position-relative add_items_item">
                                    <div class="row">
                                    <div class="col-lg-6 col-md-6">
                                    <div class="form-group pt-0">
                                    <label for="exampleFormControlInput1" class="form-label">Additional Material</label>
                                    <input type="text" class="form-control" name="repair_material[]" id="repair_material-${x}" placeholder="Enter Material">
                                    <span class="field_error" id="repair_material_error-${x}" style="color:red"> </span>
                                    </div>
                                    </div>
                                    <div class="col-lg-6 col-md-6">
                                    <div class="form-group pt-0">
                                    <label for="exampleFormControlInput1" class="form-label">Quantity</label>
                                    <input type="text" class="form-control" name="repair_quantity[]" id="repair_quantity-${x}" placeholder="">
                                    <span class="field_error" id="repair_quantity_error-${x}" style="color:red"> </span>
                                    </div>
                                    </div>
                                    <div class="col-lg-12 col-md-12 col-12 mt-4">
                                    <div class="form-check">
                                    <input class="form-check-input" name="repair_customer_recieved-${x}" type="checkbox" id="repair_customer_recieved-${x}" value="1">
                                    <label class="form-check-label" for="gridCheck">
                                    Customer’s jewellery is received
                                    </label>
                                    </div>
                                    </div>

                                    <div class="checkout text-end">
                                    <button class="btn btn_confirm repair_confirm" data-type="repair" data-key="${x}" >Confirm</button>
                                    </div>
                                    </div>
                                    </div>
                                    </div>
                                    </div>
                                    </div>
                                    </div>
                                    </div>

                                    <div class="modal fade" id="bespokeIllustrationModal-${x}" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog illustration_dialog">
                                    <div class="modal-content">
                                    <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalLabel">Add Illustration</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    </div>
                                    <div class="modal-body">
                                    <div class="row">
                                    <div class="col-md-6 d-flex align-items-center">
                                    <div class="required_photo">
                                    <div class="dropzone dropZoneimageUpload">
                                    <span class="drop-zone__prompt dz-default dz-message">
                                    <div>
                                    <p>Click here to add photo</p>
                                    <span>Photo Requiement:</span>
                                    <ul>
                                    <li>File type PNG or JPG</li>
                                    <li>Maximum Size: 500 KB</li>
                                    </ul>
                                    </div>
                                    </span>
                                    </div>
                                    </div>
                                    </div>
                                    <div class="col-lg-6">
                                    <div class="form-group modal_drawing pt-0">
                                    <div class="start-drawing" id="blackboardPlaceholder">
                                    <p>Start Drawing</p>
                                    <canvas data-key="${x}" class="drawingCanvas bespoke_drawingCanvas" width="500" height="230"></canvas>
                                    <div class="pen-eraser">
                                    <span class="pen" onclick="togglePenPointer(this);"><img
                                    src="{{ asset('public/img/pen.png') }}"/></span>
                                    <span class="erase" onclick="eraserHandler(this);"><img
                                    src="{{ asset('public/img/eraser.png') }}"/></span>
                                    </div>
                                    </div>
                                    <input type="hidden" id="drawing_textarea_base64-0"
                                    name="drawing_textarea_base64">
                                    </div>
                                    </div>

                                    <div class="col-lg-12">
                                    <div class="preview-droped-images">
                                    </div>
                                    </div>
                                    </div>
                                    </div>
                                    <div class="modal-footer">
                                    <button type="button" class="btn btn-primary btn-save illustration_btn">Save</button>
                                    </div>
                                    </div>
                                    </div>
                                    </div>


                                    <div class="modal fade" id="repairIllustrationModal-${x}" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog illustration_dialog">
                                    <div class="modal-content">
                                    <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalLabel">Add Illustration</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    </div>
                                    <div class="modal-body">
                                    <div class="row">
                                    <div class="col-md-6 d-flex align-items-center">
                                    <div class="required_photo">
                                    <div class="dropzone dropZoneimageUpload">
                                    <span class="drop-zone__prompt dz-default dz-message">
                                    <div>
                                    <p>Click here to add photo</p>
                                    <span>Photo Requiement:</span>
                                    <ul>
                                    <li>File type PNG or JPG</li>
                                    <li>Maximum Size: 500 KB</li>
                                    </ul>
                                    </div>
                                    </span>
                                    </div>
                                    </div>
                                    </div>
                                    <div class="col-lg-6">
                                    <div class="form-group modal_drawing pt-0">
                                    <div class="start-drawing" id="blackboardPlaceholder">
                                    <p>Start Drawing</p>
                                    <canvas data-key="${x}" class="drawingCanvas bespoke_drawingCanvas" width="500" height="230"></canvas>
                                    <div class="pen-eraser">
                                    <span class="pen" onclick="togglePenPointer(this);"><img
                                    src="{{ asset('public/img/pen.png') }}"/></span>
                                    <span class="erase" onclick="eraserHandler(this);"><img
                                    src="{{ asset('public/img/eraser.png') }}"/></span>
                                    </div>
                                    </div>
                                    <input type="hidden" id="drawing_textarea_base64-0"
                                    name="drawing_textarea_base64">
                                    </div>
                                    </div>

                                    <div class="col-lg-12">
                                    <div class="preview-droped-images">
                                    </div>
                                    </div>
                                    </div>
                                    </div>
                                    <div class="modal-footer">
                                    <button type="button" class="btn btn-primary btn-save illustration_btn">Save</button>
                                    </div>
                                    </div>
                                    </div>
                                    </div>

                `)
                                    @php
                                        $item_code =  \App\Models\Jewellery::getItemCodeArray();
                                    @endphp

                            var item_code =  {!!  json_encode($item_code) !!};
                            $(".jewelley_item_code").autocomplete({
                                source: item_code, // list of items.
                            });


                            alertMessageRight(response.message, 'success');

                        }
                        else {
                            alertMessageRight(response.message, 'error');
                        }
                    }
                    else {
                        alertMessageRight('Something went wrong', 'error');

                        $.each(response.errors, function (key, value) {
                            $("#" + key + "_error").html(value);
                            $("#" + key + "_error-" + x).html(value);
                        });

                    }
                },
                error: function () {

                }
            });


        });


        $(document).on("click", ".bespoke_confirm", function (e) {

            e.preventDefault();
            $_this = $(this);
            let nameData = $("#nameData").val();
            let emailData = $("#emailData").val();
            let phoneData = $("#phoneData").val();

            let btn_type = $_this.attr('data-type');
            let index = $_this.attr('data-key');

            let item_code = $("#jewelley_item_code-" + index).val();
            //bespoke
            let category_id = $("#category_id-" + index).val();
            let description = $("#description-" + index).val();
            let gold_color_id = $("#gold_color_id-" + index).val();
            let material = $("#material-" + index).val();
            let quantity = $("#quantity-" + index).val();

            let drawing_textarea_base64 = $("#drawing_textarea_base64").val();

            drawing_textarea_base64 = (drawing_textarea_base64) ? drawing_textarea_base64 : null;


            let customer_received = $(`input[id='customer_recieved-${x}']:checked`).val();
                customer_received = (customer_received) ? customer_received : 0;

             var thisHref = "{{route('quotations.getBespokeData')}}";

            if (!thisHref || thisHref == '#') {
                return false;
            }
            let formData = {
                'name': nameData, 'email': emailData, 'phone': phoneData, 'category_id': category_id,
                'description': description,'gold_color_id': gold_color_id, 'material': material,
                'quantity': quantity, 'customer_received': customer_received, 'type_name': btn_type, 'drawing_textarea_base64': drawing_textarea_base64
            };

            $.ajax({
                url: thisHref,
                type: "json",
                data: formData,
                method: 'POST',
                cache: false,

                beforeSend: function () {
                    $('.field_error').html('');
                },

                success: function (response) {

                    if (!response.errors) {

                        // $("#jewelley_item_code-" + index).attr('readonly', true);

                        let item_string = `18k ${ response.data.goldColor_name} ${response.data.category_name} (Small) Link chain`;

                        $(".customer_append").append(`

                              <div class="item_select-${x} mt-5">
                                <div class="d-flex align-items-start amount_price">
                                  <div class="form-group">
                                  <label for="exampleFormControlInput1" class="form-label m-0" id="item_string_bespoke-${x}">${item_string}</label>
                                   <!--<p></p>-->
                                  <input type="text" class="form-control" id="exampleFormControlInput1" placeholder="Additional Information...">
                                </div>
                              <div class="form-group d-flex align-items-center">
                               <input type="text" class="form-control amount"  id="price-${x}" placeholder="" value=" ">
                              </div>
                            </div>
                            <div class="edit-delete d-flex align-items-center mt-3">
							<a href="#"  class="bespoke_edit me-4" data-key="${x}"><img src="{{ asset('public/img/edit.png')}}" class="img-fluid pe-2">Edit</a>
							<a href="#" class="quotation_dlt" data-key="${x}"><img src="{{ asset('public/img/delete.png') }}" class="img-fluid pe-2">Remove</a>
						    </div>

                            <div class="hidden_fields">
                             <input type="hidden" id="category_id_bespoke-${x}" name="quotations[${x}][bespoke][category_id]" value="${response.data.category_id}">
                             <input type="hidden" id="description_bespoke-${x}" name="quotations[${x}][bespoke][description]" value="${response.data.description}">
                             <input type="hidden" id="gold_color_id_bespoke-${x}" name="quotations[${x}][bespoke][gold_color_id]" value="${response.data.gold_color_id}">
                             <input type="hidden" id="material_bespoke-${x}" name="quotations[${x}][bespoke][material]" value="${response.data.material}">
                             <input type="hidden" id="quantity_bespoke-${x}" name="quotations[${x}][bespoke][quantity]" value="${response.data.quantity}">
                             <input type="hidden" id="customer_received_bespoke-${x}" name="quotations[${x}][bespoke][customer_received]" value="${response.data.customer_received}">
                             <input type="hidden" id="type_name-${x}"  name="quotations[${x}][bespoke][type_name]" value="${btn_type}">

                             <input type="hidden" id="drawing_textarea_hidden"  name="quotations[${x}][bespoke][drawing_textarea]" value="${response.data.drawing_textarea_base64}">

                            <div class="bespoke_dropzone-${x}">

                            </div>

                            </div>

                            </div>
                        `);

                           let preview =  $('.preview-quotations-images-'+index).children();
                           let img  = preview.find('.dropzone_images-'+index);
                               img.each(function () {
                               $(".bespoke_dropzone-"+x).append(`<input type="hidden"  name="quotations[${x}][bespoke][dropzone_images][]" value="${$(this).val()}">`);
                            });

                        $(".empty_file").hide();
                        $("#total_bill").show();
                        $('#checkout_btn').hide();
                        $('#checkout_submit').show();

                        $(".bespoke_confirm").hide();

                        $(".qutation_type").removeClass("qutation_type")

                        x++;

                        $("#append_button").append(`

                                    <div class="content-${x}">
                                    <div class="card-body create_quotation">
                                    <div class="add_item">
                                    <div class="items">
                                    <div class="d-flex align-items-center">
                                    <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label head">Add Item</label>
                                    </div>
                                    <ul class="nav nav-tabs ms-auto">
                                    <li class="nav-item" role="presentation">
                                    <button id="inventory-${x}" class="nav-link  inventory qutation_type" data-id="inventory">Inventory</button>
                                    </li>
                                    <li class="nav-item" role="presentation">
                                    <button id="bespoke-${x}"  class="nav-link bespoke qutation_type" data-id="bespoke">Bespoke</button>
                                    </li>
                                    <li class="nav-item" role="presentation">
                                    <button id="repair-${x}" class="nav-link repair qutation_type" data-id="repair">Repair</button>
                                    </li>
                                    </ul>
                                    </div>
                                    </div>
                                    </div>
                                    </div>

                                    <div class="card-body create_quotation" id="inventory_fields-${x}" style="display: none;">
                                    <div class="add_item">
                                    <div class="items">
                                    <div class="tab-content add_items_content">
                                    <div class="position-relative add_items_item mt-0">
                                    <div class="search">
                                    <img src="{{ asset('public/img/search.png') }}">
                                    <input type="text" name="item_code[]" class="form-control cus_form_control jewelley_item_code" id="jewelley_item_code-${x}" placeholder="Enter or Search Item Code">
                                    <span class="field_error" id="item_code_error-${x}" style="color:red"> </span>
                                    </div>

                                    <div class="checkout text-end">
                                    <button class="btn btn_confirm inventory_confirm" data-type="inventory" data-key="${x}">Confirm</button>
                                    </div>
                                    </div>
                                    </div>
                                    </div>
                                    </div>
                                    </div>

                                    <div class="card-body create_quotation" id="bespoke_fields-${x}" style="display: none;">
                                    <div class="add_item">
                                    <div class="items">
                                    <div class="tab-content add_items_content">
                                    <div class="add_items_bespoke mt-0">
                                    <div class="position-relative add_items_item">
                                    <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label">Category</label>
                                    </div>
                                    <ul class="category_ul-${x}">
                                    @php
                                    $categories = \App\Models\Category::getCategories();
                                    $gold_colors = \App\Models\GoldColor::getGoldColorsList();
                                    @endphp
                                    @foreach($categories as $key=>$value)
                                    <li class="nav-link ">
                                    <a  data-key="${x}" class="category_id d-block"  value= "{{ $value->id }}" >{{ $value->name }}</a>
                                    </li>
                                    @endforeach
                                    <input type="hidden" id="category_id-${x}" name="category_id[]" value="">
                                    <span class="field_error" id="category_id_error-${x}" style="color:red"> </span>
                                    </ul>
                                    </div>
                                    <div class="position-relative add_items_item">
                                    <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label">Description</label>
                                    <input type="text" id="description-${x}" name="description[]" class="form-control" id="exampleFormControlInput1" placeholder="Enter description...">
                                    <span class="field_error" id="description_error-${x}" style="color:red"> </span>
                                    </div>
                                    <div class="checkout text-start">
                                    <button class="btn btn_confirm btn_illustration" type="button" data-bs-toggle="modal"
                                    data-bs-target="#bespokeIllustrationModal-${x}">
                                    Add Illustration
                                    </button>
                                    </div>
                                    </div>
                                    <div class="position-relative add_items_item">
                                    <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label">Gold Colour</label>
                                    </div>
                                    <ul class="gold_color gold_color_ul-${x}">
                                    @foreach($gold_colors as $key=>$value)
                                    <li class="nav-link">
                                    <a  data-key="${x}" class="gold_color_id d-block" value="{{ $key }}" >{{ $value }}</a>
                                    </li>
                                    @endforeach
                                    <input type="hidden" id="gold_color_id-${x}" name="gold_color_id[]" value="">
                                    <span class="field_error" id="gold_color_id_error-${x}" style="color:red"> </span>
                                    </ul>
                                    </div>
                                    <div class="position-relative add_items_item">
                                    <div class="row">
                                    <div class="col-lg-6 col-md-6">
                                    <div class="form-group pt-0">
                                    <label for="exampleFormControlInput1" class="form-label">Additional Material</label>
                                    <input type="text" class="form-control" id="material-${x}" name="material[]" placeholder="Enter material">
                                    <span class="field_error" id="material_error-${x}" style="color:red"> </span>
                                    </div>
                                    </div>
                                    <div class="col-lg-6 col-md-6">
                                    <div class="form-group pt-0">
                                    <label for="exampleFormControlInput1" class="form-label">Quantity</label>
                                    <input type="text" class="form-control" id="quantity-${x}" name="quantity"   placeholder="Enter quantity">
                                    <span class="field_error" id="quantity_error-${x}" style="color:red"> </span>  </div>
                                    </div>
                                    <div class="col-lg-12 col-md-12 col-12 mt-4">
                                    <div class="form-check">
                                    <input class="form-check-input" name="customer_received" type="checkbox" id="customer_received-${x}">
                                    <label class="form-check-label" for="gridCheck">
                                    Customer’s jewellery is received
                                    </label>
                                    </div>
                                    </div>

                                    <div class="checkout text-end">
                                    <button class="btn btn_confirm bespoke_confirm" data-type="bespoke" data-key="${x}">Confirm</button>
                                    {{--<button class="btn btn_confirm">Confirm</button>--}}
                                    </div>
                                    </div>
                                    </div>
                                    </div>
                                    </div>
                                    </div>
                                    </div>
                                    </div>

                                    <div class="card-body create_quotation" id="repair_fields-${x}" style="display: none;">
                                    <div class="add_item">
                                    <div class="items">
                                    <div class="tab-content add_items_content">
                                    <div class="add_items_bespoke mt-0">

                                    <div class="position-relative add_items_item">
                                    <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label">Category</label>
                                    </div>
                                    <ul class="category_ul-${x}">

                                    @php
                                    $categories = \App\Models\Category::getCategories();
                                    $gold_colors = \App\Models\GoldColor::getGoldColorsList();

                                    @endphp
                                    @foreach($categories as $key=>$value)
                                    <li class="nav-link ">
                                    <a  data-key="${x}" class="category_id d-block"  value= "{{ $value->id }}" >{{ $value->name }}</a>
                                    </li>

                                    @endforeach

                                    <input type="hidden" id="repair_category_id-${x}" name="repair_category_id[]" value="">

                                    </ul>
                                    <div><span class="field_error" id="repair_category_id_error-${x}" style="color:red"> </span></div>
                                    </div>
                                    <div class="position-relative add_items_item">
                                    <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label">Description</label>
                                    <input type="text" id="repair_description-${x}" name="repair_description[]" class="form-control"  placeholder="Enter description...">
                                    <span class="field_error" id="repair_description_error-${x}" style="color:red"> </span>
                                    </div>
                                    <div class="checkout text-start">
                                    <button class="btn btn_confirm btn_illustration" type="button" data-bs-toggle="modal"
                                    data-bs-target="#repairIllustrationModal-${x}">
                                    Add Illustration
                                    </button>
                                    </div>
                                    </div>
                                    <div class="position-relative add_items_item">
                                    <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label">Gold Colour</label>
                                    </div>
                                    <ul class="gold_color gold_color_ul-${x}">

                                    @foreach($gold_colors as $key=>$value)
                                    <li class="nav-link">
                                    <a data-key="${x}" class="gold_color_id d-block"  name="repair_gold_color_id[]" value="{{ $key }}" >{{ $value }}</a>
                                    </li>
                                    @endforeach

                                    <input type="hidden" id="repair_gold_color_id-${x}" name="repair_gold_color_id[]" value="">
                                    <span class="field_error" id="repair_gold_color_id_error-${x}" style="color:red"> </span>
                                    </ul>
                                    </div>
                                    <div class="position-relative add_items_item">
                                    <div class="row">
                                    <div class="col-lg-6 col-md-6">
                                    <div class="form-group pt-0">
                                    <label for="exampleFormControlInput1" class="form-label">Additional Material</label>
                                    <input type="text" class="form-control" name="repair_material[]" id="repair_material-${x}" placeholder="Enter Material">
                                    <span class="field_error" id="repair_material_error-${x}" style="color:red"> </span>
                                    </div>
                                    </div>
                                    <div class="col-lg-6 col-md-6">
                                    <div class="form-group pt-0">
                                    <label for="exampleFormControlInput1" class="form-label">Quantity</label>
                                    <input type="text" class="form-control" name="repair_quantity[]" id="repair_quantity-${x}" placeholder="">
                                    <span class="field_error" id="repair_quantity_error-${x}" style="color:red"> </span>
                                    </div>
                                    </div>
                                    <div class="col-lg-12 col-md-12 col-12 mt-4">
                                    <div class="form-check">
                                    <input class="form-check-input" name="repair_customer_recieved-${x}" type="checkbox" id="repair_customer_recieved-${x}" value="1">
                                    <label class="form-check-label" for="gridCheck">
                                    Customer’s jewellery is received
                                    </label>
                                    </div>
                                    </div>


                                    <div class="checkout text-end">
                                    <button class="btn btn_confirm repair_confirm" data-type="repair" data-key="${x}" >Confirm</button>
                                    </div>
                                    </div>
                                    </div>
                                    </div>
                                    </div>
                                    </div>
                                    </div>
                                    </div>

                                    <div class="modal fade" id="bespokeIllustrationModal-${x}" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog illustration_dialog">
                                    <div class="modal-content">
                                    <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalLabel">Add Illustration</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    </div>
                                    <div class="modal-body">
                                    <div class="row">
                                    <div class="col-md-6 d-flex align-items-center">
                                    <div class="required_photo">
                                    <div class="dropzone dropZoneimageUpload" >
                                    <span class="drop-zone__prompt dz-default dz-message">
                                    <div>
                                    <p>Click here to add photo</p>
                                    <span>Photo Requiement:</span>
                                    <ul>
                                    <li>File type PNG or JPG</li>
                                    <li>Maximum Size: 500 KB</li>
                                    </ul>
                                    </div>
                                    </span>
                                    </div>
                                    </div>
                                    </div>

                                    <div class="col-lg-6">
                                    <div class="form-group modal_drawing pt-0">
                                    <div class="start-drawing" id="blackboardPlaceholder">
                                    <p>Start Drawing</p>
                                    <canvas data-key="${x}" class="drawingCanvas bespoke_drawingCanvas" width="500" height="230"></canvas>
                                    <div class="pen-eraser">
                                    <span class="pen" onclick="togglePenPointer(this);"><img
                                    src="{{ asset('public/img/pen.png') }}"/></span>
                                    <span class="erase" onclick="eraserHandler(this);"><img
                                    src="{{ asset('public/img/eraser.png') }}"/></span>
                                    </div>
                                    </div>
                                    <input type="hidden"  name="drawing_textarea_base64">
                                    </div>
                                    </div>

                                    <div class="col-lg-12">
                                    <div class="preview-droped-images">
                                    </div>
                                    </div>
                                    </div>
                                    </div>
                                    <div class="modal-footer">
                                    <button type="button" data-key="${x}" class="btn btn-primary btn-save illustration_save">Save</button>
                                    </div>
                                    </div>
                                    </div>
                                    </div>


                                     <div class="modal fade" id="repairIllustrationModal-0" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                        <div class="modal-dialog illustration_dialog">
                                        <div class="modal-content">
                                        <div class="modal-header">
                                        <h5 class="modal-title" id="">Add Illustration</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                        </div>
                                        <div class="modal-body">
                                        <div class="row">
                                        <div class="col-md-6 d-flex align-items-center">
                                        <div class="required_photo">
                                        <div class="dropzone dropZoneimageUpload"  >
                                            <span class="drop-zone__prompt dz-default dz-message">
                                            <div>
                                                <p>Click here to add photo</p>
                                                <span>Photo Requiement:</span>
                                                <ul>
                                                    <li>File type PNG or JPG</li>
                                                    <li>Maximum Size: 500 KB</li>
                                                </ul>
                                            </div>
                                            </span>
                                        </div>
                                        </div>
                                        </div>
                                        <div class="col-lg-6">
                                        <div class="form-group modal_drawing pt-0">
                                        <div class="start-drawing" id="blackboardPlaceholder">
                                            <p>Start Drawing</p>
                                            <canvas data-key="${x}" class="drawingCanvas repair_drawingCanvas"  width="500" height="230"></canvas>
                                            <div class="pen-eraser">
                                                    <span class="pen" onclick="togglePenPointer(this);"><img
                                                                src="{{ asset('public/img/pen.png') }}"/></span>
                                                <span class="erase" onclick="eraserHandler(this);"><img
                                                            src="{{ asset('public/img/eraser.png') }}"/></span>
                                            </div>
                                        </div>
                                        <input type="hidden"  name="drawing_textarea_base64">
                                        </div>
                                        </div>

                                        <div class="col-lg-12">
                                        <div class="preview-droped-images">
                                        </div>
                                        </div>
                                        </div>
                                        </div>
                                        <div class="modal-footer">
                                        <button type="button" data-key="0" class="btn btn-primary btn-save illustration_save">Save</button>
                                        </div>
                                        </div>
                                        </div>
                                        </div>


 `)
                                @php
                                    $item_code =  \App\Models\Jewellery::getItemCodeArray();
                                @endphp

                        var item_code =  {!!  json_encode($item_code) !!};
                        $(".jewelley_item_code").autocomplete({
                            source: item_code, // list of items.
                        });

                        $(".dropZoneimageUpload").dropzone({

                            headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
                            acceptedFiles: ".jpg,.png,",
                            maxFiles: 10,
                            maxFilesize: 0.5,
                            maxThumbnailFilesize: 1,
                            autoProcessQueue: true,
                            addRemoveLinks: true,
                            url: "{{ route('quotations.dropzoneStore') }}",

                            sending: function (file, xhr, formData) {

                                formData.append('table', TABLENAME);

                                $(file.previewElement).append($('<div class="upload_progress" id="upload_progress"><div class="progress"><div class="progress-bar" role="progressbar" aria-valuenow="75" aria-valuemin="0" aria-valuemax="100" style="width:70%"> </div> </div> </div>'));

                                if (xhr.upload) {
                                    xhr.upload.addEventListener('progress', function (event) {
                                        var percent = 0;
                                        var position = event.loaded || event.position;
                                        var total = event.total;
                                        if (event.lengthComputable) {
                                            percent = Math.ceil(position / total * 100);
                                        }
                                        //update progressbar
                                        $("#upload_progress .progress-bar").css("width", +percent + "%").html(+percent + "%");
                                    }, true);
                                }
                                return xhr;
                            },

                            init: function () {
                                this.on("error", function (file, response) {
                                    alertMessageRight(response, 'error');
                                    this.removeFile(file);
                                });

                            },

                            success: function (file, response) {

                                $(file.previewElement).append($(`<input type="hidden" name="images[]" class="dropzone_images-${x}"  value="${response.file}">`));
                                $(file.previewElement.querySelector("#upload_progress")).hide();
                            },

                        });

                        $('.remove_button').click(function () {
                            $(this).parent().remove();
                        });

                        alertMessageRight(response.message, 'success');

                    } else {

                        alertMessageRight('Something went wrong', 'error');

                        $.each(response.errors, function (key, value) {
                            $("#" + key + "_error").html(value);
                            $("#" + key + "_error-" + x).html(value);

                        });

                    }
                },
                error: function () {

                }
            });


        });

        $(document).on("click", ".repair_confirm", function (e) {

            e.preventDefault();
            $_this = $(this);
            let nameData = $("#nameData").val();
            let emailData = $("#emailData").val();
            let phoneData = $("#phoneData").val();

            let btn_type = $_this.attr('data-type');
            let index = $_this.attr('data-key');

            //bespoke
            let category_id = $("#repair_category_id-" + index).val();
            let description = $("#repair_description-" + index).val();
            let gold_color_id = $("#repair_gold_color_id-" + index).val();
            let material = $("#repair_material-" + index).val();
            let quantity = $("#repair_quantity-" + index).val();

            let drawing_textarea_base64 = $("#drawing_textarea_base64").val();
            console.log(drawing_textarea_base64,'before');
                drawing_textarea_base64 = (drawing_textarea_base64) ? drawing_textarea_base64 : null;
                console.log(drawing_textarea_base64,'after');

            let customer_received = $(`input[id='repair_customer_recieved-${x}']:checked`).val();
                 customer_received = (customer_received) ? customer_received : 0;

            var thisHref = "{{route('quotations.getRepairData')}}";

            if (!thisHref || thisHref == '#') {
                return false;
            }
            let formData = {
                'name': nameData, 'email': emailData, 'phone': phoneData, 'repair_category_id': category_id, 'repair_description': description, 'repair_gold_color_id': gold_color_id,
                'repair_material': material, 'repair_quantity': quantity, 'repair_customer_received': customer_received, 'type_name': btn_type, 'drawing_textarea_base64': drawing_textarea_base64
            };

            $.ajax({
                url: thisHref,
                type: "json",
                data: formData,
                method: 'POST',
                cache: false,

                beforeSend: function () {
                    $('.field_error').html('');
                },

                success: function (response) {

                    console.log(response);

                    if (!response.errors) {

                        let item_string = `18k ${ response.data.goldColor_name} ${response.data.category_name} (Small) Link chain`;

                        $(".customer_append").append(`

                              <div class="item_select-${x} mt-5">
                                <div class="d-flex align-items-start amount_price">
                                  <div class="form-group">
                                  <label for="exampleFormControlInput1" class="form-label m-0" id="item_string_repair-${x}">${item_string}</label>
                                   <!--<p></p>-->
                                  <input type="text" class="form-control" id="exampleFormControlInput1" placeholder="Additional Information...">
                                </div>
                              <div class="form-group d-flex align-items-center">
                               <input type="text" class="form-control amount"  id="price-${x}" placeholder="" value=" ">
                              </div>
                            </div>
                            <div class="edit-delete d-flex align-items-center mt-3">
							<a href="#"  class="repair_edit me-4" data-key="${x}"><img src="{{ asset('public/img/edit.png')}}" class="img-fluid pe-2">Edit</a>
							<a href="#" class="quotation_dlt" data-key="${x}"><img src="{{ asset('public/img/delete.png') }}" class="img-fluid pe-2">Remove</a>
						    </div>

                            <div class="hidden_fields">
                             <input type="hidden" id="category_id_repair-${x}" name="quotations[${x}][repair][category_id]" value="${response.data.repair_category_id}">
                             <input type="hidden" id="description_repair-${x}" name="quotations[${x}][repair][description]" value="${response.data.repair_description}">
                             <input type="hidden" id="gold_color_id_repair-${x}" name="quotations[${x}][repair][gold_color_id]" value="${response.data.repair_gold_color_id}">
                             <input type="hidden" id="material_repair-${x}" name="quotations[${x}][repair][material]" value="${response.data.repair_material}">
                             <input type="hidden" id="quantity_repair-${x}" name="quotations[${x}][repair][quantity]" value="${response.data.repair_quantity}">
                             <input type="hidden" id="customer_received_repair-${x}" name="quotations[${x}][repair][customer_received]" value="${response.data.repair_customer_received}">
                             <input type="hidden" id="type_name-${x}"  name="quotations[${x}][repair][type_name]" value="${btn_type}">

                             <input type="hidden" id="drawing_textarea_hidden"  name="quotations[${x}][repair][drawing_textarea]" value="${response.data.repair_drawing_textarea_base64}">

                            </div>

                            <div class="repair_dropzone-${x}">
                            </div>
                            </div>

                        `);


                        $(".quotation_dropzone-"+x).each(function () {
                            $(".repair_dropzone-"+x).append(`<input type="hidden"  name="quotations[${x}][repair][dropzone_images][]" value="${$(this).val()}">`);
                        });

                        $(".empty_file").hide();
                        $("#total_bill").show();
                        $('#checkout_btn').hide();
                        $('#checkout_submit').show();

                        $(".repair_confirm").hide();

                        $(".qutation_type").removeClass("qutation_type")

                        x++;

                        $("#append_button").append(`

                                    <div class="content-${x}">
                                    <div class="card-body create_quotation">
                                    <div class="add_item">
                                    <div class="items">
                                    <div class="d-flex align-items-center">
                                    <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label head">Add Item</label>
                                    </div>
                                    <ul class="nav nav-tabs ms-auto">
                                    <li class="nav-item" role="presentation">
                                    <button id="inventory-${x}" class="nav-link  inventory qutation_type" data-id="inventory">Inventory</button>
                                    </li>
                                    <li class="nav-item" role="presentation">
                                    <button id="bespoke-${x}"  class="nav-link bespoke qutation_type" data-id="bespoke">Bespoke</button>
                                    </li>
                                    <li class="nav-item" role="presentation">
                                    <button id="repair-${x}" class="nav-link repair qutation_type" data-id="repair">Repair</button>
                                    </li>
                                    </ul>
                                    </div>
                                    </div>
                                    </div>
                                    </div>

                                    <div class="card-body create_quotation" id="inventory_fields-${x}" style="display: none;">
                                    <div class="add_item">
                                    <div class="items">
                                    <div class="tab-content add_items_content">
                                    <div class="position-relative add_items_item mt-0">
                                    <div class="search">
                                    <img src="{{ asset('public/img/search.png') }}">
                                    <input type="text" name="item_code[]" class="form-control cus_form_control jewelley_item_code" id="jewelley_item_code-${x}" placeholder="Enter or Search Item Code">
                                    <span class="field_error" id="item_code_error-${x}" style="color:red"> </span>
                                    </div>

                                    <div class="checkout text-end">
                                    <button class="btn btn_confirm inventory_confirm" data-type="inventory" data-key="${x}">Confirm</button>
                                    </div>
                                    </div>
                                    </div>
                                    </div>
                                    </div>
                                    </div>

                                    <div class="card-body create_quotation" id="bespoke_fields-${x}" style="display: none;">
                                    <div class="add_item">
                                    <div class="items">
                                    <div class="tab-content add_items_content">
                                    <div class="add_items_bespoke mt-0">
                                    <div class="position-relative add_items_item">
                                    <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label">Category</label>
                                    </div>
                                    <ul class="category_ul-${x}">
                                    @php
                                    $categories = \App\Models\Category::getCategories();
                                    $gold_colors = \App\Models\GoldColor::getGoldColorsList();
                                    @endphp
                                    @foreach($categories as $key=>$value)
                                    <li class="nav-link ">
                                    <a  data-key="${x}" class="category_id d-block"  value= "{{ $value->id }}" >{{ $value->name }}</a>
                                    </li>
                                    @endforeach
                                    <input type="hidden" id="category_id-${x}" name="category_id[]" value="">
                                    <span class="field_error" id="category_id_error-${x}" style="color:red"> </span>
                                    </ul>
                                    </div>
                                    <div class="position-relative add_items_item">
                                    <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label">Description</label>
                                    <input type="text" id="description-${x}" name="description[]" class="form-control" id="exampleFormControlInput1" placeholder="Enter description...">
                                    <span class="field_error" id="description_error-${x}" style="color:red"> </span>
                                    </div>
                                    <div class="checkout text-start">
                                    <button class="btn btn_confirm btn_illustration" type="button" data-bs-toggle="modal"
                                    data-bs-target="#addillustrationModal-${x}">
                                    Add Illustration
                                    </button>
                                    </div>
                                    </div>
                                    <div class="position-relative add_items_item">
                                    <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label">Gold Colour</label>
                                    </div>
                                    <ul class="gold_color gold_color_ul-${x}">
                                    @foreach($gold_colors as $key=>$value)
                                    <li class="nav-link">
                                    <a  data-key="${x}" class="gold_color_id d-block" value="{{ $key }}" >{{ $value }}</a>
                                    </li>
                                    @endforeach
                                    <input type="hidden" id="gold_color_id-${x}" name="gold_color_id[]" value="">
                                    <span class="field_error" id="gold_color_id_error-${x}" style="color:red"> </span>
                                    </ul>
                                    </div>
                                    <div class="position-relative add_items_item">
                                    <div class="row">
                                    <div class="col-lg-6 col-md-6">
                                    <div class="form-group pt-0">
                                    <label for="exampleFormControlInput1" class="form-label">Additional Material</label>
                                    <input type="text" class="form-control" id="material-${x}" name="material[]" placeholder="Enter material">
                                    <span class="field_error" id="material_error-${x}" style="color:red"> </span>
                                    </div>
                                    </div>
                                    <div class="col-lg-6 col-md-6">
                                    <div class="form-group pt-0">
                                    <label for="exampleFormControlInput1" class="form-label">Quantity</label>
                                    <input type="text" class="form-control" id="quantity-${x}" name="quantity"   placeholder="Enter quantity">
                                    <span class="field_error" id="quantity_error-${x}" style="color:red"> </span>  </div>
                                    </div>
                                    <div class="col-lg-12 col-md-12 col-12 mt-4">
                                    <div class="form-check">
                                    <input class="form-check-input" name="customer_received" type="checkbox" id="customer_received-${x}">
                                    <label class="form-check-label" for="gridCheck">
                                    Customer’s jewellery is received
                                    </label>
                                    </div>
                                    </div>
                                    <div class="checkout text-end">
                                    <button class="btn btn_confirm bespoke_confirm" data-type="bespoke" data-key="${x}">Confirm</button>
                                    {{--<button class="btn btn_confirm">Confirm</button>--}}
                                    </div>
                                    </div>
                                    </div>
                                    </div>
                                    </div>
                                    </div>
                                    </div>
                                    </div>

                                    <div class="card-body create_quotation" id="repair_fields-${x}" style="display: none;">
                                    <div class="add_item">
                                    <div class="items">
                                    <div class="tab-content add_items_content">
                                    <div class="add_items_bespoke mt-0">

                                    <div class="position-relative add_items_item">
                                    <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label">Category</label>
                                    </div>
                                    <ul class="category_ul-${x}">

                                    @php
                                    $categories = \App\Models\Category::getCategories();
                                    $gold_colors = \App\Models\GoldColor::getGoldColorsList();

                                    @endphp
                                    @foreach($categories as $key=>$value)
                                    <li class="nav-link ">
                                    <a  data-key="${x}" class="category_id d-block"  value= "{{ $value->id }}" >{{ $value->name }}</a>
                                    </li>

                                    @endforeach

                                    <input type="hidden" id="repair_category_id-${x}" name="repair_category_id[]" value="">

                                    </ul>
                                    <div><span class="field_error" id="repair_category_id_error-${x}" style="color:red"> </span></div>
                                    </div>
                                    <div class="position-relative add_items_item">
                                    <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label">Description</label>
                                    <input type="text" id="repair_description-${x}" name="repair_description[]" class="form-control"  placeholder="Enter description...">
                                    <span class="field_error" id="repair_description_error-${x}" style="color:red"> </span>
                                    </div>
                                    <div class="checkout text-start">
                                    <button class="btn btn_confirm btn_illustration" type="button" data-bs-toggle="modal"
                                    data-bs-target="#addillustrationModal-${x}">
                                    Add Illustration
                                    </button>
                                    </div>
                                    </div>
                                    <div class="position-relative add_items_item">
                                    <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label">Gold Colour</label>
                                    </div>
                                    <ul class="gold_color gold_color_ul-${x}">

                                    @foreach($gold_colors as $key=>$value)
                                    <li class="nav-link">
                                    <a data-key="${x}" class="gold_color_id d-block"  name="repair_gold_color_id[]" value="{{ $key }}" >{{ $value }}</a>
                                    </li>
                                    @endforeach

                                    <input type="hidden" id="repair_gold_color_id-${x}" name="repair_gold_color_id[]" value="">
                                    <span class="field_error" id="repair_gold_color_id_error-${x}" style="color:red"> </span>
                                    </ul>
                                    </div>
                                    <div class="position-relative add_items_item">
                                    <div class="row">
                                    <div class="col-lg-6 col-md-6">
                                    <div class="form-group pt-0">
                                    <label for="exampleFormControlInput1" class="form-label">Additional Material</label>
                                    <input type="text" class="form-control" name="repair_material[]" id="repair_material-${x}" placeholder="Enter Material">
                                    <span class="field_error" id="repair_material_error-${x}" style="color:red"> </span>
                                    </div>
                                    </div>
                                    <div class="col-lg-6 col-md-6">
                                    <div class="form-group pt-0">
                                    <label for="exampleFormControlInput1" class="form-label">Quantity</label>
                                    <input type="text" class="form-control" name="repair_quantity[]" id="repair_quantity-${x}" placeholder="">
                                    <span class="field_error" id="repair_quantity_error-${x}" style="color:red"> </span>
                                    </div>
                                    </div>
                                    <div class="col-lg-12 col-md-12 col-12 mt-4">
                                    <div class="form-check">
                                    <input class="form-check-input" name="repair_customer_recieved-${x}" type="checkbox" id="repair_customer_recieved-${x}" value="1">
                                    <label class="form-check-label" for="gridCheck">
                                    Customer’s jewellery is received
                                    </label>
                                    </div>
                                    </div>
                                    <div class="checkout text-end">
                                    <button class="btn btn_confirm repair_confirm" data-type="repair" data-key="${x}" >Confirm</button>
                                    </div>
                                    </div>
                                    </div>
                                    </div>
                                    </div>
                                    </div>
                                    </div>
                                    </div>

                                    <div class="modal fade" id="addillustrationModal-${x}" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog illustration_dialog">
                                    <div class="modal-content">
                                    <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalLabel">Add Illustration</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    </div>
                                    <div class="modal-body">
                                    <div class="row">
                                    <div class="col-md-6 d-flex align-items-center">
                                    <div class="required_photo">
                                    <div class="dropzone dropZoneimageUpload" >
                                    <span class="drop-zone__prompt dz-default dz-message">
                                    <div>
                                    <p>Click here to add photo</p>
                                    <span>Photo Requiement:</span>
                                    <ul>
                                    <li>File type PNG or JPG</li>
                                    <li>Maximum Size: 500 KB</li>
                                    </ul>
                                    </div>
                                    </span>
                                    </div>
                                    </div>
                                    </div>

                                    <div class="col-lg-6">
                                    <div class="form-group modal_drawing pt-0">
                                    <div class="start-drawing" id="blackboardPlaceholder">
                                    <p>Start Drawing</p>
                                    <canvas id="drawingCanvas" width="500" height="230"></canvas>
                                    <div class="pen-eraser">
                                    <span class="pen" onclick="togglePenPointer();"><img
                                    src="{{ asset('public/img/pen.png') }}"/></span>
                                    <span class="erase" onclick="eraserHandler();"><img
                                    src="{{ asset('public/img/eraser.png') }}"/></span>
                                    </div>
                                    </div>
                                    <input type="hidden" id="drawing_textarea_base64-0"
                                    name="drawing_textarea_base64">
                                    </div>
                                    </div>

                                    <div class="col-lg-12">
                                    <div class="preview-droped-images">
                                    </div>
                                    </div>
                                    </div>
                                    </div>
                                    <div class="modal-footer">
                                    <button type="button" class="btn btn-primary btn-save illustration_btn">Save</button>
                                    </div>
                                    </div>
                                    </div>
                                    </div>



`)
                                @php
                                    $item_code =  \App\Models\Jewellery::getItemCodeArray();
                                @endphp

                        var item_code =  {!!  json_encode($item_code) !!};
                        $(".jewelley_item_code").autocomplete({
                            source: item_code, // list of items.
                        });


                        alertMessageRight(response.message, 'success');

                    } else {

                        alertMessageRight('Something went wrong', 'error');

                        $.each(response.errors, function (key, value) {
                            $("#" + key + "_error").html(value);
                            $("#" + key + "_error-" + x).html(value);

                        });

                    }
                },
                error: function () {

                }
            });


        });


        ///////////Delete quotation /////////////////
        $("body").delegate(".quotation_dlt", "click", function (e) {
            e.preventDefault();
            $_this = $(this);
            var index = $_this.attr('data-key');
            $('.content-' + index).remove();
            $('.item_select-' + index).remove();

            var quotation_price = 0;
            $(".amount").each(function () {
                let value = ($(this).val()) ? parseFloat($(this).val()) : 0;
                quotation_price = quotation_price + value;

            });
            subtotal_quot = 0;
            calculateTotal(quotation_price);

            var customer_append = $(".customer_append").children().length;

            if (customer_append == 0) {
                $(".empty_file").show();
                $("#total_bill").hide();
                $('#checkout_btn').show();
                $('#checkout_submit').hide();
            }


        });

        ///////////Edit inventory /////////////////
        $("body").delegate(".inventory_edit", "click", function (e) {
            e.preventDefault();

            $_this = $(this);
            var index = $_this.attr('data-key');
            $("#jewelley_item_code-" + index).attr('readonly', false);
            let parent_div_invent = $('#inventory_fields-' + index).find('.checkout')
            let btn_confirm_invent = parent_div_invent.find('.btn_confirm').show();
            parent_div_invent.children().removeClass('inventory_confirm');
            parent_div_invent.children().addClass('update_inventory');

        });

        ///////////Edit bespoke /////////////////
        $("body").delegate(".bespoke_edit", "click", function (e) {
            e.preventDefault();
            $_this = $(this);
            var index = $_this.attr('data-key');

            let parent_div_bespoke = $('#bespoke_fields-' + index).find('.checkout')
            let btn_confirm_bespoke = parent_div_bespoke.find('.btn_confirm').show();
            parent_div_bespoke.children().removeClass('bespoke_confirm');
            parent_div_bespoke.children().addClass('update_bespoke');

        });

        ///////////Edit Repair /////////////////
        $("body").delegate(".repair_edit", "click", function (e) {
            e.preventDefault();
            $_this = $(this);
            var index = $_this.attr('data-key');

            let parent_div_repair = $('#repair_fields-' + index).find('.checkout')
            let btn_confirm_repair = parent_div_repair.find('.btn_confirm').show();
            parent_div_repair.children().removeClass('repair_confirm');
            parent_div_repair.children().addClass('update_repair');

        });


        $(document).on("click", ".update_inventory", function (e) {

            e.preventDefault();
            $_this = $(this);
            let nameData = $("#nameData").val();
            let emailData = $("#emailData").val();
            let phoneData = $("#phoneData").val();
            let index = $_this.attr('data-key');
            let item_code = $("#jewelley_item_code-" + index).val();

            var thisHref = "{{route('quotations.getJewelleryByItemCode')}}";

            if (!thisHref || thisHref == '#') {
                return false;
            }

            $.ajax({
                url: thisHref,
                type: "json",
                data: {'item_code': item_code, 'name': nameData, 'email': emailData, 'phone': phoneData},
                type: 'GET',
                cache: false,

                beforeSend: function () {
                    $('.field_error').html('');
                },

                success: function (response) {
                    if (!response.errors) {

                        $("#jewelley_item_code-" + index).attr('readonly', true);
                        let price = (response.data.review_cost) ? response.data.review_cost.total : "";


                        let item_string = `18k ${ response.data.gold_color.name} ${response.data.category.name} (Small) Link chain`

                        $('#item_string_invent-' + index).text(item_string);
                        $('#item_code_str_invent-' + index).text(response.data.item_code);
                        $('#price-' + index).val(price);

                        <!--  -------hidden ------------  -->

                        $('#item_code_invent' + index).val(response.data.item_code);
                        $('#jewellery_id_invent-' + index).val(response.data.id);
                        $('#category_id_invent-' + index).val(response.data.category_id);


                        $(".empty_file").hide();
                        $("#total_bill").show();
                        $('#checkout_btn').hide();
                        $('#checkout_submit').show();

                         $_this.hide();

                        alertMessageRight(response.message, 'success');

                    } else {

                        $.each(response.errors, function (key, value) {
                            $("#" + key + "_error").html(value);
                            $("#" + key + "_error-" + x).html(value);
                        });
                        alertMessageRight(response.message, 'error');
                    }
                },
                error: function () {

                }
            });


        });


        $(document).on("click", ".update_bespoke", function (e) {

            e.preventDefault();
            $_this = $(this);
            let nameData = $("#nameData").val();
            let emailData = $("#emailData").val();
            let phoneData = $("#phoneData").val();

            let index = $_this.attr('data-key');

            //bespoke
            let category_id = $("#category_id-" + index).val();
            let description = $("#description-" + index).val();
            let gold_color_id = $("#gold_color_id-" + index).val();
            let material = $("#material-" + index).val();
            let quantity = $("#quantity-" + index).val();
            let customer_received = $(`input[id='customer_recieved-${index}']:checked`).val();
                customer_received = (customer_received) ? customer_received : 0;

            let drawing_textarea_base64 = $("#drawing_textarea_base64").val();
                drawing_textarea_base64 = (drawing_textarea_base64) ? drawing_textarea_base64 : null;

            var thisHref = "{{route('quotations.getBespokeData')}}";

            if (!thisHref || thisHref == '#') {
                return false;
            }
            let formData = {
                'name': nameData, 'email': emailData, 'phone': phoneData, 'category_id': category_id,
                'description': description, 'gold_color_id': gold_color_id, 'material': material, 'quantity': quantity,
                'customer_received': customer_received, 'drawing_textarea_base64': drawing_textarea_base64
            };

            $.ajax({
                url: thisHref,
                type: "json",
                data: formData,
                method: 'POST',
                cache: false,

                beforeSend: function () {
                    $('.field_error').html('');
                },

                success: function (response) {
                    console.log(response);

                    if (!response.errors) {

                        let item_string = `18k ${ response.data.goldColor_name} ${response.data.category_name} (Small) Link chain`;

                        $('#item_string_bespoke-' + index).text(item_string);

                        <!--  -------hidden ------------  -->
                        $('#category_id_bespoke-'+index).val(response.data.category_id);
                        $('#description_bespoke-'+index).val(response.data.description);
                        $('#gold_color_id_bespoke-'+index).val(response.data.gold_color_id);
                        $('#material_bespoke-'+index).val(response.data.material);
                        $('#quantity_bespoke-'+index).val(response.data.quantity);
                        $('#customer_received_bespoke-'+index).val(response.data.customer_received);

                        $(".images_fields-"+index).children().remove();
                        $(".dropzone_images-"+index).each(function () {
                            $(".images_fields"+index).append(`<input type="hidden" class="images_dropzone_bespoke-${index} " name="quotations[${index}][dropzone_images][]" value="${$(this).val()}">`);

                        });

                        $(".empty_file").hide();
                        $("#total_bill").show();
                        $('#checkout_btn').hide();
                        $('#checkout_submit').show();
                        $_this.hide();

                        alertMessageRight(response.message, 'success');

                    } else {

                        $.each(response.errors, function (key, value) {
                            $("#" + key + "_error").html(value);
                            $("#" + key + "_error-" + x).html(value);

                        });
                        alertMessageRight(response.message, 'error');
                    }
                },
                error: function () {

                }
            });


        });

        $(document).on("click", ".update_repair", function (e) {

            e.preventDefault();
            $_this = $(this);
            let nameData = $("#nameData").val();
            let emailData = $("#emailData").val();
            let phoneData = $("#phoneData").val();

            let index = $_this.attr('data-key');

            //Repair
            let category_id = $("#repair_category_id-"+index).val();
            let description = $("#repair_description-"+index).val();
            let gold_color_id = $("#repair_gold_color_id-"+index).val();
            let material = $("#repair_material-"+index).val();
            let quantity = $("#repair_quantity-"+index).val();
            let customer_received = $(`input[id='repair_customer_recieved-${index}']:checked`).val();
                customer_received = (customer_received) ? customer_received : 0;
            let drawing_textarea_base64 = $("#drawing_textarea_base64").val();
                drawing_textarea_base64 = (drawing_textarea_base64) ? drawing_textarea_base64 : null;

            var thisHref = "{{route('quotations.getRepairData')}}";

            if (!thisHref || thisHref == '#') {
                return false;
            }
            let formData = {
                'name': nameData, 'email': emailData, 'phone': phoneData,
                'repair_category_id': category_id, 'repair_description': description, 'repair_gold_color_id': gold_color_id, 'repair_material': material,
                'repair_quantity': quantity, 'repair_customer_received': customer_received,
                'drawing_textarea_base64': drawing_textarea_base64
            };

            $.ajax({
                url: thisHref,
                type: "json",
                data: formData,
                method: 'POST',
                cache: false,

                beforeSend: function () {
                    $('.field_error').html('');
                },
                success: function (response) {
                    if (!response.errors) {

                        let item_string = `18k ${ response.data.goldColor_name} ${response.data.category_name} (Small) Link chain`;

                        $('#item_string_repair-' + index).text(item_string);


                        console.log(response);
                        <!--  -------hidden ------------  -->
                        $('#category_id_repair-' + index).val(response.data.repair_category_id);
                        $('#description_repair-' + index).val(response.data.repair_description);
                        $('#gold_color_id_repair-' + index).val(response.data.repair_gold_color_id);
                        $('#material_repair-' + index).val(response.data.repair_material);
                        $('#quantity_repair-' + index).val(response.data.repair_quantity);
                        $('#customer_received_repair-' + index).val(response.data.repair_customer_received);

                        $(".images_fields-" + index).children().remove();
                        $(".dropzone_images-" + index).each(function () {
                            $(".images_fields" + index).append(`<input type="hidden" class="images_dropzone_repair-${index}" name="quotations[${index}][repair][dropzone_images][]" value="${$(this).val()}">`);

                        });

                        $(".empty_file").hide();
                        $("#total_bill").show();
                        $('#checkout_btn').hide();
                        $('#checkout_submit').show();
                        $_this.hide();

                        alertMessageRight(response.message, 'success');

                    } else {

                        $.each(response.errors, function (key, value) {
                            $("#" + key + "_error").html(value);
                            $("#" + key + "_error-" + x).html(value);

                        });
                        alertMessageRight(response.message, 'error');
                    }
                },
                error: function () {

                }
            });


        });




        $("body").delegate(".illustration_save", "click", function (e) {
            e.preventDefault();
             $_this =   $(this);
               var index = $_this.attr('data-key');
                 let parent_div = $_this.parent().parent();
                 let preview_div = parent_div.find('.preview-droped-images');
                preview_div.addClass('preview-quotations-images-'+x)

               $('#addillustrationModal-' + index).modal('hide');
        });



        ////////////checkout submit /////////////

        $("#submitQuotation").submit(function (e) {
            e.preventDefault();
            $_this = $(this);

            let formData = $(this).serialize();

            var thisHref = "{{route('quotations.quotationsStore')}}";

            if (!thisHref || thisHref == '#') {
                return false;
            }

            $.ajax({
                url: thisHref,
                type: "json",
                data: formData,
                type: 'POST',
                cache: false,
                beforeSend: function () {
                    $('.field_error').html('');
                },

                success: function (response) {

                    if (!response.errors) {

                        if(response.status){
                            let quotationId = response.data.id;
                            let printRoute = "{{ route('quotations.print') }}";
                            let printHref = printRoute + '/' + quotationId;
                            $('#print_btn').attr('href', printHref);
                        }
                        // alertMessageRight(response.message, 'success');
                    } else {

                        $.each(response.errors, function (key, value) {
                            $("#" + key + "_error").html(value);
                            $("#" + key + "_error-" + x).html(value);

                        });

                        alertMessageRight(response.message, 'error');
                        ($_this).find(':input[type=submit]').prop('disabled', false);
                    }
                },
                error: function () {
                    ($_this).find(':input[type=submit]').prop('disabled', false);
                }

            });
        });

        $("body").delegate(".amount", "input", function () {
            var quotation_price = 0;
            $(".amount").each(function () {
                let value = ($(this).val()) ? parseFloat($(this).val()) : 0;
                quotation_price = quotation_price + value;

            });

            subtotal_quot = 0;
            calculateTotal(quotation_price);

        });


        function calculateTotal(price) {

            subtotal_quot = parseFloat(subtotal_quot) + parseFloat(price);
            subtotal_quot = subtotal_quot.toFixed(3);

            let gst_amount_quot = 0;
            gst_amount_quot = subtotal_quot * 7 / 100;
            gst_amount_quot = gst_amount_quot.toFixed(3);

            let total_quot = parseFloat(subtotal_quot) + parseFloat(gst_amount_quot);
            total_quot = total_quot.toFixed(3);

            $("#subtotal_quotation").text(subtotal_quot);
            $("#gst_quotation").text(gst_amount_quot);
            $("#total_quotation").text(total_quot);

            $("#quot_subtotal").val(subtotal_quot);
            $("#quot_gst_percent").val("7");
            $("#quot_gst_amount").val(gst_amount_quot);
            $("#quot_total").val(total_quot);
        }

       });


</script>


