<script type="text/javascript">
  $('.convert_to_invoice').on('click', function(e) {
    e.preventDefault();
    var thisHref = $(this).attr('data-attr');
    var id = $(this).attr('data-id');

    $.ajax({
      url: thisHref,
      type: "json",
      data:{ id:id },
      method: 'POST',
      cache: false,
      success: function (response) {
        if (response.status) {
          alertMessageRight(response.message, 'success');
          let invoiceId = response.data.id;
          let printRoute = "{{ route('invoices.printInvoice') }}";
          let printHref = printRoute + '/' + invoiceId;
          $('.btn_print').attr('href', printHref);
          $('#invoice_id').val(invoiceId);
          $('#paid_amount').val(response.data.paid_amount);
          $("#invoice").modal('show');
          if(response.data.customer.is_vip == 1){
            $('.layaway_click').removeClass('no_vip');
          } 
        }else{
          alertMessageRight(response.message, 'error');
        }
      }    
    });
  });

  $('.full_payment').click(function(){
    var invoice_id = $('#invoice_id').val();
    var paid_amount = $('#paid_amount').val();
    $('#loader').show();

    updatePayment(invoice_id,paid_amount);
  });

  $('.layaway_click').click(function(){
    $('.layaway_amount').show();
    $('.layaway_amount').addClass('active')
    $('.btn_print').addClass('printActive')
  });

  $('.layaway_amount').on('focusout',function(){
    var invoice_id = $('#invoice_id').val();
    var paid_amount = $('#paid_amount').val();
    $('#loader').show();
    
    updatePayment(invoice_id,paid_amount);
    $('#paid_amount').val('');
    // $('.layaway_amount').hide();
  });
    
  function updatePayment(invoice_id,paid_amount){
    $.ajax({
      url: "{{ route('invoices.updatePayment') }}",
      type: "json",
      data: {'invoice_id':invoice_id,'paid_amount':paid_amount},
      method: 'POST',
      cache: false,
      success: function (response) {
        console.log(response); 
        $('#loader').hide();
        if(response.status == 1){
          alertMessageRight(response.message, 'success');
          $('.btn_print').addClass('printActive');
          $('.btn_print').removeClass('no_print');
        }else{
          alertMessageRight(response.message,'error');
        }
      }
    });
  }

  $('body').on('hidden.bs.modal','#invoice',function(){
    location.href = "{{ route('invoices.todaysSales') }}" 
  });
</script>
