@php 
use App\Models\Quotation;
@endphp

@extends('layouts.master')
@section('title', "Quotations")
@section('header', "Quotations")

@section('content')
	<form id="quotattionItemsForm" method="POST">
		@csrf

		<input type="hidden" name="quotation_id" value="{{ $quotation_id }}" />

		<div class="today_sale_main pb-5">
			<div class="dasboard-menu-item ps-0">
				<div class="today_sale_heading">
					<div class="create_quote_link today_sale">
						@include('frontend.elements.layouts.time_date_user_details')
					</div>

					<div class="today_sale_detail">
						<div class="card-body">
							<div class="earring-table sale_detail_main table-responsive">
								<table class="table stock-detail sale-detail">
									<thead>
										<tr>
											<th>
												<input class="form-check-input form-check-minus" style="border: 2px solid #555;" type="checkbox">
											</th>
											<th>@sortablelink('item_code', __('content.item_code'))</th>
											<th>{{ __('content.type') }}</th>
											<th>{{ __('content.image') }}</th>
											<th>@sortablelink('gold_color_id', __('content.gold_colour'))</th>
											<th>@sortablelink('sub_total', __('content.amount'))</th>
											<th>{!! __('content.customer_name_with_br') !!}</th>
											<th>{!! __('content.customer_email_with_br') !!}</th>
											<th>{!! __('content.customer_phone_no_with_br') !!}</th>

											@if($type == Quotation::TYPE_BESPOKE_AND_REPAIR)
												<th>{{ __('content.action') }}</th>
											@endif
										</tr>
									</thead>
									<tbody>
										
										@forelse($record->quotation_item as $key => $quotationItem)
											<tr>
												@php $exist_invoice = App\Models\InvoiceItem::checkInvoiceByQuotationItem($quotationItem->id) ;@endphp
												<td>
													<input class="form-check-input" style="border: 2px solid #555;" type="checkbox" name="qut_item_ids[]" value="{{ $quotationItem->id }}" {{ ($exist_invoice) ? "disabled": " "}} >
												</td>
												<td>{{ $quotationItem->item_code ?? '-' }}</td>
												<td>{{ $quotationItem->type_name ?? '-' }}</td>
												<td>
													<a href="javascript:void(0);" class="view_image" data-record_id="{{ $quotationItem->id }}">View</a>
													<!-- data-bs-toggle="modal" data-bs-target="#img-Modal" -->
												</td>
												<td>{{ isset($quotationItem->gold_color_id) ? $quotationItem->gold_color->name : '-' }}</td>
												<td>{{ !empty($quotationItem->sub_total) ? '$'.number_format($quotationItem->sub_total) : '-' }}</td>

												<td>{{ isset($quotationItem->quotation->customer_name) ? ucwords($quotationItem->quotation->customer_name) : (isset($quotationItem->quotation->customer_id) ? ucwords($quotationItem->quotation->customer->fullname) : '-') }}</td>
												<td>{{ isset($quotationItem->quotation->customer_email) ? $quotationItem->quotation->customer_email : (isset($quotationItem->quotation->customer_id) ? $quotationItem->quotation->customer->email : '-') }}</td>
												<td>{{ isset($quotationItem->quotation->customer_phone) ? $quotationItem->quotation->customer_phone : (isset($quotationItem->quotation->customer_id) ? $quotationItem->quotation->customer->phone : '-') }}</td>

												@if($type == Quotation::TYPE_BESPOKE_AND_REPAIR)
													<td>
														<a href="javascript:void(0);{{-- route('jobs.printJob', $quotationItem->job_id) --}}" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-custom-class="custom-tooltip" data-bs-title="Print Job Order" class="red-tooltip">
						                                    <img src="{{ asset('public/img/print.png') }}">
						                                </a>
													</td>
												@endif
											</tr>
										@empty
		                                    <tr>
		                                        <td class="text-center" colspan="{{ ($type == Quotation::TYPE_BESPOKE_AND_REPAIR) ? '7' : '6' }}">No Record Found!</td>
		                                    </tr>
	                                    @endforelse
									</tbody>
								</table>
							</div>
						</div>
					</div>

					<div class="buttons buttons_1">
	                    @if($type == Quotation::TYPE_INVENTORY)
	                    	<a class="btn btn-primary btn-create btn-full submitForm" type="button" data-action="{{ route('quotations.createInvoice') }}">Create Invoice</a>
	                    @elseif($type == Quotation::TYPE_BESPOKE_AND_REPAIR)
	                    	<button class="btn btn-primary btn-create btn-full sendToJobOrder" type="button" data-action="{{ route('quotations.sendToJobOrder') }}">Send to Job Order</button>
	                    @endif
	                </div>
				</div>
			</div>
		</div>
	</form>

	@include('frontend.invoices.pay_amount_with_print_invoice_popup') 
	@include('frontend.quotations.scripts.send_to_job_order') 
	@include('frontend.quotations.image_popup')

	<script>
		$(function(){
			$('.submitForm').on('click', function(e){
				e.preventDefault();

				var formData = $('#quotattionItemsForm').serialize();
				var formAction = $(this).data('action');

		        $.ajax({
		            url: formAction,
		            type: "POST",
		            cache: false,
		            data: formData,
		            dataType: 'json',
		            success:function(res){
			            if(res.errors){
			                error(res.errors, res.title); 
			            }

			            if (res.status == 0) {
			                error(res.errors, res.title); 
			            }else if (res.status == 1) {
			                $("#quotattionItemsForm")[0].reset(); 

			                let invoiceId = res.data.id;
					        let printRoute = "{{ route('invoices.printInvoice') }}";
					        let printHref = printRoute + '/' + invoiceId;
					        $('.btn_print').attr('href', printHref);
					        $('#invoice_id').val(invoiceId);
					        $('#full_paid_amount').val(res.data.total);
					        $("#invoice").modal('show');
					        if(res.data.customer.is_vip == 1){
					            $('.layaway_click').removeClass('no_vip');
					        } 
			                success(res.message, res.title);
			            }
		            },
		            error: function(response) {
		            	$('#message-error').text(response.responseJSON.errors.message);
		            }
		        });
			});
		});
        
	</script>

@endsection



