@php
use App\Models\QuotationItem;
@endphp

@extends('layouts.master')
@section('title', "Quotations")
@section('header', "Quotations")

@section('content')
    
<div class="today_sale_main pb-5">
    <div class="dasboard-menu-item ps-0">
        <div class="today_sale_heading">
            <div class="create_quote_link today_sale py-4">
                <span class="d-flex align-items-center create_span">
                    <img src="{{ asset('public/img/create_quotation.png') }}" />
                    <a href="javascript:void(0);">{{ __('content.todays_quotaions') }}</a>
                </span>

                @include('frontend.elements.layouts.time_date_user_details')

            </div>

            <div class="total_invoice_main d-flex align-items-center justify-content-between">
                <div class="total_invoice_wise d-flex align-items-center">
                    <div class="total_invoice">
                        <p>{!! __('content.bespoke_with_br') !!}
                        {{-- nl2br(e('Bespoke \n定制')) --}}</p>
                        <h3>{{ $todayBespokeCount }}</h3>
                    </div>
                    <div class="total_invoice">
                        <p>{!! __('content.repair_with_br') !!}</p>
                        <h3>{{ $todayRepairCount }}</h3>
                    </div>
                    <div class="total_invoice">
                        <p>{!! __('content.inventory_with_br') !!}</p>
                        <h3>{{ $todayInventoryCount }}</h3>
                    </div>
                </div>
                <div class="total_amount_todal_sale">
                    <p>Amount Transacted  (based on Invoice)</p>
                    <h3>$ {{ $inventoryOrders->sum('sub_total') + $bespokeAndRepairOrders->sum('sub_total') }}</h3>
                </div>
            </div>
        </div>
    </div>
</div>

{{-- dd($record) --}}

<div class="inventory_detail">
    @php
        $activeTab = !empty(request()->tab) ? request()->tab : null ;
        $tabInventory = QuotationItem::TAB_INVENTORY;
        $tabBespokeAndRepair = QuotationItem::TAB_BESPOKE_AND_REPAIR;
    @endphp
    <ul class="nav nav-tabs nav-pills nav-justified quotation_inventory_" id="myTab" role="tablist">
        <li class="nav-item" role="presentation">
         <!--  <button class="nav-link {{-- (($activeTab == $tabInventory) ||  ($activeTab == null)) ? 'active' : '' --}}" id="inventory-tab" data-bs-toggle="tab" data-bs-target="#inventory-tab-pane" type="button" role="tab" aria-controls="inventory-tab-pane" aria-selected="true">Inventory</button> -->

          <a href="{{route('quotations.todaysOrders', [ 'tab' =>
            QuotationItem::TAB_INVENTORY ]) }}" class="nav-link {{ ($tab == QuotationItem::TAB_INVENTORY) ? 'active' : '' }}" id="table-tab">Inventory</a>
        </li>
        <li class="nav-item" role="presentation">
          <!-- <button class="nav-link {{-- ($activeTab == $tabBespokeAndRepair) ? 'active' : '' --}}" id="bespoke_and_repair-tab" data-bs-toggle="tab" data-bs-target="#bespoke_and_repair-tab-pane" type="button" role="tab" aria-controls="bespoke_and_repair-tab-pane" aria-selected="false">Bespoke and Repair</button> -->

          <a href="{{ route('quotations.todaysOrders', [ 'tab' => QuotationItem::TAB_BESPOKE_AND_REPAIR ]) }}" class="nav-link {{ ($tab == QuotationItem::TAB_BESPOKE_AND_REPAIR) ? 'active' : '' }}" id="table-tab">Bespoke and Repair</a>
        </li>
    </ul>
    <div class="inventory_detail_main">
        <div class="tab-content" id="myTabContent">
            @if($tab == $tabInventory)
                <!-- <div class="tab-pane fade {{-- (($activeTab == $tabInventory) ||  ($activeTab == null)) ? 'show active' : '' --}}" id="inventory-tab-pane" role="tabpanel" aria-labelledby="inventory-tab" tabindex="0"> -->
                <div class="">
                    <div class="today_sale_detail">
                        <div class="card-body">
                            <div class="earring-table sale_detail_main table-responsive">
                                <table class="table stock-detail sale-detail">
                                    <thead>
                                        <tr>
                                            <th>@sortablelink('reference_date', __('content.date'))</th>
                                            <th>@sortablelink('id', __('content.quotation_id'))</th>
                                            <th>{{ __('content.type') }}</th>
                                            <th>@sortablelink('total', __('content.amount'))</th>
                                            <th>@sortablelink('customer_name', __('content.customer'))</th>

                                            {{-- @canany(['frontQuotation-convertToInvoice','frontQuotation-printOrderVoucher','frontQuotation-print','frontQuotation-sendEmailPDF']) --}}
                                            @canany(['frontQuotation-printOrderVoucher','frontQuotation-print','frontQuotation-sendEmailPDF'])
                                            <th>{{ __('content.action') }}</th>
                                            @endcanany
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($inventoryOrders as $record)
                                        @php $newQutNo = $record->quotation_no."-1"; @endphp
                                        <tr>
                                            <td>{{ isset($record->reference_date) ? date('d/m/Y', strtotime($record->reference_date)) : '-' }}</td>
                                            <td>
                                                <a href="{{ route('quotations.showItemsList', ['quotation_id'=>$record->id, 'type'=>$tab]) }}" class="view_link">
                                                    @if(!empty($record->quotation_no)) 
                                                        @if($record->bespokeAndRepairCount > 0) 
                                                            {{ $newQutNo }} 
                                                        @else
                                                            {{ $record->quotation_no }}
                                                        @endif
                                                    @else 
                                                        -
                                                    @endif
                                                </a>
                                            </td>
                                            <td>Inventory</td>
                                            <td>{{ !empty($record->total) ? '$'.number_format($record->total) : '-' }}</td>
                                            <td>{{ isset($record->customer_name) ? ucwords($record->customer_name) : (isset($record->customer_id) ? ucwords($record->customer->fullname) : '-') }}</td>
                                            <td>
                                                <div class="dropdown">
                                                    {{-- @canany(['frontQuotation-convertToInvoice','frontQuotation-printOrderVoucher','frontQuotation-print','frontQuotation-sendEmailPDF'])   --}}
                                                    @canany(['frontQuotation-printOrderVoucher','frontQuotation-print','frontQuotation-sendEmailPDF'])  
                                                    <button class="btn btn-secondary down" type="button" id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false">
                                                            Action
                                                        </button>
                                                    @endcanany

                                                    <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="dropdownMenuButton1">

                                                        {{-- @can('frontQuotation-convertToInvoice') 
                                                            <li>
                                                                <a class="dropdown-item duplicate convert_to_invoice" data-attr="{{ route('quotations.convertToInvoice') }}" data-id="{{ $record->id }}" href="javascript:void(0)"><img src="{{ asset('public/img/convert_invoice.png') }}">Convert to Invoice</a>
                                                            </li>
                                                        @endcan --}}

                                                        @can('frontQuotation-printOrderVoucher') 
                                                            <li>
                                                                <a class="dropdown-item btnprn" href="{{ route('quotations.printOrderVoucher', $record->id) }}"><img src="{{ asset('public/img/print.png') }}">Print Order Voucher</a>
                                                            </li>
                                                        @endcan

                                                        @can('frontQuotation-print') 
                                                        <li>
                                                            <a class="dropdown-item" href="{{ route('quotations.printQuotation', $record->id) }}"><img src="{{ asset('public/img/print.png') }}">Print Quotation</a>
                                                        </li>
                                                        @endcan

                                                        @can('frontQuotation-sendEmailPDF')
                                                        <li>
                                                            <a class="dropdown-item sendEmailPDF" href="javascript:void(0);{{-- route('quotations.sendEmailPDF', $record->id) --}}" id="sendEmailPDF-{{ $record->id }}" data-record_id="{{ $record->id }}" data-for="quotations"><img src="{{ asset('public/img/envelope.png') }}">Send email </a>
                                                        </li>
                                                        @endcan

                                                    </ul>
                                                </div>
                                            </td>
                                        </tr>
                                        @empty
                                        <tr>
                                            <td class="text-center" colspan="6">No Record Found!</td>
                                        </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>

                            <div class="row mt-4">
                                <div class="col-sm-12 col-md-5 pl-4 d-flex justify-content-start">
                                    <div class="dataTables_info" id="bs4-table_info" role="status" aria-live="polite">
                                        Page {{ $inventoryOrders->currentPage() }} of {{ $inventoryOrders->lastPage() }}, showing {{ $inventoryOrders->count() }} record(s) out of {{ $inventoryOrders->total() }} total
                                    </div>
                                </div>

                                <div class="col-sm-12 col-md-7 d-flex justify-content-end">
                                    <div class="dataTables_paginate paging_simple_numbers float-right" id="bs4-table_paginate">
                                        {!! $inventoryOrders->appends(Request::except('page'))->links() !!}
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            @elseif($tab == $tabBespokeAndRepair)
                <!-- <div class="tab-pane fade {{-- ($activeTab == $tabBespokeAndRepair) ? 'show active' : '' --}}" id="bespoke_and_repair-tab-pane" role="tabpanel" aria-labelledby="bespoke_and_repair-tab" tabindex="0"> -->
                <div class="">
                    <div class="today_sale_detail">
                        <div class="card-body">
                            <div class="earring-table sale_detail_main table-responsive">
                                <table class="table stock-detail sale-detail">
                                    <thead>
                                        <tr>
                                            <th>@sortablelink('reference_date', __('content.date'))</th>
                                            <th>@sortablelink('id', __('content.quotation_id'))</th>
                                            <th>{{ __('content.type') }}</th>
                                            <th>@sortablelink('total', __('content.amount'))</th>
                                            <th>@sortablelink('customer_name', __('content.customer'))</th>
                                            {{-- @canany(['frontQuotation-convertToInvoice','frontQuotation-printOrderVoucher','frontQuotation-print','frontQuotation-sendEmailPDF'])   --}}
                                            @canany(['frontQuotation-printOrderVoucher','frontQuotation-print','frontQuotation-sendEmailPDF'])  
                                            <th>{{ __('content.action') }}</th>
                                            @endcanany

                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($bespokeAndRepairOrders as $record)
                                        @php $newBespokeQutNo = $record->quotation_no."-2"; 
                                        @endphp
                                        <tr>
                                            <td>{{ isset($record->reference_date) ? date('d/m/Y', strtotime($record->reference_date)) : '-' }}</td>
                                            <td><a href="{{ route('quotations.showItemsList',['quotation_id'=>$record->id, 'type'=>$tab]) }}" class="view_link">{{ $record->quotation_no ? (($record->inventoryCount > 0) ? $newBespokeQutNo : $record->quotation_no) : '-' }}</a></td>
                                            <td>Bespoke Or Repair</td>
                                            <td>{{ !empty($record->total) ? '$'.number_format($record->total) : '-' }}</td>
                                            <td>{{ isset($record->customer_name) ? ucwords($record->customer_name) : (isset($record->customer_id) ? ucwords($record->customer->fullname) : '-') }}</td>
                                            <td>
                                                <div class="dropdown">
                                                    {{-- @canany(['frontQuotation-convertToInvoice','frontQuotation-printOrderVoucher','frontQuotation-print','frontQuotation-sendEmailPDF'])   --}}
                                                    @canany(['frontQuotation-printOrderVoucher','frontQuotation-print','frontQuotation-sendEmailPDF'])  
                                                    <button class="btn btn-secondary down" type="button"nid="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false">
                                                        Action
                                                    </button>
                                                    @endcanany

                                                    <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="dropdownMenuButton1">

                                                        <!-- <li><a class="dropdown-item duplicate" href="javascript:void(0);"><img src="{{ asset('public/img/hammer.png') }}">Send to Job Order</a></li> -->
                                                        {{-- @can('frontQuotation-convertToInvoice')
                                                            <li>
                                                                <a class="dropdown-item duplicate convert_to_invoice" data-attr="{{ route('quotations.convertToInvoice') }}" data-id="{{ $record->id }}" href="javascript:void(0)"><img src="{{ asset('public/img/convert_invoice.png') }}">Convert to Invoice</a>
                                                            </li>
                                                        @endcan  --}}
                                                        
                                                        @can('frontQuotation-printOrderVoucher')
                                                            <li>
                                                                <a class="dropdown-item" href="{{ route('quotations.printOrderVoucher', $record->id) }}"><img src="{{ asset('public/img/print.png') }}">Print Order Voucher</a>
                                                            </li>
                                                        @endcan 

                                                        @can('frontQuotation-print')
                                                            <li>
                                                                <a class="dropdown-item btnprn" href="{{ route('quotations.printQuotation', $record->id) }}"><img src="{{ asset('public/img/print.png') }}">Print Quotation</a>
                                                            </li>
                                                        @endcan

                                                        @can('frontQuotation-print')
                                                            <li>
                                                                <a class="dropdown-item sendEmailPDF" href="javascript:void(0);{{-- route('quotations.sendEmailPDF', $record->id) --}}" id="sendEmailPDF-{{ $record->id }}" data-record_id="{{ $record->id }}" data-for="quotations"><img src="{{ asset('public/img/envelope.png') }}">Send email</a>
                                                            </li>
                                                        @endcan

                                                    </ul>
                                                </div>
                                            </td>
                                        </tr>
                                        @empty
                                        <tr>
                                            <td class="text-center" colspan="7">No Record Found!</td>
                                        </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>

                            <div class="row mt-4">
                                <div class="col-sm-12 col-md-5 pl-4 d-flex justify-content-start">
                                    <div class="dataTables_info" id="bs4-table_info" role="status" aria-live="polite">
                                        Page {{ $bespokeAndRepairOrders->currentPage() }} of {{ $bespokeAndRepairOrders->lastPage() }}, showing {{ $bespokeAndRepairOrders->count() }} record(s) out of {{ $bespokeAndRepairOrders->total() }} total
                                    </div>
                                </div>

                                <div class="col-sm-12 col-md-7 d-flex justify-content-end">
                                    <div class="dataTables_paginate paging_simple_numbers float-right" id="bs4-table_paginate">
                                        {!! $bespokeAndRepairOrders->appends(Request::except('page'))->links() !!}
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            @endif
        </div>
    </div>
</div>

@include('frontend.invoices.pay_amount_with_print_invoice_popup') 


@include('frontend.elements.scripts.pdf_email_js')  

{{-- @include('frontend.invoices.layway_popup') --}}

{{-- @include('frontend.quotations.scripts.convert_to_invoice_js') --}}

{{-- @include('frontend.quotations.script') --}}

@endsection

