@extends('layouts.master')
@section('title',"Create Quotation")
@section('header', "Create Quotation")

@section('content')
	<div class="container">
    	<div class="row">
    		<div class="col-md-6 d-flex align-items-center">
    			<div class="required_photo">
    				<div class="dropzone dropZoneimageUpload"  >
                        <span class="drop-zone__prompt dz-default dz-message">
                            <div>
                                <p>Click here to add photo</p>
                                <span>Photo Requiement:</span>
                                <ul>
                                    <li>File type PNG or JPG</li>
                                    <li>Maximum Size: 2 MB</li>
                                </ul>
                            </div>
                        </span>
    				</div>
    			</div>
    		</div>

    		<div class="col-lg-12">
    			{{--<div class="preview-droped-images">--}}
    			{{--</div>--}}
    		</div>

    		<div class="col-lg-6">
    			<div class="required_photo">
    				<div class="dropzone dropZoneimageUpload"  >
                        <span class="drop-zone__prompt dz-default dz-message">
                            <div>
                                <p>Click here to add photo</p>
                                <span>Photo Requiement:</span>
                                <ul>
                                    <li>File type PNG or JPG</li>
                                    <li>Maximum Size: 2 MB</li>
                                </ul>
                            </div>
                        </span>
    				</div>
    			</div>
    		</div>

    		<div class="col-lg-12">
    			{{--<div class="preview-droped-images">--}}
    			{{--</div>--}}
    		</div>
    	</div>
	</div>

	<script>
        $(".dropZoneimageUpload").dropzone({

            headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
            acceptedFiles: ".jpg,.png,",
            maxFiles: 10,
            maxFilesize: 0.5,
            maxThumbnailFilesize: 1,
            autoProcessQueue: true,
            addRemoveLinks: true,
            url: "{{ route('quotations.dropzoneStore') }}",

            sending: function (file, xhr, formData) {

                formData.append('table', TABLENAME);

                $(file.previewElement).append($('<div class="upload_progress" id="upload_progress"><div class="progress"><div class="progress-bar" role="progressbar" aria-valuenow="75" aria-valuemin="0" aria-valuemax="100" style="width:70%"> </div> </div> </div>'));

                if (xhr.upload) {
                    xhr.upload.addEventListener('progress', function (event) {
                        var percent = 0;
                        var position = event.loaded || event.position;
                        var total = event.total;
                        if (event.lengthComputable) {
                            percent = Math.ceil(position / total * 100);
                        }
                        //update progressbar
                        $("#upload_progress .progress-bar").css("width", +percent + "%").html(+percent + "%");
                    }, true);
                }
                return xhr;
            },

            init: function () {
                this.on("error", function (file, response) {
                    alertMessageRight(response, 'error');
                    this.removeFile(file);
                });

            },

            success: function (file, response) {

                $(file.previewElement).append($(`<input type="hidden" name="images[]" class="dropzone_images-${x}"  value="${response.file}">`));
                $(file.previewElement.querySelector("#upload_progress")).hide();
            },

        });


        $('.remove_button').click(function () {
            $(this).parent().remove();
        });
	</script>

@endsection
