@php
$inventory = \App\Models\QuotationItem::INVENTORY;
$bespoke = \App\Models\QuotationItem::BESPOKE;
$repair = \App\Models\QuotationItem::REPAIR;
$buttonIndex = $buttonIndex+1;
@endphp

<div class="content-{{ $buttonIndex }}">
    <div class="card-body create_quotation custom-create-quote">
        <div class="add_item add_item_custom">
            <div class="items">
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="exampleFormControlInput1" class="form-label head">{!! __('content.add_item_from_with_br') !!}</label>
                        </div>
                    </div>
                    <div class="col-md-9">
                        <ul class="nav nav-tabs ms-auto">
                            <li class="nav-item" role="presentation">
                                <button id="inventory-{{ $buttonIndex }}"  type="button"  class="nav-link  inventory qutation_type" data-id="{{ $inventory }}">{!! __('content.inventory_with_br') !!}</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button id="bespoke-{{ $buttonIndex }}"  type="button"  class="nav-link bespoke qutation_type" data-id="{{ $bespoke }}">{!! __('content.bespoke_with_br') !!}</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button id="repair-{{ $buttonIndex }}"  type="button"  class="nav-link repair qutation_type" data-id="{{ $repair }}">{!!  __('content.repair_with_br') !!}</button>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="card-body create_quotation" id="inventory_fields-{{ $buttonIndex }}" style="display: none;">
        <div class="add_item">
            <div class="items">
                <div class="tab-content add_items_content content-{{ $buttonIndex }}">
                    <div class="position-relative add_items_item mt-0">
                        <div class="search">
                            <img src="{{ asset('public/img/search.png') }}">
                            <input type="text" name="qut[{{ $buttonIndex }}][{{ $inventory }}][item_code]" class="form-control cus_form_control jewelley_item_code" id="jewelley_item_code-{{ $buttonIndex }}" placeholder="Enter or Search Item Code">
                            <span class="field_error" id="item_code_error-{{ $buttonIndex }}" style="color:red"> </span>
                        </div>

                        <div class="checkout text-end">
                            <button class="btn btn_confirm inventory_confirm" type="button" data-type="{{ $inventory }}" data-key="{{ $buttonIndex }}">{!! __('content.confirm_with_br') !!}</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="card-body create_quotation" id="bespoke_fields-{{ $buttonIndex }}" style="display: none;">
        <div class="add_item add_item_custom">
            <div class="items">
                <div class="tab-content add_items_content content-{{ $buttonIndex }}">
                    <div class="add_items_bespoke mt-0">
                        <div class="position-relative add_items_item">
                            <div class="form-group">
                                <label for="exampleFormControlInput1" class="form-label">Category</label>
                            </div>
                            <ul class="bespoke_category_ul-{{ $buttonIndex }}">
                                @php
                                    $categories = \App\Models\Category::getCategories();
                                    $gold_colors = \App\Models\GoldColor::getGoldColorsList();
                                @endphp
                                @foreach($categories as $key=>$value)
                                    <li class="nav-link ">
                                        <a data-key="{{ $buttonIndex }}" data-type="{{ $bespoke }}" class="category_id d-block"  value= "{{ $value->id }}" >{{ __('content.'.strtolower($value->name)) }}</a>
                                    </li>
                                @endforeach
                                <input type="hidden" id="bespoke_category_id-{{ $buttonIndex }}" name="qut[{{ $buttonIndex }}][{{ $bespoke }}][category_id]"  value="">
                                <span class="field_error" id="bespoke_category_id_error-{{ $buttonIndex }}"> </span>
                            </ul>
                        </div>
                        <div class="position-relative add_items_item">
                            <div class="form-group">
                                <label for="exampleFormControlInput1" class="form-label">{{ __('content.description')}}</label>
                                <input type="text" id="bespoke_description-{{ $buttonIndex }}" name="qut[{{ $buttonIndex }}][{{ $bespoke }}][description]" class="form-control" placeholder="Enter description...">
                                <span class="field_error" id="bespoke_description_error-{{ $buttonIndex }}"> </span>
                            </div>
                            <div class="checkout text-start">
                                <button class="btn btn_confirm btn_illustration bespokeIllustrationModal-{{ $buttonIndex }}" data-key="{{ $buttonIndex }}" type="button" data-bs-toggle="modal"
                                        data-bs-target="#bespokeIllustrationModal-{{ $buttonIndex }}">
                                    Add Illustration
                                </button>
                            </div>
                        </div>
                        <div class="position-relative add_items_item">
                            <div class="form-group">
                                <label for="exampleFormControlInput1" class="form-label">{{ __('content.gold_colour') }}</label>
                            </div>
                            <ul class="gold_color bespoke_gold_color_ul-{{ $buttonIndex }}">
                                @foreach($gold_colors as $key=>$value)
                                    @php
                                      $val = strtok($value," ");
                                    @endphp
                                    <li class="nav-link">
                                        <a data-key="{{ $buttonIndex }}" data-type="{{ $bespoke }}" class="gold_color_id d-block"  value="{{ $key }}" >{{ __('content.'.strtolower($val)) }}</a>
                                    </li>
                                @endforeach
                                <input type="hidden" id="bespoke_gold_color_id-{{ $buttonIndex }}" name="qut[{{ $buttonIndex }}][{{ $bespoke }}][gold_color_id]"  value="">
                                <span class="field_error" id="bespoke_gold_color_id_error-{{ $buttonIndex }}"> </span>
                            </ul>
                        </div>
                        <div class="position-relative add_items_item">
                            <div class="row">
                                <div class="col-lg-6 col-md-6">
                                    <div class="form-group pt-0">
                                        <label for="exampleFormControlInput1" class="form-label">{{ __('content.additional_material') }}</label>
                                        <input type="text" class="form-control" id="bespoke_material-{{ $buttonIndex }}" name="qut[{{ $buttonIndex }}][{{ $bespoke }}][material]"  placeholder="Enter material">
                                        <span class="field_error" id="bespoke_material_error-{{ $buttonIndex }}"> </span>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-6">
                                    <div class="form-group pt-0">
                                        <label for="exampleFormControlInput1" class="form-label">{{ __('content.quantity') }} </label>
                                        <input type="text" class="form-control" id="bespoke_quantity-{{ $buttonIndex }}" name="qut[{{ $buttonIndex }}][{{ $bespoke }}][quantity]"  placeholder="">
                                        <span class="field_error" id="bespoke_quantity_error-{{ $buttonIndex }}"> </span>  </div>
                                </div>
                                <div class="col-lg-12 col-md-12 col-12 mt-4">
                                    <div class="form-check">
                                        <input class="form-check-input" value="1" name="qut[{{ $buttonIndex }}][{{ $bespoke }}][customer_received]"  type="checkbox" id="bespoke_customer_received-{{ $buttonIndex }}">
                                        <label class="form-check-label" for="gridCheck">
                                            {{ __('content.jewellry_received') }}
                                        </label>
                                    </div>
                                </div>
                                <div class="checkout text-end">
                                    <button class="btn btn_confirm bespoke_repair_confirm" type="button" data-type="{{ $bespoke }}" data-key="{{ $buttonIndex }}" >{!! __('content.confirm_with_br') !!}</button>
                                    {{--<button class="btn btn_confirm">Confirm</button>--}}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="card-body create_quotation" id="repair_fields-{{ $buttonIndex }}" style="display: none;">
        <div class="add_item add_item_custom">
            <div class="items">
                <div class="tab-content add_items_content">
                    <div class="add_items_bespoke mt-0">

                        <div class="position-relative add_items_item">
                            <div class="form-group">
                                <label for="exampleFormControlInput1" class="form-label">Category</label>
                            </div>
                            <ul class="repair_category_ul-{{ $buttonIndex }}">

                                @php
                                    $categories = \App\Models\Category::getCategories();
                                    $gold_colors = \App\Models\GoldColor::getGoldColorsList();

                                @endphp
                                @foreach($categories as $key=>$value)
                                    <li class="nav-link ">
                                        <a  data-key="{{ $buttonIndex }}" data-type="{{ $repair }}" class="category_id d-block"  value= "{{ $value->id }}" >{{ __('content.'.strtolower($value->name)) }}</a>
                                    </li>

                                @endforeach

                                <input type="hidden" id="repair_category_id-{{ $buttonIndex }}" name="qut[{{ $buttonIndex }}][{{ $repair }}][category_id]" value="">
                            </ul>
                            <div><span class="field_error" id="repair_category_id_error-{{ $buttonIndex }}"> </span></div>
                        </div>
                        <div class="position-relative add_items_item">
                            <div class="form-group">
                                <label for="exampleFormControlInput1" class="form-label">{{ __('content.description')}}</label>
                                <input type="text" id="repair_description-{{ $buttonIndex }}" name="qut[{{ $buttonIndex }}][{{ $repair }}][description]" class="form-control"  placeholder="Enter description...">
                                <span class="field_error" id="repair_description_error-{{ $buttonIndex }}" style="color:red"> </span>
                            </div>
                            <div class="checkout text-start">
                                <button class="btn btn_confirm btn_illustration repairIllustrationModal-{{ $buttonIndex }}" data-key="{{ $buttonIndex }}" type="button" data-bs-toggle="modal"
                                        data-bs-target="#repairIllustrationModal-{{ $buttonIndex }}">
                                    Add Illustration
                                </button>
                            </div>
                        </div>
                        <div class="position-relative add_items_item">
                            <div class="form-group">
                                <label for="exampleFormControlInput1" class="form-label">{{ __('content.gold_colour') }}</label>
                            </div>
                            <ul class="gold_color repair_gold_color_ul-{{ $buttonIndex }}">

                                @foreach($gold_colors as $key=>$value)
                                    @php
                                        $val = strtok($value," ");
                                    @endphp
                                    <li class="nav-link">
                                        <a data-key="{{ $buttonIndex }}" data-type="{{ $repair }}" class="gold_color_id d-block"  value="{{ $key }}" >{{ __('content.'.strtolower($val)) }}</a>
                                    </li>
                                @endforeach

                                <input type="hidden" id="repair_gold_color_id-{{ $buttonIndex }}" name="qut[{{ $buttonIndex }}][{{ $repair }}][gold_color_id]" value="">
                                <span class="field_error" id="repair_gold_color_id_error-{{ $buttonIndex }}" style="color:red"> </span>
                            </ul>
                        </div>
                        <div class="position-relative add_items_item">
                            <div class="row">
                                <div class="col-lg-6 col-md-6">
                                    <div class="form-group pt-0">
                                        <label for="exampleFormControlInput1" class="form-label">{{ __('content.additional_material') }}</label>
                                        <input type="text" class="form-control" name="qut[{{ $buttonIndex }}][{{ $repair }}][material]" id="repair_material-{{ $buttonIndex }}" placeholder="Enter Material">
                                        <span class="field_error" id="repair_material_error-{{ $buttonIndex }}" style="color:red"> </span>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-6">
                                    <div class="form-group pt-0">
                                        <label for="exampleFormControlInput1" class="form-label">{{ __('content.quantity') }} </label>
                                        <input type="text" class="form-control" name="qut[{{ $buttonIndex }}][{{ $repair }}][quantity]" id="repair_quantity-{{ $buttonIndex }}" placeholder="">
                                        <span class="field_error" id="repair_quantity_error-{{ $buttonIndex }}" style="color:red"> </span>
                                    </div>
                                </div>
                                <div class="col-lg-12 col-md-12 col-12 mt-4">
                                    <div class="form-check">
                                        <input class="form-check-input"  name="qut[{{ $buttonIndex }}][{{ $repair }}][customer_received]"  type="checkbox" id="repair_customer_received-{{ $buttonIndex }}" value="1">
                                        <label class="form-check-label" for="gridCheck">
                                            {{ __('content.jewellry_received') }}
                                        </label>
                                    </div>
                                </div>

                                <div class="checkout text-end">
                                    <button class="btn btn_confirm bespoke_repair_confirm" type="button"  data-type="{{ $repair }}" data-key="{{ $buttonIndex }}" >{!! __('content.confirm_with_br') !!}</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="bespokeIllustrationModal-{{ $buttonIndex }}" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog illustration_dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">{{ __('content.add_illustation')}}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6 d-flex align-items-center">
                            <div class="required_photo">
                                <div class="dropzone dropZoneimageUpload" id="bespokeDropZoneimageUpload-{{ $buttonIndex }}">
                                    <span class="drop-zone__prompt dz-default dz-message">
                                    <div>
                                    <p>Click here to add photo</p>
                                    <span>Photo Requiement:</span>
                                    <ul>
                                    <li>File type PNG or JPG</li>
                                    <li>Maximum Size: 2 MB</li>
                                    </ul>
                                    </div>
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="form-group modal_drawing pt-0">
                                <div class="start-drawing" id="blackboardPlaceholder">
                                    <p>Start Drawing</p>
                                    <canvas data-key="{{ $buttonIndex }}" class="drawingCanvas bespoke_drawingCanvas" width="500" height="230"></canvas>
                                    <div class="pen-eraser">
                                    <span class="pen" onclick="togglePenPointer(this);"><img
                                                src="{{ asset('public/img/pen.png') }}"/></span>
                                        <span class="erase" onclick="eraserHandler(this);"><img
                                                    src="{{ asset('public/img/eraser.png') }}"/></span>
                                    </div>
                                </div>
                                <input type="hidden" id="drawing_textarea_base64-0"
                                name="qut[{{ $buttonIndex }}][{{ $bespoke }}][drawing_textarea_base64]">
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <div id="bespoke-template-preview-{{ $buttonIndex }}" class="preview-droped-images" >
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" data-key="{{ $buttonIndex }}" data-type="{{ $bespoke }}"  class="btn btn-primary btn-save illustration_save">{{ __('content.save') }} </button>
                    <input type="hidden" class="illustrartion" name="qut[{{ $buttonIndex }}][{{ $bespoke }}][illustration]" value="">
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="repairIllustrationModal-{{ $buttonIndex }}" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog illustration_dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">{{ __('content.add_illustation')}}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6 d-flex align-items-center">
                            <div class="required_photo">
                                <div class="dropzone dropZoneimageUpload" id="repairDropZoneimageUpload-{{ $buttonIndex }}">
                                    <span class="drop-zone__prompt dz-default dz-message">
                                    <div>
                                    <p>Click here to add photo</p>
                                    <span>Photo Requiement:</span>
                                    <ul>
                                    <li>File type PNG or JPG</li>
                                    <li>Maximum Size: 2 KB</li>
                                    </ul>
                                    </div>
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="form-group modal_drawing pt-0">
                                <div class="start-drawing" id="blackboardPlaceholder">
                                    <p>Start Drawing</p>
                                    <canvas data-key="{{ $buttonIndex }}" class="drawingCanvas repair_drawingCanvas" width="500" height="230"></canvas>
                                    <div class="pen-eraser">
                                    <span class="pen" onclick="togglePenPointer(this);"><img
                                                src="{{ asset('public/img/pen.png') }}"/></span>
                                        <span class="erase" onclick="eraserHandler(this);"><img
                                                    src="{{ asset('public/img/eraser.png') }}"/></span>
                                    </div>
                                </div>
                                <input type="hidden"  name="qut[{{ $buttonIndex }}][{{ $repair }}][drawing_textarea_base64]">
                            </div>
                        </div>

                        <div class="col-lg-12">
                            <div id="repair-template-preview-{{ $buttonIndex }}" class="preview-droped-images" >
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" data-key="{{ $buttonIndex }}" data-type="{{ $repair }}" class="btn btn-primary btn-save illustration_save">{{ __('content.save') }} </button>
                    <input type="hidden" class="illustrartion" name="qut[{{ $buttonIndex }}][{{ $repair }}][illustration]" value="">
                </div>
            </div>
        </div>
    </div>

</div>
