@include('admin.elements.css.drawing_create_css')

@php
    $inventory = \App\Models\QuotationItem::INVENTORY;
    $bespoke = \App\Models\QuotationItem::BESPOKE;
    $repair = \App\Models\QuotationItem::REPAIR;
@endphp

   <div class="card-body create_quotation">
        <div class="row">
            <div class="col-lg-6 col-md-6 mb-4" x-data="{isTyped: false}">
                <div class="form-group position-relative pt-0">
                    <label for="exampleFormControlInput1" class="form-label">{{ __('content.customer_phone_no') }}</label>
                    <div class="search">
                        <img src="{{asset('public/img/search.png')}}">
                        <input type="text"  class="form-control cus_form_control" id="customer_phone" name="customer_phone" autocomplete="off" list="browsers" placeholder="Enter or Search Phone Number" value="">
                        <span class="field_error" id="customer_phone_error"></span>
                    </div>
                </div>
            </div>

            <div class="col-lg-6 col-md-6 mb-4">
                <div class="form-group">
                    <label for="exampleFormControlInput1" class="form-label">{{ __('content.customer_name') }}</label>
                    <input type="text" class="cus_form_control ps-2" id="customer_name" name="customer_name" value="">
                    <span class="field_error" id="customer_name_error"> </span>
                </div>
            </div>

            <div class="col-lg-6 col-md-6">
                <div class="form-group">
                    <label for="exampleFormControlInput1" class="form-label">{{ __('content.customer_email') }}</label>
                    <input type="text" class="cus_form_control ps-2" id="customer_email" name="customer_email" value="">
                    <span class="field_error" id="customer_email_error"></span>
                </div>
            </div>
        </div>
    </div>

<div class="content-0 ">

<div class="card-body create_quotation custom-create-quote">
        <div class="add_item add_item_custom">
            <div class="items">
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="exampleFormControlInput1" class="form-label head">{!! __('content.add_item_from_with_br') !!}</label>
                        </div>
                    </div>
                    <div class="col-md-9">
                        <ul class="nav nav-tabs ms-auto">
                            <li class="nav-item" role="presentation">
                                <button id="inventory-0" type="button" class="nav-link inventory qutation_type" data-id="{{ $inventory }}">{!! __('content.inventory_with_br') !!}</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button  id="bespoke-0"  type="button"  class="nav-link bespoke qutation_type" data-id="{{ $bespoke }}">{!! __('content.bespoke_with_br') !!}</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button id="repair-0"  type="button"  class="nav-link repair qutation_type" data-id="{{ $repair }}">{!! __('content.repair_with_br') !!}</button>
                            </li>
                        </ul>
                    </div>
                </div>

            </div>
        </div>
    </div>


<div class="card-body create_quotation" id="inventory_fields-0">
    <div class="add_item">
        <div class="items add_item_custom">
            <div class="tab-content add_items_content">
                <div class="position-relative add_items_item mt-0">
                    <div class="search">
                        <img src="{{ asset('public/img/search.png') }}">
                        <input type="text" name="qut[0][{{ $inventory }}][item_code]" class="form-control cus_form_control jewelley_item_code" id="jewelley_item_code-0" placeholder="Enter or Search Item Code">
                        <span class="field_error" id="item_code_error-0"> </span>
                    </div>
                    <div class="checkout text-end">
                        <button class="btn btn_confirm inventory_confirm" type="button" data-type="{{ $inventory }}" data-key="0">{!! __('content.confirm_with_br') !!}</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<div class="card-body create_quotation" id="bespoke_fields-0">
    <div class="add_item add_item_custom">
        <div class="items">
            <div class="tab-content add_items_content">
                <div class="add_items_bespoke mt-0">

                    <div class="position-relative add_items_item">
                        <div class="form-group">
                            <label for="exampleFormControlInput1" class="form-label">Category</label>
                        </div>
                        <ul class="bespoke_category_ul-0 click_class">

                            @php
                                $categories = \App\Models\Category::getCategories();
                                $gold_colors = \App\Models\GoldColor::getGoldColorsList();

                            @endphp
                            @foreach($categories as $key=>$value)
                                <li class="nav-link ">
                                    <a  data-key="0" class="category_id d-block" data-type="{{ $bespoke }}" value= "{{ $value->id }}" >{{ __('sidebar.'.strtolower($value->name)) }}</a>
                                </li>

                            @endforeach

                            <input type="hidden" id="bespoke_category_id-0" name="qut[0][{{ $bespoke }}][category_id]" value="">

                        </ul>
                        <div><span class="field_error" id="bespoke_category_id_error-0" style="color:red"> </span></div>
                    </div>

                    <div class="position-relative add_items_item">
                        <div class="form-group">
                            <label for="exampleFormControlInput1" class="form-label">{{ __('content.description')}}</label>
                            <input type="text" id="bespoke_description-0" name="qut[0][{{ $bespoke }}][description]" class="form-control"  placeholder="Enter description...">
                            <span class="field_error" id="bespoke_description_error-0" style="color:red"> </span>
                        </div>
                        <div class="checkout text-start">
                            <button class="btn btn_confirm btn_illustration bespokeIllustrationModal-0" data-key="0" type="button" data-bs-toggle="modal"
                                    data-bs-target="#bespokeIllustrationModal-0">
                                Add Illustration
                            </button>
                        </div>
                    </div>
                    <div class="position-relative add_items_item">
                        <div class="form-group">
                            <label for="exampleFormControlInput1" class="form-label">{{ __('content.gold_colour')}}</label>
                        </div>
                        <ul class="gold_color bespoke_gold_color_ul-0">
                            @foreach($gold_colors as $key=>$value)
                                @php
                                 $val = strtok($value," ");
                                @endphp
                                <li class="nav-link">
                                    <a data-key="0" data-type="{{ $bespoke }}"  class="gold_color_id d-block" value="{{ $key }}" >{{ __('content.'.strtolower($val)) }}</a>
                                </li>
                            @endforeach

                            <input type="hidden" id="bespoke_gold_color_id-0" name="qut[0][{{ $bespoke }}][gold_color_id]"  value="">
                             <span class="field_error" id="bespoke_gold_color_id_error-0" style="color:red"> </span>
                        </ul>
                    </div>
                    <div class="position-relative add_items_item">
                        <div class="row">
                            <div class="col-lg-6 col-md-6">
                                <div class="form-group pt-0">
                                    <label for="exampleFormControlInput1" class="form-label">{{ __('content.additional_material') }}</label>
                                    <input type="text" class="form-control" name="qut[0][{{ $bespoke }}][material]"  id="bespoke_material-0" placeholder="Enter Material">
                                    <span class="field_error" id="bespoke_material_error-0" style="color:red"> </span>
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6">
                                <div class="form-group pt-0">
                                    <label for="exampleFormControlInput1" class="form-label">{{ __('content.quantity') }} </label>
                                    <input type="text" class="form-control" name="qut[0][{{ $bespoke }}][quantity]" id="bespoke_quantity-0" placeholder="">
                                    <span class="field_error" id="bespoke_quantity_error-0" style="color:red"> </span>
                                </div>
                            </div>
                            <div class="col-lg-12 col-md-12 col-12 mt-4">
                                <div class="form-check">
                                    <input class="form-check-input" name="qut[0][{{ $bespoke }}][customer_recieved]"  type="checkbox" id="bespoke_customer_recieved-0" value="1">
                                    <label class="form-check-label" for="gridCheck">
                                        {{ __('content.jewellry_received') }}
                                    </label>
                                </div>
                            </div>
                            <div class="checkout text-end">
                                <button class="btn btn_confirm bespoke_repair_confirm" type="button" data-type="{{ $bespoke }}" data-key="0" >{!! __('content.confirm_with_br') !!}</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card-body create_quotation" id="repair_fields-0">
        <div class="add_item add_item_custom">
            <div class="items">
                <div class="tab-content add_items_content">
                    <div class="add_items_bespoke mt-0">

                        <div class="position-relative add_items_item">
                            <div class="form-group">
                                <label for="exampleFormControlInput1" class="form-label">Category</label>
                            </div>
                            <ul class="repair_category_ul-0">

                                @php
                                    $categories = \App\Models\Category::getCategories();
                                    $gold_colors = \App\Models\GoldColor::getGoldColorsList();

                                @endphp
                                @foreach($categories as $key=>$value)
                                    <li class="nav-link ">
                                        <a  data-key="0" data-type="{{ $repair }}" class="category_id d-block"  value= "{{ $value->id }}" >{{ __('sidebar.'.strtolower($value->name)) }}</a>
                                    </li>

                                @endforeach

                                <input type="hidden" id="repair_category_id-0" name="qut[0][{{ $repair }}][category_id]" value="">

                            </ul>
                            <div><span class="field_error" id="repair_category_id_error-0" style="color:red"> </span></div>
                        </div>
                        <div class="position-relative add_items_item">
                            <div class="form-group">
                                <label for="exampleFormControlInput1" class="form-label">{{ __('content.description')}}</label>
                                <input type="text" id="repair_description-0" name="qut[0][{{ $repair }}][description]"  class="form-control"  placeholder="Enter description...">
                                <span class="field_error" id="repair_description_error-0" style="color:red"> </span>
                            </div>
                            <div class="checkout text-start">
                                <button class="btn btn_confirm btn_illustration repairIllustrationModal-0" data-key="0" type="button" data-bs-toggle="modal"
                                        data-bs-target="#repairIllustrationModal-0">
                                    Add Illustration
                                </button>
                            </div>
                        </div>
                        <div class="position-relative add_items_item">
                            <div class="form-group">
                                <label for="exampleFormControlInput1" class="form-label">{{ __('content.gold_colour') }}</label>
                            </div>
                            <ul class="gold_color repair_gold_color_ul-0">
                                @foreach($gold_colors as $key=>$value)
                                @php
                                $val = strtok($value," ");
                               @endphp
                                    <li class="nav-link">
                                        <a data-key="0" class="gold_color_id d-block" data-type="{{ $repair }}"  name="repair_gold_color_id[]" value="{{ $key }}" >{{ __('content.'.strtolower($val)) }}</a>
                                    </li>
                                @endforeach

                                <input type="hidden" id="repair_gold_color_id-0" name="qut[0][{{ $repair }}][gold_color_id]"  value="">
                                <span class="field_error" id="repair_gold_color_id_error-0" style="color:red"> </span>
                            </ul>
                        </div>
                        <div class="position-relative add_items_item">
                            <div class="row">
                                <div class="col-lg-6 col-md-6">
                                    <div class="form-group pt-0">
                                        <label for="exampleFormControlInput1" class="form-label">{{ __('content.additional_material') }}</label>
                                        <input type="text" class="form-control" name="qut[0][{{ $repair }}][material]"  id="repair_material-0" placeholder="Enter Material">
                                        <span class="field_error" id="repair_material_error-0" style="color:red"> </span>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-6">
                                    <div class="form-group pt-0">
                                        <label for="exampleFormControlInput1" class="form-label">{{ __('content.quantity') }}</label>
                                        <input type="text" class="form-control" name="qut[0][{{ $repair }}][quantity]"  id="repair_quantity-0" placeholder="">
                                        <span class="field_error" id="repair_quantity_error-0" style="color:red"> </span>
                                    </div>
                                </div>
                                <div class="col-lg-12 col-md-12 col-12 mt-4">
                                    <div class="form-check">
                                        <input class="form-check-input" name="qut[0][{{ $repair }}][customer_recieved]"  type="checkbox" id="repair_customer_recieved-0" value="1">
                                        <label class="form-check-label" for="gridCheck">
                                            {{ __('content.jewellry_received') }}
                                        </label>
                                    </div>
                                </div>

                                <div class="checkout text-end">
                                    <button class="btn btn_confirm bespoke_repair_confirm" type="button" data-type="{{ $repair }}" data-key="0" >{!! __('content.confirm_with_br') !!}</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<div id="append_button">

</div>

<!-- Modal -->

<div class="modal fade" id="bespokeIllustrationModal-0" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog illustration_dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="">{{ __('content.add_illustation')}}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-6 d-flex align-items-center">
                        <div class="required_photo">
                            <div class="dropzone dropZoneimageUpload" id="bespokeDropZoneimageUpload-0" >
                                <span class="drop-zone__prompt dz-default dz-message">
                                <div>
                                    <p>Click here to add photo</p>
                                    <span>Photo Requiement:</span>
                                    <ul>
                                        <li>File type PNG or JPG</li>
                                        <li>Maximum Size: 2 MB</li>
                                    </ul>
                                </div>
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="form-group modal_drawing pt-0">
                            <div class="start-drawing" id="blackboardPlaceholder">
                                <p>Start Drawing</p>
                                <canvas data-key="0" class="drawingCanvas bespoke_drawingCanvas"  width="500" height="230"></canvas>
                                <div class="pen-eraser">
                                        <span class="pen" onclick="togglePenPointer(this);"><img
                                                    src="{{ asset('public/img/pen.png') }}"/></span>
                                    <span class="erase" onclick="eraserHandler(this);"><img
                                                src="{{ asset('public/img/eraser.png') }}"/></span>
                                </div>
                            </div>
                            <input type="hidden"  name="qut[0][{{ $bespoke }}][drawing_textarea_base64]">
                        </div>
                    </div>

                    <div class="col-lg-12">
                        <div id="bespoke-template-preview-0" class="preview-droped-images" >
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" data-key="0" data-type="{{ $bespoke }}"  class="btn btn-primary btn-save illustration_save">{{ __('content.save') }}</button>
                <input type="hidden" class="illustrartion" name="qut[0][{{ $bespoke }}][illustration]" value="">
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="repairIllustrationModal-0" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog illustration_dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id=""> {{ __('content.add_illustation')}}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-6 d-flex align-items-center">
                        <div class="required_photo">
                            <div class="dropzone dropZoneimageUpload" id="repairDropZoneimageUpload-0"  >
                                <span class="drop-zone__prompt dz-default dz-message">
                                <div>
                                    <p>Click here to add photo</p>
                                    <span>Photo Requiement:</span>
                                    <ul>
                                        <li>File type PNG or JPG</li>
                                        <li>Maximum Size: 2 MB</li>
                                    </ul>
                                </div>
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="form-group modal_drawing pt-0">
                            <div class="start-drawing" id="blackboardPlaceholder">
                                <p>Start Drawing</p>
                                <canvas data-key="0" class="drawingCanvas repair_drawingCanvas"  width="500" height="230"></canvas>
                                <div class="pen-eraser">
                                        <span class="pen" onclick="togglePenPointer(this);"><img
                                                    src="{{ asset('public/img/pen.png') }}"/></span>
                                    <span class="erase" onclick="eraserHandler(this);"><img
                                                src="{{ asset('public/img/eraser.png') }}"/></span>
                                </div>
                            </div>
                            <input type="hidden" name="qut[0][{{ $repair }}][drawing_textarea_base64]" name="drawing_textarea_base64">
                        </div>
                    </div>

                    <div class="col-lg-12">
                        <div id="repair-template-preview-0" class="preview-droped-images" >
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" data-key="0" data-type="{{ $repair }}" class="btn btn-primary btn-save illustration_save">{{ __('content.save') }} </button>
                <input type="hidden" class="illustrartion" name="qut[0][{{ $repair }}][illustration]" value="">
            </div>
        </div>
    </div>
</div>


