@php 
use App\Models\Quotation;
$shopSettings = \App\Models\Setting::shop_settings(); 
@endphp

@extends('layouts.print')

@section('title',"Print Orde Voucher")

@section('header', "Print Orde Voucher")

@section('content')

<table style="max-width:500px;width:100%;margin:0 auto;padding:40px;">
        <tbody>
            <tr style="">
                <td>
                    <div style="display: flex;justify-content: space-between; margin-bottom:60px;align-items: flex-start;">
                        <img style="" src="{{ asset('public/img/print_order_voucher.png') }}" alt="logo">
                        <div style="width: fit-content;">
                            <h5 style="margin:0px;font-size:14px;font-weight:600;color:#BE1E2D;opacity: 0.6;">Order Voucher No. {{ empty($quotation->quotation_no) ?  getItemCode(Quotation::ZEROES, $quotation->id, Quotation::VOUCHER) : $quotation->quotation_no }}</h5>
                            <p style="margin:0px;font-weight: 300;font-size:12px;color:#000;">Date {{ date('d/m/Y', strtotime($quotation->reference_date)) }}</p>
                        </div>
                    </div>
                </td>
            </tr>
            <tr style="display: flex;justify-content: space-between;margin-top:20px;">
                <td style="font-size:12px;display: flex;align-items: center;">
                    <p style="color:#64748B;margin:0px;">Sales Person:</p><h4 style="margin:0px;"><span style="color:#BE1E2D;opacity: 0.6;font-weight: 600;padding-left:15px;margin:0px;">
                        {{ ucwords($quotation->staff_name) ?? $quotation->staff ? ucwords($quotation->staff->fullname) : '' }}</span></h4><p></p>
                </td>
                <td style="font-size:12px;display: flex;align-items: center;">
                    <p style="color:#64748B;margin:0px;">Received From:</p><h4 style="margin:0px;"><span style="color:#BE1E2D;opacity: 0.6;font-weight: 600;padding-left:15px;">
                        {{ ucwords($quotation->customer_name) ?? ucwords($quotation->customer->fullname) ?? '' }}</span></h4><p></p>
                </td>
            </tr>
            <tr style="">
                <td style="display: flex;justify-content: space-between;">
                    <p style="font-size:10px;font-weight:300;color:#000;margin:0px;">{{ $shopSettings['email'] }}</p>
                    <p style="font-size:10px;font-weight:300;color:#000;margin:0px;">{{ $quotation->customer_email ?? $quotation->customer->email ?? '' }}</p>
                </td>
            </tr>
            <tr style="">
                <td style="display: flex;justify-content: space-between;">
                    <p style="font-size:10px;font-weight:300;color:#000;">{{ $shopSettings['address_line1'] }}
                        <span style="display: block;">{{ $shopSettings['address_line2'] }}</span>
                        <span style="display: block;">{{ $shopSettings['phone'] }}</span>
                    </p>
                    <p style="font-size:10px;font-weight:300;color:#000;">{{ $quotation->customer_phone ?? $quotation->customer->phone ?? '' }}</p>
                </td>
            </tr>
            <tr style="">
                <td style="">
                    <table cellpadding="0" cellspacing="0" style="width:100%;">
                        <thead>
                            <tr>
                                <th style="font-weight: 600;font-size: 10px;line-height: 14px;color:#fff;background: #88020F;text-align: start;
                                padding:10px 10px 10px 20px;width:10%;text-transform: uppercase;">#
                                </th>
                                <th style="font-weight: 600;font-size: 10px;line-height: 14px;color:#fff;background: #88020F;text-align: start;
                                padding:10px 10px 10px 20px;width:10%;text-transform: uppercase;">
                                    Item
                                </th>
                                <!-- <th style="font-weight: 600;font-size: 10px;line-height: 14px;color:#fff;background: #88020F;text-align: start;
                                padding:10px 10px 10px 20px;width:10%;text-transform: uppercase;">
                                    Value
                                </th> -->
                                <th style="font-weight: 600;font-size: 10px;line-height: 14px;color:#fff;background: #88020F;text-align: start;
                                padding:10px 10px 10px 20px;width:10%;text-transform: uppercase;">
                                    Price
                                </th>
                                <th style="font-weight: 600;font-size: 10px;line-height: 14px;color:#fff;background: #88020F;text-align: start;
                                padding:10px 10px 10px 20px;width:10%;text-transform: uppercase;">
                                    Gold Colour
                                </th>
                            </tr>
                        </thead>
                        @php $counter = 1; @endphp
                        @forelse($quotation->quotation_item as $key => $quotationItem)
                            <tr style="">
                                <td style="margin-top:10px;vertical-align: top;border-top: 1px solid rgb(0 0 0 / 10%);border-bottom: 1px solid rgb(0 0 0 / 10%);padding: 14px 21px;">
                                    <h4 style="margin:0px; text-align:start;font-size:12px;font-weight:400;color:#000000;line-height: 18px;">{{ $counter }}</h4>
                                </td>
                                <td style="margin-top:10px;vertical-align: top;border-top: 1px solid rgb(0 0 0 / 10%);border-bottom: 1px solid rgb(0 0 0 / 10%);padding: 14px 21px;">
                                    <div style="width:216px;">
                                        <p style="margin:0px; text-align:start;font-size:10px;font-weight:400;color:#000000;line-height: 18px;">{{ $quotationItem->description ?? ' ' }}</p>
                                        <img style="width:100%;" src="{{ !empty($quotationItem->quotation_item_image) ? (!empty($quotationItem->quotation_item_image[0]) ? $quotationItem->quotation_item_image[0]->image_url : getDefaultImage()) : getDefaultImage() }}">
                                    </div>
                                </td>
                                <!-- <td style="margin-top:10px;vertical-align: top;border-top: 1px solid rgb(0 0 0 / 10%);border-bottom: 1px solid rgb(0 0 0 / 10%);padding: 14px 21px;">
                                    <p style="margin:0px; text-align:start;font-size:10px;font-weight:400;color:#000000;line-height: 18px;">$102.00</p>
                                </td> -->
                                <td style="margin-top:10px;vertical-align: top;border-top: 1px solid rgb(0 0 0 / 10%);border-bottom: 1px solid rgb(0 0 0 / 10%);padding: 14px 21px;">
                                    <p style="margin:0px; text-align:start;font-size:10px;font-weight:400;color:#000000;line-height: 18px;">$<span class="item_price" id="price-{{ $counter }}" data-id="{{ $quotationItem->id }}">{{ $quotationItem->sub_total ?? '0' }}</span></p>
                                </td>
                                <td style="margin-top:10px;vertical-align: top;border-top: 1px solid rgb(0 0 0 / 10%);border-bottom: 1px solid rgb(0 0 0 / 10%);padding: 14px 21px;">
                                    <p style="margin:0px; text-align:start;font-size:10px;font-weight:400;color:#000000;line-height: 18px;">{{ $quotationItem->gold_color->name ?? '-' }}</p>
                                </td>
                            </tr>
                        @php $counter++; @endphp
                        @empty
                            <tr style="">
                                <td colspan="4">No record found!</td>
                            </tr>
                        @endforelse
                    </table>
                    <table cellpadding="0" cellspacing="0" style="width: 100%;">
                        <tr style="">
                            <td style="margin-top:10px;vertical-align: top;">
                                <div style="max-width: 222px;margin-left: auto;width: 100%;margin-top:83px;">
                                    <div style="display:flex;align-items: flex-end; padding-bottom: 20px;justify-content: space-between;">
                                        <h4 style="margin:0px;text-align:start;font-size:12px;font-weight:400;line-height: 18px;">Subtotal:</h4>
                                        <img src="{{ asset('public/img/Line_1.png') }}" style="height: 1px;">
                                        <p style="margin:0px;font-size:12px;font-weight: 600;line-height: 18px;">$<span id="subtotal"></span></p>
                                    </div>
                                    <div style="display:flex;align-items: flex-end; padding-bottom: 20px;justify-content: space-between;">
                                        <h4 style="margin:0px;text-align:start;font-size:12px;font-weight:400;line-height: 18px;">GST:</h4>
                                        <img src="{{ asset('public/img/Line_2.png') }}" style="height: 1px;">
                                        <p style="margin:0px;font-size:12px;font-weight: 600;line-height: 18px;">$<span id="gst"></span></p>
                                    </div>
                                    <div style="display:flex;align-items: flex-end; padding-bottom: 20px;justify-content: space-between;">
                                        <h4 style="margin:0px;text-align:start;font-size:12px;font-weight:400;line-height: 18px;">Total:</h4>
                                        <img src="{{ asset('public/img/Line_3.png') }}" style="height: 1px;">
                                        <p style="margin:0px;font-size:12px;font-weight: 600;line-height: 18px;">$<span id="total"></span></p>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <div style="display: flex;align-items: center;justify-content:space-between;width:100%;">
                                    <div style="flex:0 0 50%;">
                                        <h3 style="font-weight: 600;font-size: 12px;line-height: 18px;color: #475569;text-transform: uppercase;">Customer signature</h3>
                                        <p style="border: 1px solid #CBD5E1;border-radius: 5px;height: 69px;margin-right:7px;"></p>
                                    </div>
                                    <div style="flex:0 0 50%;">
                                        <h3 style="font-weight: 600;font-size: 12px;line-height: 18px;color: #475569;text-transform: uppercase;">Sales signature</h3>
                                        <p style="border: 1px solid #CBD5E1;border-radius: 5px;height: 69px;margin-left:7px;"></p>
                                    </div>
                                </div>
                            </td>
                            
                        </tr>
                        <tr>
                            <td style="margin-top:10px;vertical-align: top;">
                                <p style="font-weight: 300;font-size: 6px;line-height: 9px;">EVERY CARE WILL BE TAKEN WITH JEWELLERY ARTICLES WITH US FOR SETTING OR MAKING. HOWEVER IN CASE OF DAMAGE OR LOSS, MAXIMUM CONPENSATION 
                                SHALLBE BASED ON THE AMOUNT STATED ABOVE. CUSTOMERS ARE REQUESTED TO PAY FOR THE SETTING FEE IN ACCORDANCE WITH THE PERVAILING GOLD RETAIL 
                                PRICE. THIS ORDER IS VALID FOR 6 MONTHS ONLY.  </p>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </tbody>
    </table>

@endsection