@php
use App\Models\QuotationItem;
@endphp

@extends('layouts.master')
@section('title', "Sales")
@section('header', "Sales")

@section('content')

   <div class="today_sale_main">
        <div class="dasboard-menu-item ps-0">
            <div class="today_sale_heading">
                <div class="create_quote_link today_sale py-4">
                    <span class="d-flex align-items-center create_span">
                        <img src="{{ asset('public/img/create_quotation.png') }}" /><a href="javascript:void(0);">Today’s Sales</a>
                    </span>

                    @include('frontend.elements.layouts.time_date_user_details')

                </div>

                <div class="total_invoice_main d-flex align-items-center justify-content-between">
                    <div class="total_invoice_wise d-flex align-items-center">
                        <div class="total_invoice">
                            <p>Total Invoice</p>
                            <h3>{{ count($records) }}</h3>
                        </div>
                        <div class="total_invoice">
                            <p>New Customer</p>
                            <h3>{{ $records[0]->todaysNewCustomersCount }}</h3>
                        </div> 
                    </div>                 
                    <div class="total_amount_todal_sale">
                        <p>Amount Transacted  (based on Invoice)</p>
                        <h3>$ {{ number_format($records->sum('total')) }}</h3>
                    </div>
                </div>

                <div class="today_sale_detail">
                    <div class="card-body">
                        <div class="earring-table sale_detail_main table-responsive">
                            <table class="table stock-detail sale-detail">
                                <thead>
                                    <tr>
                                        <th>@sortablelink('reference_date', __('content.date'))</th>
                                        <th>@sortablelink('id', __('content.invoice_id'))</th>
                                        <th>@sortablelink('total', __('content.amount'))</th>
                                        <th>{{ __('content.paid_amount') }}</th>
                                        <th>@sortablelink('customer_name', __('content.customer'))</th>
                                        <th>{{ __('content.action') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($records as $record)
                                    {{-- dd($record) --}}
                                    <tr>
                                        <td>{{ isset($record->reference_date) ? date('d/m/Y', strtotime($record->reference_date)) : '-' }}</td>
                                        <td>{{ $record->id ?? '-' }}</td>
                                        <td>{{ !empty($record->total) ? '$'.$record->total : '-' }}</td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <span id="paid_amount-{{ $record->id }}">${{ $record->balance ?? '0' }}</span>
                                                
                                                @if($record->due > 0)
                                                <a href="javascript:void(0)" class="return_edit" id="paidAmount-{{$record->id}}" data-record_id="{{$record->id}}" >
                                                    <img class="return_first" src="{{ asset('public/img/icon-edit.png') }}">
                                                </a><!-- data-bs-toggle="modal" data-bs-target="#paidAmountModal" -->
                                                @endif
                                            </div>
                                        </td>
                                        <td>{{ ucwords($record->customer_name) ?? ucwords($record->customer->fullname) ?? '-' }}</td>
                                        <td>
                                            <div class="dropdown">
                                                <button class="btn btn-secondary down" type="button" id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false">
                                                    Action
                                                </button>
                                                <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                                                    <li><a class="dropdown-item btnprn" href="{{ route('invoices.printInvoice', $record->id) }}"><img src="{{ asset('public/img/print.png') }}">Print Invoice</a></li>
                                                </ul>
                                            </div>
                                        </td>
                                    </tr>
                                    @empty
                                    <tr>
                                        <td class="text-center" colspan="7">No Record Found!</td>
                                    </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade model-custom-1" id="paidAmountModal" tabindex="-1" aria-labelledby="reportModalLabel"
     aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered dialog-filter-option download_option">
        <div class="modal-content">
            <div class="modal-header">
               <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" id="close_model"></button>
            </div>
            <div class="modal-body filter-options">
                <h5 class="modal-title"></h5>
                <form class="paidAmountForm" id="invoicePaidAmountForm" action="{{ route('invoices.submitPaidAmount') }}" method="POST">
                @csrf

                    <div class="loader-bg" id="loader" style="display:none;z-index:9999;">
                        <div class="loader"></div>
                    </div>
                    <input type="hidden" name="id" id="hidden_record_id"/>
                    <div class="row">
                        <div class="col-12">
                            <div class="form-group me-2">
                                <label style="text-align:center; font-weight:600; font-size:14px;">Paid Amount</label>
                                <input type="text" name="paid_amount" id="paid_amount" class="cus_form_control w-100" value="" placeholder="0.00">
                                <span class="error-message">
                                    <strong id="paid_amountError" class="error_msg"></strong>
                                </span>
                            </div>
                        </div>
                    </div>
                
                        <div class="col-lg-12 col-md-12 mt-3">
                            <div class="m-0">
                                <button type="submit" class="btn btn_download w-50 d-block mx-auto submit_report" name="submit">Save
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script> 
    $(document).ready(function(){
        alert('ready');
        $('.return_edit').click(function(){
            var record_id = $(this).data('record_id');
            console.log('record_id :',record_id);
            $('#hidden_record_id').val(record_id);

            $('#paidAmountModal').modal('show');

            $('.paidAmountForm').submit(function(e){
                e.preventDefault(); 
                var action = $(this).attr('action');
                console.log('action : ',action);

                var formData = new FormData();
                formData.append("id", $("#hidden_record_id").val());
                formData.append("paid_amount", $("#paid_amount").val());
                formData.append("_token", "{{csrf_token()}}");

                $('#loader').show();
                $.ajax({
                    type:'POST',
                    url: action,
                    data: formData,
                    contentType: false,
                    processData: false,
                    dataType: 'json',
                    success: function(res){
                        $('#loader').hide();
                        console.log('res :'+res);
                        console.log('res message :'+res.message);

                        if(res.errors) {
                            $.each(res.errors, function(key, value) {
                                key2=key.replace(".", "_");
                                $('#'+key2+'Error').html(value[0]);  
                            });
                        }

                        if(res.status==0){
                            error(res.message, res.title);
                        }else if(res.status==1){
                            $('#paidAmountModal form')[0].reset();
                            $('#paidAmountModal').modal('hide');
                            $('#paid_amount-'+record_id).html('$'+res.data.balance);
                            success(res.message, res.title);
                        }
                    },
                });
            });
        });
    });
</script>

@endsection