@php
use App\Models\QuotationItem;
@endphp

@extends('layouts.master')
@section('title', "Sales")
@section('header', "Sales")

@section('content')

   <div class="today_sale_main">
        <div class="dasboard-menu-item ps-0">
            <div class="today_sale_heading">
                <div class="create_quote_link today_sale py-4">
                    <span class="d-flex align-items-center create_span">
                        <img src="{{ asset('public/img/create_quotation.png') }}" /><a href="javascript:void(0);">Today’s Sales</a>
                    </span>

                    @include('frontend.elements.layouts.time_date_user_details')

                </div>

                <div class="total_invoice_main d-flex align-items-center justify-content-between">
                    <div class="total_invoice_wise d-flex align-items-center">
                        <div class="total_invoice">
                            <p>Total Invoice</p>
                            <h3>{{ count($records) }}</h3>
                        </div>
                        <div class="total_invoice">
                            <p>New Customer</p>
                            <h3>{{ $records[0]->todaysNewCustomersCount }}</h3>
                        </div> 
                    </div>                 
                    <div class="total_amount_todal_sale">
                        <p>Amount Transacted  (based on Invoice)</p>
                        <h3>$ {{ number_format($records->sum('total')) }}</h3>
                    </div>
                </div>

                <div class="today_sale_detail">
                    <div class="card-body">
                        <div class="earring-table sale_detail_main table-responsive">
                            <table class="table stock-detail sale-detail">
                                <thead>
                                    <tr>
                                        <th>@sortablelink('reference_date', __('content.date'))</th>
                                        <th>@sortablelink('id', __('content.invoice_id'))</th>
                                        <th>@sortablelink('total', __('content.amount'))</th>
                                        <th>{{ __('content.paid_amount') }}</th>
                                        <th>@sortablelink('customer_name', __('content.customer'))</th>
                                        <th>{{ __('content.action') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($records as $record)
                                    {{-- dd($record) --}}
                                    <tr>
                                        <td>{{ isset($record->reference_date) ? date('d/m/Y', strtotime($record->reference_date)) : '-' }}</td>
                                        <td>{{ $record->id ?? '-' }}</td>
                                        <td>{{ !empty($record->total) ? '$'.$record->total : '-' }}</td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <span id="paid_amount-{{ $record->id }}">${{ $record->paid_amount ?? 0 }}</span>

                                                @if($record->due > 0)
                                                <a  href="javascript:void(0)" id="invoicePaidAmount-{{ $record->id }}" class="return_edit" data-record_id="{{ $record->id }}" >    <img class="return_first" src="{{ asset('public/img/icon-edit.png') }}">
                                                </a> <!-- data-bs-toggle="modal" data-bs-target="#Layway_popup" -->
                                                @endif
                                            </div>
                                        </td>
                                        <td>{{ ucwords($record->customer_name) ?? ucwords($record->customer->fullname) ?? '-' }}</td>
                                        <td>
                                            <div class="dropdown">
                                                <button class="btn btn-secondary down" type="button" id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false">
                                                    Action
                                                </button>
                                                <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                                                    <li><a class="dropdown-item btnprn" href="{{ route('invoices.printInvoice', $record->id) }}"><img src="{{ asset('public/img/print.png') }}">Print Invoice</a></li>
                                                </ul>
                                            </div>
                                        </td>
                                    </tr>
                                    @empty
                                    <tr>
                                        <td class="text-center" colspan="7">No Record Found!</td>
                                    </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

{{-- @include('frontend.invoices.layway_popup') --}}

<!-- Modal-invoice -->
<div class="modal fade" id="Layway_popup" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog Layway_popup modal-xl">
        <div class="modal-content">
            <div class="modal-header border-0">
                <h5 class="modal-title" id="exampleModalLabel">Layway Payment</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">

                <div class="loader-bg" id="loader" style="display:none; z-index:9999;">
                    <div class="loader"></div>
                </div>

                <div class="layway_content">
                    <div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="table-responsive">
                                    <table class="table table-borderless table_max mb-0">
                                        <tr>
                                            <td>Total Amount:</td>
                                            <td class="text-end"><strong id="invoice_total"></strong></td>
                                        </tr>
                                        <tr>
                                            <td>Paid Amount:</td>
                                            <td class="text-end" id="invoice_balance"></td>
                                        </tr>
                                        <tr>
                                            <!-- <td class="text-end pe-4">Balance:</td>
                                        <td class="text-start ps-4">$600.00</td> -->

                                            <td colspan="2">
                                                <div
                                                    class="balence_calc d-flex align-items-center justify-content-center">
                                                    <div class="me-5">Balance:</div>
                                                    <div id="invoice_due"></div>
                                                </div>
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <form class="paidAmountForm" id="invoicePaidAmountForm" action="{{ route('invoices.updatePaidAmount') }}" method="POST">
                                @csrf
                                    <input type="hidden" name="id" id="hidden_record_id"/>
                                    <div class="text-end rigt_cont">
                                        <h6 class="font-weight-normal mb-2">Amount to Deposit:</h6>
                                        <input type="text" class="form-control form_control_amt ms-auto" name="paid_amount" id="paid_amount" placeholder="$ 0.00">
                                        <span class="error-message">
                                            <strong id="paid_amountError" class="error_msg"></strong>
                                        </span>
                                        <button class="btn btn-primary btn-update mt-2" id="bt_update" type="submit">Update</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="bottom_t_cont mt-5 pt-5" id="bt_table">
                        <div class="row">
                            <div class="col-md-12">
                                <h6>Layway Payment History</h6>
                                <div class="earring-table sale_detail_main table-responsive">
                                    <table class="table stock-detail sale-detail">
                                        <thead>
                                            <tr>
                                                <th>{{ __('content.date') }}</th>
                                                <th>{{ __('content.deposit') }}</th>
                                                <th>{{ __('content.staff') }}</th>
                                            </tr>
                                        </thead>
                                        <tbody id="invoiceTransactionList">
                                            <!-- <tr>
                                                <td>11/02/2022</td>
                                                <td>20938022</td>
                                                <td>Inventory</td>
                                            </tr> -->
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.4/moment.min.js" />

<script> 
    $(document).ready(function(){
        alert('ready');
        // $('.return_edit').click(function(){
        //     var record_id = $(this).data('record_id');
        //     console.log('record_id :',record_id);
        //     $('#hidden_record_id').val(record_id);

        //     var actionUrl = "{{ route('invoices.details', ':invoice_id')}}";
        //     actionUrl = actionUrl.replace(':invoice_id', record_id);

        //     //--------- Display invoice details on PopUp ----------
        //     $.ajax({
        //         type:'GET',
        //         url: actionUrl,
        //         contentType: false,
        //         processData: false,
        //         dataType: 'json',
        //         success: function(res){
        //             $('#loader').hide();
        //             console.log('res :'+res);

        //             if(res.errors) {
        //                 $.each(res.errors, function(key, value) {
        //                     key2=key.replace(".", "_");
        //                     $('#'+key2+'Error').html(value[0]);  
        //                 });
        //             }

        //             if(res.status==0){
        //                 error(res.message, res.title);
        //             }else if(res.status==1){
        //                 $('#Layway_popup').modal('show');

        //                 $('#invoice_total').html('$'+res.data.total);
        //                 $('#invoice_balance').html('$'+res.data.balance);
        //                 $('#invoice_due').html('$'+res.data.due);

        //                 var transactions = res.data.transaction;
        //                 if(transactions.length){
        //                     $.each(transactions, function(key, value) {
        //                         var newDate = moment(value.date).format("DD/MM/YYYY");
        //                         $('#invoiceTransactionList').append(`<tr>
        //                             <td>${newDate}</td>
        //                             <td>${'$'+value.paid_amount}</td>
        //                             <td>${res.data.staff.fullname}</td>
        //                         </tr>`); 
        //                     });
        //                 }else{
        //                     $('#invoiceTransactionList').html('<tr colspan="3" id="no_record">No record found!</tr>');
        //                 }
        //                 // success(res.message, res.title);  
        //             }
        //         },
        //     });

        //     //--------- Update Paid Amount Js Starts Here ----------
        //     $('.paidAmountForm').submit(function(e){

        //         // $('#bt_update').prop('disabled', false);
        //         var _this = $(this);

        //         e.preventDefault(); 
        //         var action = $(this).attr('action');
        //         console.log('action : ',action);

        //         var inputPaidAmount = $("#paid_amount").val();

        //         var formData = new FormData();
        //         formData.append("id", $("#hidden_record_id").val());
        //         formData.append("paid_amount", inputPaidAmount);
        //         formData.append("_token", "{{csrf_token()}}");

        //         $('#loader').show();
        //         $.ajax({
        //             type:'POST',
        //             url: action,
        //             data: formData,
        //             contentType: false,
        //             processData: false,
        //             dataType: 'json',
        //             success: function(res){
        //                 $('#loader').hide();
        //                 console.log('res :'+res);

        //                 (_this).find(':input[type=submit]').prop('disabled', false);

        //                 if(res.errors) {
        //                     $.each(res.errors, function(key, value) {
        //                         key2 = key.replace(".", "_");
        //                         $('#'+key2+'Error').html(value[0]);  
        //                     });
        //                 }

        //                 if(res.status==0){
        //                     error(res.message, res.title);
        //                 }else if(res.status==1){
        //                     $('#Layway_popup form')[0].reset();
        //                     // $('#Layway_popup').modal('hide');
        //                     $('#no_record').hide();

        //                     $('#invoice_balance').html('$'+res.data.balance.toFixed(2));
        //                     $('#invoice_due').html('$'+res.data.due.toFixed(2));

        //                     var latestTransaction = res.data.transaction;
        //                     console.log('latestTransaction 0 : ', latestTransaction[0].paid_amount);
        //                     if(latestTransaction.length){
        //                         $.each(latestTransaction, function(key, value) {
        //                             var newTransDate = moment(latestTransaction[0].date).format("DD/MM/YYYY");
        //                             $('#invoiceTransactionList').append(`<tr>
        //                                 <td>${newTransDate}</td>
        //                                 <td>${'$'+latestTransaction[0].paid_amount}</td>
        //                                 <td>${ (res.data.staff_name) ? (res.data.staff_name) : (res.data.staff.fullname) ? (res.data.staff.fullname) : '-'}</td>
        //                             </tr>`); 
        //                         });
        //                     }
                            
        //                     $('#paid_amount-'+record_id).html('$'+res.data.balance);
        //                     success(res.message, res.title);
        //                 }
        //             },
        //         });
        //     });
        //     //---------- Update Paid Amount Js Ends Here -----------

        // });
    });
</script>


@endsection