@php
use App\Models\QuotationItem;
use App\Models\Invoice;
@endphp


@extends('layouts.master')
@section('title', "Sales")
@section('header', "Sales")

@section('content')

    {{-- <div class="loader-bg" id="loader" style="display:none; z-index:9999;">
        <div class="loader"></div>
    </div> --}}

   <div class="today_sale_main">
        <div class="dasboard-menu-item ps-0">
            <div class="today_sale_heading">
                <div class="create_quote_link today_sale py-4">
                    <span class="d-flex align-items-center create_span">
                        <img src="{{ asset('public/img/create_quotation.png') }}" /><a href="javascript:void(0);">Today’s Sales</a>
                    </span>

                    @include('frontend.elements.layouts.time_date_user_details')

                </div>

                <div class="total_invoice_main d-flex align-items-center justify-content-between">
                    <div class="total_invoice_wise d-flex align-items-center">
                        <div class="total_invoice">
                            <p>Total Invoice</p>
                            <h3>{{ count($records) }}</h3>
                        </div>
                        <div class="total_invoice">
                            <p>New Customer</p>
                            <h3>{{ $new_customers ? $new_customers : 0 }}</h3>
                        </div> 
                    </div>                 
                    <div class="total_amount_todal_sale">
                        <p>Amount Transacted  (based on Invoice)</p>
                        <h3>$ {{ number_format($records->sum('total')) }}</h3>
                    </div>
                </div>

                <div class="today_sale_detail">
                    <div class="card-body">
                        <div class="earring-table sale_detail_main table-responsive">
                            <table class="table stock-detail sale-detail">
                                <thead>
                                    <tr>
                                        <th>@sortablelink('reference_date', __('content.date'))</th>
                                        <th>@sortablelink('id', __('content.invoice_id'))</th>
                                        <th>@sortablelink('total', __('content.amount'))</th>
                                        <th>{{ __('content.paid_amount') }}</th>
                                        <th>@sortablelink('customer_name', __('content.customer'))</th>
                                       
                                        @canany(['frontInvoice-refund','frontInvoice-print','frontInvoice-sendEmailPDF'])
                                        <th>{{ __('content.action') }}</th>
                                        @endcanany

                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($records as $record)
                                    <tr>
                                        <td>{{ isset($record->reference_date) ? date('d/m/Y', strtotime($record->reference_date)) : '-' }}</td>
                                        <td>{{ $record->invoice_no ?? '-' }}</td>
                                        <td>{{ !empty($record->total) ? '$'.$record->total : '-' }}</td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <span id="paid_amount-{{ $record->id }}">${{ (($record->is_refund == Invoice::ONE)  && ($record->balance == Invoice::ZERO)) ? $record->balance :  ($record->paid_amount ?? 0) }}</span>

                                                @if($record->due > 0)
                                                <a  href="javascript:void(0)" id="invoicePaidAmount-{{ $record->id }}" class="return_edit" data-record_id="{{ $record->id }}" >    <img class="return_first" src="{{ asset('public/img/icon-edit.png') }}">
                                                </a> <!-- data-bs-toggle="modal" data-bs-target="#Layway_popup" -->
                                                @endif
                                            </div>
                                        </td>
                                        <td>{{ ucwords($record->customer_name) ?? ucwords($record->customer->fullname) ?? '-' }}</td>
                                        <td>
                                            <div class="dropdown">

                                                @canany(['frontInvoice-refund','frontInvoice-print','frontInvoice-sendEmailPDF'])
                                                <button class="btn btn-secondary down" type="button" id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false">
                                                    Action
                                                </button>
                                                @endcanany
                                                
                                                <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">

                                                   @can('frontInvoice-refund')
                                                        <li>
                                                            @if($record->balance > 0)
                                                            <a class="dropdown-item" href="{{ route('invoices.refund', $record->id) }}">
                                                                <img src="{{ asset('public/img/vector.png') }}">Refund
                                                            </a>
                                                            @endif
                                                        </li>
                                                    @endcan

                                                    @can('frontInvoice-print')
                                                        <li>
                                                            <a class="dropdown-item" href="{{ route('invoices.printInvoice', $record->id) }}"> <!-- btnprn -->
                                                                <img src="{{ asset('public/img/print.png') }}">Print Invoice
                                                            </a>
                                                        </li>
                                                    @endcan

                                                    @can('frontInvoice-sendEmailPDF')
                                                        <li>
                                                            <a class="dropdown-item sendEmailPDF" href="javascript:void(0);{{-- route('invoices.sendEmailPDF', $record->id) --}}" id="sendEmailPDF-{{ $record->id }}" data-record_id="{{ $record->id }}" data-for="invoices">
                                                                <img src="{{ asset('public/img/envelope.png') }}">Send email
                                                            </a>
                                                        </li>
                                                    @endcan

                                                </ul>
                                            </div>
                                        </td>
                                    </tr>
                                    @empty
                                    <tr>
                                        <td class="text-center" colspan="7">No Record Found!</td>
                                    </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@include('frontend.elements.scripts.pdf_email_js')  

@include('frontend.invoices.layway_popup')  

@endsection