<div class="row mt-2">
	<div class="col-md-3">
		<div class="short_by new-filter"> 
			<label>Date</label>
			<input type="date" id="date" class="form-control short_by new-filter" name="date" value="{{ (request()->get('date')) ?? '' }}">	
		</div>
	</div>
	<div class="col-md-3">
		<div class="short_by new-filter"> 
			<label>Week</label>
			<input type="week" id="week" class="form-control short_by new-filter" name="week" value="{{ (request()->get('week')) ?? '' }}">
		</div>
	</div>
	<div class="col-md-3">
		<div class="short_by new-filter"> 
			<label>Month</label>
			<input type="month" id="month" class="form-control short_by new-filter" name="month" value="{{ (request()->get('month')) ?? '' }}">
		</div>
	</div>
	<div class="col-md-3">
		<div class="short_by new-filter"> 
			<label>Year</label>
			<select id="year" class="makeMeList form-control" name="year">
				<option value="">Select Year</option>
				@php $i = date('Y'); @endphp
				@while ($i >= 1970)
					<option value="{{ $i }}" {{ (request()->get('year') == $i) ?  'selected' : '' }}>{{ $i }}</option>
				    @php $i--; @endphp
				@endwhile
			</select>
		</div>
	</div>
</div>

<div class="row mt-3">
	@if(!in_array(Route::currentRouteName(), ['admin.transactions.index']))
	<div class="col-md-3">
		<div class="short_by new-filter"> 
			<label>Total Price</label>
			<input type="text" id="total" class="form-control short_by new-filter" name="total" value="{{ (request()->get('total')) ?? '' }}" placeholder="Total Price">
		</div>
	</div>
	@endif
	
	<div class="col-md-3">
		<div class="short_by new-filter"> 
			<label>User Type</label>
			<select id="user_type" class="form-control" name="user_type">
				<option value="">Select User Type</option>
				@php $users = \App\Models\User::getUserTypes(); @endphp
				@foreach($users as $key=>$value)
					<option value="{{ $key }}" {{(request()->get('user_type') == $key) ?  'selected' : '' }}>{{ $value }}</option>
				@endforeach
			</select>
		</div>
	</div>
</div>

<script type="text/javascript">
	$(function () {
    $('.makeMeList').each(function (index, element) {
        $(this).parent()
            .after()
            .append("<div class='scrollableList'><div class='selectedOption'></div><ul></ul></div>");

        $(element).each(function (idx, elm) {
            $('option', elm).each(function (id, el) {
                $('.scrollableList ul:last').append('<li>' + el.text + '</li>');
            });
            $('.scrollableList ul').hide();
            $('.makeMeUl').children('div.selectedOption').text("Select Year");
        });
        $('.scrollableList:last').children('div.selectedOption').text("Select Year");
    });

    $('.selectedOption').on('click', function () {
        $(this).next('ul').slideToggle(200);
        $('.selectedOption').not(this).next('ul').hide();
    });

    $('.scrollableList ul li').on('click', function () {
        var selectedLI = $(this).text();
        $(this).parent().prev('.selectedOption').text(selectedLI);
        $(this).parent('ul').hide();
    });

    $('.scrollableList').show();
    $('.makeMeList').hide();
});
</script>