@php
    use Illuminate\Support\Facades\Route;
    $routeName = Route::currentRouteName();
@endphp

<header>
    <div class="container-fluid">
        <nav class="navbar_custom jewellery ">
            <a class="navbar-brand" href="{{ (Auth::guard('web')->check()) ? route('dashboard') : route('login') }}">
                <img src="{{ asset('public/img/logo.png') }}"/> 
            </a>
            <div class="dashboard">
                <div class="form-group">
                    @if(auth()->user())
                    <select class="form-select" id="dashboardDropdown" value="">
                        <option class="switchDashboard {{ (request()->routeIs('admin.*')) ? 'active' : '' }}" 
                            {{ (request()->routeIs('admin.*')) ? 'selected' : '' }} value="admin" id="adminDashboard">Admin Dashboard</option>
                        <option class="switchDashboard {{ (!request()->routeIs('admin.*')) ? 'active' : '' }}" {{  (!request()->routeIs('admin.*')) ? 'selected' : '' }} value="web" id="frontDashboard">Front Dashboard</option>
                    </select>
                    @endif
                </div>
            </div>
            
            <div class="ms-auto items d-flex">
                <div class="d-flex align-items-center">  
                </div>
                <div class="nav_right_content d-flex align-items-center">
                    <div class="d-flex align-items-center ps-2">
                        {{-- <p href="javascript:void(0);">Get Help</p>
                        <a href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#exampleModal" class="help">?</a> --}}
                    </div>
                    @if(Auth::guard('web')->check())
                    <div class="d-flex align-items-center log">
                        <a href="{{ route('logout') }}" onclick="event.preventDefault(); document.getElementById('logout-form').submit();"><p>Log Out<img class="ms-2" src="{{ asset('public/img/logout.png') }}"/></p></a>
                        <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
                            @csrf
                        </form>
                    </div>
                    @endif
                </div>
            </div>
        </nav>
    </div>
</header>

<script>
    $(document).ready(function(){
        $('#dashboardDropdown').change(function(){
            _this = $(this);
            var selectedVal = _this.val();

            // _this.children().removeClass('active');
            // $('#'+selectedVal+'Dashboard').addClass('active');

            var requestedUrl = '{{ route("switchDashboard", ":requestFor") }}';
            requestedUrl = requestedUrl.replace(':requestFor', selectedVal);
            console.log('requestedUrl', requestedUrl);

            $.ajax({
                type:'GET',
                url: requestedUrl,
                success: function(res){
                    console.log('res :'+res);

                    if(res.status==0){
                        error(res.message, res.title);
                    }else if(res.status==1){
                        window.open(res.data, '_blank');
                        success(res.message, res.title); 
                        location.reload(true); 
                    }
                },
            });
        });
    });
</script>