@extends('layouts.admin.default')

@section('title',"Worksmiths")

@section('header', "Worksmiths")
@section('content')
    <div class="card mb-4">
        <div class="card-header">
            <h4 class="mb-0">All Worksmith</h4>
            <p>This section displays all Worksmith.</p>
        </div>
        <div class="card-body">
            @php
                $placeholder = "Search Worksmith";
            @endphp
              @can('worksmith-create')
            @php
                $create = [
                    'route' => route('admin.worksmiths.create'),
                    'name' => "Create Worksmith"
                ];
            @endphp
            @endcan

            @include('admin.elements.search.common')

            <div class="earring-table table-responsive no_crack" >
                <table class="table stock-detail">
                    <thead>
                    <tr>
                        <th>{{ __('content.account_id') }}</th>
                        <!-- <th>@sortablelink('account_type','Type 中文')</th> -->
                        <th>@sortablelink('fullname', __('content.full_name'))</th>
                        <!-- <th>Country Code</th> -->
                        <th>@sortablelink('phone', __('content.phone_number'))</th>
                        <th>@sortablelink('email', __('content.email'))</th>
                        <!-- <th>@sortablelink('role_id','Role 中文')</th> -->
                        <!-- <th>@sortablelink('username','Username 中文')</th> -->
                        <!-- <th>Status 中文</th> -->
                        <th>{{ __('content.remarks') }}</th>

                        @canany(['worksmith-update','worksmith-delete'])
                        <th>{{ __('content.action') }}</th>  
                        @endcanany

                    </tr>
                    </thead>
                    <tbody>
                    @if(!empty($records) && $records->count())
                        @foreach($records as $record)
                            <tr>
                                @php  $account_id = sprintf("%03d", $record->id); @endphp
                                <td>{{ $account_id }}</td>
                                <!-- <td class="text-center">{{--  !empty($record->account_type) ? $record->account_type : "-" --}}</td> -->
                                <td>{{ ucfirst($record->fullname) }}</td>
                                <!-- <td>{{-- $record->country_code ?? '-' --}}</td> -->
                                <td>{{ $record->phone_with_code }}</td>
                                <td class="text-nowrap">{{ $record->email }}</td>
                                <!-- <td>{{-- ($record->role_id) ? $record->role->name : "NA" --}}</td> -->
                                <!-- <td class="text-center">{{--  !empty($record->username ) ? $record->username  : "-" --}}</td> -->
                                <!-- <td>Active 4mins ago</td> -->
                                <td class="">{{!empty($record->remarks) ? \Illuminate\Support\Str::limit($record->remarks, 50, $end='...') : "-"}}</td>
                              
                                @canany(['worksmith-update','worksmith-delete'])
                                <td>
                                    <div class="dropdown">
                                        <button class="btn btn-secondary down" type="button" id="dropdownMenuButton1"
                                                data-bs-toggle="dropdown" aria-expanded="false">
                                            Action
                                        </button>
                                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                                          
                                            @can('worksmith-update')
                                            <li><a class="dropdown-item" href="{{ route('admin.worksmiths.edit',$record->id ) }}"><img src="{{ asset('public/img/edit.png') }}">Edit</a></li>
                                            @endcan

                                            @can('worksmith-delete')
                                            <li><a class="dropdown-item confirmDelete" href="javascript:void(0);" data-action="{{ route('admin.worksmiths.destroy',$record->id) }}"><img src=" {{ asset('public/img/delete.png') }} ">Delete</a></li>
                                            @endcan
                                            
                                        </ul>
                                    </div>
                                </td>
                                @endcanany
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td class="text-center" colspan="6">No Record Found!</td>
                        </tr>
                    @endif
                    </tbody>
                </table>
            </div>

            @include('admin.elements.pagination.common')
        </div>
    </div>
    <!-- Modal -->

    <div class="modal fade model-custom-1" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel"
         aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered dialog-filter-option">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="staticBackdropLabel">Filter</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body filter-options">
                    <div class="row">
                        <div class="col-lg-12 col-md-12">
                            <div class="form-group">
                                <label for="exampleFormControlInput1" class="form-label cus_label">Jewellery Price Range
                                    (W GST)</label>
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-6">
                            <div class="form-group cus_form_group me-2">
                                <input type="email" class="cus_form_control" id="exampleFormControlInput1"
                                       placeholder="$">
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-6 position-relative">
                            <div class="form-group cus_form_group left-form-control ms-2">
                                <input type="email" class="cus_form_control" id="exampleFormControlInput1"
                                       placeholder="$">
                            </div>
                        </div>
                        <div class="col-lg-12 col-md-12 pt-2">
                            <div class="form-group">
                                <label for="exampleFormControlInput1" class="form-label cus_label">Worksmith Price
                                    Range</label>
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-6">
                            <div class="form-group cus_form_group me-2">
                                <input type="email" class="cus_form_control" id="exampleFormControlInput1"
                                       placeholder="$">
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-6 position-relative">
                            <div class="form-group cus_form_group left-form-control ms-2">
                                <input type="email" class="cus_form_control" id="exampleFormControlInput1"
                                       placeholder="$">
                            </div>
                        </div>
                        <div class="col-lg-12 col-md-12 pt-2">
                            <div class="form-group">
                                <label for="exampleFormControlInput1" class="form-label cus_label">Gold Price
                                    Range</label>
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-6">
                            <div class="form-group cus_form_group me-2">
                                <input type="email" class="cus_form_control" id="exampleFormControlInput1"
                                       placeholder="$">
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-6 position-relative">
                            <div class="form-group cus_form_group left-form-control ms-2">
                                <input type="email" class="cus_form_control" id="exampleFormControlInput1"
                                       placeholder="$">
                            </div>
                        </div>
                        <div class="col-lg-12 col-md-12 pt-2">
                            <div class="form-group">
                                <label for="exampleFormControlInput1" class="form-label cus_label">Gold Colour</label>
                                <select class="form-select" aria-label="Default select example">
                                    <option selected>Select One Option</option>
                                    <option value="1">One</option>
                                    <option value="2">Two</option>
                                    <option value="3">Three</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-lg-12 col-md-12 pt-2">
                            <div class="form-group">
                                <label for="exampleFormControlInput1" class="form-label cus_label">Backing Type</label>
                                <select class="form-select" aria-label="Default select example">
                                    <option selected>Select One Option</option>
                                    <option value="1">One</option>
                                    <option value="2">Two</option>
                                    <option value="3">Three</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-lg-12 col-md-12 pt-2">
                            <div class="form-group">
                                <label for="exampleFormControlInput1" class="form-label cus_label">Claw Type</label>
                                <select class="form-select" aria-label="Default select example">
                                    <option selected>Select One Option</option>
                                    <option value="1">One</option>
                                    <option value="2">Two</option>
                                    <option value="3">Three</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-lg-12 col-md-12 mt-3">
                            <div class="filter-modal-btn m-0">
                                <button type="button" class="btn btn-filter" data-bs-dismiss="modal"><i
                                            class="icofont-filter"></i>Filter</button>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
    @include('admin.worksmiths.script')
@endsection
