@extends('layouts.admin.default')

@section('title',"SubAdmins")

@section('header', "SubAdmins")
@section('content')
    <div class="card mb-4">
        <div class="card-header">
            <h4 class="mb-0">SubAdmins</h4>
            <p>This section displays the SubAdmins in Sancy’s Inventory</p>
        </div>
        <div class="card-body">
            @include('admin.elements.search.common')
            <div class="earring-table table-responsive">
                <table class="table stock-detail">
                    <thead>
                    <tr>
                        <th>{{ __('content.select') }}</th>
                        <th>{{ __('content.image') }}</th>
                        <th>#</th>
                        <th>@sortablelink('firstname', __('content.full_name'))</th>
                        <th>@sortablelink('email', __('content.email'))</th>
                        <th>@sortablelink('phone', __('content.phone_number'))</th>
                        <th>@sortablelink('created_at', __('content.created_at'))</th>
                        <th>{{ __('content.action') }}</th>
                    </tr>
                    </thead>
                    <tbody>
                    @if(!empty($records) && $records->count())
                        @php $slNo = $records->firstItem() @endphp
                        @foreach($records as $record)

                            <tr>
                                <td>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault">
                                    </div>
                                </td>
                                <td>
                                    <a data-fancybox="gallery" href="{{@$record->image}}"><img  width="70" src="{{ @$record->image }}"></a>
                                </td>
                                <td>{{$slNo++}}</td>
                                <td>{{ ucfirst($record->fullname) }}</td>
                                <td>{{ $record->email }}</td>
                                <td>{{ $record->phone }}</td>
                                <td>{{ date('d/m/y', strtotime($record->created_at))}}</td>
                                <td>
                                    <div class="dropdown">
                                        <button class="btn btn-secondary down" type="button" id="dropdownMenuButton1"
                                                data-bs-toggle="dropdown" aria-expanded="false">
                                            Action
                                        </button>
                                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">

                                            <li><a class="dropdown-item duplicate" href="#"><img src="{{ asset('public/img/duplicate.png') }}">Duplicate</a></li>
                                            <li><a class="dropdown-item" href="#"><img src="{{ asset('public/img/quotation.png') }}">Quotations</a></li>
                                            <li><a class="dropdown-item" href="{{ route('admin.subadmins.edit',$record->id ) }}"><img src="{{ asset('public/img/edit.png') }}">Edit</a></li>
                                            <li><a class="dropdown-item" href="#"><img src="{{ asset('public/img/print.png') }}">Print</a></li>
                                            <li><a class="dropdown-item confirmDelete" href="javascript:void(0);"
                                                   data-action="{{ route('admin.subadmins.destroy',$record->id) }}"><img
                                                            src=" {{ asset('public/img/delete.png') }} ">Delete</a></li>
                                        </ul>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td class="text-center" colspan="13">No Record Found!</td>
                        </tr>
                    @endif
                    </tbody>
                </table>
            </div>
            @include('admin.elements.pagination.common')
        </div>
    </div>
    <!-- Modal -->
    <div class="modal fade model-custom-1" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel"
         aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered dialog-filter-option">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="staticBackdropLabel">Filter</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body filter-options">
                    <div class="row">
                        <div class="col-lg-12 col-md-12">
                            <div class="form-group">
                                <label for="exampleFormControlInput1" class="form-label cus_label">Jewellery Price Range
                                    (W GST)</label>
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-6">
                            <div class="form-group cus_form_group me-2">
                                <input type="email" class="cus_form_control" id="exampleFormControlInput1"
                                       placeholder="$">
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-6 position-relative">
                            <div class="form-group cus_form_group left-form-control ms-2">
                                <input type="email" class="cus_form_control" id="exampleFormControlInput1"
                                       placeholder="$">
                            </div>
                        </div>
                        <div class="col-lg-12 col-md-12 pt-2">
                            <div class="form-group">
                                <label for="exampleFormControlInput1" class="form-label cus_label">Worksmith Price
                                    Range</label>
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-6">
                            <div class="form-group cus_form_group me-2">
                                <input type="email" class="cus_form_control" id="exampleFormControlInput1"
                                       placeholder="$">
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-6 position-relative">
                            <div class="form-group cus_form_group left-form-control ms-2">
                                <input type="email" class="cus_form_control" id="exampleFormControlInput1"
                                       placeholder="$">
                            </div>
                        </div>
                        <div class="col-lg-12 col-md-12 pt-2">
                            <div class="form-group">
                                <label for="exampleFormControlInput1" class="form-label cus_label">Gold Price
                                    Range</label>
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-6">
                            <div class="form-group cus_form_group me-2">
                                <input type="email" class="cus_form_control" id="exampleFormControlInput1"
                                       placeholder="$">
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-6 position-relative">
                            <div class="form-group cus_form_group left-form-control ms-2">
                                <input type="email" class="cus_form_control" id="exampleFormControlInput1"
                                       placeholder="$">
                            </div>
                        </div>
                        <div class="col-lg-12 col-md-12 pt-2">
                            <div class="form-group">
                                <label for="exampleFormControlInput1" class="form-label cus_label">Gold Colour</label>
                                <select class="form-select" aria-label="Default select example">
                                    <option selected>Select One Option</option>
                                    <option value="1">One</option>
                                    <option value="2">Two</option>
                                    <option value="3">Three</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-lg-12 col-md-12 pt-2">
                            <div class="form-group">
                                <label for="exampleFormControlInput1" class="form-label cus_label">Backing Type</label>
                                <select class="form-select" aria-label="Default select example">
                                    <option selected>Select One Option</option>
                                    <option value="1">One</option>
                                    <option value="2">Two</option>
                                    <option value="3">Three</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-lg-12 col-md-12 pt-2">
                            <div class="form-group">
                                <label for="exampleFormControlInput1" class="form-label cus_label">Claw Type</label>
                                <select class="form-select" aria-label="Default select example">
                                    <option selected>Select One Option</option>
                                    <option value="1">One</option>
                                    <option value="2">Two</option>
                                    <option value="3">Three</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-lg-12 col-md-12 mt-3">
                            <div class="filter-modal-btn m-0">
                                <button type="button" class="btn btn-filter" data-bs-dismiss="modal"><i
                                            class="icofont-filter"></i>Filter</button>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>


    <script>
        // $('.datePicker').datetimepicker({
        //     format: 'd-m-Y',
        //     timepicker: false
        // });
    </script>
@endsection
