@extends('layouts.admin.default')

@section('title',"Add SubAdmin")

@section('header', "Add SubAdmin")

@section('content')

    <div class="card details mb-4">
        <div class="card-header">
            <h4 class="mb-0">Add SubAdmin</h4>
        </div>
        <div class="card-body">
            <form method="POST" class="sign-in-form" class="sign-in-form" enctype="multipart/form-data"
                  action="{{ route('admin.subadmins.store') }}" autocomplete="off">
                @csrf
                <div class="row">
                    <div class="modal-login pb-0">
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label">First Name</label>
                                    <input type="text" name="firstname" class="form-control"
                                           placeholder="Enter First Name"
                                           value="{{ old('firstname',$record->firstname) }}">
                                    @if ($errors->has('firstname'))
                                        <span class="error-message">
                                            <strong>{{ $errors->first('firstname') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label">Last Name</label>
                                    <input type="text" name="lastname" class="form-control"
                                           placeholder="Enter Last Name"
                                           value="{{ old('lastname',$record->lastname) }}">
                                    @if ($errors->has('lastname'))
                                        <span class="error-message">
                                            <strong>{{ $errors->first('lastname') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="modal-login pb-0">
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label">Email</label>
                                    <input type="text" name="email" class="form-control"
                                           placeholder="Enter Email"
                                           value="{{ old('email',$record->email) }}">
                                    @if ($errors->has('email'))
                                        <span class="error-message">
                                            <strong>{{ $errors->first('email') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label">Role</label>
                                    <select class="form-control" name="role_id">
                                        <option value="">Select Option</option>
                                        @foreach($role as $key=>$value)
                                            <option value="{{ $key }}" {{ old('role_id',$record->role_id) == $key ? 'selected' : '' }}>{{ $value }}</option>
                                        @endforeach
                                    </select>
                                    @if ($errors->has('role_id'))
                                        <span class="error-message">
                                            <strong>{{ $errors->first('role_id') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="modal-login pb-0">
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label">Password</label>
                                    <input type="password" name="password" class="form-control"
                                           placeholder="Enter Password"
                                           value="">
                                    @if ($errors->has('password'))
                                        <span class="error-message">
                                            <strong>{{ $errors->first('password') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label for="exampleFormControlInput1" class="form-label">Confirm Password</label>
                                    <input type="password" name="password_confirmation" class="form-control"
                                           placeholder="Enter Confirm Password">
                                    @if ($errors->has('password_confirmation'))
                                        <span class="error-message">
                                            <strong>{{ $errors->first('password_confirmation') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-lg-6">
                        <div class="form-group">
                            <label for="exampleFormControlInput1" class="form-label">Phone</label>
                            <input type="text" name="phone" class="form-control"
                                   placeholder="Enter Phone"
                                   value="{{ old('phone',$record->phone) }}">
                            @if ($errors->has('phone'))<span
                                    class="error-message"><strong>{{ $errors->first('phone') }}</strong></span>@endif
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="form-group">
                            <label for="exampleFormControlInput1" class="form-label">Image</label>
                            <input type="file" name="image" class="form-control">
                        </div>
                    </div>
                </div>
                <div class="buttons mt-5">
                    <button class="btn btn-primary btn-create" type="submit">Add</button>
                    <a href="{{ route('admin.subadmins.index') }}" class="btn btn-primary btn-reset-form"
                       type="submit">Cancel</a>
                </div>
            </form>
        </div>
    </div>

@endsection
