@extends('layouts.admin.default')

@section('title',"Staffs")

@section('header', "Staffs")
@section('content')
    <div class="card mb-4">
        <div class="card-header">
            <h4 class="mb-0">All Accounts</h4>
            <p>This section displays all accounts.</p>
        </div>
        <div class="card-body">
            @php
                $placeholder = "Search Accounts";
            @endphp

            @can('staff-create')
                @php
                    $create = [
                        'route' => route('admin.staffs.create'),
                        'name' => "Create staff"
                    ];
                @endphp
            @endcan
            @include('admin.elements.search.common')

            <div class="card-body create_quotation">
                <div class="add_item">
                    <div class="items all_accounts">
                        @php
                            $activeTab =  !empty(request()->tab) ? request()->tab : null ;   
                            $tabAll  = \App\Models\Admin::TABALL;
                            $tabSubadmin   = \App\Models\Admin::TABSUBADMIN;
                            $tabStaff   = \App\Models\Admin::TABSTAFF;
                        @endphp

                        <ul class="nav nav-tabs" id="myTab" role="tablist">
                            <li class="nav-item ms-0" role="presentation">
                                {{-- <button class="nav-link account_type all {{ ($activeTab) == $tabAll  ||  ($activeTab == null)  ? 'active' : '' }}" data-tab={{ $tabAll }} id="home-tab" data-bs-toggle="tab" data-bs-target="#home-tab-pane" type="button" role="tab" aria-controls="home-tab-pane" aria-selected="true">All</button> --}}
                                <a href="{{route('admin.staffs.index', [ 'tab' => $tabAll ]) }}" class="nav-link account_type all text-center {{ ($activeTab) == $tabAll  ||  ($activeTab == null)  ? 'active' : '' }}">All</a>
                            </li>
                            <li class="nav-item ms-0" role="presentation">
                                <a href="{{route('admin.staffs.index', [ 'tab' => $tabSubadmin ]) }}" class="nav-link text-center account_type sub-admin btn-brown {{ ($activeTab) == $tabSubadmin ? 'active' : '' }}">Sub-Admin</a>
                                {{-- <button class="nav-link account_type sub-admin btn-brown {{ ($activeTab) == $tabSubadmin ? 'active' : '' }}" id="profile-tab" data-tab="{{ $tabSubadmin }}" data-bs-toggle="tab" data-bs-target="#profile-tab-pane" type="button" role="tab" aria-controls="profile-tab-pane" aria-selected="false">Sub-Admin</button> --}}
                            </li>
                            <li class="nav-item ms-0" role="presentation">
                                <a href="{{route('admin.staffs.index', [ 'tab' => $tabStaff ]) }}" class="nav-link text-center account_type staff {{ ($activeTab) == $tabStaff ? 'active' : '' }}">Staff</a>
                                {{-- <button class="nav-link account_type staff {{ ($activeTab) == $tabStaff ? 'active' : '' }}" id="contact-tab" data-tab="{{ $tabStaff }}" data-bs-toggle="tab" data-bs-target="#contact-tab-pane" type="button" role="tab" aria-controls="contact-tab-pane" aria-selected="false">Staff</button> --}}
                            </li>
                        </ul>

                        <div class="tab-content" id="myTabContent">
                            <div class="tab-pane fade {{ ($activeTab)== $tabAll || ($activeTab == null)  ? 'show active' : '' }}"
                                 id="home-tab-pane" role="tabpanel" aria-labelledby="home-tab" tabindex="0">
                                <div class="earring-table table-responsive no_crack">
                                    <table class="table stock-detail">
                                        {{-- <input type="hidden" name="tab" value="all" > --}}
                                        <thead>
                                        <tr>
                                            <th>{{ __('content.account_id') }}</th>
                                            <th>@sortablelink('account_type', __('content.type'))</th>
                                            <th>@sortablelink('fullname', __('content.full_name'))</th>
                                            <th>@sortablelink('phone', __('content.phone_number'))</th>
                                            <th>@sortablelink('email', __('content.email'))</th>
                                            <th>@sortablelink('role_id', __('content.role'))</th>
                                            <th>@sortablelink('username', __('content.username'))</th>
                                            <th>{{ __('content.status') }}</th>
                                            <th>{{ __('content.remarks') }}</th>
                                            <th>{{ __('content.action') }}</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @if(!empty($all) && $all->count())
                                            @foreach($all as $record)
                                                @php  // $account_id = sprintf("%03d", $record->id); @endphp
                                                <tr>
                                                    <td>
                                                        {{ getItemCode(3, $record->id) }}
                                                        {{-- $account_id --}}
                                                    </td>
                                                    <td class="">{{ !empty($record->account_type) ? $record->account_type :" -" }}</td>
                                                    <td>{{ ucfirst($record->fullname) }}</td>
                                                    <td class="text-nowrap">{{ $record->phone_with_code }}</td>
                                                    <td>{{ $record->email }}</td>
                                                    <td>{{ !empty($record->role) ? @$record->role->name : "NA"  }}</td>
                                                    <td class="">{{ !empty($record->username) ? $record->username : "-" }}</td>
                                                    <td>Active 4mins ago</td>
                                                    <td class="description">{{ !empty($record->remarks) ? \Illuminate\Support\Str::limit($record->remarks, 50, $end='...') : "-" }}</td>
                                                    @canany(['staff-update','staff-delete'])
                                                    <td>
                                                        <div class="dropdown">
                                                            <button class="btn btn-secondary down" type="button" id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false">Action</button>
                                                            <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                                                                @can('staff-update') 
                                                                <li><a class="dropdown-item" href="{{ route('admin.staffs.edit',['id' =>$record->id ,'tab' => $tabAll] )}}"><img src="{{ asset('public/img/edit.png') }}">Edit</a></li>
                                                                @endcan

                                                                @can('staff-delete')  
                                                                <li><a class="dropdown-item confirmDelete" href="javascript:void(0);" data-action="{{ route('admin.staffs.destroy',$record->id) }}"><img src=" {{ asset('public/img/delete.png') }}">Delete</a></li>
                                                                @endcan 

                                                            </ul>
                                                        </div>
                                                    </td>
                                                  @endcan 
                                                </tr>
                                            @endforeach
                                        @else
                                            <tr>
                                                <td class="text-center" colspan="13">No Record Found!</td>
                                            </tr>
                                        @endif
                                        </tbody>
                                    </table>
                                </div>
                                @include('admin.elements.pagination.common',[$records = $all])
                            </div>
                            <div class="tab-pane fade {{ ($activeTab) == $tabSubadmin  ? 'show active' : '' }}"
                                 id="profile-tab-pane" role="tabpanel" aria-labelledby="profile-tab" tabindex="0">
                                <div class="earring-table table-responsive no_crack">
                                    <table class="table stock-detail">
                                        <thead>
                                        <tr>
                                            <th>{{ __('content.account_id') }}</th>
                                            <th>@sortablelink('account_type', __('content.type'))</th>
                                            <th>@sortablelink('firstname', __('content.full_name'))</th>
                                            <th>@sortablelink('phone', __('content.phone_number'))</th>
                                            <th>@sortablelink('email', __('content.email'))</th>
                                            <th>@sortablelink('role_id', __('content.role'))</th>
                                            <th>@sortablelink('username', __('content.username'))</th>
                                            <th>{{ __('content.status') }}</th>
                                            <th>{{ __('content.remarks') }}</th>
                                            <th>{{ __('content.action') }}</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @if(!empty($subAdmins) && $subAdmins->count())
                                            @foreach($subAdmins as $record)
                                                <tr>
                                                    @php  // $account_id = sprintf("%03d", $record->id); @endphp
                                                    <td>
                                                        {{ getItemCode(3, $record->id) }}
                                                        {{-- $account_id --}}
                                                    </td>
                                                    <td class="">{{ !empty($record->account_type) ? $record->account_type: "-" }}</td>
                                                    <td>{{ ucfirst($record->fullname) }}</td>
                                                    <td class="text-nowrap">{{ $record->phone_with_code }}</td>
                                                    <td>{{ $record->email }}</td>
                                                    <td>{{($record->role_id ?  $record->role->name : "NA") }}</td>
                                                    <td class="">{{ !empty($record->username) ? $record->username : "-" }}</td>
                                                    <td>Active 4mins ago</td>
                                                    <td class="description">{{ !empty($record->remarks) ? \Illuminate\Support\Str::limit($record->remarks, 50, $end='...') : "-" }}</td>
                                                    @canany(['staff-update','staff-delete'])
                                                    <td>
                                                        <div class="dropdown">
                                                            <button class="btn btn-secondary down" type="button" id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false">Action</button>
                                                            <ul class="dropdown-menu"
                                                                aria-labelledby="dropdownMenuButton1">
                                                                @can('staff-update')
                                                                <li><a class="dropdown-item" href="{{ route('admin.staffs.edit',['id' =>$record->id ,'tab' => $tabSubadmin]  ) }}"><img src="{{ asset('public/img/edit.png') }}">Edit</a></li>
                                                                @endcan
                                                                @can('staff-delete')
                                                                <li><a class="dropdown-item confirmDelete" href="javascript:void(0);" data-action="{{ route('admin.staffs.destroy',$record->id) }}"><img src=" {{ asset('public/img/delete.png') }} ">Delete</a></li>
                                                                @endcan
                                                            </ul>
                                                        </div>
                                                    </td>
                                                    @endcan
                                                </tr>
                                            @endforeach
                                        @else
                                            <tr>
                                                <td class="text-center" colspan="13">No Record Found!</td>
                                            </tr>
                                        @endif
                                        </tbody>
                                    </table>
                                </div>
                                @include('admin.elements.pagination.common',[$records = $subAdmins])
                            </div>
                            <div class="tab-pane fade {{ ($activeTab) == $tabStaff ? 'show active' : '' }}"
                                 id="contact-tab-pane" role="tabpanel" aria-labelledby="contact-tab" tabindex="0">
                                <div class="earring-table table-responsive no_crack">
                                    <table class="table stock-detail">
                                        <thead>
                                        <tr>
                                            <th>{{ __('content.account_id') }}</th>
                                            <th>@sortablelink('account_type', __('content.type'))</th>
                                            <th>@sortablelink('firstname', __('content.full_name'))</th>
                                            <th>@sortablelink('phone', __('content.phone_number'))</th>
                                            <th>@sortablelink('email', __('content.email'))</th>
                                            <th>@sortablelink('role_id', __('content.role'))</th>
                                            <th>@sortablelink('username', __('content.username'))</th>
                                            <th>{{ __('content.status') }}</th>
                                            <th>{{ __('content.remarks') }}</th>
                                            @canany(['staff-update','staff-delete'])
                                            <th>{{ __('content.action') }}</th>
                                            @endcan
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @if(!empty($staffs) && $staffs->count())
                                            @foreach($staffs as $record)
                                                @php  // $account_id = sprintf("%03d", $record->id); @endphp
                                                <tr>
                                                    <td>
                                                        {{ getItemCode(3, $record->id) }}
                                                        {{-- $account_id --}}
                                                    </td>
                                                    <td class="">{{ !empty($record->account_type) ? $record->account_type : "-" }}</td>
                                                    <td>{{ ucfirst($record->fullname) }}</td>
                                                    <td class="text-nowrap">{{ $record->phone_with_code }}</td>
                                                    <td>{{ $record->email }}</td>
                                                    <td>{{ !empty($record->role_id) ? @$record->role->name : "NA" }}</td>
                                                    <td class="">{{ !empty($record->username ) ? $record->username  : "-"}}</td>
                                                    <td>Active 4mins ago</td>
                                                    <td class="">{{ !empty($record->remarks) ? \Illuminate\Support\Str::limit($record->remarks, 50, $end='...') : "-" }}</td>
                                                    @canany(['staff-update','staff-delete'])
                                                    <td>
                                                        <div class="dropdown">
                                                            <button class="btn btn-secondary down" type="button"
                                                                    id="dropdownMenuButton1"
                                                                    data-bs-toggle="dropdown" aria-expanded="false">
                                                                Action
                                                            </button>
                                                            <ul class="dropdown-menu"
                                                                aria-labelledby="dropdownMenuButton1">
                                                                @can('staff-update')
                                                                    <li><a class="dropdown-item" href="{{ route('admin.staffs.edit',['id' =>$record->id ,'tab' =>$tabStaff]  ) }}"><img src="{{ asset('public/img/edit.png') }}">Edit</a></li>
                                                                @endcan
                                                                @can('staff-delete')
                                                                    <li><a class="dropdown-item confirmDelete" href="javascript:void(0);" data-action="{{ route('admin.staffs.destroy',$record->id) }}"><img src=" {{ asset('public/img/delete.png') }} ">Delete</a></li>
                                                                @endcan
                                                            </ul>
                                                        </div>
                                                    </td>
                                                     @endcan
                                                </tr>
                                            @endforeach
                                        @else
                                            <tr>
                                                <td class="text-center" colspan="13">No Record Found!</td>
                                            </tr>
                                        @endif
                                        </tbody>
                                    </table>
                                </div>
                                @include('admin.elements.pagination.common',[$records = $staffs])
                            </div>
                        </div>
                    </div>
                </div>
            </div> 
        </div>
    </div>

    @include('admin.staffs.script')
@endsection
