@extends('layouts.admin.default')

@section('title',"Edit Staff")

@section('header', "Edit Staff")

@section('content')

    <form action="{{ route('admin.staffs.update',$record->id) }}" method="post" autocomplete="off">
        @csrf
        @method('PUT')
        <div class="card mb-4">
            <div class="card-header">
                <h4 class="mb-0">Edit Account</h4>
            </div>
            <input type="hidden" name="tab" value="{{ request()->tab }}">
            <div class="card-body">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="form-group cus_form_group">
                            <label  class="form-label cus_label pe-5">Account Type</label>
                            <div class="form-group d-flex">
                                @php $account_type = CommonHelper::getAccountType();@endphp
                                @foreach($account_type as $key=>$value)
                                    <div class="form-check">
                                        <input class="form-check-input cus-form-check-input account_type" type="radio"
                                               name="account_type" value="{{ $key }}"
                                                {{ old('account_type',$record->account_type) == $key ? "checked": " "}}  {{ ($key) == \App\Models\Admin::SUBADMIN ? "checked": " "}}>
                                        <label class="form-check-label cus_form_check_label">{{ $value }}</label>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="card details mb-4">
            <div class="card-header">
                <h4 class="mb-0">Edit Staff Account</h4>
            </div>
            <div class="card-body">
                <div class="col-lg-12 mt-3">
                    <label  class="form-label">
                        {{ __('content.draw_upload') }}
                        <img src="{{ asset('public/img/folder.png') }}" class="folder"></label>
                    <div class="row">
                        <div class="col-lg-4">
                            <div class="form-group pt-0">
                                <div class="drop-zone" id="notClikable">
                                    <div class="dropzone" id="dropZoneimageUpload">
                                            <span class="drop-zone__prompt dz-default dz-message text-start">Drop Photo here <br>
                                            {{ __('content.drop_photo_only') }}
                                            <p style="text-align: left;margin-top: 10px;">Photo Requiement:</p>
                                            <ul>
                                                <li>File type PNG or JPG</li>
                                                <li>Maximum Size: 2 MB</li>
                                            </ul>
                                            </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <div class="preview-droped-images">
                                @if(!empty($record->image))
                                    <div class="dz-preview dz-processing dz-image-preview dz-complete">
                                        <div class="dz-image">
                                            <img data-dz-thumbnail="" height="60" alt="bracelet.png"
                                                 src="{{ $record->image_url  }}">
                                        </div>
                                        <a class="dz-remove remove_button" href="javascript:undefined;"
                                           data-dz-remove="">X</a>
                                        <input type="hidden" value="{{ $record->image }}" id="imageById" name="image">
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
                <div class="mt-3">
                    <div class="row">
                        <div class="col-lg-6 col-md-6">
                            <div class="form-group pt-0">
                                <label for="fullname" class="form-label">{{ __('content.full_name') }}</label>
                                <input type="text" class="form-control" name="fullname" id="fullname" value="{{ old('fullname',$record->fullname) }}">
                            </div>
                            @if ($errors->has('fullname'))
                                <span class="error-message">
                                <strong>{{ $errors->first('fullname') }}</strong>
                            </span>
                            @endif
                        </div>

                        <div class="col-lg-6 col-md-6">
                            <div class="form-group pt-0">
                                <label  class="form-label">Date of Birth</label>
                                <input type="text" name="dob" class="form-control datePicker" value="{{ old('dob', !empty($record->dob) ? date('d-m-Y', strtotime($record->dob)): ' ' ) }}">
                            </div>
                            @if ($errors->has('dob'))
                                <span class="error-message">
                            <strong>{{ $errors->first('dob') }}</strong>
                            </span>
                            @endif
                        </div>
                        <div class="col-lg-6 mt-2 cus_form_group">
                            <div class="form-group d-flex align-items-center justify-content-between pt-2">
                                <label  class="form-label mb-0 pe-5">Gender</label>
                                <div class="gender_input">
                                    @php $gender = \App\Models\Admin::getGender(); @endphp
                                    @if(!empty($gender))
                                        @foreach($gender as $key=>$value)
                                            <div class="form-check me-0 ms-4">
                                                <input class="form-check-input cus-form-check-input" type="radio"
                                                       name="gender" value="{{ $key }}"
                                                        {{ old("gender",$record->gender) == $key ? 'checked' : '' }} {{ ($key) == \App\Models\Admin::MALEVALUE ? "checked": " "}}>
                                                <label class="form-check-label cus_form_check_label" for="flexRadioDefault1">
                                                    {{ $value }}
                                                </label>
                                            </div>
                                        @endforeach
                                    @endif
                                    @if ($errors->has('gender'))<span
                                            class="error-message"><strong>{{ $errors->first('gender') }}</strong></span>@endif
                                </div>
                            </div>
                        </div>
                        <div class="w-100"></div>
                        @php
                             $phone_with_code=  $record->country_code." ".$record->phone
                                @endphp

                        <div class="col-lg-6 col-md-6 ">
                            <div class="form-group">
                                <label  class="form-label">{{ __('content.phone_number') }}</label>
                                <input type="text" name="phone" class="form-control"
                                       value="{{ old('phone',$phone_with_code) }}">
                            </div>
                            @if ($errors->has('phone'))<span
                                    class="error-message"><strong>{{ $errors->first('phone') }}</strong></span>@endif
                        </div>
                        <div class="col-lg-6 col-md-6">
                            <div class="form-group">
                                <label for="email" class="form-label">{{ __('content.email') }}</label>
                                <input type="text" name="email" class="form-control" id="email"
                                       value="{{ old('email',$record->email) }}">
                            </div>
                            @if ($errors->has('email'))<span
                                    class="error-message"><strong>{{ $errors->first('email') }}</strong></span>
                            @endif
                        </div>

                        <div class="col-lg-12">
                            <div class="form-group">
                                <label  class="form-label">Address</label>
                                <textarea class="form-control" name="address" value="" placeholder="Address" rows="1">{{ old('address',$record->address) }}</textarea>
                            </div>
                            @if ($errors->has('address'))
                                <span class="error-message">
                            <strong>{{ $errors->first('address') }}</strong>
                            </span>
                            @endif
                        </div>
                        <div class="col-lg-6 col-md-6">
                            <div class="form-group">
                                <label  class="form-label">{{ __('content.username') }}</label>
                                <input type="text" name="username" class="testmax form-control"
                                       value="{{ old('username',$record->username) }}">
                            </div>
                            @if ($errors->has('username'))
                                <span class="error-message">
                            <strong>{{ $errors->first('username') }}</strong>
                            </span>
                            @endif
                        </div>
                        <div class="col-lg-3 col-md-3">
                            <div class="form-group">
                                <label for="password" class="form-label">Password</label>
                                <input type="password" class="form-control" name="password"
                                       id="password">
                                <label class="form-label">Minimum 8 characters</label>
                            </div>
                            @if ($errors->has('password'))
                                <span class="error-message">
                                            <strong>{{ $errors->first('password') }}</strong>
                                        </span>
                            @endif
                        </div>
                        <div class="col-lg-3 col-md-3">
                            <div class="form-group">
                                <label  class="form-label">Confirm Password</label>
                                <input type="password" name="password_confirmation" class="form-control">
                            </div>
                        </div>
                        @if ($errors->has('password_confirmation'))
                            <span class="error-message">
                                <strong>{{ $errors->first('password_confirmation') }}</strong>
                            </span>
                        @endif
                        <div class="col-lg-6 col-md-6 role">
                            <div class="form-group">
                                <label  class="form-label">{{ __('content.role') }}</label>
                                <select class="form-select" name="role_id">
                                    @php  $role =  \App\Models\Role::getRoleList(); @endphp
                                    <option value="">Select Option</option>
                                    @foreach($role as $key=>$value)
                                        <option value="{{ $key }}" {{ old('role_id',$record->role_id) == $key ? 'selected' : '' }}>{{ $value }}</option>
                                    @endforeach
                                </select>
                                @if ($errors->has('role_id'))
                                    <span class="error-message">
                                            <strong>{{ $errors->first('role_id') }}</strong>
                                        </span>
                                @endif
                            </div>
                        </div>

                        <div class="col-lg-12">
                            <div class="form-group">
                                <label class="form-label">{{ __('content.remarks') }}</label>
                                <textarea type="text" name="remarks" value="" class="form-control"
                                          rows="1">{{ old('remarks',$record->remarks) }}</textarea>
                            </div>
                            @if ($errors->has('remarks'))
                                <span class="error-message">
                            <strong>{{ $errors->first('remarks') }}</strong>
                            </span>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="card details mb-4">
            <div class="card-body">
                <div class="buttons">
                    <button class="btn btn-primary btn-create" type="submit">Update</button>
                    <a href="" class="btn btn-primary btn-reset-form"
                       type="button">Reset Form</a>
                </div>
            </div>
        </div>
    </form>
    @include('admin.staffs.script')
@endsection
