@extends('layouts.admin.default')

@section('title',"Add Size")

@section('header', "Add Size")


@section('content')

<div class="card details mb-4">
    <div class="card-header">
        <h4 class="mb-0">Add Size</h4>
    </div>
    <div class="card-body">
        <form method="POST" class="sign-in-form" action="{{ route('admin.sizes.store') }}" autocomplete="off">
            @csrf
            <div class="row">
                <div class="modal-login pb-0">
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="form-group">
                                <label for="exampleFormControlInput1" class="form-label">Category</label>
                                <select name="category_id" class="form-select" aria-label="Default select example" value="{{ old('status',$record->status) }}">
                                    <option value="">Select Category</option>
                                    @php $options = \App\Models\Category::getCategoriesList(); @endphp
                                    @foreach($options as $key=>$value)
                                    <option {{ old('category_id',$record->category_id) == $key ? 'selected' : '' }} value="{{ $key }}"  >{{ ucwords($value) }}</option>
                                    @endforeach
                                </select>
                                @if ($errors->has('category_id'))
                                <span class="error-message">
                                    <strong>{{ $errors->first('category_id') }}</strong>
                                </span>
                                @endif
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="form-group">
                                <label for="exampleFormControlInput1" class="form-label">Size</label>
                                <input type="text" name="name" placeholder="Enter Size" value="{{old('name',$record->name)}}" class="form-control" id="exampleFormControlInput1" >
                                @if ($errors->has('name'))
                                <span class="error-message">
                                    <strong>{{ $errors->first('name') }}</strong>
                                </span>
                                @endif
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="form-group">
                                <label for="exampleFormControlInput1" class="form-label">Status</label>
                                <select name="status" class="form-select" aria-label="Default select example" value="{{ old('status',$record->status) }}">
                                    @php $options = CommonHelper::getStatusOption(); @endphp
                                    @foreach($options as $key=>$value)
                                    <option {{ old('status',$record->status) == $key ? 'selected' : '' }} value="{{ $key }}"  > {{ $value }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
            </div>    
            <div class="buttons mt-5">
                <button class="btn btn-primary btn-create" type="submit">Add</button>
                <a href="{{route('admin.sizes.index')}}" class="btn btn-primary btn-reset-form" type="submit">Back</a>
            </div>
        </form>
    </div>
</div>   

@endsection