@extends('layouts.admin.default')

@section('title',"Shop Settings")

@section('header', "Shop Settings")

@section('content')

    <form action="{{ route('admin.settings.updateShopSettings') }}" method="post" autocomplete="off">
        @csrf
        @method('PUT')
        <!-- <div class="card mb-4">
            <div class="card-header">
                <h4 class="mb-0">Shop Settings</h4>
            </div>
        </div> -->
        <div class="card details mb-4">
            <div class="card-header">
                <h4 class="mb-0">Edit Shop Settings</h4>
            </div>
            <div class="card-body pt-0">
                <div class="mt-1">
                    <div class="row">
                        @foreach($records as $key=>$value)
                        <div class="col-lg-6 col-md-6">
                            <div class="form-group">
                                <label for="{{ $value['key'] }}" class="form-label">{{ \CommonHelper::displaySettingLabel($value['key'])  }}</label>
                                <input type="text" class="form-control" name="{{ $value['key'] }}" id="{{ $value['key'] }}" value="{{ old($value['key'],$value['value']) }}">
                            </div>
                            @if ($errors->has($value['key']))
                                <span class="error-message">
                                <strong>{{ $errors->first($value['key']) }}</strong>
                            </span>
                            @endif
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
        <div class="card details mb-4">
            <div class="card-body">
                <div class="buttons">
                    <button class="btn btn-primary btn-create" type="submit">Update</button>
                    <a href="" class="btn btn-primary btn-reset-form" type="button">Reset Form</a>
                </div>
            </div>
        </div>
    </form>

@endsection
