@extends('layouts.admin.default')

@section('title',"Roles")

@section('header', "Roles")
@section('content')

    <div class="card card_custom mb-4">
        <div class="card-header">
            <h4 class="mb-0">Access Roles</h4>
            <p>This section displays all the Access Roles.</p>
        </div>
        <div class="card-body">
            @php
                $placeholder = "Search an Access Role...";

                $create = [
                    'route' => route('admin.roles.create'),
                    'name' => "Create Role"
                ];
              @endphp
            @include('admin.elements.search.common')

            <div class="table-responsive earring-table access-role">

                <table class="table stock-detail table_custom">
                    @php
                        $roles = \App\Models\Role::getRoleList();
                        $permissions  = \App\Models\Role::getAllPermissions();
                    @endphp

                    <thead>
                    <tr>
                        <th></th>
                        @foreach($roles as $key=>$value)
                            <th class="text-center">
                                <span>{{ $value }}</span>
                                @can('role-update') 
                                <a href="{{ route('admin.roles.edit',$key) }}"><img src="{{ asset('public/img/edit.png') }}"/></a>                              
                                @endcan

                                @can('role-delete')
                                <a class="confirmDelete" href="javascript:void(0);" data-action="{{ route('admin.roles.destroy',$key) }}"> <img src="{{ asset('public/img/delete.png') }}"/></a>
                                @endcan
                            </th>
                        @endforeach
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($permissions as $key_permisssion=>$permission)
                        <tr>
                            <td>
                                @php  
                                $permission_name =  str_replace("-"," ",$permission);
                                $parts = explode(' ', $permission_name);
                                $partData = preg_replace('~([a-z])([A-Z])~', '\\1 \\2', $parts);
                                $new_permission_name = implode(' ', $partData); 
                                @endphp
                                <span class="d-block">{{ ucwords($new_permission_name) }}</span>
                                日期
                            </td>
                            @foreach($roles as $key_role=>$role)
                                @if(isset($roleHasPermissionArr[$key_role][$key_permisssion]))
                                    <td class="text-center"><img src="{{ asset('public/img/asscess-right.png') }} "/></td>
                                @else
                                    <td class="text-center"><img src=" {{ asset('public/img/access-cancel.png') }} "/></td>
                                @endif
                            @endforeach
                        </tr>
                    @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>


@endsection
