@extends('layouts.admin.default')

@section('title',"Edit Role")

@section('header', "Edit Role")


@section('content')
    <form class="create_asccess" action="{{ route('admin.roles.update',$record->id) }}" method="post">
        @csrf
        @method('PUT')
        <div class="card mb-4">
            <div class="card-header">
                <h4 class="mb-0">Edit Access Role</h4>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-lg-6 col-md-6 mb-4">
                        <div class="form-group">
                            <label for="exampleFormControlInput1" class="form-label">Role Name</label>
                            <input type="text" name="name" value="{{ old('name',$record->name) }}"
                                   class="cus_form_control w-100 m-0">
                        </div>
                        @if ($errors->has('name'))
                            <span class="error-message">
                                    <strong>{{ $errors->first('name') }}</strong>
                                </span>
                        @endif
                    </div>
                </div>

                <div class="row">
                    <div class="col-lg-12 col-md-12">
                        <div class="form-group">
                            <label for="exampleFormControlInput1" class="form-label">Remarks</label>
                        </div>
                         @php
                             $permission_by_id = $permission_list->map(function ($permission) {
                                       return $permission->permission_id;
                                });
                             $permission_by_id = $permission_by_id->toArray();

                         @endphp
                        <div class="accordion accordion-flush custom_accordian" id="accordionFlushExample">
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="flush-headingOne">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#flush-collapseOne" aria-expanded="false"
                                            aria-controls="flush-collapseOne">
                                        Role Access System
                                    </button>
                                </h2>
                                <div id="flush-collapseOne" class="accordion-collapse collapse"
                                     aria-labelledby="flush-headingOne" data-bs-parent="#accordionFlushExample">
                                    <div class="accordion-body d-flex justify-content-between">
                                        <label>Access Role </label>
                                        <div class="checkbox-group d-flex">
                                            @php
                                              $role_list= \App\Models\Role::getRolePermissionList();
                                            @endphp
                                            @foreach($role_list as $key=>$value)
                                                @php $value_arr = explode("-", $value);@endphp
                                                <div class="form-check me-5">
                                                    <input class="form-check-input" name="permission[]" type="checkbox"
                                                           value="{{ $key }}" {{ (is_array(old('permission',$permission_by_id)) && in_array($key, old('permission',$permission_by_id))) ? ' checked' : '' }} >
                                                    <label class="form-check-label" for="flexCheckDefault">
                                                        {{ ucfirst(last($value_arr)) }}
                                                    </label>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="flush-headingTwo">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#flush-collapseTwo" aria-expanded="false"
                                            aria-controls="flush-collapseTwo">
                                        Account Creation
                                    </button>
                                </h2>
                                <div id="flush-collapseTwo" class="accordion-collapse collapse"
                                     aria-labelledby="flush-headingTwo" data-bs-parent="#accordionFlushExample">
                                    <div class="accordion-body d-flex justify-content-between">
                                        <label>Account Creation </label>
                                        <div class="checkbox-group d-flex">
                                            @php    $staff_list= \App\Models\Role::getStaffPermissionList();
                                            @endphp
                                            @foreach($staff_list as $key=>$value)
                                                @php $value_arr = explode("-", $value);@endphp
                                                <div class="form-check me-5">
                                                    <input class="form-check-input" name="permission[]" type="checkbox"
                                                           value="{{ $key }}" {{ (is_array(old('permission',$permission_by_id)) && in_array($key, old('permission',$permission_by_id))) ? ' checked' : '' }} >
                                                    <label class="form-check-label" for="flexCheckDefault">
                                                        {{ ucfirst(last($value_arr)) }}
                                                    </label>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="flush-headingThree">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#flush-collapseThree" aria-expanded="false"
                                            aria-controls="flush-collapseThree">
                                        Customer Management System
                                    </button>
                                </h2>
                                <div id="flush-collapseThree" class="accordion-collapse collapse"
                                     aria-labelledby="flush-headingThree" data-bs-parent="#accordionFlushExample">
                                    <div class="accordion-body d-flex justify-content-between">
                                        <label>Customer Management</label>
                                        <div class="checkbox-group d-flex">
                                            @php    $customer_list= \App\Models\Role::getCustomerPermissionList();@endphp
                                            @foreach($customer_list as $key=>$value)
                                                @php $value_arr = explode("-", $value);@endphp
                                                <div class="form-check me-5">
                                                    <input class="form-check-input" name="permission[]" type="checkbox"
                                                           value="{{ $key }}" {{ (is_array(old('permission',$permission_by_id)) && in_array($key, old('permission',$permission_by_id))) ? ' checked' : '' }} >
                                                    <label class="form-check-label" for="flexCheckDefault">
                                                        {{ ucfirst(last($value_arr)) }}
                                                    </label>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="flush-headingThree">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#flush-collapseFour" aria-expanded="false"
                                            aria-controls="flush-collapseFour">
                                        Frontend UI System
                                    </button>
                                </h2>
                                <div id="flush-collapseFour" class="accordion-collapse collapse"aria-labelledby="flush-headingThree" data-bs-parent="#accordionFlushExample">
                                    <div class="accordion-body d-flex justify-content-between">
                                        <label>Quotation Management </label>
                                        <div class="checkbox-group d-flex">
                                            @php  
                                              $front_quotation_list = App\Models\Role::getFrontQuotationPermissionList();     
                                            @endphp
                                            @foreach($front_quotation_list as $key=>$value)
                                                @php 
                                                    $value_arr = explode("-", $value);
                                                    $string = last($value_arr);
                                                    $parts = explode(' ', $string);
                                                    $partData = preg_replace('~([a-z])([A-Z])~', '\\1 \\2', $parts);
                                                    $new_string = implode(' ', $partData); 
                                                @endphp
                                                <div class="form-check me-5">
                                                    <input class="form-check-input" name="permission[]" type="checkbox" value="{{ $key }}" {{ (is_array(old('permission',$permission_by_id)) && in_array($key, old('permission',$permission_by_id))) ? ' checked' : '' }}>
                                                    <label class="form-check-label" for="flexCheckDefault">{{ ucfirst($new_string) }}</label>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                    <div class="accordion-body d-flex justify-content-between">
                                        <label>Invoice Management </label>
                                        <div class="checkbox-group d-flex">
                                            @php  
                                              $front_invoice_list = App\Models\Role::getFrontInvoicePermissionList();
                                            @endphp
                                            @foreach($front_invoice_list as $key=>$value)
                                                @php 
                                                    $value_arr = explode("-", $value);
                                                    $string = last($value_arr);
                                                    $parts = explode(' ', $string);
                                                    $partData = preg_replace('~([a-z])([A-Z])~', '\\1 \\2', $parts);
                                                    $new_string = implode(' ', $partData); 
                                                @endphp
                                                <div class="form-check me-5">
                                                    <input class="form-check-input" name="permission[]" type="checkbox" value="{{ $key }}" {{ (is_array(old('permission',$permission_by_id)) && in_array($key, old('permission',$permission_by_id))) ? ' checked' : '' }} >
                                                    <label class="form-check-label" for="flexCheckDefault">{{ ucfirst($new_string) }}</label>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                    <div class="accordion-body d-flex justify-content-between">
                                        <label>Repair Job Management </label>
                                        <div class="checkbox-group d-flex">
                                            @php  
                                              $front_repair_list = App\Models\Role::getFrontRepairJobPermissionList();
                                            @endphp
                                            @foreach($front_repair_list as $key=>$value)
                                                @php $value_arr = explode("-", $value);@endphp
                                                <div class="form-check me-5">
                                                    <input class="form-check-input" name="permission[]" type="checkbox" value="{{ $key }}" {{ (is_array(old('permission',$permission_by_id)) && in_array($key, old('permission',$permission_by_id))) ? ' checked' : '' }} >
                                                    <label class="form-check-label" for="flexCheckDefault">{{ ucfirst(last($value_arr)) }}</label>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                    <div class="accordion-body d-flex justify-content-between">
                                        <label>Bespoke Job Management </label>
                                        <div class="checkbox-group d-flex">
                                            @php  
                                              $front_bespoke_list = App\Models\Role::getFrontBespokeJobPermissionList();
                                            @endphp
                                            @foreach($front_bespoke_list as $key=>$value)
                                                @php $value_arr = explode("-", $value);@endphp
                                                <div class="form-check me-5">
                                                    <input class="form-check-input" name="permission[]" type="checkbox" value="{{ $key }}" {{ (is_array(old('permission',$permission_by_id)) && in_array($key, old('permission',$permission_by_id))) ? ' checked' : '' }} >
                                                    <label class="form-check-label" for="flexCheckDefault">{{ ucfirst(last($value_arr)) }}</label>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="accordion-item">
                                <h2 class="accordion-header" id="flush-headingThree">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#flush-collapseFive" aria-expanded="false"
                                            aria-controls="flush-collapseFive">
                                        Inventory Management System
                                    </button>
                                </h2>
                                <div id="flush-collapseFive" class="accordion-collapse collapse"
                                     aria-labelledby="flush-headingThree" data-bs-parent="#accordionFlushExample">
                                    <div class="accordion-body d-flex justify-content-between">
                                        <label>Inventory Management  </label>
                                        <div class="checkbox-group d-flex">
                                            @php    $inventory_list= \App\Models\Role::getJewelleryPermissionList();
                                            @endphp
                                            @foreach($inventory_list as $key=>$value)
                                                @php
                                                    $value_arr = explode("-", $value);
                                                    $string = last($value_arr);
                                                    $parts = explode(' ', $string);
                                                    $partData = preg_replace('~([a-z])([A-Z])~', '\\1 \\2', $parts);
                                                    $new_string = implode(' ', $partData); 
                                                 @endphp
                                                <div class="form-check me-5">
                                                    <input class="form-check-input" name="permission[]" type="checkbox"
                                                           value="{{ $key }}" {{ (is_array(old('permission',$permission_by_id)) && in_array($key, old('permission',$permission_by_id))) ? ' checked' : '' }} >
                                                    <label class="form-check-label" for="flexCheckDefault">
                                                        {{ ucfirst($new_string) }}
                                                    </label>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="flush-headingThree">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#flush-collapseSix" aria-expanded="false"
                                            aria-controls="flush-collapseThree">
                                        Job Order Management System
                                    </button>
                                </h2>
                                <div id="flush-collapseSix" class="accordion-collapse collapse"
                                     aria-labelledby="flush-headingThree" data-bs-parent="#accordionFlushExample">
                                    <div class="accordion-body d-flex justify-content-between">
                                        <label>Job Management </label>
                                        <div class="checkbox-group d-flex">
                                            @php    $job_list = \App\Models\Role::getJobPermissionList();
                                            @endphp
                                            @foreach($job_list as $key=>$value)
                                                @php $value_arr = explode("-", $value);@endphp
                                                <div class="form-check me-5">
                                                    <input class="form-check-input" name="permission[]" type="checkbox"
                                                           value="{{ $key }}" {{ (is_array(old('permission',$permission_by_id)) && in_array($key, old('permission',$permission_by_id))) ? ' checked' : '' }} >
                                                    <label class="form-check-label" for="flexCheckDefault">
                                                        {{ ucfirst(last($value_arr)) }}
                                                    </label>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="accordion-item">
                                <h2 class="accordion-header" id="flush-headingThree">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#flush-collapseSeven" aria-expanded="false"
                                            aria-controls="flush-collapseThree">
                                        Sales Management Systems
                                    </button>
                                </h2>
                                <div id="flush-collapseSeven" class="accordion-collapse collapse"
                                     aria-labelledby="flush-headingThree" data-bs-parent="#accordionFlushExample">
                                    <div class="accordion-body d-flex justify-content-between">
                                        <label>Quotation Management</label>
                                        <div class="checkbox-group d-flex">
                                            @php    $quotation_list= \App\Models\Role::getQuotationPermissionList();@endphp
                                            @foreach($quotation_list as $key=>$value)
                                                @php 
                                                    $value_arr = explode("-", $value);
                                                    $string = last($value_arr);
                                                    $parts = explode(' ', $string);
                                                    $partData = preg_replace('~([a-z])([A-Z])~', '\\1 \\2', $parts);
                                                    $new_string = implode(' ', $partData);
                                                @endphp
                                                <div class="form-check me-5">
                                                    <input class="form-check-input" name="permission[]" type="checkbox"
                                                           value="{{ $key }}" {{ (is_array(old('permission',$permission_by_id)) && in_array($key, old('permission',$permission_by_id))) ? ' checked' : '' }} >
                                                    <label class="form-check-label" for="flexCheckDefault">
                                                        {{ ucfirst($new_string) }}
                                                    </label>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                    <div class="accordion-body d-flex justify-content-between">
                                        <label>Invioce Management</label>
                                        <div class="checkbox-group d-flex">
                                            @php    $invoice_list= \App\Models\Role::getInvoicePermissionList();@endphp
                                            @foreach($invoice_list as $key=>$value)
                                                @php 
                                                    $value_arr = explode("-", $value);
                                                    $string = last($value_arr);
                                                    $parts = explode(' ', $string);
                                                    $partData = preg_replace('~([a-z])([A-Z])~', '\\1 \\2', $parts);
                                                    $new_string = implode(' ', $partData);
                                                @endphp
                                                <div class="form-check me-5">
                                                    <input class="form-check-input" name="permission[]" type="checkbox"
                                                           value="{{ $key }}" {{ (is_array(old('permission',$permission_by_id)) && in_array($key, old('permission',$permission_by_id))) ? ' checked' : '' }} >
                                                    <label class="form-check-label" for="flexCheckDefault">
                                                        {{ ucfirst($new_string) }}
                                                    </label>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>

                                </div>
                            </div>

                            <div class="accordion-item">
                                <h2 class="accordion-header" id="flush-headingThree">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#flush-collapseEight" aria-expanded="false"
                                            aria-controls="flush-collapseThree">
                                        Worksmith Management System
                                    </button>
                                </h2>
                                <div id="flush-collapseEight" class="accordion-collapse collapse"
                                     aria-labelledby="flush-headingThree" data-bs-parent="#accordionFlushExample">
                                    <div class="accordion-body d-flex justify-content-between">
                                        <label>Worksmith Management  </label>
                                        <div class="checkbox-group d-flex">
                                            @php    $worksmith_list= \App\Models\Role::getWorksmithPermissionList();
                                            @endphp
                                            @foreach($worksmith_list as $key=>$value)
                                                @php $value_arr = explode("-", $value);@endphp
                                                <div class="form-check me-5">
                                                    <input class="form-check-input" name="permission[]" type="checkbox"
                                                           value="{{ $key }}" {{ (is_array(old('permission',$permission_by_id)) && in_array($key, old('permission',$permission_by_id))) ? ' checked' : '' }} >
                                                    <label class="form-check-label" for="flexCheckDefault">
                                                        {{ ucfirst(last($value_arr)) }}
                                                    </label>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="accordion-item">
                                <h2 class="accordion-header" id="flush-headingThree">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#flush-collapseNine" aria-expanded="false"
                                            aria-controls="flush-collapseThree">
                                        Consignment Management System
                                    </button>
                                </h2>
                                <div id="flush-collapseNine" class="accordion-collapse collapse"
                                     aria-labelledby="flush-headingThree" data-bs-parent="#accordionFlushExample">
                                    <div class="accordion-body d-flex justify-content-between">
                                        <label>Consignment Management  </label>
                                        <div class="checkbox-group d-flex">
                                            @php
                                                $consignment_list= \App\Models\Role::getConsignmentPermissionList();
                                            @endphp
                                            @foreach($consignment_list as $key=>$value)
                                                @php 
                                                    $value_arr = explode("-", $value);
                                                    $string = last($value_arr);
                                                    $parts = explode(' ', $string);
                                                    $partData = preg_replace('~([a-z])([A-Z])~', '\\1 \\2', $parts);
                                                    $new_string = implode(' ', $partData);
                                                @endphp
                                                <div class="form-check me-5">
                                                    <input class="form-check-input" name="permission[]" type="checkbox"
                                                           value="{{ $key }}" {{ (is_array(old('permission',$permission_by_id)) && in_array($key, old('permission',$permission_by_id))) ? ' checked' : '' }} >
                                                    <label class="form-check-label" for="flexCheckDefault">
                                                        {{ ucfirst($new_string) }}
                                                    </label>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="flush-headingTen">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#flush-collapseTen" aria-expanded="false"
                                            aria-controls="flush-collapseThree">
                                        Setting Management System
                                    </button>
                                </h2>
                                <div id="flush-collapseTen" class="accordion-collapse collapse"
                                     aria-labelledby="flush-headingNine" data-bs-parent="#accordionFlushExample">
                                    <div class="accordion-body d-flex justify-content-between">
                                        <label>Setting Management  </label>
                                        <div class="checkbox-group d-flex">
                                            @php
                                                $setting_list= \App\Models\Role::getSettingPermissionList();
                                            @endphp
                                            @foreach($setting_list as $key=>$value)
                                                @php 
                                                    $value_arr = explode("-", $value);
                                                    $string = last($value_arr);
                                                    $parts = explode(' ', $string);
                                                    $partData = preg_replace('~([a-z])([A-Z])~', '\\1 \\2', $parts);
                                                    $new_string = implode(' ', $partData);
                                                @endphp
                                                <div class="form-check me-5">
                                                    <input class="form-check-input" name="permission[]" type="checkbox"
                                                           value="{{ $key }}" {{ (is_array(old('permission',$permission_by_id)) && in_array($key, old('permission',$permission_by_id))) ? ' checked' : '' }} >
                                                    <label class="form-check-label" for="flexCheckDefault">
                                                        {{ ucfirst($new_string) }}
                                                    </label>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <div class="card details mb-4">
            <div class="card-body">
                <div class="buttons buttons_1">
                    <button class="btn btn-primary btn-create" type="submit">Update</button>
                    <button class="btn btn-primary btn-reset-form" type="submit">Reset Form</button>
                </div>
            </div>
        </div>

    </form>
@endsection