@php 
    use App\Models\Quotation;
    $shopSettings = \App\Models\Setting::shop_settings(); 
@endphp

@extends('layouts.new_print')

@section('title',"Order Voucher PDF")

@section('header', "Order Voucher PDF")

@section('content')

<style>
    /*.break {page-break-before: always;page-break-after: always;}
    .no_break {page-break-inside: avoid}*/
   
</style>

<table style="max-width:500px; width:100%; margin:0 auto;">
   <tr>
       <td>
        <table style="max-width:500px; width:100%; margin:0 auto;">
            <tr style="">
                <td>
                  <img style="margin-bottom:60px;" src="{{ asset('public/img/print_order_voucher.png') }}" alt="logo">
                </td>
                <td style="vertical-align:baseline; text-align:right;">
                    <h5 style="margin:0px; font-size:12px; font-weight:600; color:#BE1E2D; opacity:0.6;">Order Voucher No. {{ empty($quotation->quotation_no) ?  getItemCode(Quotation::ZEROES, $quotation->id, Quotation::VOUCHER) : $quotation->quotation_no }}</h5>
                    <p style="margin:0px;font-weight: 300;font-size:12px;color:#000;">
                        Date {{ date('d/m/Y', strtotime($quotation->reference_date)) }}
                    </p>
                </td>
            </tr>
            <tr style="margin-top:20px;">
                <td style="font-size:12px;vertical-align: top;">
                    <p style="color:#64748B; margin:0px;">Sales Person: 
                        <span style="color:#BE1E2D; opacity:0.6; font-weight:600;padding-left:15px; margin:0px;">
                            {{ ucwords($quotation->staff_name) ?? $quotation->staff ? ucwords($quotation->staff->fullname) : '' }}
                        </span>
                    </p>
                     <p style="font-size:10px;font-weight:300;color:#000;margin:0px;">{{ $shopSettings['email'] }}</p>
                      <p style="font-size:10px; font-weight:300; color:#000;">
                        {{ $shopSettings['address_line1'] }}
                        <span style="display:block;">
                            {{ $shopSettings['address_line2'] }}
                        </span>
                        <span style="display:block;">
                            {{ $shopSettings['phone'] }}
                        </span>
                    </p>
                </td>
                <td style="font-size:12px; text-align:right;vertical-align: top;">
                    <p style="color:#64748B ;margin:0px;">Received From: 
                        <span style="color:#BE1E2D; opacity:0.6; font-weight:600;padding-left:15px;">
                            {{ ucwords($quotation->customer_name) ?? ucwords($quotation->customer->fullname) ?? '' }}
                        </span>
                    </p>
                    <p style="font-size:10px;font-weight:300;color:#000;margin:0px;">{{ $quotation->customer_email ?? $quotation->customer->email ?? '' }}</p>
                    <p style="font-size:10px; margin-top:0; font-weight:300; color:#000;margin-top:10px;">    
                        {{ $quotation->customer_phone ?? ($quotation->customer->phone ?? '') }}
                    </p>
                </td>
            </tr>
        </table>
        <table cellpadding="0" cellspacing="0" style="width:100%;">
            <tr>
                <th style="font-weight:600; font-size:10px; line-height:10px; color:#fff;width:50px; background:#88020F; text-align: left; padding:10px 10px 10px 20px; width:10%;text-transform:uppercase;">#
                </th>
                <th style="font-weight:600; font-size:10px; line-height:10px; color:#fff; background:#88020F; text-align: left; padding:10px 10px 10px 20px; width:10%;text-transform:uppercase;">
                    Item
                </th>
                <th style="font-weight:600; font-size:10px; line-height:10px; color:#fff; background:#88020F; text-align: left; padding:10px 10px 10px 20px; width:10%;text-transform:uppercase;">
                    Price
                </th>
                <th style="font-weight:600; font-size:10px; line-height:10px; color:#fff; background:#88020F; text-align: left; padding:10px 10px 10px 20px; width:10%;text-transform:uppercase;">
                    Gold Colour
                </th>
            </tr>
            @php $counter = 1; $imgCounter = 0; @endphp
            @forelse($quotation->quotation_item as $key => $quotationItem)
                <tr style="">
                    <td style="margin-top:10px; vertical-align:top;border-top:1px solid rgb(0 0 0 / 10%); border-bottom:1px solid rgb(0 0 0 / 10%); padding: 5px 21px;">
                        <h4 style="margin:0px; text-align:left; font-size:12px; font-weight:400; color:#000000; line-height:12px;">{{ $counter }}</h4>
                    </td>
                    <td style="margin-top:10px; vertical-align:top;border-bottom:1px solid rgb(0 0 0 / 10%); border-top:1px solid rgb(0 0 0 / 10%); padding:5px 21px;">
                        <div style="width:300px;">
                            <p style="margin:0px; text-align:left; font-size:10px; font-weight:400; color:#000000; line-height:12px;">
                                {{ $quotationItem->description ?? '-' }}
                            </p>
                            @if(quotationItemImage($quotationItem) !== null)
                                @php $imgCounter++; @endphp
                                <img style="width:100%; margin-top:5px; {{ (quotationItemImage($quotationItem) == getDefaultImage()) ? 'height:100px;' : '' }}" src="{{ quotationItemImage($quotationItem) }}">
                            @endif
                        </div>
                    </td>
                            
                    <td style="margin-top:10px; vertical-align:top;border-bottom:1px solid rgb(0 0 0 / 10%); border-top:1px solid rgb(0 0 0 / 10%); padding:5px 21px;">
                        <p style="margin:0px; text-align:left; font-size:10px; font-weight:400; color:#000000; line-height:12px;">$<span class="item_price" id="price-{{ $counter }}" data-id="{{ $quotationItem->id }}">{{ $quotationItem->sub_total ?? '0' }}</span></p>
                    </td>
                    <td style="margin-top:10px; vertical-align:top;border-bottom:1px solid rgb(0 0 0 / 10%); border-top:1px solid rgb(0 0 0 / 10%); padding:5px 21px;">
                        <p style="margin:0px; text-align:left; font-size:10px; font-weight:400; color:#000000; line-height:12px;">{{ $quotationItem->gold_color->name ?? '-' }}</p>
                    </td>
                </tr>
                {{-- @if($imgCounter >= 2) --}}
                    <!-- <td class="page-break" style="border:none;"></td> --> 
                {{-- @endif  --}}
                @php $counter++; @endphp
            @empty
                <tr style="">
                    <td colspan="4">No record found!</td>
                </tr>
            @endforelse
        </table> 

       </td>
   </tr>
   
   <tr>
       <td>
          <table cellpadding="0" cellspacing="0" style="width: 100%;">
                    <tr style="">
                        <td colspan="2" style="margin-top:10px; vertical-align:top;">
                            <div style="max-width:240px; text-align:right;margin-left:auto; width:100%; margin-top:83px;">
                                <div style="padding-bottom:0px;">
                                    <h4 style="margin:0px; text-align:left; font-size:12px; font-weight:400; line-height:14px; display:inline-block; color:#777;">Subtotal:</h4>
                                    <img src="{{ asset('public/img/Line_1.png') }}" style="height:1px; display:inline-block;">
                                    <p style="margin:0px; font-size:12px;font-weight:600; line-height:14px; display: inline-block; color:#777;">$<span id="
                                        subtotal">{{ $quotation->quotation_item_sum_sub_total }}
                                        </span>
                                    </p>
                                </div>
                                <div style="padding-bottom: 20px;">
                                    <h4 style="margin:0px; text-align:left;font-size:12px; font-weight:400; line-height: 14px; display:inline-block; color:#777;">GST:</h4>
                                    <img src="{{ asset('public/img/Line_2.png') }}" style="height:1px; display:inline-block;">
                                    <p style="margin:0px; font-size:12px;font-weight:600; line-height:14px; display: inline-block;color:#777;">$<span id="gst">{{ $quotation->gst_total }}</span></p>
                                </div>
                                <div style="padding-bottom:10px;">
                                    <h4 style="margin:0px; text-align:left; font-size:12px; font-weight:600; line-height:16px; display:inline-block;">Total:</h4> 
                                    <img src="{{ asset('public/img/Line_3.png') }}" style="height:1px; display:inline-block;">
                                    <p style="margin:0px; font-size:12px;font-weight:600; line-height:16px; display: inline-block;">$<span id="total">{{ $quotation->grand_total }}</span></p>
                                </div>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td style="width: 50%">
                            <h3 style="font-weight:600; font-size:12px;line-height: 18px; color:#475569; text-transform:uppercase;">Customer signature</h3>
                            <p style="border:1px solid #CBD5E1; border-radius: 5px; height:69px; margin-right:7px;"></p>
                        </td>

                        <td style="width: 50%">
                            <h3 style="font-weight: 600;font-size: 12px;line-height: 18px;color: #475569;text-transform: uppercase;">Sales signature</h3>
                            <p style="border: 1px solid #CBD5E1;border-radius: 5px;height: 69px;"></p>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2" style="margin-top:10px; vertical-align:top;">
                            <p style="font-weight:300; font-size:6px; line-height:9px;">EVERY CARE WILL BE TAKEN WITH JEWELLERY ARTICLES WITH US FOR SETTING OR MAKING. HOWEVER IN CASE OF DAMAGE OR LOSS, MAXIMUM CONPENSATION 
                            SHALLBE BASED ON THE AMOUNT STATED ABOVE. CUSTOMERS ARE REQUESTED TO PAY FOR THE SETTING FEE IN ACCORDANCE WITH THE PERVAILING GOLD RETAIL 
                            PRICE. THIS ORDER IS VALID FOR 6 MONTHS ONLY.</p>
                        </td>
                    </tr>
                </table> 
       </td>
   </tr>

   
 </table>

@endsection