@extends('layouts.admin.default')

@section('title',"Quotations")

@section('header', "Quotations")

@section('content')

    {{-- <div class="loader-bg" id="loader" style="display:none; z-index:9999;">
        <div class="loader"></div>
    </div> --}}

    <div class="card mb-4">
        <div class="card-header">
            <h4 class="mb-0">All Quotations</h4>
            <p>This section displays all quotations.</p>
        </div>
        <div class="card-body">
            @php $placeholder = "Search Quotation Number, Phone Number..."; @endphp

            @include('admin.elements.search.common')
            <div class="earring-table table-responsive">
                <table class="table stock-detail">
                    <thead>
                    <tr>
                        <th>@sortablelink('quotation.reference_date', __('content.date'))</th>
                        <th>{{ __('content.quotation_id') }}</th> 
                        {{-- <th style="width:310px;">{{ __('content.description') }}</th> --}}
                        <th>@sortablelink('total', __('content.amount'))</th>
                        <th>@sortablelink('quotation.customer_name', __('content.customer'))</th>
                        <th>@sortablelink('quotation.customer_phone', __('content.phone_number'))</th>
                        @canany(['quotation-convertToInvoice','quotation-convertToInvoice','quotation-printOrderVoucher','quotation-print','quotation-update','quotation-delete']) 
                        <th>{{ __('content.action') }}</th>
                        @endcanany 
                    </tr>
                    </thead>
                    <tbody>
                    @if(!empty($records) && $records->count())
                        @php $slNo = $records->firstItem() @endphp
                        @foreach($records as $record)
                            <tr>
                                <td>{{ isset($record->reference_date) ? date('d/m/Y' , strtotime($record->reference_date)) : '-' }}</td>
                                <td>{{ $record->quotation_no ?? '-' }}</td> 
                                {{-- <td class="description">{{ isset($record->description) ? \Illuminate\Support\Str::limit($record->description, 112, $end='...') : '-' }}</td> --}}
                                <td>{{ isset($record->total) ? '$'. $record->total : '-' }}</td>
                                <td class="text-nowrap">{{ isset($record->customer_name) ? ucwords($record->customer_name) : (isset($record->customer_id) ? ucwords($record->customer->fullname) : '-') }}</td>
                                <td class="text-nowrap">{{ $record->phone_with_code }}</td>

                                @canany(['quotation-convertToInvoice', 'quotation-convertToInvoice', 'quotation-printOrderVoucher', 'quotation-print', 'quotation-update', 'quotation-delete'])
                                <td>
                                    <div class="dropdown">
                                        <button class="btn btn-secondary down" type="button" id="dropdownMenuButton1"
                                        data-bs-toggle="dropdown" aria-expanded="false">
                                            Action
                                        </button>
                                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                                            @php  $exist_invoice = App\Models\Invoice::checkInvoiceByQuotation($record->id); @endphp
                                            @if(empty($exist_invoice))
                                                @can('quotation-convertToInvoice') 
                                                    <li><a class="dropdown-item duplicate convert_to_invoice convertToInvoice" data-attr="{{ route('admin.quotations.convertToInvoice') }}" data-id="{{ $record->id }}" href="javascript:void(0)"><img src="{{ asset('public/img/convert_invoice.png') }}">Convert to Invoice</a></li>
                                                @endcan
                                            @endif
											
                                            @can('quotation-printOrderVoucher') 
												<li><a class="dropdown-item btnprn" href="{{ route('admin.quotations.printOrderVoucher', $record->id) }}"><img src="{{ asset('public/img/print.png') }}">Print Order Voucher</a></li>
                                            @endcan

                                            @can('quotation-print')
												<li><a class="dropdown-item" href="{{ route('admin.quotations.printQuotation', $record->id) }}"><img src="{{ asset('public/img/print.png') }}">Print Quotation</a></li>
                                            @endcan

                                            @can('quotation-sendEmailPDF')
												<li><a class="dropdown-item sendEmailPDF" href="javascript:void(0);{{-- route('admin.quotations.sendEmailPDF', $record->id) --}}" id="sendEmailPDF-{{ $record->id }}" data-record_id="{{ $record->id }}" data-for="quotations"><img src="{{ asset('public/img/envelope.png') }}">Send email</a></li>
                                            @endcan

                                            @can('quotation-update')
                                                <li><a class="dropdown-item" href="{{ route('admin.quotations.edit', $record->id) }}"><img src="{{ asset('public/img/edit.png') }}">Edit</a></li>
                                            @endcan

                                            @can('quotation-delete')
												<li><a class="dropdown-item confirmDelete" href="javascript:void(0);" data-action="{{ route('admin.quotations.destroy', $record->id) }}"><img src=" {{ asset('public/img/delete.png') }} ">Delete</a></li>
                                            @endcan

                                        </ul>
                                    </div>
                                </td>
                                @endcanany
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td class="text-center" colspan="{{ (auth()->user()->canany(['quotation-convertToInvoice', 'quotation-convertToInvoice', 'quotation-printOrderVoucher', 'quotation-print', 'quotation-update', 'quotation-delete'])) ? '6' : '5' }}">No Record Found!</td>
                        </tr>
                    @endif
                    </tbody>
                </table>
            </div>
            @include('admin.elements.pagination.common')
        </div>
    </div>

@include('admin.invoices.pay_amount_with_print_invoice_popup')
@include('admin.quotations.scripts.convert_to_invoice_js') 

@include('admin.elements.scripts.pdf_email_js')

{{-- @include('admin.quotations.script') --}}

@endsection
