@extends('layouts.admin.default')

@section('title',"Edit Quotation")

@section('header', "Edit Quotation")

@section('content')
<style>
    #drawingCanvas {
        position: absolute;
        left: 0;
        right: 0;
        border: none;
        color: #FFF;
        overflow: hidden;
        background-color: transparent;
        /*display: none;*/

    }

    #tempCanvas {
        position: absolute;
        left: 0;
        right: 0;
        overflow: hidden;
        border: none;
        /*display: none;*/
    }
</style>

@php
    $inventory = \App\Models\QuotationItem::INVENTORY;
    $bespoke = \App\Models\QuotationItem::BESPOKE;
    $repair = \App\Models\QuotationItem::REPAIR;

   $is_error = $errors->any() ? 1 : 0;
   $xi = $is_error ? old('jewelleries') ? count(old('jewelleries')) : '1' : 1;

@endphp

<form id="updateQuotationSubmit" method="">
<div class="card details mb-4">
    <div class="card-header">
        <h4 class="mb-0">Edit Quotation</h4>
    </div>

    <div class="card-body create_quotation add_item_from_main">

        @foreach($records->quotation_item as $index=>$record)
        <div class="items items_new {{ ($index !=0) ? "mt-5" : ""  }}">
            <div class="align-items-center">
                <label class="add_itemm">Add Item From*:</label>
                <ul class="nav nav-tabs  tabbing-0 {{ ($record->type_name) ? 'button_color' : ' '}} " id="myTab" role="tablist">
                    <li class="nav-item m-0 me-3" role="presentation">
                        <button class="nav-link inventory {{ ($record->type_name) == \App\Models\QuotationItem::INVENTORY  ? 'active' : ' '}}" data-key="0" data-bs-toggle="tab" data-bs-target="#inventory-0" type="button" role="tab" aria-controls="home" aria-selected="true">Inventory</button>
                    </li>
                    <li class="nav-item m-0 me-3" role="presentation">
                        <button class="nav-link bespoke {{ ($record->type_name) == \App\Models\QuotationItem::BESPOKE  ? 'active' : ' '}}" data-key="0" data-bs-toggle="tab" data-bs-target="#bespoke-0" type="button" role="tab" aria-controls="profile" aria-selected="false">Bespoke</button>
                    </li>
                    <li class="nav-item m-0 me-3" role="presentation">
                        <button class="nav-link repair {{ ($record->type_name) == \App\Models\QuotationItem::REPAIR  ? 'active' : ' '}}" data-key="0" data-bs-toggle="tab" data-bs-target="#repair-0" type="button" role="tab" aria-controls="contact" aria-selected="false">Repair</button>
                    </li>
                </ul>
                <div class="tab-content" id="myTabContent-0">
                    <div class="tab-pane fade show {{ ($record->type_name) == \App\Models\QuotationItem::INVENTORY  ? 'active show' : ' '}}" id="inventory-0" role="tabpanel" aria-labelledby="home-tab">
                        <div class="position-relative add_item_search">
                            <div class="search">
                            <span><img src="{{ asset('public/img/search.png') }}" class="display">
                                <img src="{{ asset('public/img/search_foucs.png') }}" class="focus_search">
                            </span>
                                <div class="d-flex align-items-center position-relative">
                                    <div class="input_div w-100">
                                        <input type="text" id="jewelley_item_code-0" class="form-control cus_form_control jewelley_item_code" value="{{ $record->item_code }}"  name="qut[0][{{ $inventory }}][item_code]" placeholder="Search an item code or an scan item...">
                                        <label class="field_error" id="item_code_error-0" style="color:red"> </label>
                                    </div>
                                    <img src="{{ asset('public/img/cross.png') }}" class="cross cross_invent">
                                </div>

                                <div class="col-lg-12 button_div">
                                    <div class="d-flex mt-5">
                                        <button class="btn btn-primary btn-create btn-confirm inventory_confirm me-4" data-key="0" type="button">Update Item</button>
                                        <button class="btn btn-outline-primary btn-reset-form-custom" type="button">Reset Form</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="tab-pane fade {{ ($record->type_name) == \App\Models\QuotationItem::BESPOKE  ? 'active show' : ' '}}" id="bespoke-0" role="tabpanel" aria-labelledby="profile-tab">
                        <div class="position-relative add_item_search add_item_search_custom">
                                <div class="sample card-body mt-0 p-0 pt-4">
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="category jobs_edit">
                                                <div class="form-group">
                                                    <label for="exampleFormControlInput1" class="form-label">Category</label>
                                                </div>
                                                <ul class="category_ul-0">
                                                    @php $categories = \App\Models\Category::getCategories(); @endphp
                                                    @foreach($categories as $key=>$value)
                                                        <li class="{{ old('category_id',$record->category_id) == $value->id ?  'active_category' : '' }}"><a class="category_id"  data-key="0" value="{{ $value->id }}" ><img src="{{ $value->image }}" height="60" width="60"/>{{ $value->name }}</a></li>
                                                    @endforeach
                                                </ul>
                                                <input id="bespoke_category_id-0" class="categories_id" type="hidden" name="qut[0][{{ $bespoke }}][category_id]" value="{{ old('category_id', $record->category_id) }}" />
                                                <label class="field_error" id="bespoke_category_id_error-0"> </label>
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label for="exampleFormControlInput1" class="form-label"> {{ __('content.gold_colour') }} </label>
                                                <select class="form-select gold_color_id" id="bespoke_gold_color_id-0"  name="qut[0][{{ $bespoke }}][gold_color_id]" aria-label="Default select example" onchange="onChangeElem(event)">
                                                    <option value="" >Select One Option</option>
                                                    @php $gold_colors = \App\Models\GoldColor::getGoldColorsList(); @endphp
                                                    @foreach($gold_colors as $key=>$value)
                                                        <option value="{{ $key }}" {{ old('gold_color_id',$record->gold_color_id) ==  $key ? 'selected' : '' }}>{{ $value }}</option>
                                                    @endforeach
                                                </select>
                                                <label class="field_error" id="bespoke_gold_color_id_error-0"> </label>
                                            </div>
                                            </div>

                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label for="exampleFormControlInput1"  class="form-label">{{ __('content.size') }} </label>
                                                <input type="text" id="bespoke_size-0" name="qut[0][{{ $bespoke }}][size]" class="form-control size" value="{{ old('size',isset($record->size) ? (float)$record->size: '' ) }}" onchange="onChangeElem(event)">
                                                <label class="field_error" id="bespoke_size_error-0"> </label>
                                            </div>
                                        </div>

                                        <div class="col-lg-12">
                                            <div class="form-group">
                                                <label for="exampleFormControlInput1" class="form-label">{{ __('content.description') }} </label>
                                                <textarea class="form-control" id="bespoke_description-0" name="qut[0][{{ $bespoke }}][description]" placeholder="Description" value="" rows="2" onchange="onChangeElem(event)"> {{ old('description',$record->description) }} </textarea>
                                                <label class="field_error" id="bespoke_description_error-0" style="color:red"> </label>
                                            </div>
                                        </div>

                                        <div class="col-lg-12 mt-3">
                                            <label for="exampleFormControlInput1" class="form-label"> {{ __('content.draw_upload') }}
                                                <img src="{{ asset('public/img/folder.png') }}" class="folder">
                                            </label>
                                            <div class="row">
                                                <div class="col-lg-4">
                                                    <div class="form-group pt-0">
                                                        <div class="drop-zone">
                                                            <div class="dropzone dropZoneimageUpload" id="bespokeDropZoneimageUpload-0">
                                                                <span class="drop-zone__prompt dz-default dz-message">Drop Photo here <br>{{ __('content.drop_photo') }}
                                                                    <p>Photo Requiement:</p>
                                                                <ul>
                                                                <li>File type PNG or JPG</li>
                                                                <li>Maximum Size: 500 KB</li>
                                                                </ul>
                                                                </span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-8">
                                                    <div class="form-group pt-0">
                                                        <div class="start-drawing"
                                                                id="blackboardPlaceholder">
                                                            <p>{{ __('content.start_drawing') }}</p>
                                                            <canvas  data-key="0"  class="drawingCanvas bespoke_drawingCanvas" width="500"
                                                                    height="230"></canvas>
                                                            <div class="pen-eraser">
                                                                <span class="pen" onclick="togglePenPointer(this);"><img src="{{ asset('public/img/pen.png') }}"/></span>
                                                                <span class="erase" onclick="eraserHandler(this);"><img src="{{ asset('public/img/eraser.png') }}"/></span>
                                                            </div>
                                                        </div>
                                                        <input type="hidden" id="bespoke_drawing_textarea_base64-0"  name="qut[0][{{ $bespoke }}][drawing_textarea_base64]">
                                                        {{--<input type="hidden" id="bespoke_drawing_image" value="{{ $record->drawing_image_url }}"  name="qut[0][{{ $bespoke }}][drawing_image]">--}}
                                                        <input type="hidden" id="bespoke_drawing_image" value="{{ $record->drawing_image_url }}">
                                                    </div>
                                                </div>
                                                <div class="col-lg-12">
                                                    <div id="bespoke-template-preview-0" class="preview-droped-images" >
                                                      
                                                        {{-- @if(!empty($record->quotation_item->quotation_item_image)) --}}
                                                        @foreach($record->quotation_item_image as  $key=>$value)
                                                            <div class="dz-preview dz-processing dz-image-preview dz-complete">
                                                                <div class="dz-image">
                                                                    <img data-dz-thumbnail="" height="60" alt="bracelet.png" src="{{ $value->image_url  }}">
                                                                </div>
                                                                <a class="dz-remove remove_button" href="javascript:undefined;"
                                                                    data-dz-remove="">X</a>
                                                                <input type="hidden" value="{{ $value->image }}" name="qut[0][{{ $bespoke }}][images][]">
                                                            </div>
                                                        @endforeach
                                                        {{-- @endif --}}
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                            <div class="col-lg-12">
                                                <div class="sample">
                                                    <div class="col-lg-12">
                                                        <div class="form-group d-flex align-items-center pt-0">
                                                            <label for="exampleFormControlInput1" class="form-label mb-0 pe-5">{{ __('content.sample_provided') }}</label>
                                                            <div class="form-check">
                                                                <input class="form-check-input cus-form-check-input bespoke_is_sample_provided-0" type="radio" name="qut[0][{{ $bespoke }}][is_sample_provided]"  value="1"  {{ old("is_sample_provided",$record->is_sample_provided) == 1 ? 'checked' : '' }} onchange="onChangeElem(event)">
                                                                <label class="form-check-label cus_form_check_label" for="flexRadioDefault1">{{ __('content.yes') }}</label>
                                                            </div>
                                                            <div class="form-check">
                                                                <input class="form-check-input cus-form-check-input bespoke_is_sample_provided-0" type="radio" name="qut[0][{{ $bespoke }}][is_sample_provided]" value="0" {{ old("is_sample_provided",$record->is_sample_provided) == 0 ? 'checked' : '' }} onchange="onChangeElem(event)">
                                                                <label class="form-check-label cus_form_check_label"
                                                                        for="flexRadioDefault1">
                                                                    {{ __('content.no') }}
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-12">
                                                        <div class="form-group">
                                                            <label for="exampleFormControlInput1" class="form-label">{{ __('content.sample_description') }}</label>
                                                            <textarea class="form-control" id="bespoke_sample_description-0" name="qut[0][{{ $bespoke }}][sample_description]" placeholder="{{ __('content.description') }}" rows="2" onchange="onChangeElem(event)">{{ old('sample_description',$record->sample_description) }}</textarea>
                                                            <label class="field_error" id="bespoke_sample_description_error-0" > </label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="sample">
                                                <div class="row">
                                                    <div class="col-lg-4">
                                                        <div class="form-group pt-0">
                                                            <label for="exampleFormControlInput1" class="form-label">{{ __('content.gold_weight') }}</label>
                                                            <input type="text" class="form-control" id="bespoke_gold_weight-0" name="qut[0][{{ $bespoke }}][gold_weight]"  value="{{ old('gold_weight',isset($record->gold_weight)? (float)$record->gold_weight :"") }}" onchange="onChangeElem(event)">
                                                            <label class="field_error" id="bespoke_gold_weight_error-0" > </label>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-4">
                                                        <div class="form-group pt-0">
                                                            <label for="exampleFormControlInput1" class="form-label">{{ __('content.gold_cost') }}</label>
                                                            <input type="text" class="form-control" id="bespoke_gold_cost-0"  name="qut[0][{{ $bespoke }}][gold_cost]"  value="{{ old('gold_cost',isset($record->gold_cost)? (float)$record->gold_cost :"") }}" onchange="onChangeElem(event)">
                                                            <label class="field_error" id="bespoke_gold_cost_error-0"> </label>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-4">
                                                        <div class="form-group pt-0">
                                                            <label for="exampleFormControlInput1" class="form-label">{{ __('content.workmanship_cost') }}</label>
                                                            <input type="text" class="form-control" id="bespoke_craftsmanship_cost-0"   name="qut[0][{{ $bespoke }}][craftsmanship_cost]" value="{{ old('workmanship_cost',isset($record->craftsmanship_cost)? (float)$record->craftsmanship_cost :"") }}" onchange="onChangeElem(event)">
                                                            <label class="field_error" id="bespoke_craftsmanship_cost_error-0"> </label>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-6">
                                                        <div class="form-group">
                                                            <label for="exampleFormControlInput1" class="form-label">{{ __('content.polishing_cost') }}</label>
                                                            <input type="text" class="form-control" id="bespoke_polishing-0" name="qut[0][{{ $bespoke }}][polishing]" value="{{ old('polishing',isset($record->polishing)? (float)$record->polishing :"") }}" onchange="onChangeElem(event)">
                                                            <label class="field_error" id="bespoke_polishing_error-0"> </label>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-6">
                                                        <div class="form-group">
                                                            <label for="exampleFormControlInput1" class="form-label">{{ __('content.setting_cost') }}</label>
                                                            <input type="text" class="form-control" id="bespoke_setting_cost-0" name="qut[0][{{ $bespoke }}][setting_cost]" value="{{ old('setting_cost',isset($record->setting_cost)? (float)$record->setting_cost :'') }}" onchange="onChangeElem(event)">
                                                            <label class="field_error" id="bespoke_setting_cost_error-0" > </label>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-6">
                                                        <div class="form-group">
                                                            <label for="exampleFormControlInput1" class="form-label">{{ __('content.earing_pin') }}</label>
                                                            <input type="text" class="form-control" id="bespoke_earing_pin-0" name="qut[0][{{ $bespoke }}][earing_pin]" value="{{ old('earing_pin',isset($record->earing_pin) ? (float)$record->earing_pin : ' ') }}" onchange="onChangeElem(event)">
                                                            <label class="field_error" id="bespoke_earing_pin_error-0" > </label>
                                                        </div>
                                                    </div>

                                                    <div class="col-lg-6">
                                                        <div class="form-group">
                                                            <label for="exampleFormControlInput1" class="form-label">{{ __('content.backing_type') }}</label>
                                                            <select class="form-select" id="bespoke_backing_type-0" aria-label="Default select example" name="qut[0][{{ $bespoke }}][backing_type]" onchange="onChangeElem(event)">
                                                                <option value=" ">Select One Option</option>
                                                                @php $backing_types = \App\Models\Jewellery::backingTypeArray(); @endphp
                                                                @foreach($backing_types as $key=>$value)
                                                                    <option value="{{ $key }}" {{ old('backing_type',$record->backing_type) == $key ? 'selected' : '' }}>{{ $value }}</option>
                                                                @endforeach
                                                            </select>
                                                            <label class="field_error" id="bespoke_backing_type_error-0" > </label>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-6">
                                                        <div class="form-group">
                                                            <label for="exampleFormControlInput1" class="form-label">{{ __('content.backing_cost') }}</label>
                                                            <input type="text" class="form-control" id="bespoke_backing_cost-0"  name="qut[0][{{ $bespoke }}][backing_cost]" value="{{ old('backing_cost',isset($record->backing_cost) ? (float)$record->backing_cost : '') }}" onchange="onChangeElem(event)">
                                                            <label class="field_error" id="bespoke_backing_cost_error-0"> </label>
                                                        </div>
                                                    </div>

                                                    <div class="col-lg-3">
                                                        <div class="form-group">
                                                            <label for="exampleFormControlInput1" class="form-label">{{ __('content.backing_size') }}</label>
                                                            <input type="text" class="form-control"  id="bespoke_backing_size-0"  name="qut[0][{{ $bespoke }}][backing_size]" value="{{ old('backing_size',isset($record->backing_size) ? (float)$record->backing_size : '') }}" onchange="onChangeElem(event)" >
                                                            <label class="field_error" id="bespoke_backing_size_error-0"> </label>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-3">
                                                        <div class="form-group">
                                                            <label for="exampleFormControlInput1" class="form-label">{{ __('content.backing_quantity') }}</label>
                                                            <input type="text" class="form-control" id="bespoke_backing_quantity-0" name="qut[0][{{ $bespoke }}][backing_quantity]" value="{{ old('backing_quantity',isset($record->backing_quantity) ? (float)$record->backing_quantity : '') }}" onchange="onChangeElem(event)">
                                                            <label class="field_error" id="bespoke_backing_quantity_error-0"> </label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="sample">
                                                <div class="row">
                                                    <div class="col-lg-6">
                                                        <div class="form-group pt-0">
                                                            <label for="exampleFormControlInput1" class="form-label">{{ __('content.claw') }} </label>
                                                            <select class="form-select" aria-label="Default select example" id="bespoke_claw-0"  name="qut[0][{{ $bespoke }}][claw]" onchange="onChangeElem(event)">
                                                                <option value=" ">Select One Option</option>
                                                                @php $claw = \App\Models\Jewellery::clawArray(); @endphp
                                                                @foreach($claw as $key=>$value)
                                                                    <option value="{{ $key }}"  {{ old('claw',$record->claw) == $key ? 'selected' : '' }}>{{ $value }}</option>
                                                                @endforeach
                                                            </select>
                                                            <label class="field_error" id="bespoke_claw_error-0" > </label>
                                                        </div>
                                                    </div>

                                                    <div class="col-lg-6">
                                                        <div class="form-group pt-0">
                                                            <label for="exampleFormControlInput1" class="form-label">Worksmith</label>
                                                            @php $worksmiths = \App\Models\Worksmith::getWorksmithsList();@endphp
                                                            <select class="form-select" aria-label="Default select example" id="bespoke_worksmith_id-0"  name="qut[0][{{ $bespoke }}][worksmith_id]" onchange="onChangeElem(event)">
                                                                <option value=" ">Select One Option</option>
                                                                @foreach($worksmiths as $key=>$value)
                                                                    <option value="{{ $key }}" {{ old('worksmith_id',$record->worksmith_id) == $key ? 'selected' : '' }}>{{ $value }}</option>
                                                                @endforeach
                                                            </select>
                                                            <label class="field_error" id="bespoke_worksmith_id_error-0"> </label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <div class="sample">
                                            <div class="row">
                                                @if(old('jewelleries',!empty($record->quotation_loose_piece->toArray())))
                                                    @php
                                                        $oldJewelleries = old('jewelleries',@$record->quotation_loose_piece->toArray());
                                                        $oldCount = count($oldJewelleries);
                                                    @endphp
                                                    @foreach(old('jewelleries',@$record->quotation_loose_piece->toArray()) as $key => $value)
                                                        @php $x=$key+1; @endphp
                                                        <div class="row indexes" id="row{{$key}}">
                                                            <div class="col-lg-3">
                                                                <div class="form-group pt-0">
                                                                    <label for="exampleFormControlInput1" class="form-label">{{ __('content.item_code') }}</label>
                                                                    <input type="text" class="form-control" name="qut[0][{{ $bespoke }}][jewelleries][{{$key}}][stock_no]" value="{{ old('jewelleries.'.$key.'.stock_no',@$value['stock_no']) }}">
                                                                </div>
                                                                @if ($errors->has('jewelleries.'.$key.'.stock_no'))
                                                                    <span class="error-message"><strong>{{ $errors->first('jewelleries.'.$key.'.stock_no') }}</strong></span>
                                                                @endif
                                                            </div>
                                                            <div class="col-lg-3">
                                                                <div class="form-group pt-0">
                                                                    <label for="exampleFormControlInput1" class="form-label">{{ __('content.weight') }}</label>
                                                                    <input type="text" class="form-control" id="{{$key}}" name="qut[0][{{ $bespoke }}][jewelleries][{{$key}}][weight]" value="{{ old('jewelleries.'.$key.'.weight',isset($value['weight']) ? (float)$value['weight'] : '') }}" oninput="onInputweight()">
                                                                </div>
                                                                @if ($errors->has('jewelleries.'.$key.'.weight'))
                                                                    <span class="error-message"><strong>{{ $errors->first('jewelleries.'.$key.'.weight') }}</strong></span>
                                                                @endif
                                                            </div>
                                                            <div class="col-lg-3">
                                                                <div class="form-group pt-0">
                                                                    <label for="exampleFormControlInput1" class="form-label">{{ __('content.unit_price') }}</label>
                                                                    <input type="text" class="form-control" id="{{$key}}" name="qut[0][{{ $bespoke }}][jewelleries][{{$key}}][unit_price]" value="{{ old('jewelleries.'.$key.'.unit_price',isset($value['unit_price']) ? (float)$value['unit_price'] : '') }}" oninput="onInputUnitPrice()">
                                                                </div>
                                                                @if ($errors->has('jewelleries.'.$key.'.unit_price'))
                                                                    <span class="error-message"><strong>{{ $errors->first('jewelleries.'.$key.'.unit_price') }}</strong></span>
                                                                @endif
                                                            </div>
                                                            <div class="col-lg-2">
                                                                <div class="form-group pt-0">
                                                                    <label for="exampleFormControlInput1" class="form-label">{{ __('content.price') }}</label>
                                                                    <input type="text" class="form-control" id="price-{{ $key }}" name="qut[0][{{ $bespoke }}][jewelleries][{{ $key }}][price]" value="{{ old('jewelleries.'.$key.'.price',isset($value['price']) ? (float)$value['price'] : '' ) }}" >
                                                                </div>
                                                                @if ($errors->has('jewelleries.'.$key.'.price'))<span class="error-message"><strong>{{ $errors->first('jewelleries.'.$key.'.price') }}</strong></span>
                                                                @endif
                                                            </div>
                                                            @if($key>0)
                                                                <div class="col-lg-1">
                                                                    <button type="button" name="remove" id="{{ $key }}" class="btn btn-danger plus_btn_remove bespoke_remove">X
                                                                    </button>
                                                                </div>
                                                            @endif
                                                        </div>
                                                    @endforeach
                                                @else
                                                    <div class="col-lg-3">
                                                        <div class="form-group pt-0">
                                                            <label for="exampleFormControlInput1" class="form-label">{{ __('content.item_code') }}</label>
                                                            <input type="text" class="form-control" id="exampleFormControlInput1" name="qut[0][{{ $bespoke }}][jewelleries][0][stock_no]" value="{{ old('jewelleries.0.stock_no') }}">
                                                        </div>
                                                        @if ($errors->has('jewelleries.0.stock_no'))
                                                            <span class="error-message"><strong>{{ $errors->first('jewelleries.0.stock_no') }}</strong></span>
                                                        @endif
                                                    </div>
                                                    <div class="col-lg-3">
                                                        <div class="form-group pt-0">
                                                            <label for="exampleFormControlInput1" class="form-label">{{ __('content.weight') }}</label>
                                                            <input type="text" class="form-control" id="0" name="qut[0][{{ $bespoke }}][jewelleries][0][weight]" value="{{ old('jewelleries.0.weight') }}" oninput="onInputweight()">
                                                        </div>
                                                        @if ($errors->has('jewelleries.0.weight'))
                                                            <span class="error-message"><strong>{{ $errors->first('jewelleries.0.weight') }}</strong></span>
                                                        @endif
                                                    </div>
                                                    <div class="col-lg-3">
                                                        <div class="form-group pt-0">
                                                            <label for="exampleFormControlInput1" class="form-label">{{ __('content.unit_price') }}</label>
                                                            <input type="text" class="form-control" id="0" name="qut[0][{{ $bespoke }}][jewelleries][0][unit_price]" value="{{ old('jewelleries.0.unit_price') }}" oninput="onInputUnitPrice()">
                                                            </div>
                                                        @if ($errors->has('jewelleries.0.unit_price'))<span class="error-message"><strong>{{ $errors->first('jewelleries.0.unit_price') }}</strong></span>
                                                        @endif
                                                    </div>
                                                    <div class="col-lg-2">
                                                        <div class="form-group pt-0">
                                                            <label for="exampleFormControlInput1" class="form-label">{{ __('content.price') }}</label>
                                                            <input type="text" class="form-control" id="price-0" name="qut[0][{{ $bespoke }}][jewelleries][0][price]" value="{{ old('jewelleries.0.price') }} ">
                                                        </div>
                                                        @if ($errors->has('jewelleries.0.price'))<span class="error-message"><strong>{{ $errors->first('jewelleries.0.price') }}</strong></span>
                                                        @endif
                                                    </div>
                                                @endif
                                                <div id="append_fields_bespoke-0">

                                                </div>
                                                <div class="col-lg-12">
                                                    <div class="form-group plus pt-0">
                                                        <a class="addPlusBespoke" data-key="0" id="addPlus"><i class="icofont-plus"></i></a>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                        <div class="col-lg-12">
                                            <div class="d-flex mt-5">
                                                <input type="hidden" id="bespoke_subtotal-0" name="qut[0][{{ $bespoke }}][subtotal]" value="">
                                                <button data-key="0" data-type="{{ $bespoke }}" class="btn btn-primary btn-create btn-confirm bespoke_repair_edit me-4" type="button">Update Item</button>
                                                <button class="btn btn-outline-primary btn-reset-form-custom" type="submit">Reset Form</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                        </div>
                    </div>

                    <div class="tab-pane fade {{ ($record->type_name) == \App\Models\QuotationItem::REPAIR  ? 'active show' : ' '}}" id="repair-0" role="tabpanel" aria-labelledby="contact-tab">
                        <div class="position-relative add_item_search add_item_search_custom">
                            <div class="sample card-body mt-0 p-0 pt-4">
                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="category jobs_edit">
                                            <div class="form-group">
                                                <label for="exampleFormControlInput1" class="form-label">Category</label>
                                            </div>
                                            <ul class="category_ul-0">
                                                @php $categories = \App\Models\Category::getCategories(); @endphp
                                                @foreach($categories as $key=>$value)
                                                    <li class="{{ old('category_id',$record->category_id) == $value->id ? 'active_category' : '' }}"><a class="category_id"  data-key="0" value= "{{ $value->id }}" ><img src="{{ $value->image }}" height="60" width="60"/>{{ $value->name }}</a></li>
                                                @endforeach
                                            </ul>
                                            <input id="repair_category_id-0" class="categories_id" type="hidden" name="qut[0][{{ $repair }}][category_id]" value="{{ old('category_id', $record->category_id) }}" />
                                            <label class="field_error" id="repair_category_id_error-0"> </label>
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label for="exampleFormControlInput1" class="form-label"> {{ __('content.gold_colour') }} </label>
                                            <select class="form-select gold_color_id" id="repair_gold_color_id-0"  name="qut[0][{{ $repair }}][gold_color_id]" aria-label="Default select example" onchange="onChangeElem(event)">
                                                <option value="" >Select One Option</option>
                                                @php $gold_colors = \App\Models\GoldColor::getGoldColorsList(); @endphp
                                                @foreach($gold_colors as $key=>$value)
                                                    <option value="{{ $key }}" {{ old('gold_color_id',$record->gold_color_id) ==  $key ? 'selected' : '' }}>{{ $value }}</option>
                                                @endforeach
                                            </select>
                                            <label class="field_error" id="repair_gold_color_id_error-0"> </label>
                                        </div>
                                    </div>

                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label for="exampleFormControlInput1"  class="form-label">{{ __('content.size') }} </label>
                                            <input type="text" id="repair_size-0" name="qut[0][{{ $repair }}][size]" class="form-control size" value="{{ old('size',isset($record->size) ? (float)$record->size: '' ) }}" onchange="onChangeElem(event)">
                                            <label class="field_error" id="repair_size_error-0"> </label>
                                        </div>
                                    </div>

                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label for="exampleFormControlInput1" class="form-label">{{ __('content.description') }} </label>
                                            <textarea class="form-control" id="repair_description-0" name="qut[0][{{ $repair }}][description]" placeholder="Description" value="" rows="2" onchange="onChangeElem(event)"> {{ old('description',$record->description) }} </textarea>
                                            <label class="field_error" id="repair_description_error-0" style="color:red"> </label>
                                        </div>
                                    </div>

                                    <div class="col-lg-12 mt-3">
                                        <label for="exampleFormControlInput1" class="form-label"> {{ __('content.draw_upload') }}
                                            <img src="{{ asset('public/img/folder.png') }}" class="folder">
                                        </label>
                                        <div class="row">
                                            <div class="col-lg-4">
                                                <div class="form-group pt-0">
                                                    <div class="drop-zone">
                                                        <div class="dropzone dropZoneimageUpload" id="repairDropZoneimageUpload-0">
                                                                <span class="drop-zone__prompt dz-default dz-message">Drop Photo here <br>{{ __('content.drop_photo') }}
                                                                    <p>Photo Requiement:</p>
                                                                <ul>
                                                                <li>File type PNG or JPG</li>
                                                                <li>Maximum Size: 500 KB</li>
                                                                </ul>
                                                                </span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-lg-8">
                                                <div class="form-group pt-0">
                                                    <div class="start-drawing"
                                                            id="blackboardPlaceholder">
                                                        <p>{{ __('content.start_drawing') }}</p>
                                                        <canvas  data-key="0"  class="drawingCanvas repair_drawingCanvas" width="500"
                                                                    height="230"></canvas>
                                                        <div class="pen-eraser">
                                                            <span class="pen" onclick="togglePenPointer(this);"><img src="{{ asset('public/img/pen.png') }}"/></span>
                                                            <span class="erase" onclick="eraserHandler(this);"><img src="{{ asset('public/img/eraser.png') }}"/></span>
                                                        </div>
                                                    </div>
                                                    <input type="hidden" id="repair_drawing_textarea_base64-0"  name="qut[0][{{ $repair }}][drawing_textarea_base64]">
                                                    <input type="hidden" id="repair_drawing_image" value="{{ $record->drawing_image_url }}"  name="qut[0][{{ $repair }}][drawing_image]">
                                                </div>
                                            </div>
                                            <div class="col-lg-12">
                                                <div id="repair-template-preview-0" class="preview-droped-images" >
                                                    @if(!empty($record->quotation_item->quotation_item_image))
                                                    @foreach($record->quotation_item->quotation_item_image as  $key=>$value)
                                                        <div class="dz-preview dz-processing dz-image-preview dz-complete">
                                                            <div class="dz-image">
                                                                <img data-dz-thumbnail="" height="60" alt="bracelet.png" src="{{ $value->image_url  }}">
                                                            </div>
                                                            <a class="dz-remove remove_button" href="javascript:undefined;"
                                                                data-dz-remove="">X</a>
                                                            <input type="hidden" value="{{ $value->image }}" name="images[]">
                                                        </div>
                                                    @endforeach
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-12">
                                        <div class="sample">
                                            <div class="col-lg-12">
                                                <div class="form-group d-flex align-items-center pt-0">
                                                    <label for="exampleFormControlInput1" class="form-label mb-0 pe-5">{{ __('content.sample_provided') }}</label>
                                                    <div class="form-check">
                                                        <input class="form-check-input cus-form-check-input repair_is_sample_provided-0" type="radio" name="qut[0][{{ $repair }}][is_sample_provided]"  value="1" {{ old("is_sample_provided",$record->is_sample_provided) == 1 ? 'checked' : '' }} onchange="onChangeElem(event)">
                                                        <label class="form-check-label cus_form_check_label" for="flexRadioDefault1">{{ __('content.yes') }}</label>
                                                    </div>
                                                    <div class="form-check">
                                                        <input class="form-check-input cus-form-check-input repair_is_sample_provided-0" type="radio" name="qut[0][{{ $repair }}][is_sample_provided]" value="0" {{ old("is_sample_provided",$record->is_sample_provided) == 0 ? 'checked' : '' }} onchange="onChangeElem(event)">
                                                        <label class="form-check-label cus_form_check_label"
                                                                for="flexRadioDefault1">
                                                            {{ __('content.no') }}
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-lg-12">
                                                <div class="form-group">
                                                    <label for="exampleFormControlInput1" class="form-label">{{ __('content.sample_description') }}</label>
                                                    <textarea class="form-control" id="repair_sample_description-0" name="qut[0][{{ $repair }}][sample_description]" placeholder="{{ __('content.description') }}" rows="2" onchange="onChangeElem(event)">{{ old('sample_description',$record->sample_description) }}</textarea>
                                                    <label class="field_error" id="repair_sample_description_error-0" > </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="sample">
                                        <div class="row">
                                            <div class="col-lg-4">
                                                <div class="form-group pt-0">
                                                    <label for="exampleFormControlInput1" class="form-label">{{ __('content.gold_weight') }}</label>
                                                    <input type="text" class="form-control" id="repair_gold_weight-0" name="qut[0][{{ $repair }}][gold_weight]"  value="{{ old('gold_weight',isset($record->gold_weight)? (float)$record->gold_weight :'') }}" onchange="onChangeElem(event)">
                                                    <label class="field_error" id="repair_gold_weight_error-0" > </label>
                                                </div>
                                            </div>
                                            <div class="col-lg-4">
                                                <div class="form-group pt-0">
                                                    <label for="exampleFormControlInput1" class="form-label">{{ __('content.gold_cost') }}</label>
                                                    <input type="text" class="form-control" id="repair_gold_cost-0"  name="qut[0][{{ $repair }}][gold_cost]"  value="{{ old('gold_cost',isset($record->gold_cost)? (float)$record->gold_cost :'') }}" onchange="onChangeElem(event)">
                                                    <label class="field_error" id="repair_gold_cost_error-0"> </label>
                                                </div>
                                            </div>
                                            <div class="col-lg-4">
                                                <div class="form-group pt-0">
                                                    <label for="exampleFormControlInput1" class="form-label">{{ __('content.workmanship_cost') }}</label>
                                                    <input type="text" class="form-control" id="repair_craftsmanship_cost-0"   name="qut[0][{{ $repair }}][craftsmanship_cost]" value="{{ old('workmanship_cost',isset($record->craftsmanship_cost)? (float)$record->craftsmanship_cost :'') }}" onchange="onChangeElem(event)">
                                                    <label class="field_error" id="repair_craftsmanship_cost_error-0"> </label>
                                                </div>
                                            </div>
                                            <div class="col-lg-6">
                                                <div class="form-group">
                                                    <label for="exampleFormControlInput1" class="form-label">{{ __('content.polishing_cost') }}</label>
                                                    <input type="text" class="form-control" id="repair_polishing-0" name="qut[0][{{ $repair }}][polishing]" value="{{ old('polishing',isset($record->polishing)? (float)$record->polishing :'') }}" onchange="onChangeElem(event)">
                                                    <label class="field_error" id="repair_polishing_error-0"> </label>
                                                </div>
                                            </div>
                                            <div class="col-lg-6">
                                                <div class="form-group">
                                                    <label for="exampleFormControlInput1" class="form-label">{{ __('content.setting_cost') }}</label>
                                                    <input type="text" class="form-control" id="repair_setting_cost-0" name="qut[0][{{ $repair }}][setting_cost]" value="{{ old('setting_cost',isset($record->setting_cost)? (float)$record->setting_cost :'') }}" onchange="onChangeElem(event)">
                                                    <label class="field_error" id="repair_setting_cost_error-0" > </label>
                                                </div>
                                            </div>
                                            <div class="col-lg-6">
                                                <div class="form-group">
                                                    <label for="exampleFormControlInput1" class="form-label">{{ __('content.earing_pin') }}</label>
                                                    <input type="text" class="form-control" id="repair_earing_pin-0" name="qut[0][{{ $repair }}][earing_pin]" value="{{ old('earing_pin',isset($record->earing_pin) ? (float)$record->earing_pin : '') }}" onchange="onChangeElem(event)">
                                                    <label class="field_error" id="repair_earing_pin_error-0" > </label>
                                                </div>
                                            </div>

                                            <div class="col-lg-6">
                                                <div class="form-group">
                                                    <label for="exampleFormControlInput1" class="form-label">{{ __('content.backing_type') }}</label>
                                                    <select class="form-select" id="repair_backing_type-0" aria-label="Default select example" name="qut[0][{{ $repair }}][backing_type]" onchange="onChangeElem(event)">
                                                        <option value=" ">Select One Option</option>
                                                        @php $backing_types = \App\Models\Jewellery::backingTypeArray(); @endphp
                                                        @foreach($backing_types as $key=>$value)
                                                            <option value="{{ $key }}" {{ old('backing_type',$record->backing_type) == $key ? 'selected' : '' }}>{{ $value }}</option>
                                                        @endforeach
                                                    </select>
                                                    <label class="field_error" id="repair_backing_type_error-0" > </label>
                                                </div>
                                            </div>
                                            <div class="col-lg-6">
                                                <div class="form-group">
                                                    <label for="exampleFormControlInput1" class="form-label">{{ __('content.backing_cost') }}</label>
                                                    <input type="text" class="form-control" id="repair_backing_cost-0"  name="qut[0][{{ $repair }}][backing_cost]" value="{{ old('backing_cost',isset($record->backing_cost) ? (float)$record->backing_cost : '') }}" onchange="onChangeElem(event)">
                                                    <label class="field_error" id="repair_backing_cost_error-0"> </label>
                                                </div>
                                            </div>

                                            <div class="col-lg-3">
                                                <div class="form-group">
                                                    <label for="exampleFormControlInput1" class="form-label">{{ __('content.backing_size') }}</label>
                                                    <input type="text" class="form-control"  id="repair_backing_size-0"  name="qut[0][{{ $repair }}][backing_size]" value="{{ old('backing_size',isset($record->backing_size) ? (float)$record->backing_size : '') }}" onchange="onChangeElem(event)" >
                                                    <label class="field_error" id="repair_backing_size_error-0"> </label>
                                                </div>
                                            </div>
                                            <div class="col-lg-3">
                                                <div class="form-group">
                                                    <label for="exampleFormControlInput1" class="form-label">{{ __('content.backing_quantity') }}</label>
                                                    <input type="text" class="form-control" id="repair_backing_quantity-0" name="qut[0][{{ $repair }}][backing_quantity]" value="{{ old('backing_quantity',isset($record->backing_quantity) ? (float)$record->backing_quantity : '') }}" onchange="onChangeElem(event)">
                                                    <label class="field_error" id="repair_backing_quantity_error-0"> </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="sample">
                                        <div class="row">
                                            <div class="col-lg-6">
                                                <div class="form-group pt-0">
                                                    <label for="exampleFormControlInput1" class="form-label">{{ __('content.claw') }} </label>
                                                    <select class="form-select" aria-label="Default select example" id="repair_claw-0"  name="qut[0][{{ $repair }}][claw]" onchange="onChangeElem(event)">
                                                        <option value=" ">Select One Option</option>
                                                        @php $claw = \App\Models\Jewellery::clawArray(); @endphp
                                                        @foreach($claw as $key=>$value)
                                                            <option value="{{ $key }}"  {{ old('claw',$record->claw) == $key ? 'selected' : '' }}>{{ $value }}</option>
                                                        @endforeach
                                                    </select>
                                                    <label class="field_error" id="repair_claw_error-0" > </label>
                                                </div>
                                            </div>

                                            <div class="col-lg-6">
                                                <div class="form-group pt-0">
                                                    <label for="exampleFormControlInput1" class="form-label">Worksmith</label>
                                                    @php $worksmiths = \App\Models\Worksmith::getWorksmithsList();@endphp
                                                    <select class="form-select" aria-label="Default select example" id="repair_worksmith_id-0"  name="qut[0][{{ $repair }}][worksmith_id]" onchange="onChangeElem(event)">
                                                        <option value=" ">Select One Option</option>
                                                        @foreach($worksmiths as $key=>$value)
                                                            <option value="{{ $key }}" {{ old('worksmith_id',$record->worksmith_id) == $key ? 'selected' : '' }}>{{ $value }}</option>
                                                        @endforeach
                                                    </select>
                                                    <label class="field_error" id="repair_worksmith_id_error-0"> </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="sample">
                                        <div class="row">
                                            @if(old('jewelleries',!empty($record->quotation_loose_piece->toArray())))
                                                @php
                                                    $oldJewelleries = old('jewelleries',@$record->quotation_loose_piece->toArray());
                                                    $oldCount = count($oldJewelleries);
                                                @endphp
                                                @foreach(old('jewelleries',@$record->quotation_loose_piece->toArray()) as $key => $value)
                                                    @php $x=$key+1; @endphp
                                                    <div class="row indexes" id="row{{$key}}">
                                                        <div class="col-lg-3">
                                                            <div class="form-group pt-0">
                                                                <label for="exampleFormControlInput1" class="form-label">{{ __('content.item_code') }}</label>
                                                                <input type="text" class="form-control bespoke_multiple_stocks-0" name="qut[0][{{ $bespoke }}][jewelleries][{{$key}}][stock_no]" value="{{ old('jewelleries.'.$key.'.stock_no',@$value['stock_no']) }}">
                                                            </div>
                                                            <span class="error-message">
                                                                <strong class="field_error" id="qut-0-{{$bespoke}}-jewelleries-0-stock_no_error"></strong>
                                                            </span>
                                                        </div>
                                                        <div class="col-lg-3">
                                                            <div class="form-group pt-0">
                                                                <label for="exampleFormControlInput1" class="form-label">{{ __('content.weight') }}</label>
                                                                <input type="text" class="form-control bespoke_multiple_weights-0" id="{{$key}}" name="qut[0][{{ $bespoke }}][jewelleries][{{$key}}][weight]" value="{{ old('jewelleries.'.$key.'.weight',isset($value['weight']) ? (float)$value['weight'] : '') }}" oninput="onInputweight()">
                                                            </div>
                                                            <span class="error-message">
                                                                <strong class="field_error" id="qut-0-{{$bespoke}}-jewelleries-0-weight_error"></strong>
                                                            </span>
                                                        </div>
                                                        <div class="col-lg-3">
                                                            <div class="form-group pt-0">
                                                                <label for="exampleFormControlInput1" class="form-label">{{ __('content.unit_price') }}</label>
                                                                <input type="text" class="form-control bespoke_multiple_unit_prices-0" id="{{$key}}" name="qut[0][{{ $bespoke }}][jewelleries][{{$key}}][unit_price]" value="{{ old('jewelleries.'.$key.'.unit_price',isset($value['unit_price']) ? (float)$value['unit_price'] : '') }}" oninput="onInputUnitPrice()">
                                                            </div>
                                                            <span class="error-message">
                                                                <strong class="field_error" id="qut-0-{{$bespoke}}-jewelleries-0-unit_price_error"></strong>
                                                             </span>
                                                        </div>
                                                        <div class="col-lg-2">
                                                            <div class="form-group pt-0">
                                                                <label for="exampleFormControlInput1" class="form-label">{{ __('content.price') }}</label>
                                                                <input type="text" class="form-control bespoke_multiple_prices-0" id="price-{{ $key }}" name="qut[0][{{ $bespoke }}][jewelleries][{{ $key }}][price]" value="{{ old('jewelleries.'.$key.'.price',isset($value['price']) ? (float)$value['price'] : '' ) }}" >
                                                            </div>
                                                            <span class="error-message">
                                                                <strong class="field_error" id="qut-0-{{$bespoke}}-jewelleries-0-price_error"></strong>
                                                             </span>
                                                        </div>
                                                        @if($key>0)
                                                            <div class="col-lg-1">
                                                                <button type="button" name="remove" id="{{ $key }}" class="btn btn-danger plus_btn_remove bespoke_remove">X
                                                                </button>
                                                            </div>
                                                        @endif
                                                    </div>
                                                @endforeach
                                            @else
                                                <div class="col-lg-3">
                                                    <div class="form-group pt-0">
                                                        <label for="exampleFormControlInput1" class="form-label">{{ __('content.item_code') }}</label>
                                                        <input type="text" class="form-control" id="exampleFormControlInput1" name="qut[0][{{ $repair }}][jewelleries][0][stock_no]" value="{{ old('jewelleries.0.stock_no') }}">
                                                    </div>
                                                    @if ($errors->has('jewelleries.0.stock_no'))
                                                        <span class="error-message"><strong>{{ $errors->first('jewelleries.0.stock_no') }}</strong></span>
                                                    @endif
                                                </div>
                                                <div class="col-lg-3">
                                                    <div class="form-group pt-0">
                                                        <label for="exampleFormControlInput1" class="form-label">{{ __('content.weight') }}</label>
                                                        <input type="text" class="form-control" id="0" name="qut[0][{{ $repair }}][jewelleries][0][weight]" value="{{ old('jewelleries.0.weight') }}" oninput="onInputweight()">
                                                    </div>
                                                    @if ($errors->has('jewelleries.0.weight'))
                                                        <span class="error-message"><strong>{{ $errors->first('jewelleries.0.weight') }}</strong></span>
                                                    @endif
                                                </div>
                                                <div class="col-lg-3">
                                                    <div class="form-group pt-0">
                                                        <label for="exampleFormControlInput1" class="form-label">{{ __('content.unit_price') }}</label>
                                                        <input type="text" class="form-control" id="0" name="qut[0][{{ $repair }}][jewelleries][0][unit_price]" value="{{ old('jewelleries.0.unit_price') }}" oninput="onInputUnitPrice()">
                                                    </div>
                                                    @if ($errors->has('jewelleries.0.unit_price'))<span class="error-message"><strong>{{ $errors->first('jewelleries.0.unit_price') }}</strong></span>
                                                    @endif
                                                </div>
                                                <div class="col-lg-2">
                                                    <div class="form-group pt-0">
                                                        <label for="exampleFormControlInput1" class="form-label">{{ __('content.price') }}</label>
                                                        <input type="text" class="form-control" id="price-0" name="qut[0][{{ $repair }}][jewelleries][0][price]" value="{{ old('jewelleries.0.price') }} ">
                                                    </div>
                                                    @if ($errors->has('jewelleries.0.price'))<span class="error-message"><strong>{{ $errors->first('jewelleries.0.price') }}</strong></span>
                                                    @endif
                                                </div>
                                            @endif
                                            <div id="append_fields_bespoke-0">

                                            </div>
                                            <div class="col-lg-12">
                                                <div class="form-group plus pt-0">
                                                    <a class="addPlusBespoke" data-key="0" id="addPlus"><i class="icofont-plus"></i></a>
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                    <div class="col-lg-12">
                                        <div class="d-flex mt-5">
                                            <input type="hidden" id="repair_subtotal-0" name="qut[0][{{ $repair }}][subtotal]" value="">
                                            <button data-key="0" data-type="{{ $repair }}" class="btn btn-primary btn-create btn-confirm bespoke_repair_edit me-4" type="button">Update Item</button>
                                            <button class="btn btn-outline-primary btn-reset-form-custom" type="submit">Reset Form</button>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>    
        @endforeach

        <div class="append_btn"></div>
        </div>
 

    <div class="sample card-body mt-0">
       <div class="row">
            <input type="hidden" name="id" value="{{$records->id }}">
            <input type="hidden" id="update_item" name="update_item" value="">
        <div class="col-lg-6 col-md-6">
                <div class="form-group pt-0">
                    <label for="exampleFormControlInput1" class="form-label">Handled By</label>
                    @php $handledBy = \App\Models\Admin::handleBYArray();@endphp
                    <select class="form-select common_input" aria-label="Default select example" name="staff_id">
                        <option value="">Select One Option</option>
                        @foreach($handledBy as $key=>$value)
                     
                            <option value="{{ $value->id }}" {{ old('staff_id',$records->staff_id) == $value->id ? 'selected' : '' }}>{{ ucwords($value->fullname ) }}</option>
                        @endforeach
                    </select>
                    <span class="field_error" id="staff_id_error"> </span>
                </div>
            </div>
            <div class="col-lg-6 col-md-6">
                <div class="form-group pt-lg-0 pt-md-0 pt-sm-0 pt-3 position-relative">
                    <label for="exampleFormControlInput1" class="form-label">Customer Phone Number</label>
                    <div class="search">
                        <img src="{{ asset('public/img/search.png') }}">
                        <input type="text" class="form-control" id="customer_phone" name="customer_phone" placeholder="Enter or Search Phone Number" value="{{ $records->phone_with_code }}">
                    </div>
                    <span class="field_error" id="customer_phone_error" style="color:red"> </span>
                </div>
            </div>
            <div class="col-lg-6 col-md-6">
                <div class="form-group">
                    <label for="exampleFormControlInput1" class="form-label">Customer Name</label>
                    <input type="text" class="form-control" id="customer_name" name="customer_name" value="{{ old('customer_name',$records->customer_name) }}">
                    <span class="field_error" id="customer_name_error" style="color:red"> </span>
                </div>
            </div>
            <div class="col-lg-6 col-md-6">
                <div class="form-group">
                    <label for="exampleFormControlInput1" class="form-label">Customer Email</label>
                    <input type="email" class="form-control" id="customer_email" name="customer_email" value="{{ old('customer_email',$records->customer_email) }}" >
                    <span class="field_error" id="customer_email_error" style="color:red"> </span>
                </div>
            </div>
        </div>
    </div>
   </div>

<div class="card details mb-4">
        <div class="card-body">
            <div class="buttons buttons_1">
                <button class="btn btn-primary btn-create" type="submit">Input Cost</button>
                <button class="btn btn-primary btn-reset-form" type="submit">Reset Form</button>
            </div>
            <div class="col-lg-8 note pt-2">
                <p>Note:
                    <span class="d-block">Upon creating a jewellery successfully, a job order for a worksmith will be automatically created. Go to Job Order to assign a worksmith to the newly job order.</span>
                </p>
            </div>
        </div>
</div>
</form>

@include('admin.elements.scripts.active_itemcode')
@include('admin.quotations.scripts.multiple_append_dropzon_js')
@include('frontend.elements.scripts.multiple_append_drawing_canvas_js')
@include('admin.quotations.scripts.script')

@endsection
