@extends('layouts.admin.default')

@section('title',"Edit Quotation")

@section('header', "Edit Quotation")

@section('content')
<style>
    #drawingCanvas {
        position: absolute;
        left: 0;
        right: 0;
        border: none;
        color: #FFF;
        overflow: hidden;
        background-color: transparent;
        /*display: none;*/

    }

    #tempCanvas {
        position: absolute;
        left: 0;
        right: 0;
        overflow: hidden;
        border: none;
        /*display: none;*/
    }
</style>

@php
    $inventory = \App\Models\QuotationItem::INVENTORY;
    $bespoke = \App\Models\QuotationItem::BESPOKE;
    $repair = \App\Models\QuotationItem::REPAIR;

   $is_error = $errors->any() ? 1 : 0;
   $xi = $is_error ? old('jewelleries') ? count(old('jewelleries')) : '1' : 1;

@endphp

<form id="updateQuotationSubmit" method="">
<div class="card details mb-4">
    <div class="card-header">
        <h4 class="mb-0">Edit Quotation</h4>
    </div>

    <div class="card-body create_quotation add_item_from_main">

        @foreach($records->quotation_item as $index=>$record)
        <div class="items items_new {{ ($index !=0) ? "mt-5" : ""  }}">
            <div class="align-items-center">
                <label class="add_itemm">Add Item From*:</label>
                <ul class="nav nav-tabs  tabbing-{{ $index }} {{-- ($record->type_name) ? 'button_color' : ' ' --}} " id="myTab" role="tablist">
                    <li class="nav-item m-0 me-3" role="presentation">
                        <button class="nav-link inventory {{ ($record->type_name) == $inventory ? 'active' : ' '}}" data-key="{{ $index }}" data-bs-toggle="tab" data-bs-target="#inventory-{{ $index }}" type="button" role="tab" aria-controls="home" aria-selected="true">{!! __('content.inventory_with_br') !!}</button>
                    </li>
                    <li class="nav-item m-0 me-3" role="presentation">
                        <button class="nav-link bespoke {{ ($record->type_name) == $bespoke ? 'active' : ' '}}" data-key="{{ $index }}" data-bs-toggle="tab" data-bs-target="#bespoke-{{ $index }}" type="button" role="tab" aria-controls="profile" aria-selected="false">{!! __('content.bespoke_with_br') !!} </button>
                    </li>
                    <li class="nav-item m-0 me-3" role="presentation">
                        <button class="nav-link repair {{ ($record->type_name) == $repair  ? 'active' : ' '}}" data-key="{{ $index }}" data-bs-toggle="tab" data-bs-target="#repair-{{ $index }}" type="button" role="tab" aria-controls="contact" aria-selected="false"> {!! __('content.repair_with_br') !!}</button>
                    </li>
                </ul>
                <div class="tab-content" id="myTabContent-{{ $index }}">
                    <div class="tab-pane fade show {{ ($record->type_name) == $inventory  ? 'active show' : ' '}}" id="inventory-{{ $index }}" role="tabpanel" aria-labelledby="home-tab">
                        <div class="position-relative add_item_search">
                            <div class="search">
                            <span><img src="{{ asset('public/img/search.png') }}" class="display">
                                <img src="{{ asset('public/img/search_foucs.png') }}" class="focus_search">
                            </span>
                                <div class="d-flex align-items-center position-relative">
                                    <div class="input_div w-100">
                                        <input type="text" id="jewelley_item_code-{{ $index }}" class="form-control cus_form_control jewelley_item_code" value="{{ $record->item_code }}"  name="qut[{{ $index }}][{{ $inventory }}][item_code]" placeholder="Search an item code or an scan item...">
                                        <label class="field_error" id="item_code_error-{{ $index }}" style="color:red"> </label>
                                    </div>
                                    <img src="{{ asset('public/img/cross.png') }}" class="cross cross_invent">
                                </div>

                                <div class="col-lg-12 button_div">
                                    <div class="d-flex mt-5">
                                        <input class="checked-{{ $index }}" type="hidden" id="inventory_checked-{{ $index }}" name="qut[{{ $index }}][{{ $inventory }}][checked]" value="{{ ($record->type_name) == $inventory ? "1":"0" }}">
                                        <input type="hidden" id="inventory_subtotal-{{ $index }}" name="qut[{{ $index }}][{{ $inventory }}][subtotal]" value="">
                                        <button class="btn btn-primary btn-create btn-confirm inventory_edit me-4" data-key="{{ $index }}" type="button">Update Item</button>
                                        <button class="btn btn-outline-primary btn-reset-form-custom reset_form" data-type="inventory" data-key="{{ $index }}" type="button">Reset Form</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="tab-pane fade {{ ($record->type_name) == $bespoke ? 'active show' : ' '}}" id="bespoke-{{ $index }}" role="tabpanel" aria-labelledby="profile-tab">
                        <div class="position-relative add_item_search add_item_search_custom">
                                <div class="sample card-body mt-0 p-0 pt-4">
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="category jobs_edit">
                                                <div class="form-group">
                                                    <label for="exampleFormControlInput1" class="form-label">Category</label>
                                                </div>
                                                <ul class="category_ul-{{ $index }}">
                                                    @php $categories = \App\Models\Category::getCategories(); @endphp
                                                    @foreach($categories as $key=>$value)
                                                        <li class="{{ old('category_id',$record->category_id) == $value->id ?  'active_category' : '' }}"><a class="category_id"  data-key="{{ $index }}" value="{{ $value->id }}" ><img src="{{ $value->image }}" height="60" width="60"/>{{ $value->name }}</a></li>
                                                    @endforeach
                                                </ul>
                                                <input id="bespoke_category_id-{{ $index }}" class="categories_id" type="hidden" name="qut[{{ $index }}][{{ $bespoke }}][category_id]" value="{{ old('category_id', $record->category_id) }}" />
                                                <label class="field_error" id="bespoke_category_id_error-{{ $index }}"> </label>
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label for="exampleFormControlInput1" class="form-label"> {{ __('content.gold_colour') }} </label>
                                                <select class="form-select gold_color_id" id="bespoke_gold_color_id-{{ $index }}"  name="qut[{{ $index }}][{{ $bespoke }}][gold_color_id]" aria-label="Default select example" onchange="onChangeElem(event)">
                                                    <option value="" >Select One Option</option>
                                                    @php $gold_colors = \App\Models\GoldColor::getGoldColorsList(); @endphp
                                                    @foreach($gold_colors as $key=>$value)
                                                        <option value="{{ $key }}" {{ old('gold_color_id',$record->gold_color_id) ==  $key ? 'selected' : '' }}>{{ $value }}</option>
                                                    @endforeach
                                                </select>
                                                <label class="field_error" id="bespoke_gold_color_id_error-{{ $index }}"> </label>
                                            </div>
                                            </div>

                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label for="exampleFormControlInput1"  class="form-label">{{ __('content.size') }} </label>
                                                <input type="text" id="bespoke_size-{{ $index }}" name="qut[{{ $index }}][{{ $bespoke }}][size]" class="form-control size" value="{{ old('size',isset($record->size) ? (float)$record->size: '' ) }}" onchange="onChangeElem(event)">
                                                <label class="field_error" id="bespoke_size_error-{{ $index }}"> </label>
                                            </div>
                                        </div>

                                        <div class="col-lg-12">
                                            <div class="form-group">
                                                <label for="exampleFormControlInput1" class="form-label">{{ __('content.description') }} </label>
                                                <textarea class="form-control" id="bespoke_description-{{ $index }}" name="qut[{{ $index }}][{{ $bespoke }}][description]" placeholder="Description" value="" rows="2" onchange="onChangeElem(event)">{{ old('description',$record->description) }}</textarea>
                                                <label class="field_error" id="bespoke_description_error-{{ $index }}" style="color:red"> </label>
                                            </div>
                                        </div>

                                        <div class="col-lg-12 mt-3">
                                            <label for="exampleFormControlInput1" class="form-label"> {{ __('content.draw_upload') }}
                                                <img src="{{ asset('public/img/folder.png') }}" class="folder">
                                            </label>
                                            <div class="row">
                                                <div class="col-lg-4">
                                                    <div class="form-group pt-0">
                                                        <div class="drop-zone">
                                                            <div class="dropzone dropZoneimageUpload" id="bespokeDropZoneimageUpload-{{ $index }}">
                                                                <span class="drop-zone__prompt dz-default dz-message">Drop Photo here <br>{{ __('content.drop_photo') }}
                                                                    <p>Photo Requiement:</p>
                                                                <ul>
                                                                <li>File type PNG or JPG</li>
                                                                <li>Maximum Size: 2 MB</li>
                                                                </ul>
                                                                </span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-8">
                                                    <div class="form-group pt-0">
                                                        <div class="start-drawing"
                                                                id="blackboardPlaceholder">
                                                            <p>{{ __('content.start_drawing') }}</p>
                                                            <canvas  data-key="{{ $index }}" id="drawingCanvas"  class="drawingCanvas bespoke_drawingCanvas" width="500"
                                                                    height="230"></canvas>
                                                            <div class="pen-eraser">
                                                                <span class="pen" onclick="togglePenPointer(this);"><img src="{{ asset('public/img/pen.png') }}"/></span>
                                                                <span class="erase" onclick="eraserHandler(this);"><img src="{{ asset('public/img/eraser.png') }}"/></span>
                                                            </div>
                                                        </div>
                                                        <input type="hidden" id="bespoke_drawing_textarea_base64-{{ $index }}"  name="qut[{{ $index }}][{{ $bespoke }}][drawing_textarea_base64]">
                                                        {{--<input type="hidden" id="bespoke_drawing_image" value="{{ $record->drawing_image_url }}"  name="qut[0][{{ $bespoke }}][drawing_image]">--}}
                                                        <input type="hidden" id="bespoke_drawing_image" value="{{ $record->drawing_image_url }}">
                                                    </div>
                                                </div>
                                                <div class="col-lg-12">
                                                    <div id="bespoke-template-preview-{{ $index }}" class="preview-droped-images" >

                                                        {{-- @if(!empty($record->quotation_item->quotation_item_image)) --}}
                                                        @foreach($record->quotation_item_image as  $key=>$value)
                                                            <div class="dz-preview dz-processing dz-image-preview dz-complete">
                                                                <div class="dz-image">
                                                                    <img data-dz-thumbnail="" height="60" alt="bracelet.png" src="{{ $value->image_url  }}">
                                                                </div>
                                                                <a class="dz-remove remove_button" href="javascript:undefined;"
                                                                    data-dz-remove="">X</a>
                                                                <input type="hidden" value="{{ $value->image }}" name="qut[{{ $index }}][{{ $bespoke }}][images][]">
                                                            </div>
                                                        @endforeach
                                                        {{-- @endif --}}
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                            <div class="col-lg-12">
                                                <div class="sample">
                                                    <div class="col-lg-12">
                                                        <div class="form-group d-flex align-items-center pt-0">
                                                            <label for="exampleFormControlInput1" class="form-label mb-0 pe-5">{{ __('content.sample_provided') }}</label>
                                                            <div class="form-check">
                                                                <input class="form-check-input cus-form-check-input bespoke_is_sample_provided-{{ $index }}" type="radio" name="qut[{{ $index }}][{{ $bespoke }}][is_sample_provided]"  value="1"  {{ old("is_sample_provided",$record->is_sample_provided) == 1 ? 'checked' : '' }} onchange="onChangeElem(event)">
                                                                <label class="form-check-label cus_form_check_label" for="flexRadioDefault1">{{ __('content.yes') }}</label>
                                                            </div>
                                                            <div class="form-check">
                                                                <input class="form-check-input cus-form-check-input bespoke_is_sample_provided-{{ $index }}" type="radio" name="qut[{{ $index }}][{{ $bespoke }}][is_sample_provided]" value="0" {{ old("is_sample_provided",$record->is_sample_provided) == 0 ? 'checked' : '' }} onchange="onChangeElem(event)">
                                                                <label class="form-check-label cus_form_check_label"
                                                                        for="flexRadioDefault1">
                                                                    {{ __('content.no') }}
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-12">
                                                        <div class="form-group">
                                                            <label for="exampleFormControlInput1" class="form-label">{{ __('content.sample_description') }}</label>
                                                            <textarea class="form-control" id="bespoke_sample_description-{{ $index }}" name="qut[{{ $index }}][{{ $bespoke }}][sample_description]" placeholder="{{ __('content.description') }}" rows="2" onchange="onChangeElem(event)">{{ old('sample_description',$record->sample_description) }}</textarea>
                                                            <label class="field_error" id="bespoke_sample_description_error-{{ $index }}" > </label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="sample">
                                                <div class="row">
                                                    <div class="col-lg-4">
                                                        <div class="form-group pt-0">
                                                            <label for="exampleFormControlInput1" class="form-label">{{ __('content.gold_weight') }}</label>
                                                            <input type="text" class="form-control" id="bespoke_gold_weight-{{ $index }}" name="qut[{{ $index }}][{{ $bespoke }}][gold_weight]"  value="{{ old('gold_weight',isset($record->gold_weight)? (float)$record->gold_weight :"") }}" onchange="onChangeElem(event)">
                                                            <label class="field_error" id="bespoke_gold_weight_error-{{ $index }}" > </label>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-4">
                                                        <div class="form-group pt-0">
                                                            <label for="exampleFormControlInput1" class="form-label">{{ __('content.gold_cost') }}</label>
                                                            <input type="text" class="form-control" id="bespoke_gold_cost-{{ $index }}"  name="qut[{{ $index }}][{{ $bespoke }}][gold_cost]"  value="{{ old('gold_cost',isset($record->gold_cost)? (float)$record->gold_cost :"") }}" onchange="onChangeElem(event)">
                                                            <label class="field_error" id="bespoke_gold_cost_error-{{ $index }}"> </label>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-4">
                                                        <div class="form-group pt-0">
                                                            <label for="exampleFormControlInput1" class="form-label">{{ __('content.workmanship_cost') }}</label>
                                                            <input type="text" class="form-control" id="bespoke_craftsmanship_cost-{{ $index }}"   name="qut[{{ $index }}][{{ $bespoke }}][craftsmanship_cost]" value="{{ old('workmanship_cost',isset($record->craftsmanship_cost)? (float)$record->craftsmanship_cost :"") }}" onchange="onChangeElem(event)">
                                                            <label class="field_error" id="bespoke_craftsmanship_cost_error-{{ $index }}"> </label>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-6">
                                                        <div class="form-group">
                                                            <label for="exampleFormControlInput1" class="form-label">{{ __('content.polishing_cost') }}</label>
                                                            <input type="text" class="form-control" id="bespoke_polishing-{{ $index }}" name="qut[{{ $index }}][{{ $bespoke }}][polishing]" value="{{ old('polishing',isset($record->polishing)? (float)$record->polishing :"") }}" onchange="onChangeElem(event)">
                                                            <label class="field_error" id="bespoke_polishing_error-{{ $index }}"> </label>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-6">
                                                        <div class="form-group">
                                                            <label for="exampleFormControlInput1" class="form-label">{{ __('content.setting_cost') }}</label>
                                                            <input type="text" class="form-control" id="bespoke_setting_cost-{{ $index }}" name="qut[{{ $index }}][{{ $bespoke }}][setting_cost]" value="{{ old('setting_cost',isset($record->setting_cost)? (float)$record->setting_cost :'') }}" onchange="onChangeElem(event)">
                                                            <label class="field_error" id="bespoke_setting_cost_error-{{ $index }}" > </label>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-6">
                                                        <div class="form-group">
                                                            <label for="exampleFormControlInput1" class="form-label">{{ __('content.earing_pin') }}</label>
                                                            <input type="text" class="form-control" id="bespoke_earing_pin-{{ $index }}" name="qut[{{ $index }}][{{ $bespoke }}][earing_pin]" value="{{ old('earing_pin',isset($record->earing_pin) ? (float)$record->earing_pin : ' ') }}" onchange="onChangeElem(event)">
                                                            <label class="field_error" id="bespoke_earing_pin_error-{{ $index }}" > </label>
                                                        </div>
                                                    </div>
                                                    @php

                                                        if($record->category->name != App\Models\Category::RING){
                                                           $display =  "display: none";
                                                        }else{
                                                            $display =  "display: block";
                                                        }


                                                    @endphp

                                                    <div class="col-lg-6 backing_div" style="{{ $display }}">
                                                        <div class="form-group">
                                                            <label for="exampleFormControlInput1" class="form-label">{{ __('content.backing_type') }}</label>
                                                            <select class="form-select" id="bespoke_backing_type-0" aria-label="Default select example" name="qut[{{ $index }}][{{ $bespoke }}][backing_type]" onchange="onChangeElem(event)">
                                                                <option value=" ">Select One Option</option>
                                                                @php $backing_types = \App\Models\Jewellery::backingTypeArray(); @endphp
                                                                @foreach($backing_types as $key=>$value)
                                                                    <option value="{{ $key }}" {{ old('backing_type',$record->backing_type) == $key ? 'selected' : '' }}>{{ $value }}</option>
                                                                @endforeach
                                                            </select>
                                                            <label class="field_error" id="bespoke_backing_type_error-{{ $index }}" > </label>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-6 backing_div" style="{{ $display }}">
                                                        <div class="form-group">
                                                            <label for="exampleFormControlInput1" class="form-label">{{ __('content.backing_cost') }}</label>
                                                            <input type="text" class="form-control" id="bespoke_backing_cost-0"  name="qut[{{ $index }}][{{ $bespoke }}][backing_cost]" value="{{ old('backing_cost',isset($record->backing_cost) ? (float)$record->backing_cost : '') }}" onchange="onChangeElem(event)">
                                                            <label class="field_error" id="bespoke_backing_cost_error-{{ $index }}"> </label>
                                                        </div>
                                                    </div>

                                                    <div class="col-lg-3 backing_div" style="{{ $display }}">
                                                        <div class="form-group">
                                                            <label for="exampleFormControlInput1" class="form-label">{{ __('content.backing_size') }}</label>
                                                            <input type="text" class="form-control"  id="bespoke_backing_size-{{ $index }}"  name="qut[{{ $index }}][{{ $bespoke }}][backing_size]" value="{{ old('backing_size',isset($record->backing_size) ? (float)$record->backing_size : '') }}" onchange="onChangeElem(event)" >
                                                            <label class="field_error" id="bespoke_backing_size_error-{{ $index }}"> </label>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-3 backing_div" style="{{ $display }}">
                                                        <div class="form-group">
                                                            <label for="exampleFormControlInput1" class="form-label">{{ __('content.backing_quantity') }}</label>
                                                            <input type="text" class="form-control" id="bespoke_backing_quantity-{{ $index }}" name="qut[{{ $index }}][{{ $bespoke }}][backing_quantity]" value="{{ old('backing_quantity',isset($record->backing_quantity) ? (float)$record->backing_quantity : '') }}" onchange="onChangeElem(event)">
                                                            <label class="field_error" id="bespoke_backing_quantity_error-{{ $index }}"> </label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="sample">
                                                <div class="row">
                                                    <div class="col-lg-6">
                                                        <div class="form-group pt-0">
                                                            <label for="exampleFormControlInput1" class="form-label">{{ __('content.claw') }} </label>
                                                            <select class="form-select" aria-label="Default select example" id="bespoke_claw-{{ $index }}"  name="qut[{{ $index }}][{{ $bespoke }}][claw]" onchange="onChangeElem(event)">
                                                                <option value=" ">Select One Option</option>
                                                                @php $claw = \App\Models\Jewellery::clawArray(); @endphp
                                                                @foreach($claw as $key=>$value)
                                                                    <option value="{{ $key }}"  {{ old('claw',$record->claw) == $key ? 'selected' : '' }}>{{ $value }}</option>
                                                                @endforeach
                                                            </select>
                                                            <label class="field_error" id="bespoke_claw_error-{{ $index }}" > </label>
                                                        </div>
                                                    </div>

                                                    <div class="col-lg-6">
                                                        <div class="form-group pt-0">
                                                            <label for="exampleFormControlInput1" class="form-label">Worksmith</label>
                                                            @php $worksmiths = \App\Models\Worksmith::getWorksmithsList();@endphp
                                                            <select class="form-select" aria-label="Default select example" id="bespoke_worksmith_id-{{ $index }}"  name="qut[{{ $index }}][{{ $bespoke }}][worksmith_id]" onchange="onChangeElem(event)">
                                                                <option value=" ">Select One Option</option>
                                                                @foreach($worksmiths as $key=>$value)
                                                                    <option value="{{ $key }}" {{ old('worksmith_id',$record->worksmith_id) == $key ? 'selected' : '' }}>{{ $value }}</option>
                                                                @endforeach
                                                            </select>
                                                            <label class="field_error" id="bespoke_worksmith_id_error-{{ $index }}"> </label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <div class="sample">
                                            <div class="row">
                                                @if(old('jewelleries',!empty($record->quotation_loose_piece->toArray())))
                                                    @php
                                                        $oldJewelleries = old('jewelleries',@$record->quotation_loose_piece->toArray());
                                                        $oldCount = count($oldJewelleries);
                                                    @endphp
                                                    @foreach(old('jewelleries',@$record->quotation_loose_piece->toArray()) as $key => $value)
                                                        @php $x=$key+1; @endphp
                                                        <div class="row indexes" id="row{{$key}}">
                                                            <div class="col-lg-3">
                                                                <div class="form-group pt-0">
                                                                    <label for="exampleFormControlInput1" class="form-label">{{ __('content.item_code') }}</label>
                                                                    <input type="text" class="form-control jewellery_item_code bespoke_multiple_stocks-{{ $index }}" data-type="{{ $bespoke }}" id="jewelleries-{{ $index }}-{{$bespoke}}-stock_no-{{$key}}" data-id="{{ $index }}" data-index="{{$key}}" name="qut[{{ $index }}][{{ $bespoke }}][jewelleries][{{$key}}][stock_no]" value="{{ old('jewelleries.'.$key.'.stock_no',@$value['stock_no']) }}">
                                                                </div>
                                                                <span class="error-message">
                                                                <strong class="field_error" id="qut-{{ $index }}-{{$bespoke}}-jewelleries-{{ $key }}-stock_no_error"></strong>
                                                                </span>
                                                            </div>
                                                            <div class="col-lg-3">
                                                                <div class="form-group pt-0">
                                                                    <label for="exampleFormControlInput1" class="form-label">{{ __('content.weight') }}</label>
                                                                    <input type="text" class="form-control bespoke_multiple_weights-{{ $index }}" data-type="{{ $bespoke }}"  name="qut[{{ $index }}][{{ $bespoke }}][jewelleries][{{$key}}][weight]" id="jewelleries-{{ $index }}-{{$bespoke}}-weight-{{$key}}" data-id="{{ $index }}" data-index="{{$key}}" value="{{ old('jewelleries.'.$key.'.weight',isset($value['weight']) ? (float)$value['weight'] : '') }}" oninput="onInputweight()">
                                                                </div>
                                                                <span class="error-message">
                                                                    <strong class="field_error" id="qut-{{ $index }}-{{$bespoke}}-jewelleries-{{$key}}-weight_error"></strong>
                                                                 </span>
                                                            </div>
                                                            <div class="col-lg-3">
                                                                <div class="form-group pt-0">
                                                                    <label for="exampleFormControlInput1" class="form-label">{{ __('content.unit_price') }}</label>
                                                                    <input type="text" class="form-control bespoke_multiple_unit_prices-{{ $index }}" data-type="{{ $bespoke }}" name="qut[{{ $index }}][{{ $bespoke }}][jewelleries][{{$key}}][unit_price]"  id="jewelleries-{{ $index }}-{{$bespoke}}-unit_price-{{$key}}" data-id="{{ $index }}" data-index="{{$key}}" value="{{ old('jewelleries.'.$key.'.unit_price',isset($value['unit_price']) ? (float)$value['unit_price'] : '') }}" oninput="onInputUnitPrice()">
                                                                </div>
                                                                <span class="error-message">
                                                                    <strong class="field_error" id="qut-{{ $index }}-{{$bespoke}}-jewelleries-{{ $key }}-unit_price_error"></strong>
                                                                 </span>
                                                            </div>
                                                            <div class="col-lg-2">
                                                                <div class="form-group pt-0">
                                                                    <label for="exampleFormControlInput1" class="form-label">{{ __('content.price') }}</label>
                                                                    <input type="text" class="form-control bespoke_multiple_prices-{{ $index }}" data-type="{{ $bespoke }}" name="qut[{{ $index }}][{{ $bespoke }}][jewelleries][{{ $key }}][price]"  id="jewelleries-{{ $index }}-{{$bespoke}}-price-{{$key}}" data-id="{{ $index }}" data-index="{{$key}}" value="{{ old('jewelleries.'.$key.'.price',isset($value['price']) ? (float)$value['price'] : '' ) }}" >
                                                                </div>
                                                                <span class="error-message">
                                                                    <strong class="field_error" id="qut-{{ $index }}-{{$bespoke}}-jewelleries-{{ $key }}-price_error"></strong>
                                                                </span>
                                                            </div>
                                                            @if($key>0)
                                                                <div class="col-lg-1">
                                                                    <button type="button" name="remove" id="{{ $key }}" class="btn btn-danger plus_btn_remove bespoke_remove">X
                                                                    </button>
                                                                </div>
                                                            @endif
                                                        </div>
                                                    @endforeach
                                                @else
                                                <div class="col-lg-3">
                                                    <div class="form-group pt-0">
                                                        <label for="exampleFormControlInput1" class="form-label">{{ __('content.item_code') }}</label>
                                                        <input type="text" data-type="{{ $bespoke }}" class="form-control jewellery_item_code bespoke_multiple_stocks-{{ $index }}"  name="qut[{{ $index }}][{{ $bespoke }}][jewelleries][0][stock_no]" id="jewelleries-{{ $index }}-{{$bespoke}}-stock_no-0" data-id="{{ $index }}" data-index="0" value="">
                                                    </div>
                                                    <span class="error-message">
                                                    <strong class="field_error" id="qut-{{ $index }}-{{$bespoke}}-jewelleries-0-stock_no_error"></strong>
                                                    </span>
                                                </div>
                                                <div class="col-lg-3">
                                                    <div class="form-group pt-0">
                                                        <label for="exampleFormControlInput1" class="form-label">{{ __('content.weight') }}</label>
                                                        <input type="text" data-type="{{ $bespoke }}" class="form-control bespoke_multiple_weights-{{ $index }}"  name="qut[{{ $index }}][{{ $bespoke }}][jewelleries][0][weight]" id="jewelleries-{{ $index }}-{{$bespoke}}-weight-0" data-id="{{ $index }}" data-index="0" value="" oninput="onInputweight()">
                                                    </div>
                                                    <span class="error-message">
                                                        <strong class="field_error" id="qut-{{ $index }}-{{$bespoke}}-jewelleries-0-weight_error"></strong>
                                                     </span>
                                                </div>
                                                <div class="col-lg-3">
                                                    <div class="form-group pt-0">
                                                        <label for="exampleFormControlInput1" class="form-label">{{ __('content.unit_price') }}</label>
                                                        <input type="text" data-type="{{ $bespoke }}" class="form-control bespoke_multiple_unit_prices-{{ $index }}"  name="qut[{{ $index }}][{{ $bespoke }}][jewelleries][0][unit_price]"  id="jewelleries-{{ $index }}-{{$bespoke}}-unit_price-0" data-id="{{ $index }}" data-index="0" value="" oninput="onInputUnitPrice()">
                                                    </div>
                                                    <span class="error-message">
                                                        <strong class="field_error" id="qut-{{ $index }}-{{$bespoke}}-jewelleries-0-unit_price_error"></strong>
                                                     </span>
                                                </div>
                                                <div class="col-lg-2">
                                                    <div class="form-group pt-0">
                                                        <label for="exampleFormControlInput1" class="form-label">{{ __('content.price') }}</label>
                                                        <input type="text" data-type="{{ $bespoke }}" class="form-control dynamic_price bespoke_multiple_prices-{{ $index }}"  name="qut[{{ $index }}][{{ $bespoke }}][jewelleries][0][price]" id="jewelleries-{{ $index }}-{{$bespoke}}-price-0" data-id="{{ $index }}" data-index="0" value="">
                                                    </div>
                                                    <span class="error-message">
                                                        <strong class="field_error" id="qut-{{ $index }}-{{$bespoke}}-jewelleries-0-price_error"></strong>
                                                    </span>
                                                </div>
                                                @endif
                                                <div id="append_fields_bespoke-{{ $index }}">

                                                </div>
                                                <div class="col-lg-12">
                                                    <div class="form-group plus pt-0">
                                                        <a class="addPlusBespoke" data-key="{{ $index }}" ><i class="icofont-plus"></i></a>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                        <div class="col-lg-12">
                                            <div class="d-flex mt-5">
                                                <input type="hidden" class="checked-{{ $index }}" id="bespoke_checked-{{ $index }}" name="qut[{{ $index }}][{{ $bespoke }}][checked]" value="{{ ($record->type_name) == $bespoke ? "1":"0" }}">
                                                <input type="hidden" id="bespoke_subtotal-{{ $index }}" name="qut[{{ $index }}][{{ $bespoke }}][subtotal]" value="">
                                                <button data-key="{{ $index }}" data-type="{{ $bespoke }}" class="btn btn-primary btn-create btn-confirm bespoke_repair_edit me-4" type="button">Update Item</button>
                                                <button class="btn btn-outline-primary btn-reset-form-custom reset_form" data-type="bespoke" data-key="{{ $index }}" type="button">Reset Form</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                        </div>
                    </div>

                    <div class="tab-pane fade {{ ($record->type_name) == $repair ? 'active show' : ' '}}" id="repair-{{ $index }}" role="tabpanel" aria-labelledby="contact-tab">
                        <div class="position-relative add_item_search add_item_search_custom">
                            <div class="sample card-body mt-0 p-0 pt-4">
                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="category jobs_edit">
                                            <div class="form-group">
                                                <label for="exampleFormControlInput1" class="form-label">Category</label>
                                            </div>
                                            <ul class="category_ul-{{ $index }}">
                                                @php $categories = \App\Models\Category::getCategories(); @endphp
                                                @foreach($categories as $key=>$value)
                                                    <li class="{{ old('category_id',$record->category_id) == $value->id ? 'active_category' : '' }}"><a class="category_id"  data-key="{{ $index }}" value= "{{ $value->id }}" ><img src="{{ $value->image }}" height="60" width="60"/>{{ $value->name }}</a></li>
                                                @endforeach
                                            </ul>
                                            <input id="repair_category_id-{{ $index }}" class="categories_id" type="hidden" name="qut[{{ $index }}][{{ $repair }}][category_id]" value="{{ old('category_id', $record->category_id) }}" />
                                            <label class="field_error" id="repair_category_id_error-{{ $index }}"> </label>
                                        </div>
                                    </div>

                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label for="exampleFormControlInput1" class="form-label">{{ __('content.description') }} </label>
                                            <textarea class="form-control" id="repair_description-{{ $index }}" name="qut[{{ $index }}][{{ $repair }}][description]" placeholder="Description" value="" rows="2" onchange="onChangeElem(event)">{{ old('description',$record->description) }}</textarea>
                                            <label class="field_error" id="repair_description_error-{{ $index }}"> </label>
                                        </div>
                                    </div>

                                    <div class="col-lg-12 mt-3">
                                        <label for="exampleFormControlInput1" class="form-label"> {{ __('content.draw_upload') }}
                                            <img src="{{ asset('public/img/folder.png') }}" class="folder">
                                        </label>
                                        <div class="row">
                                            <div class="col-lg-4">
                                                <div class="form-group pt-0">
                                                    <div class="drop-zone">
                                                        <div class="dropzone dropZoneimageUpload" id="repairDropZoneimageUpload-{{ $index }}">
                                                                <span class="drop-zone__prompt dz-default dz-message">Drop Photo here <br>{{ __('content.drop_photo') }}
                                                                    <p>Photo Requiement:</p>
                                                                <ul>
                                                                <li>File type PNG or JPG</li>
                                                                <li>Maximum Size: 2 MB</li>
                                                                </ul>
                                                                </span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-lg-8">
                                                <div class="form-group pt-0">
                                                    <div class="start-drawing"
                                                            id="blackboardPlaceholder">
                                                        <p>{{ __('content.start_drawing') }}</p>
                                                        <canvas  data-key="{{ $index }}"  id="drawingCanvas" class="drawingCanvas repair_drawingCanvas" width="500"
                                                                    height="230"></canvas>
                                                        <div class="pen-eraser">
                                                            <span class="pen" onclick="togglePenPointer(this);"><img src="{{ asset('public/img/pen.png') }}"/></span>
                                                            <span class="erase" onclick="eraserHandler(this);"><img src="{{ asset('public/img/eraser.png') }}"/></span>
                                                        </div>
                                                    </div>
                                                    <input type="hidden" id="repair_drawing_textarea_base64-{{ $index }}"  name="qut[{{ $index }}][{{ $repair }}][drawing_textarea_base64]">
                                                    <input type="hidden" id="repair_drawing_image" value="{{ $record->drawing_image_url }}">
                                                </div>
                                            </div>
                                            <div class="col-lg-12">
                                                <div id="repair-template-preview-{{ $index }}" class="preview-droped-images" >
                                                    @foreach($record->quotation_item_image as  $key=>$value)
                                                        <div class="dz-preview dz-processing dz-image-preview dz-complete">
                                                            <div class="dz-image">
                                                                <img data-dz-thumbnail="" height="60" alt="bracelet.png" src="{{ $value->image_url  }}">
                                                            </div>
                                                            <a class="dz-remove remove_button" href="javascript:undefined;"
                                                                data-dz-remove="">X</a>
                                                            <input type="hidden" value="{{ $value->image }}" name="images[]">
                                                        </div>
                                                    @endforeach
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="sample">
                                        <div class="row">
                                            @if(old('jewelleries',!empty($record->quotation_loose_piece->toArray())))
                                                @php
                                                    $oldJewelleries = old('jewelleries',@$record->quotation_loose_piece->toArray());
                                                    $oldCount = count($oldJewelleries);
                                                @endphp
                                                @foreach(old('jewelleries',@$record->quotation_loose_piece->toArray()) as $key => $value)
                                                    @php $x=$key+1; @endphp
                                                    <div class="row indexes" id="row{{$key}}">
                                                        <div class="col-lg-3">
                                                            <div class="form-group pt-0">
                                                                <label for="exampleFormControlInput1" class="form-label">{{ __('content.item_code') }}</label>
                                                                <input type="text" data-type="{{ $repair }}" class="form-control jewellery_item_code repair_multiple_stocks-{{ $index }}" id="jewelleries-{{ $index }}-{{$repair}}-stock_no-{{$key}}" data-id="{{ $index }}" data-index="{{$key}}"  name="qut[{{ $index }}][{{ $repair }}][jewelleries][{{$key}}][stock_no]" value="{{ old('jewelleries.'.$key.'.stock_no',@$value['stock_no']) }}">
                                                            </div>
                                                            <span class="error-message">
                                                                <strong class="field_error" id="qut-{{ $index }}-{{ $repair }}-jewelleries-{{ $key }}-stock_no_error"></strong>
                                                             </span>
                                                        </div>
                                                        <div class="col-lg-3">
                                                            <div class="form-group pt-0">
                                                                <label for="exampleFormControlInput1" class="form-label">{{ __('content.weight') }}</label>
                                                                <input type="text" data-type="{{ $repair }}" class="form-control  repair_multiple_weights-{{ $index }}" name="qut[{{ $index }}][{{ $repair }}][jewelleries][{{$key}}][weight]"  id="jewelleries-{{ $index }}-{{$repair}}-weight-{{$key}}" data-id="{{ $index }}" data-index="{{$key}}" value="{{ old('jewelleries.'.$key.'.weight',isset($value['weight']) ? (float)$value['weight'] : '') }}" oninput="onInputweight()">
                                                            </div>
                                                            <span class="error-message">
                                                                <strong class="field_error" id="qut-{{ $index }}-{{$repair}}-jewelleries-{{ $key }}-weight_error"></strong>
                                                            </span>
                                                        </div>
                                                        <div class="col-lg-3">
                                                            <div class="form-group pt-0">
                                                                <label for="exampleFormControlInput1" class="form-label">{{ __('content.unit_price') }}</label>
                                                                <input type="text" data-type="{{ $repair }}" class="form-control repair_multiple_unit_prices-{{  $index }}"  name="qut[{{ $index }}][{{ $repair }}][jewelleries][{{$key}}][unit_price]" id="jewelleries-{{ $index }}-{{$repair}}-unit_price-{{$key}}" data-id="{{ $index }}" data-index="{{$key}}" value="{{ old('jewelleries.'.$key.'.unit_price',isset($value['unit_price']) ? (float)$value['unit_price'] : '') }}" oninput="onInputUnitPrice()">
                                                            </div>
                                                            <span class="error-message">
                                                                <strong class="field_error" id="qut-{{ $index }}-{{$repair}}-jewelleries-{{ $key }}-unit_price_error"></strong>
                                                             </span>
                                                        </div>
                                                        <div class="col-lg-2">
                                                            <div class="form-group pt-0">
                                                                <label for="exampleFormControlInput1" class="form-label">{{ __('content.price') }}</label>
                                                                <input type="text" data-type="{{ $repair }}" class="form-control repair_multiple_prices-{{ $index }}" name="qut[{{ $index }}][{{ $repair }}][jewelleries][{{ $key }}][price]" id="jewelleries-{{ $index }}-{{$repair}}-price-{{$key}}" data-id="{{ $index }}" data-index="{{$key}}" value="{{ old('jewelleries.'.$key.'.price',isset($value['price']) ? (float)$value['price'] : '' ) }}" >
                                                            </div>
                                                            <span class="error-message">
                                                                <strong class="field_error" id="qut-{{ $index }}-{{$repair }}-jewelleries-{{ $key }}-price_error"></strong>
                                                             </span>
                                                        </div>
                                                        @if($key>0)
                                                            <div class="col-lg-1">
                                                                <button type="button" name="remove" id="{{ $key }}" class="btn btn-danger plus_btn_remove bespoke_remove">X
                                                                </button>
                                                            </div>
                                                        @endif
                                                    </div>
                                                @endforeach
                                            @else
                                            <div class="col-lg-3">
                                                <div class="form-group pt-0">
                                                    <label for="exampleFormControlInput1" class="form-label">{{ __('content.item_code') }}</label>
                                                    <input type="text" data-type="{{ $repair }}" class="form-control jewellery_item_code repair_multiple_stocks-{{ $index }}"  name="qut[{{ $index }}][{{ $repair }}][jewelleries][0][stock_no]" id="jewelleries-{{ $index }}-{{$repair}}-stock_no-0" data-id="{{ $index }}" data-index="0"  value="">
                                                </div>
                                                <span class="error-message">
                                                    <strong class="field_error" id="qut-{{ $index }}-{{ $repair }}-jewelleries-0-stock_no_error"></strong>
                                                 </span>
                                            </div>
                                            <div class="col-lg-3">
                                                <div class="form-group pt-0">
                                                    <label for="exampleFormControlInput1" class="form-label">{{ __('content.weight') }}</label>
                                                    <input type="text" data-type="{{ $repair }}" class="form-control repair_multiple_weights-{{ $index }}"  name="qut[{{ $index }}][{{ $repair }}][jewelleries][0][weight]" id="jewelleries-{{ $index }}-{{$repair}}-weight-0" data-id="{{ $index }}" data-index="0"  value="" oninput="onInputweight()">
                                                </div>
                                                <span class="error-message">
                                                    <strong class="field_error" id="qut-{{ $index }}-{{ $repair }}-jewelleries-0-weight_error"></strong>
                                                 </span>
                                            </div>
                                            <div class="col-lg-3">
                                                <div class="form-group pt-0">
                                                    <label for="exampleFormControlInput1" class="form-label">{{ __('content.unit_price') }}</label>
                                                    <input type="text" data-type="{{ $repair }}" class="form-control repair_multiple_unit_prices-{{ $index }}"  name="qut[{{ $index }}][{{ $repair }}][jewelleries][0][unit_price]" id="jewelleries-{{ $index }}-{{$repair}}-unit_price-0" data-id="{{ $index }}" data-index="0"  value="" oninput="onInputUnitPrice()">
                                                </div>
                                                <span class="error-message">
                                                    <strong class="field_error" id="qut-{{ $index }}-{{ $repair }}-jewelleries-0-unit_price_error"></strong>
                                                 </span>
                                            </div>
                                            <div class="col-lg-2">
                                                <div class="form-group pt-0">
                                                    <label for="exampleFormControlInput1" class="form-label">{{ __('content.price') }}</label>
                                                    <input type="text" data-type="{{ $repair }}" class="form-control dynamic_price repair_multiple_prices-{{ $index }}" id="price-{{ $index }}" name="qut[{{ $index }}][{{ $repair }}][jewelleries][0][price]" id="jewelleries-{{ $index }}-{{$bespoke}}-price-0" data-id="{{ $index }}" data-index="0"  value="">
                                                </div>
                                                <span class="error-message">
                                                    <strong class="field_error" id="qut-{{ $index }}-{{ $repair }}-jewelleries-0-price_error"></strong>
                                                 </span>
                                            </div>

                                            @endif
                                            <div id="append_fields_repair-{{ $index }}">

                                            </div>
                                            <div class="col-lg-12">
                                                <div class="form-group plus pt-0">
                                                    <a class="addPlusRepair" data-key="{{ $index }}"><i class="icofont-plus"></i></a>
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                    <div class="col-lg-12">
                                        <div class="d-flex mt-5">
                                            <input type="hidden" class="checked-{{ $index }}" id="repair_checked-{{ $index }}" name="qut[{{ $index }}][{{ $repair }}][checked]" value="{{ ($record->type_name) == $repair ? "1":"0" }}">
                                            <input type="hidden" id="repair_subtotal-{{ $index }}" name="qut[{{ $index }}][{{ $repair }}][subtotal]" value="">
                                            <button data-key="{{ $index }}" data-type="{{ $repair }}" class="btn btn-primary btn-create btn-confirm bespoke_repair_edit me-4" type="button">Update Item</button>
                                            <button class="btn btn-outline-primary btn-reset-form-custom reset_form" data-type="repair" data-key="{{$index}}" type="button">Reset Form</button>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>

                </div>
            </div>
        </div>
        @endforeach

        <div class="append_btn"></div>
        </div>


    <div class="sample card-body mt-0">
       <div class="row">
            <input type="hidden" name="id" value="{{$records->id }}">
            <input type="hidden" id="update_item" name="update_item" value="">
        <div class="col-lg-6 col-md-6">
                <div class="form-group pt-0">
                    <label for="exampleFormControlInput1" class="form-label">{{ __('content.handle_by') }}</label>
                    @php $handledBy = \App\Models\Admin::handleBYArray();@endphp
                    <select class="form-select common_input" aria-label="Default select example" name="staff_id">
                        <option value="">Select One Option</option>
                        @foreach($handledBy as $key=>$value)

                            <option value="{{ $value->id }}" {{ old('staff_id',$records->staff_id) == $value->id ? 'selected' : '' }}>{{ ucwords($value->fullname ) }}</option>
                        @endforeach
                    </select>
                    <span class="field_error" id="staff_id_error"> </span>
                </div>
            </div>
            <div class="col-lg-6 col-md-6">
                <div class="form-group pt-lg-0 pt-md-0 pt-sm-0 pt-3 position-relative">
                    <label for="exampleFormControlInput1" class="form-label">{{ __('content.customer_phone_no') }}</label>
                    <div class="search">
                        <img src="{{ asset('public/img/search.png') }}">
                        <input type="text" class="form-control" id="customer_phone" name="customer_phone" placeholder="Enter or Search Phone Number" value="{{ $records->phone_with_code }}">
                    </div>
                    <span class="field_error" id="customer_phone_error" style="color:red"> </span>
                </div>
            </div>
            <div class="col-lg-6 col-md-6">
                <div class="form-group">
                    <label for="exampleFormControlInput1" class="form-label">{{ __('content.customer_name') }}</label>
                    <input type="text" class="form-control" id="customer_name" name="customer_name" value="{{ old('customer_name',$records->customer_name) }}">
                    <span class="field_error" id="customer_name_error" style="color:red"> </span>
                </div>
            </div>
            <div class="col-lg-6 col-md-6">
                <div class="form-group">
                    <label for="exampleFormControlInput1" class="form-label">{{ __('content.customer_email') }}</label>
                    <input type="email" class="form-control" id="customer_email" name="customer_email" value="{{ old('customer_email',$records->customer_email) }}" >
                    <span class="field_error" id="customer_email_error" style="color:red"> </span>
                </div>
            </div>
        </div>
    </div>
   </div>

<div class="card details mb-4">
        <div class="card-body">
            <div class="buttons buttons_1">
                <button class="btn btn-primary btn-create" type="submit">{{ __('content.input_cost') }}</button>
                <a href="" class="btn btn-primary btn-reset-form" type="submit">{{ __('content.reset_form') }}</a>
            </div>
            <div class="col-lg-8 note pt-2">
                <p>Note:
                    <span class="d-block">Upon creating a jewellery successfully, a job order for a worksmith will be automatically created. Go to Job Order to assign a worksmith to the newly job order.</span>
                </p>
            </div>
        </div>
</div>
</form>

@include('admin.elements.scripts.active_itemcode')
@include('admin.quotations.scripts.multiple_append_dropzon_js')
@include('admin.elements.scripts.multiple_append_drawing_canvas_js')
@include('admin.elements.scripts.multiple_jewellery_itemcode_autocomplete_js')
@include('admin.quotations.scripts.script')

@endsection
