@extends('layouts.admin.default')

@section('title',"Change Password")

@section('header', "Change Password")

@section('breadcrumb')
    @parent
    <li class="breadcrumb-item active" aria-current="page">Change Password</li>
@endsection

@section('content')
    {{--<div class="dasboard-menu-item">--}}
        <div class="card details mb-4">
            <div class="card-header">
                <h4 class="mb-0">Change Password </h4>
            </div>
            <div class="card-body">
                <form method="POST" action="{{ route('admin.updatePassword') }}">
                    @csrf
                    <div class="form-group position-relative">
                        <label for="exampleInputName1">Current Password</label>
                        <input type="password" class="form-control class_password" name="current_password"
                               id="exampleInputName1"
                               placeholder="Current Password" value="{{ old('current_password') }}">
                        <i class="icofont-eye-blocked password_eye togglePassword"></i>
                        @if ($errors->has('current_password'))
                            <span class="error-message">
									<strong>{{ $errors->first('current_password') }}</strong>
								</span>
                        @endif
                    </div>
                    <div class="form-group position-relative">
                        <label for="exampleInputName1">New Password</label>
                        <input type="password" class="form-control class_password" name="password" id="exampleInputName1"
                               placeholder="New Password" value="{{ old('password') }}">
                        <i class="icofont-eye-blocked password_eye togglePassword"></i>
                        @if ($errors->has('password'))
                            <span class="error-message">
									<strong>{{ $errors->first('password') }}</strong>
								</span>
                        @endif
                    </div>
                    <div class="form-group position-relative">
                        <label for="exampleInputName1">Confirm Password</label>
                        <input type="password" class="form-control class_password" name="password_confirmation" id="exampleInputName1"
                               placeholder="Confirm Password" value="{{ old('password_confirmation') }}">
                        <i class="icofont-eye-blocked password_eye togglePassword"></i>
                        @if ($errors->has('password_confirmation'))
                            <span class="error-message">
									<strong>{{ $errors->first('password_confirmation') }}</strong>
								</span>
                        @endif
                    </div>
                    <div class="buttons mt-5">
                        <button class="btn btn-primary btn-create" type="submit">Submit</button>
                        <a href="{{ route('admin.dashboard.index') }}" class="btn btn-primary btn-reset-form"
                           type="submit">Cancel</a>
                    </div>

                </form>
            </div>
        </div>
    {{--</div>--}}

@endsection
