@extends('layouts.admin.default')

@section('title',"Notifications")

@section('header',"Notifications")


@section('content')

<div class="card mb-4">
    <div class="card-header Job-dash">
        <h4 class="mb-0">Notifications</h4>
        <p>This section shows an overview of the Notifications in Sancy ERP system.</p>
    </div>
</div>


<div class="card details mb-4 report">
    <div class="row">
        @foreach($worksmiths as $worksmith)
        <div class="col-lg-12 mt-2 mb-2">
            <div class="Updating">
                <h3>{{ ucwords($worksmith->fullname) }} Notifications</h3>
                @if(count($worksmith->notifications))
                    <div class="d-flex job-status work-with justify-content-between">
                        <ul class="update">
                            @foreach($worksmith->notifications as $notification)
                            <li class="list-unstyled d-flex align-items-start">
                                <div class="number"><em></em></div>
                                <div>
                                    <h4>ID: {{ $notification->id }} - Type: {{ $notification->type }}  
                                    Data: {{ $notification->data['data'] }}</h4>
                                    <p>
                                        @if(empty($notification->read_at))
                                        <a href="{{ route('admin.notifications.markAsRead', [ 'user_id'=>$worksmith->id, 'notification_id'=>$notification->id ])}}" style="color:green"> Mark All As Read</a>
                                        @else
                                        <B>Read</B>
                                        @endif
                                    </p>
                                </div>
                            </li>
                            @endforeach
                        </ul>
                    </div>
                @else
                <p>No record found!</p>
                @endif
            </div>
        </div>
        @endforeach
    </div>
</div>

@endsection
