@extends('layouts.admin.default')

@section('title',"Edit Material")

@section('header', "Edit Material")


@section('content')

<div class="card details mb-4">
    <div class="card-header">
        <h4 class="mb-0">Edit Material</h4>
    </div>
    <div class="card-body">
        <form method="POST" class="sign-in-form" action="{{ route('admin.materials.update',$record->id) }}" autocomplete="off">
            @csrf
            @method('PUT')
            <div class="row">
                <div class="modal-login pb-0">
                    <div class="row">
                    	<input type="hidden" value="{{$record->id}}" name="id">
                        <div class="col-lg-6">
                            <div class="form-group pt-0">
                                <label for="exampleFormControlInput1" class="form-label">Material</label>
                                <input type="text" name="name" placeholder="Enter Material" value="{{old('name',$record->name)}}" class="form-control" id="exampleFormControlInput1" >
                                @if ($errors->has('name'))
                                <span class="error-message">
                                    <strong>{{ $errors->first('name') }}</strong>
                                </span>
                                @endif
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="form-group pt-0">
                                <label for="exampleFormControlInput1" class="form-label">Material Unit</label>
                                <select name="material_unit_id" class="form-select" aria-label="Default select example" value="{{ old('material_unit_id',$record->material_unit_id) }}">
                                    <option value="">Select Material Unit</option>
                                    @php $options = \App\Models\MaterialUnit::getMaterialUnitsList(); @endphp
                                    @foreach($options as $key=>$value)
                                    <option {{ old('material_unit_id',$record->material_unit_id) == $key ? 'selected' : '' }} value="{{ $key }}"  >{{ ucwords($value) }}</option>
                                    @endforeach
                                </select>
                                @if ($errors->has('material_unit_id'))
                                <span class="error-message">
                                    <strong>{{ $errors->first('material_unit_id') }}</strong>
                                </span>
                                @endif
                            </div>
                        </div>
                    </div>
                    <div class="row py-3">
                        <div class="col-lg-6">
                            <div class="form-group pt-0">
                                <label for="exampleFormControlInput1" class="form-label">Quantity</label>
                                <input type="text" name="quantity" placeholder="Enter Quantity" value="{{old('quantity',$record->quantity)}}" class="form-control" id="exampleFormControlInput1" >
                                @if ($errors->has('quantity'))
                                <span class="error-message">
                                    <strong>{{ $errors->first('quantity') }}</strong>
                                </span>
                                @endif
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="form-group pt-0">
                                <label for="exampleFormControlInput1" class="form-label">Status</label>
                                <select name="status" class="form-select" aria-label="Default select example" value="{{ old('status',$record->status) }}">
                                    @php $options = CommonHelper::getStatusOption(); @endphp
                                    @foreach($options as $key=>$value)
                                    <option {{ old('status',$record->status) == $key ? 'selected' : '' }} value="{{ $key }}"  > {{ $value }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
            </div>    
                
            
            <div class="buttons mt-5">
                <button class="btn btn-primary btn-create" type="submit">Update</button>
                <a href="{{route('admin.materials.index')}}" class="btn btn-primary btn-reset-form" type="submit">Back</a>
            </div>
        </form>
    </div>
</div>   

@endsection