@php 
$counter = 1; 
$shopSettings = \App\Models\Setting::shop_settings(); 
@endphp

@extends('layouts.admin.print')

@section('title',"Print Job")

@section('header', "Print Job")

@section('content')

    <table style="max-width:1000px;width:100%;margin:0 auto;padding:40px;">
        <tbody>
        <tr style="">
            <td style="display: flex;justify-content: space-between; margin-bottom:60px;">
                <img style="" src="{{ asset('public/img/print_order_voucher.png') }}" alt="logo">
                <div style="width: fit-content;">
                    <h5 style="margin:0px;font-size:14px;font-weight:600;color:#BE1E2D;">Job Order: {{ $record->item_code }} </h5>
                    <p style="margin:0px;font-weight: 300;font-size:12px;color:#000;">
                        Date {{ date('d/m/Y', strtotime($record->date)) }}</p>
                </div>
            </td>
        </tr>
        <tr style="display: flex;justify-content: space-between;margin:20px 0;">
            <td style="width: calc(100% / 2);">
                <img src="{{ (!empty($record->first_image->image_url ) ? $record->first_image->image_url : getDefaultImage()) }}" style="width:100%; height:100%;"/>
            </td>
            <td style="font-size:12px;align-items: center;width: calc(100% / 2);padding-left: 30px;">
                <div style="height: 100%;align-items: baseline;display: flex;flex-wrap: wrap;">
                    <div style="display: block;height: 50%;width: 100%;">
                        <p style="color:#64748B;margin:0px;">Description</p><h4 style="margin:0px;"><span style="color:#000000;font-weight: 400;font-size:12px;line-height:18px;">
						{{ $record->description ?? ' ' }}</span></h4>
                    </div>
                    <div style="display: flex;justify-content: space-between;align-items: flex-end;height: 50%;width: 100%;">
                        <div style="display: flex;justify-content: space-between;width: 100%;">
                            <p style="color:#64748B;margin:0px;;font-size: 10px;">Category<span style="display:flex;color:#7B3308;font-weight:400; font-size:12px;line-height:18px;align-items:center;"><img style="padding-right:20px;" src="{{ ($record->category->name) ? getBrownImageForCategory($record->category->name) : '' }}"/>{{ $record->category->name }}</span>
                        </p>
                        <p style="color:#64748B; margin:0px;font-size: 10px;">Size<span style="display:block;color:#000000;font-weight: 400;font-size:12px;line-height:18px;">
                            {{ $record->size ?? '-' }}</span></p>
                        </div>
                    </div>
                </div>
            </td>
        </tr>
        <tr style="">
            <td class="pgl">
                <table cellpadding="0" cellspacing="0" style="width:100%;">
                    <tr style="">

                        <td style="border-top: 1px solid rgb(0 0 0 / 10%); width: 25%;">
                            <h4 style="margin:0px; text-align:start; font-size:10px; font-weight:300;color:#000000;padding: 17px 0 13px;">Gold
                                colour</h4>
                        </td>
                        <td style="border-top: 1px solid rgb(0 0 0 / 10%); width: 25%;">
                            <p style="margin:0px;font-size:10px; text-align:center;font-weight:300; color:#000000;padding: 17px 0 13px;">Gold Cost</p>
                        </td>
                        <td style="border-top: 1px solid rgb(0 0 0 / 10%);width: 25%;">
                            <p style="margin:0px;font-size:10px; text-align:center; font-weight:300; color:#000000;padding: 17px 0 13px;">Gold Weight</p>
                        </td>
                        <td style="border-top: 1px solid rgb(0 0 0 / 10%); width: 25%;">

                        </td>
                    </tr>
                    <tr style="">
                        <td style=" width: 25%;">
                            <p style="margin:0px;font-size:12px; font-weight:500;padding: 0 0 17px;">{{ !empty($record->gold_color->name) ? $record->gold_color->name : "-" }}</p>
                        </td>
                        <td style="font-size:12px; width: 25%;">
                            <p style="margin:0px;font-size:12px; font-weight:500;padding: 0 0 17px;text-align:center;">{{ !empty($record->gold_cost) ? '$'.(float)$record->gold_cost : "-" }}</p>
                        </td>
                        <td style="width: 25%;">
                            <p style="margin:0px;font-size:12px; font-weight:500;padding: 0 0 17px;text-align:center;">{{ !empty($record->gold_weight) ? (float)$record->gold_weight.'g' : "-" }}</p>
                        </td>
                    </tr>
                    <tr>
                       <td style="border-top: 1px solid rgb(0 0 0 / 10%); width: 25%;">
                            <h4 style="margin:0px; text-align:start; font-size:10px; font-weight:300;color:#000000;padding: 17px 0 13px;">Workmanship</h4>
                        </td>
                        <td style="border-top: 1px solid rgb(0 0 0 / 10%); width: 25%;">
                            <p style="margin:0px;font-size:10px; text-align:center;font-weight:300; color:#000000;padding: 17px 0 13px;">Setting</p>
                        </td>
                        <td style="border-top: 1px solid rgb(0 0 0 / 10%);width: 25%;">
                            <p style="margin:0px;font-size:10px; text-align:center; font-weight:300; color:#000000;padding: 17px 0 13px;">Polishing</p>
                        </td>
                        <td style="border-top: 1px solid rgb(0 0 0 / 10%); width: 25%;">

                        </td>
                    <tr style="">
                        <td style="width: 25%;">
                            <p style="margin:0px;font-size:12px; font-weight:500;padding: 0 0 17px;">{{ !empty($record->craftsmanship_cost) ? '$'.(float)$record->craftsmanship_cost : "-" }}</p>
                        </td>
                        <td style="font-size:14px;width: 25%;">
                            <p style="margin:0px;font-size:12px; font-weight:500;padding: 0 0 17px;text-align: center;">{{ !empty($record->setting_cost) ? '$'.(float)$record->setting_cost : "-" }}</p>
                        </td>
                        <td style="width: 25%;">
                            <h4 style="margin:0px;font-size:12px; font-weight:500;padding: 0 0 17px;text-align: center;">{{ !empty($record->polishing) ? '$'.(float)$record->polishing : "-" }}</h4>
                        </td>
                    </tr>
                    <tr>
                       <td style="border-top: 1px solid rgb(0 0 0 / 10%); width: 25%;">
                            <h4 style="margin:0px; text-align:start; font-size:10px; font-weight:300;color:#000000;padding: 17px 0 13px;">Backing Type</h4>
                        </td>
                        <td style="border-top: 1px solid rgb(0 0 0 / 10%); width: 25%;">
                            <p style="margin:0px;font-size:10px; text-align:center;font-weight:300; color:#000000;padding: 17px 0 13px;">Backing Cost</p>
                        </td>
                        <td style="border-top: 1px solid rgb(0 0 0 / 10%);width: 25%;">
                            <p style="margin:0px;font-size:10px; text-align:center; font-weight:300; color:#000000;padding: 17px 0 13px;">Backing size(mm)</p>
                        </td>
                        <td style="border-top: 1px solid rgb(0 0 0 / 10%); width: 25%;text-align: end;">
                            <p style="margin:0px;font-size:10px;font-weight:300; color:#000000;padding: 17px 0 13px;">
                                Backing Quantity
                            </p>
                        </td>
                    </tr>
                    <tr style="">
                        <td style="width: 25%;">
                            <p style="margin:0px;font-size:12px; font-weight:500;padding: 0 0 17px;">{{ $record->backing_type ?? '-' }}</p>
                        </td>
                        <td style="font-size:14px;width: 25%;">
                            <p style="margin:0px;font-size:12px; font-weight:500;padding: 0 0 17px;text-align: center;">{{ (!empty($record->backing_cost) ? '$'.(float)$record->backing_cost : "-") }}</p>
                        </td>
                        <td style="width: 25%;">
                            <h4 style="margin:0px;font-size:12px; font-weight:500;padding: 0 0 17px;text-align: center;">{{ (!empty($record->backing_size) ? (float)$record->backing_size : "-") }}</h4>
                        </td>
                        <td style="width: 25%;">
                            <h4 style="margin:0px;font-size:12px; font-weight:500;padding: 0 0 17px;text-align: end;">{{ $record->backing_quantity ?? '-' }}</h4>
                        </td>
                    </tr>
                    <tr>
                        <td style="border-top: 1px solid rgb(0 0 0 / 10%);width: 25%;">
                            <h4 style="margin:0px; text-align:start; font-size:10px; font-weight:300;color:#000000;padding: 17px 0 13px;">
                                Earring Pin(mm)</h4>
                        </td>
                        <td style="border-top: 1px solid rgb(0 0 0 / 10%);width: 25%;">
                            <p style="margin:0px; text-align:center; font-size:10px; font-weight:300;color:#000000;padding: 17px 0 13px;">Claw</p>
                        </td>
                        <td style="border-top: 1px solid rgb(0 0 0 / 10%);width: 25%;">
                            <!--  <p style="font-size:10px;text-align:center;font-weight:300;color:#000000;">Pearl Stud</p> -->
                        </td> 
                        <td style="border-top: 1px solid rgb(0 0 0 / 10%);width: 25%;">
                            <!-- <p style="font-size:10px;text-align:end;font-weight:300;color:#000000;">Spring Hook/Lobster
                                Hook</p> -->
                        </td> 
                    </tr>
                    <tr style="">
                        <td>
                            <p style="margin:0px;font-size:12px; font-weight:500;padding: 0 0 17px;">{{ (!empty($record->earing_pin) ? $record->earing_pin : "-") }}</p>
                        </td>
                        <td>
                            <p style="margin:0px;font-size:12px; font-weight:500;padding: 0 0 17px;text-align: center">{{ $record->claw ?? '-' }}</p>
                        </td>
                        <td style="">
                            <!-- <h4 style="margin:0px;text-align:center;font-weight:500;">{{-- !empty($record->pearl_stud) ? $record->pearl_stud : "-" --}}</h4> -->
                        </td>
                        <td style="">
                            <!-- <h4 style="margin:0px;text-align:end;font-weight:500;">{{-- !empty($record->hook) ? $record->hook : "-" --}}</h4> -->
                        </td> 
                    </tr>

                    @if(!empty($record->loose_pieces) && $record->loose_pieces->count())
                    <tr>
                        <td style="border-top: 1px solid rgb(0 0 0 / 10%);">
                            <h4 style="margin:0px; text-align:start;font-size:10px;font-weight:300;color:#000000;">Item
                                Code</h4>
                        </td>
                        <td style="border-top: 1px solid rgb(0 0 0 / 10%);">
                            <p style="font-size:10px;text-align:center;font-weight:300;color:#000000;">Weight</p>
                        </td>
                        <td style="border-top: 1px solid rgb(0 0 0 / 10%);">
                            <p style="font-size:10px;text-align:center;font-weight:300;color:#000000;">Unit Price</p>
                        </td>
                        <td style="border-top: 1px solid rgb(0 0 0 / 10%);">
                            <p style="font-size:10px;text-align:end;font-weight:300;color:#000000;">Price</p>
                        </td>
                    </tr>
                        @foreach($record->loose_pieces as $key=>$value)
                            <tr style="">
                                <td style="font-size:14px;font-weight:400;padding: 20px 0;">
                                    <p style="margin:0px;">{{ $value->stock_no ?? '' }}</p>
                                </td>
                                <td style="font-size:14px;">
                                    <p style="margin:0px;text-align:center;font-weight:500;">{{ $value->weight.'g' ?? '-' }}</p>
                                </td>
                                <td style="">
                                    <h4 style="margin:0px;text-align:center;font-weight:500;">{{ '$'.$value->unit_price ?? '-' }}</h4>
                                </td>
                                <td style="">
                                    <h4 style="margin:0px;text-align:end;font-weight:500;">{{ '$'.$value->price ?? '-' }}</h4>
                                </td>
                            </tr>
                        @endforeach
                    @endif
                    <tr>
                        <td colspan="2" style="border-top: 1px solid rgb(0 0 0 / 10%);">
                            <h4 style="margin:0px; text-align:start; font-size:10px; font-weight:300;color:#000000;padding: 17px 0 13px;">Handle By</h4>
                        </td>
                        <td colspan="2" style="border-top: 1px solid rgb(0 0 0 / 10%);">
                            <p style="margin:0px; text-align:start; font-size:10px; font-weight:300;color:#000000;padding: 17px 0 13px;padding-left: 200px;">Customer Name</p>
                        </td>
                    </tr>

                    <tr style="">
                        <td colspan="2">
                            <p style="margin:0px;font-size:12px; font-weight:500; padding: 0 0 17px;">{{ (!empty($record->staff->fullname) ? $record->staff->fullname : "-" ) }}</p>
                        </td>
                        <td colspan="2" style="font-size:14px;">
                            <p style="margin:0px;font-size:12px; font-weight:500; padding: 0 0 17px;padding-left: 200px;">{{ !empty($record->customer->fullname ) ? $record->customer->fullname : "-"}}</p>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2">
                            <h4 style="margin:0px; text-align:start; font-size:10px; font-weight:300;color:#000000;padding: 0px 0 24px;">Customer Phone</h4>
                        </td>
                        <td colspan="2">
                            <p style="margin:0px; text-align:start; font-size:10px; font-weight:300;color:#000000;padding: 0px 0 24px;padding-left: 200px;">Customer Email</p>
                        </td>
                    </tr>
                    <tr style="">
                        <td colspan="2">
                            <p style="margin:0px;font-size:12px; font-weight:500; padding: 0 0 17px;">{{ (!empty($record->customer->phone_with_code ) ? $record->customer->phone_with_code : "-") }}</p>
                        </td>
                        <td colspan="2">
                            <p style="margin:0px;font-size:12px; font-weight:500;padding: 0 0 17px;padding-left: 200px;">{{ !empty($record->customer->email) ? $record->customer->email : "-" }}</p>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
        </tbody>
    </table>
@endsection